/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.svcs;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.ning.billing.ErrorCode;
import com.ning.billing.ObjectType;
import com.ning.billing.callcontext.InternalCallContext;
import com.ning.billing.callcontext.InternalTenantContext;
import com.ning.billing.catalog.api.Catalog;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanPhase;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.clock.DefaultClock;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.entitlement.api.EntitlementAOStatusDryRun;
import com.ning.billing.events.EffectiveSubscriptionInternalEvent;
import com.ning.billing.subscription.api.SubscriptionApiBase;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.SubscriptionBaseInternalApi;
import com.ning.billing.subscription.api.user.DefaultEffectiveSubscriptionEvent;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseApiService;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.DefaultSubscriptionStatusDryRun;
import com.ning.billing.subscription.api.user.SubscriptionBaseApiException;
import com.ning.billing.subscription.api.user.SubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransition;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.addon.AddonUtils;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.dao.NonEntityDao;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionInternalApi
extends SubscriptionApiBase
implements SubscriptionBaseInternalApi {
    private final Logger log = LoggerFactory.getLogger(DefaultSubscriptionInternalApi.class);
    private final AddonUtils addonUtils;
    private final NonEntityDao nonEntityDao;

    @Inject
    public DefaultSubscriptionInternalApi(SubscriptionDao dao, DefaultSubscriptionBaseApiService apiService, Clock clock, CatalogService catalogService, AddonUtils addonUtils, NonEntityDao nonEntityDao) {
        super(dao, apiService, clock, catalogService);
        this.addonUtils = addonUtils;
        this.nonEntityDao = nonEntityDao;
    }

    public SubscriptionBase createSubscription(UUID bundleId, PlanPhaseSpecifier spec, DateTime requestedDateWithMs, InternalCallContext context) throws SubscriptionBaseApiException {
        try {
            DateTime requestedDate;
            String realPriceList = spec.getPriceListName() == null ? "DEFAULT" : spec.getPriceListName();
            DateTime now = this.clock.getUTCNow();
            DateTime dateTime = requestedDate = requestedDateWithMs != null ? DefaultClock.truncateMs((DateTime)requestedDateWithMs) : now;
            if (requestedDate.isAfter((ReadableInstant)now)) {
                throw new SubscriptionBaseApiException(ErrorCode.SUB_INVALID_REQUESTED_DATE, new Object[]{now.toString(), requestedDate.toString()});
            }
            DateTime effectiveDate = requestedDate;
            Catalog catalog = this.catalogService.getFullCatalog();
            Plan plan = catalog.findPlan(spec.getProductName(), spec.getBillingPeriod(), realPriceList, requestedDate);
            PlanPhase phase = plan.getAllPhases()[0];
            if (phase == null) {
                throw new SubscriptionBaseError(String.format("No initial PlanPhase for Product %s, term %s and set %s does not exist in the catalog", spec.getProductName(), spec.getBillingPeriod().toString(), realPriceList));
            }
            SubscriptionBaseBundle bundle = this.dao.getSubscriptionBundleFromId(bundleId, (InternalTenantContext)context);
            if (bundle == null) {
                throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_NO_BUNDLE, new Object[]{bundleId});
            }
            DateTime bundleStartDate = null;
            DefaultSubscriptionBase baseSubscription = (DefaultSubscriptionBase)this.dao.getBaseSubscription(bundleId, (InternalTenantContext)context);
            switch (plan.getProduct().getCategory()) {
                case BASE: {
                    if (baseSubscription != null && baseSubscription.getState() == Entitlement.EntitlementState.ACTIVE) {
                        throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_BP_EXISTS, new Object[]{bundleId});
                    }
                    bundleStartDate = requestedDate;
                    break;
                }
                case ADD_ON: {
                    if (baseSubscription == null) {
                        throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_NO_BP, new Object[]{bundleId});
                    }
                    if (effectiveDate.isBefore((ReadableInstant)baseSubscription.getStartDate())) {
                        throw new SubscriptionBaseApiException(ErrorCode.SUB_INVALID_REQUESTED_DATE, new Object[]{effectiveDate.toString(), baseSubscription.getStartDate().toString()});
                    }
                    this.addonUtils.checkAddonCreationRights(baseSubscription, plan);
                    bundleStartDate = baseSubscription.getStartDate();
                    break;
                }
                case STANDALONE: {
                    if (baseSubscription != null) {
                        throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_BP_EXISTS, new Object[]{bundleId});
                    }
                    bundleStartDate = requestedDate;
                    break;
                }
                default: {
                    throw new SubscriptionBaseError(String.format("Can't create subscription of type %s", plan.getProduct().getCategory().toString()));
                }
            }
            UUID tenantId = this.nonEntityDao.retrieveIdFromObject(context.getTenantRecordId(), ObjectType.TENANT);
            return this.apiService.createPlan(new SubscriptionBuilder().setId(UUID.randomUUID()).setBundleId(bundleId).setCategory(plan.getProduct().getCategory()).setBundleStartDate(bundleStartDate).setAlignStartDate(effectiveDate), plan, spec.getPhaseType(), realPriceList, requestedDate, effectiveDate, now, context.toCallContext(tenantId));
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseApiException(e);
        }
    }

    public SubscriptionBaseBundle createBundleForAccount(UUID accountId, String bundleKey, InternalCallContext context) throws SubscriptionBaseApiException {
        List<SubscriptionBaseBundle> existingBundles = this.dao.getSubscriptionBundlesForKey(bundleKey, (InternalTenantContext)context);
        DateTime now = this.clock.getUTCNow();
        DateTime originalCreatedDate = existingBundles.size() > 0 ? existingBundles.get(0).getCreatedDate() : now;
        DefaultSubscriptionBaseBundle bundle = new DefaultSubscriptionBaseBundle(bundleKey, accountId, now, originalCreatedDate, now, now);
        return this.dao.createSubscriptionBundle(bundle, context);
    }

    public List<SubscriptionBaseBundle> getBundlesForAccountAndKey(UUID accountId, String bundleKey, InternalTenantContext context) throws SubscriptionBaseApiException {
        List<SubscriptionBaseBundle> bundlesForAccountAndKey = this.dao.getSubscriptionBundlesForAccountAndKey(accountId, bundleKey, context);
        return bundlesForAccountAndKey;
    }

    public List<SubscriptionBaseBundle> getBundlesForAccount(UUID accountId, InternalTenantContext context) {
        return this.dao.getSubscriptionBundleForAccount(accountId, context);
    }

    public List<SubscriptionBaseBundle> getBundlesForKey(String bundleKey, InternalTenantContext context) {
        List<SubscriptionBaseBundle> result = this.dao.getSubscriptionBundlesForKey(bundleKey, context);
        return result;
    }

    public Iterable<UUID> getNonAOSubscriptionIdsForKey(String bundleKey, InternalTenantContext context) {
        return this.dao.getNonAOSubscriptionIdsForKey(bundleKey, context);
    }

    public static SubscriptionBaseBundle getActiveBundleForKeyNotException(List<SubscriptionBaseBundle> existingBundles, SubscriptionDao dao, Clock clock, InternalTenantContext context) {
        for (SubscriptionBaseBundle cur : existingBundles) {
            List<SubscriptionBase> subscriptions = dao.getSubscriptions(cur.getId(), context);
            for (SubscriptionBase s : subscriptions) {
                if (s.getCategory() == ProductCategory.ADD_ON || s.getEndDate() != null && s.getEndDate().compareTo((ReadableInstant)clock.getUTCNow()) <= 0) continue;
                return cur;
            }
        }
        return null;
    }

    public List<SubscriptionBase> getSubscriptionsForBundle(UUID bundleId, InternalTenantContext context) {
        List<SubscriptionBase> internalSubscriptions = this.dao.getSubscriptions(bundleId, context);
        return this.createSubscriptionsForApiUse(internalSubscriptions);
    }

    public Map<UUID, List<SubscriptionBase>> getSubscriptionsForAccount(InternalTenantContext context) {
        Map<UUID, List<SubscriptionBase>> internalSubscriptions = this.dao.getSubscriptionsForAccount(context);
        HashMap<UUID, List<SubscriptionBase>> result = new HashMap<UUID, List<SubscriptionBase>>();
        for (UUID bundleId : internalSubscriptions.keySet()) {
            result.put(bundleId, this.createSubscriptionsForApiUse(internalSubscriptions.get(bundleId)));
        }
        return result;
    }

    public SubscriptionBase getBaseSubscription(UUID bundleId, InternalTenantContext context) throws SubscriptionBaseApiException {
        SubscriptionBase result = this.dao.getBaseSubscription(bundleId, context);
        if (result == null) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_GET_NO_SUCH_BASE_SUBSCRIPTION, new Object[]{bundleId});
        }
        return this.createSubscriptionForApiUse(result);
    }

    public SubscriptionBase getSubscriptionFromId(UUID id, InternalTenantContext context) throws SubscriptionBaseApiException {
        SubscriptionBase result = this.dao.getSubscriptionFromId(id, context);
        if (result == null) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_INVALID_SUBSCRIPTION_ID, new Object[]{id});
        }
        return this.createSubscriptionForApiUse(result);
    }

    public SubscriptionBaseBundle getBundleFromId(UUID id, InternalTenantContext context) throws SubscriptionBaseApiException {
        SubscriptionBaseBundle result = this.dao.getSubscriptionBundleFromId(id, context);
        if (result == null) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_GET_INVALID_BUNDLE_ID, new Object[]{id.toString()});
        }
        return result;
    }

    public UUID getAccountIdFromSubscriptionId(UUID subscriptionId, InternalTenantContext context) throws SubscriptionBaseApiException {
        return this.dao.getAccountIdFromSubscriptionId(subscriptionId, context);
    }

    public void setChargedThroughDate(UUID subscriptionId, DateTime chargedThruDate, InternalCallContext context) {
        DefaultSubscriptionBase subscription = (DefaultSubscriptionBase)this.dao.getSubscriptionFromId(subscriptionId, (InternalTenantContext)context);
        SubscriptionBuilder builder = new SubscriptionBuilder(subscription).setChargedThroughDate(chargedThruDate);
        this.dao.updateChargedThroughDate(new DefaultSubscriptionBase(builder), context);
    }

    public List<EffectiveSubscriptionInternalEvent> getAllTransitions(SubscriptionBase subscription, InternalTenantContext context) {
        List<SubscriptionBaseTransition> transitions = ((DefaultSubscriptionBase)subscription).getAllTransitions();
        return this.convertEffectiveSubscriptionInternalEventFromSubscriptionTransitions(subscription, context, transitions);
    }

    public List<EffectiveSubscriptionInternalEvent> getBillingTransitions(SubscriptionBase subscription, InternalTenantContext context) {
        List<SubscriptionBaseTransition> transitions = ((DefaultSubscriptionBase)subscription).getBillingTransitions();
        return this.convertEffectiveSubscriptionInternalEventFromSubscriptionTransitions(subscription, context, transitions);
    }

    public DateTime getNextBillingDate(UUID accountId, InternalTenantContext context) {
        List<SubscriptionBaseBundle> bundles = this.getBundlesForAccount(accountId, context);
        DateTime result = null;
        for (SubscriptionBaseBundle bundle : bundles) {
            List<SubscriptionBase> subscriptions = this.getSubscriptionsForBundle(bundle.getId(), context);
            for (SubscriptionBase subscription : subscriptions) {
                DateTime chargedThruDate = subscription.getChargedThroughDate();
                if (result != null && (chargedThruDate == null || !chargedThruDate.isBefore((ReadableInstant)result))) continue;
                result = subscription.getChargedThroughDate();
            }
        }
        return result;
    }

    public List<EntitlementAOStatusDryRun> getDryRunChangePlanStatus(UUID subscriptionId, @Nullable String baseProductName, DateTime requestedDate, InternalTenantContext context) throws SubscriptionBaseApiException {
        SubscriptionBase subscription = this.dao.getSubscriptionFromId(subscriptionId, context);
        if (subscription == null) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_INVALID_SUBSCRIPTION_ID, new Object[]{subscriptionId});
        }
        if (subscription.getCategory() != ProductCategory.BASE) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CHANGE_DRY_RUN_NOT_BP, new Object[0]);
        }
        LinkedList<EntitlementAOStatusDryRun> result = new LinkedList<EntitlementAOStatusDryRun>();
        List<SubscriptionBase> bundleSubscriptions = this.dao.getSubscriptions(subscription.getBundleId(), context);
        for (SubscriptionBase cur : bundleSubscriptions) {
            if (cur.getId().equals(subscriptionId) || cur.getState() == Entitlement.EntitlementState.CANCELLED) continue;
            EntitlementAOStatusDryRun.DryRunChangeReason reason = baseProductName != null && this.addonUtils.isAddonIncludedFromProdName(baseProductName, requestedDate, cur.getCurrentPlan()) ? EntitlementAOStatusDryRun.DryRunChangeReason.AO_INCLUDED_IN_NEW_PLAN : (baseProductName != null && this.addonUtils.isAddonAvailableFromProdName(baseProductName, requestedDate, cur.getCurrentPlan()) ? EntitlementAOStatusDryRun.DryRunChangeReason.AO_AVAILABLE_IN_NEW_PLAN : EntitlementAOStatusDryRun.DryRunChangeReason.AO_NOT_AVAILABLE_IN_NEW_PLAN);
            DefaultSubscriptionStatusDryRun status = new DefaultSubscriptionStatusDryRun(cur.getId(), cur.getCurrentPlan().getProduct().getName(), cur.getCurrentPhase().getPhaseType(), cur.getCurrentPlan().getBillingPeriod(), cur.getCurrentPriceList().getName(), reason);
            result.add(status);
        }
        return result;
    }

    public void updateExternalKey(UUID bundleId, String newExternalKey, InternalCallContext context) {
        this.dao.updateBundleExternalKey(bundleId, newExternalKey, context);
    }

    private List<EffectiveSubscriptionInternalEvent> convertEffectiveSubscriptionInternalEventFromSubscriptionTransitions(final SubscriptionBase subscription, final InternalTenantContext context, List<SubscriptionBaseTransition> transitions) {
        return ImmutableList.copyOf((Collection)Collections2.transform(transitions, (Function)new Function<SubscriptionBaseTransition, EffectiveSubscriptionInternalEvent>(){

            @Nullable
            public EffectiveSubscriptionInternalEvent apply(@Nullable SubscriptionBaseTransition input) {
                return new DefaultEffectiveSubscriptionEvent((SubscriptionBaseTransitionData)input, ((DefaultSubscriptionBase)subscription).getAlignStartDate(), null, context.getAccountRecordId(), context.getTenantRecordId());
            }
        }));
    }
}

