/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.timeline;

import com.ning.billing.catalog.api.BillingPeriod;
import com.ning.billing.catalog.api.Catalog;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.PhaseType;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.subscription.api.SubscriptionBaseTransitionType;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseTimeline;
import com.ning.billing.subscription.api.timeline.SubscriptionDataRepair;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEvent;
import com.ning.billing.subscription.events.user.ApiEvent;
import com.ning.billing.subscription.events.user.ApiEventType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionBaseTimeline
implements SubscriptionBaseTimeline {
    private final UUID id;
    private final List<SubscriptionBaseTimeline.ExistingEvent> existingEvents;
    private final List<SubscriptionBaseTimeline.NewEvent> newEvents;
    private final List<SubscriptionBaseTimeline.DeletedEvent> deletedEvents;
    private final long activeVersion;

    public DefaultSubscriptionBaseTimeline(UUID id, long activeVersion) {
        this.id = id;
        this.activeVersion = activeVersion;
        this.existingEvents = Collections.emptyList();
        this.deletedEvents = Collections.emptyList();
        this.newEvents = Collections.emptyList();
    }

    public DefaultSubscriptionBaseTimeline(SubscriptionBaseTimeline input) {
        this.id = input.getId();
        this.activeVersion = input.getActiveVersion();
        this.existingEvents = input.getExistingEvents() != null ? new ArrayList(input.getExistingEvents()) : Collections.emptyList();
        this.sortExistingEvent(this.existingEvents);
        this.deletedEvents = input.getDeletedEvents() != null ? new ArrayList(input.getDeletedEvents()) : Collections.emptyList();
        this.newEvents = input.getNewEvents() != null ? new ArrayList(input.getNewEvents()) : Collections.emptyList();
        this.sortNewEvent(this.newEvents);
    }

    public DefaultSubscriptionBaseTimeline(SubscriptionDataRepair input, Catalog catalog) throws CatalogApiException {
        this.id = input.getId();
        this.existingEvents = this.toExistingEvents(catalog, input.getActiveVersion(), input.getCategory(), input.getEvents());
        this.deletedEvents = null;
        this.newEvents = null;
        this.activeVersion = input.getActiveVersion();
    }

    private List<SubscriptionBaseTimeline.ExistingEvent> toExistingEvents(Catalog catalog, long activeVersion, ProductCategory category, List<SubscriptionBaseEvent> events) throws CatalogApiException {
        LinkedList<SubscriptionBaseTimeline.ExistingEvent> result = new LinkedList<SubscriptionBaseTimeline.ExistingEvent>();
        String prevProductName = null;
        BillingPeriod prevBillingPeriod = null;
        String prevPriceListName = null;
        PhaseType prevPhaseType = null;
        DateTime startDate = null;
        for (final SubscriptionBaseEvent cur : events) {
            if (cur.getActiveVersion() != activeVersion || !cur.isActive()) continue;
            startDate = startDate == null ? cur.getEffectiveDate() : startDate;
            String productName = null;
            BillingPeriod billingPeriod = null;
            String priceListName = null;
            PhaseType phaseType = null;
            String planPhaseName = null;
            ApiEventType apiType = null;
            switch (cur.getType()) {
                case PHASE: {
                    PhaseEvent phaseEV = (PhaseEvent)cur;
                    planPhaseName = phaseEV.getPhase();
                    phaseType = catalog.findPhase(phaseEV.getPhase(), cur.getEffectiveDate(), startDate).getPhaseType();
                    productName = prevProductName;
                    billingPeriod = catalog.findPhase(phaseEV.getPhase(), cur.getEffectiveDate(), startDate).getBillingPeriod();
                    priceListName = prevPriceListName;
                    break;
                }
                case API_USER: {
                    ApiEvent userEV = (ApiEvent)cur;
                    apiType = userEV.getEventType();
                    planPhaseName = userEV.getEventPlanPhase();
                    Plan plan = userEV.getEventPlan() != null ? catalog.findPlan(userEV.getEventPlan(), cur.getRequestedDate(), startDate) : null;
                    phaseType = userEV.getEventPlanPhase() != null ? catalog.findPhase(userEV.getEventPlanPhase(), cur.getEffectiveDate(), startDate).getPhaseType() : prevPhaseType;
                    productName = plan != null ? plan.getProduct().getName() : prevProductName;
                    billingPeriod = userEV.getEventPlanPhase() != null ? catalog.findPhase(userEV.getEventPlanPhase(), cur.getEffectiveDate(), startDate).getBillingPeriod() : prevBillingPeriod;
                    priceListName = userEV.getPriceList() != null ? userEV.getPriceList() : prevPriceListName;
                }
            }
            final SubscriptionBaseTransitionType transitionType = SubscriptionBaseTransitionData.toSubscriptionTransitionType(cur.getType(), apiType);
            final String planPhaseNameWithClosure = planPhaseName;
            final PlanPhaseSpecifier spec = new PlanPhaseSpecifier(productName, category, billingPeriod, priceListName, phaseType);
            result.add(new SubscriptionBaseTimeline.ExistingEvent(){

                public SubscriptionBaseTransitionType getSubscriptionTransitionType() {
                    return transitionType;
                }

                public DateTime getRequestedDate() {
                    return cur.getRequestedDate();
                }

                public PlanPhaseSpecifier getPlanPhaseSpecifier() {
                    return spec;
                }

                public UUID getEventId() {
                    return cur.getId();
                }

                public DateTime getEffectiveDate() {
                    return cur.getEffectiveDate();
                }

                public String getPlanPhaseName() {
                    return planPhaseNameWithClosure;
                }
            });
            prevProductName = productName;
            prevBillingPeriod = billingPeriod;
            prevPriceListName = priceListName;
            prevPhaseType = phaseType;
        }
        this.sortExistingEvent(result);
        return result;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        throw new UnsupportedOperationException();
    }

    public DateTime getUpdatedDate() {
        throw new UnsupportedOperationException();
    }

    public List<SubscriptionBaseTimeline.DeletedEvent> getDeletedEvents() {
        return this.deletedEvents;
    }

    public List<SubscriptionBaseTimeline.NewEvent> getNewEvents() {
        return this.newEvents;
    }

    public List<SubscriptionBaseTimeline.ExistingEvent> getExistingEvents() {
        return this.existingEvents;
    }

    public long getActiveVersion() {
        return this.activeVersion;
    }

    private void sortExistingEvent(List<SubscriptionBaseTimeline.ExistingEvent> events) {
        if (events != null) {
            Collections.sort(events, new Comparator<SubscriptionBaseTimeline.ExistingEvent>(){

                @Override
                public int compare(SubscriptionBaseTimeline.ExistingEvent arg0, SubscriptionBaseTimeline.ExistingEvent arg1) {
                    return arg0.getEffectiveDate().compareTo((ReadableInstant)arg1.getEffectiveDate());
                }
            });
        }
    }

    private void sortNewEvent(List<SubscriptionBaseTimeline.NewEvent> events) {
        if (events != null) {
            Collections.sort(events, new Comparator<SubscriptionBaseTimeline.NewEvent>(){

                @Override
                public int compare(SubscriptionBaseTimeline.NewEvent arg0, SubscriptionBaseTimeline.NewEvent arg1) {
                    return arg0.getRequestedDate().compareTo((ReadableInstant)arg1.getRequestedDate());
                }
            });
        }
    }
}

