/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.user;

import com.ning.billing.clock.Clock;
import com.ning.billing.subscription.api.SubscriptionBaseTransitionType;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransition;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import java.util.Iterator;
import java.util.LinkedList;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionBaseTransitionDataIterator
implements Iterator<SubscriptionBaseTransition> {
    private final Clock clock;
    private final Iterator<SubscriptionBaseTransition> it;
    private final Kind kind;
    private final TimeLimit timeLimit;
    private final Visibility visibility;
    private SubscriptionBaseTransition next;

    public SubscriptionBaseTransitionDataIterator(Clock clock, LinkedList<SubscriptionBaseTransition> transitions, Order order, Kind kind, Visibility visibility, TimeLimit timeLimit) {
        this.it = order == Order.DESC_FROM_FUTURE ? transitions.descendingIterator() : transitions.iterator();
        this.clock = clock;
        this.kind = kind;
        this.timeLimit = timeLimit;
        this.visibility = visibility;
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        do {
            boolean hasNext;
            if (!(hasNext = this.it.hasNext())) {
                return false;
            }
            this.next = this.it.next();
        } while (this.shouldSkip(this.next));
        return true;
    }

    private boolean shouldSkip(SubscriptionBaseTransition input) {
        if (this.visibility == Visibility.FROM_DISK_ONLY && !((SubscriptionBaseTransitionData)input).isFromDisk().booleanValue()) {
            return true;
        }
        if (this.kind == Kind.SUBSCRIPTION && this.shouldSkipForSubscriptionEvents((SubscriptionBaseTransitionData)input) || this.kind == Kind.BILLING && this.shouldSkipForBillingEvents((SubscriptionBaseTransitionData)input)) {
            return true;
        }
        return this.timeLimit == TimeLimit.FUTURE_ONLY && !input.getEffectiveTransitionTime().isAfter((ReadableInstant)this.clock.getUTCNow()) || this.timeLimit == TimeLimit.PAST_OR_PRESENT_ONLY && input.getEffectiveTransitionTime().isAfter((ReadableInstant)this.clock.getUTCNow());
    }

    private boolean shouldSkipForSubscriptionEvents(SubscriptionBaseTransitionData input) {
        return input.getTransitionType() == SubscriptionBaseTransitionType.MIGRATE_BILLING;
    }

    private boolean shouldSkipForBillingEvents(SubscriptionBaseTransitionData input) {
        return input.getTransitionType() == SubscriptionBaseTransitionType.MIGRATE_ENTITLEMENT;
    }

    @Override
    public SubscriptionBaseTransition next() {
        return this.next;
    }

    @Override
    public void remove() {
        throw new SubscriptionBaseError("Operation SubscriptionBaseTransitionDataIterator.remove not implemented");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Visibility {
        FROM_DISK_ONLY,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeLimit {
        FUTURE_ONLY,
        PAST_OR_PRESENT_ONLY,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        SUBSCRIPTION,
        BILLING,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Order {
        ASC_FROM_PAST,
        DESC_FROM_FUTURE;

    }
}

