/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.user;

import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import java.lang.reflect.Field;
import java.util.UUID;
import org.joda.time.DateTime;

public class SubscriptionBuilder {
    private UUID id;
    private UUID bundleId;
    private DateTime createdDate;
    private DateTime updatedDate;
    private DateTime alignStartDate;
    private DateTime bundleStartDate;
    private Long activeVersion;
    private ProductCategory category;
    private DateTime chargedThroughDate;

    public SubscriptionBuilder() {
        this.activeVersion = 1L;
    }

    public SubscriptionBuilder(DefaultSubscriptionBase original) {
        this.id = original.getId();
        this.bundleId = original.getBundleId();
        this.alignStartDate = original.getAlignStartDate();
        this.bundleStartDate = original.getBundleStartDate();
        this.category = original.getCategory();
        this.activeVersion = original.getActiveVersion();
        this.chargedThroughDate = original.getChargedThroughDate();
    }

    public SubscriptionBuilder setId(UUID id) {
        this.id = id;
        return this;
    }

    public SubscriptionBuilder setCreatedDate(DateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public SubscriptionBuilder setUpdatedDate(DateTime updatedDate) {
        this.updatedDate = updatedDate;
        return this;
    }

    public SubscriptionBuilder setBundleId(UUID bundleId) {
        this.bundleId = bundleId;
        return this;
    }

    public SubscriptionBuilder setAlignStartDate(DateTime alignStartDate) {
        this.alignStartDate = alignStartDate;
        return this;
    }

    public SubscriptionBuilder setBundleStartDate(DateTime bundleStartDate) {
        this.bundleStartDate = bundleStartDate;
        return this;
    }

    public SubscriptionBuilder setActiveVersion(long activeVersion) {
        this.activeVersion = activeVersion;
        return this;
    }

    public SubscriptionBuilder setChargedThroughDate(DateTime chargedThroughDate) {
        this.chargedThroughDate = chargedThroughDate;
        return this;
    }

    public SubscriptionBuilder setCategory(ProductCategory category) {
        this.category = category;
        return this;
    }

    public UUID getId() {
        return this.id;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    public UUID getBundleId() {
        return this.bundleId;
    }

    public DateTime getAlignStartDate() {
        return this.alignStartDate;
    }

    public DateTime getBundleStartDate() {
        return this.bundleStartDate;
    }

    public Long getActiveVersion() {
        return this.activeVersion;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public DateTime getChargedThroughDate() {
        return this.chargedThroughDate;
    }

    private void checkAllFieldsSet() {
        for (Field cur : SubscriptionBuilder.class.getDeclaredFields()) {
            try {
                Object value = cur.get(this);
                if (value != null) continue;
                throw new SubscriptionBaseError(String.format("Field %s has not been set for SubscriptionBase", cur.getName()));
            }
            catch (IllegalAccessException e) {
                throw new SubscriptionBaseError(String.format("Failed to access value for field %s for SubscriptionBase", cur.getName()), e);
            }
        }
    }
}

