/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.alignment;

import com.google.inject.Inject;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.Duration;
import com.ning.billing.catalog.api.PhaseType;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanPhase;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.subscription.alignment.BaseAligner;
import com.ning.billing.subscription.alignment.TimedMigration;
import com.ning.billing.subscription.api.migration.SubscriptionBaseMigrationApi;
import com.ning.billing.subscription.api.migration.SubscriptionBaseMigrationApiException;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.user.ApiEventType;
import org.joda.time.DateTime;

public class MigrationPlanAligner
extends BaseAligner {
    private final CatalogService catalogService;

    @Inject
    public MigrationPlanAligner(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public TimedMigration[] getEventsMigration(SubscriptionBaseMigrationApi.SubscriptionMigrationCase[] input, DateTime now) throws SubscriptionBaseMigrationApiException {
        try {
            TimedMigration[] events;
            Plan plan0 = this.catalogService.getFullCatalog().findPlan(input[0].getPlanPhaseSpecifier().getProductName(), input[0].getPlanPhaseSpecifier().getBillingPeriod(), input[0].getPlanPhaseSpecifier().getPriceListName(), now);
            Plan plan1 = input.length > 1 ? this.catalogService.getFullCatalog().findPlan(input[1].getPlanPhaseSpecifier().getProductName(), input[1].getPlanPhaseSpecifier().getBillingPeriod(), input[1].getPlanPhaseSpecifier().getPriceListName(), now) : null;
            DateTime migrationStartDate = input[0].getEffectiveDate();
            if (this.isRegularMigratedSubscription(input)) {
                events = this.getEventsOnRegularMigration(plan0, this.getPlanPhase(plan0, input[0].getPlanPhaseSpecifier().getPhaseType()), input[0].getPlanPhaseSpecifier().getPriceListName(), migrationStartDate);
            } else if (this.isRegularFutureCancelledMigratedSubscription(input)) {
                events = this.getEventsOnFuturePlanCancelMigration(plan0, this.getPlanPhase(plan0, input[0].getPlanPhaseSpecifier().getPhaseType()), input[0].getPlanPhaseSpecifier().getPriceListName(), migrationStartDate, input[0].getCancelledDate());
            } else if (this.isPhaseChangeMigratedSubscription(input)) {
                PhaseType curPhaseType = input[0].getPlanPhaseSpecifier().getPhaseType();
                Duration curPhaseDuration = null;
                for (PlanPhase cur : plan0.getAllPhases()) {
                    if (cur.getPhaseType() != curPhaseType) continue;
                    curPhaseDuration = cur.getDuration();
                    break;
                }
                if (curPhaseDuration == null) {
                    throw new SubscriptionBaseMigrationApiException(String.format("Failed to compute current phase duration for plan %s and phase %s", plan0.getName(), curPhaseType));
                }
                migrationStartDate = this.removeDuration(input[1].getEffectiveDate(), curPhaseDuration);
                events = this.getEventsOnFuturePhaseChangeMigration(plan0, this.getPlanPhase(plan0, input[0].getPlanPhaseSpecifier().getPhaseType()), input[0].getPlanPhaseSpecifier().getPriceListName(), migrationStartDate, input[1].getEffectiveDate());
            } else if (this.isPlanChangeMigratedSubscription(input)) {
                events = this.getEventsOnFuturePlanChangeMigration(plan0, this.getPlanPhase(plan0, input[0].getPlanPhaseSpecifier().getPhaseType()), plan1, this.getPlanPhase(plan1, input[1].getPlanPhaseSpecifier().getPhaseType()), input[0].getPlanPhaseSpecifier().getPriceListName(), migrationStartDate, input[1].getEffectiveDate());
            } else {
                throw new SubscriptionBaseMigrationApiException("Unknown migration type");
            }
            return events;
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseMigrationApiException((Throwable)e);
        }
    }

    private TimedMigration[] getEventsOnRegularMigration(Plan plan, PlanPhase initialPhase, String priceList, DateTime effectiveDate) {
        TimedMigration[] result = new TimedMigration[]{new TimedMigration(effectiveDate, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.MIGRATE_ENTITLEMENT, plan, initialPhase, priceList)};
        return result;
    }

    private TimedMigration[] getEventsOnFuturePhaseChangeMigration(Plan plan, PlanPhase initialPhase, String priceList, DateTime effectiveDate, DateTime effectiveDateForNextPhase) throws SubscriptionBaseMigrationApiException {
        TimedMigration[] result = new TimedMigration[2];
        result[0] = new TimedMigration(effectiveDate, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.MIGRATE_ENTITLEMENT, plan, initialPhase, priceList);
        boolean foundCurrent = false;
        PlanPhase nextPhase = null;
        for (PlanPhase cur : plan.getAllPhases()) {
            if (cur == initialPhase) {
                foundCurrent = true;
                continue;
            }
            if (!foundCurrent) continue;
            nextPhase = cur;
        }
        if (nextPhase == null) {
            throw new SubscriptionBaseMigrationApiException(String.format("Cannot find next phase for Plan %s and current Phase %s", plan.getName(), initialPhase.getName()));
        }
        result[1] = new TimedMigration(effectiveDateForNextPhase, SubscriptionBaseEvent.EventType.PHASE, null, plan, nextPhase, priceList);
        return result;
    }

    private TimedMigration[] getEventsOnFuturePlanChangeMigration(Plan currentPlan, PlanPhase currentPhase, Plan newPlan, PlanPhase newPhase, String priceList, DateTime effectiveDate, DateTime effectiveDateForChangePlan) {
        TimedMigration[] result = new TimedMigration[]{new TimedMigration(effectiveDate, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.MIGRATE_ENTITLEMENT, currentPlan, currentPhase, priceList), new TimedMigration(effectiveDateForChangePlan, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.CHANGE, newPlan, newPhase, priceList)};
        return result;
    }

    private TimedMigration[] getEventsOnFuturePlanCancelMigration(Plan plan, PlanPhase initialPhase, String priceList, DateTime effectiveDate, DateTime effectiveDateForCancellation) {
        TimedMigration[] result = new TimedMigration[]{new TimedMigration(effectiveDate, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.MIGRATE_ENTITLEMENT, plan, initialPhase, priceList), new TimedMigration(effectiveDateForCancellation, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.CANCEL, null, null, null)};
        return result;
    }

    private PlanPhase getPlanPhase(Plan plan, PhaseType phaseType) throws SubscriptionBaseMigrationApiException {
        for (PlanPhase cur : plan.getAllPhases()) {
            if (cur.getPhaseType() != phaseType) continue;
            return cur;
        }
        throw new SubscriptionBaseMigrationApiException(String.format("Cannot find PlanPhase from Plan %s and type %s", plan.getName(), phaseType));
    }

    private boolean isRegularMigratedSubscription(SubscriptionBaseMigrationApi.SubscriptionMigrationCase[] input) {
        return input.length == 1 && input[0].getCancelledDate() == null;
    }

    private boolean isRegularFutureCancelledMigratedSubscription(SubscriptionBaseMigrationApi.SubscriptionMigrationCase[] input) {
        return input.length == 1 && input[0].getCancelledDate() != null;
    }

    private boolean isPhaseChangeMigratedSubscription(SubscriptionBaseMigrationApi.SubscriptionMigrationCase[] input) {
        if (input.length != 2) {
            return false;
        }
        return this.isSamePlan(input[0].getPlanPhaseSpecifier(), input[1].getPlanPhaseSpecifier()) && !this.isSamePhase(input[0].getPlanPhaseSpecifier(), input[1].getPlanPhaseSpecifier());
    }

    private boolean isPlanChangeMigratedSubscription(SubscriptionBaseMigrationApi.SubscriptionMigrationCase[] input) {
        if (input.length != 2) {
            return false;
        }
        return !this.isSamePlan(input[0].getPlanPhaseSpecifier(), input[1].getPlanPhaseSpecifier());
    }

    private boolean isSamePlan(PlanPhaseSpecifier plan0, PlanPhaseSpecifier plan1) {
        return plan0.getPriceListName().equals(plan1.getPriceListName()) && plan0.getProductName().equals(plan1.getProductName()) && plan0.getBillingPeriod() == plan1.getBillingPeriod();
    }

    private boolean isSamePhase(PlanPhaseSpecifier plan0, PlanPhaseSpecifier plan1) {
        return plan0.getPhaseType() == plan1.getPhaseType();
    }
}

