/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.api.timeline;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.ning.billing.ErrorCode;
import com.ning.billing.ObjectType;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.PlanPhaseSpecifier;
import com.ning.billing.catalog.api.Product;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.SubscriptionBaseTransitionType;
import com.ning.billing.subscription.api.timeline.DefaultNewEvent;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseRepairException;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.SubscriptionBaseApiException;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransition;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.addon.AddonUtils;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.user.ApiEventBuilder;
import com.ning.billing.subscription.events.user.ApiEventCancel;
import com.ning.billing.util.callcontext.CallContext;
import com.ning.billing.util.callcontext.InternalCallContextFactory;
import com.ning.billing.util.callcontext.TenantContext;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionDataRepair
extends DefaultSubscriptionBase {
    private final AddonUtils addonUtils;
    private final Clock clock;
    private final SubscriptionDao repairDao;
    private final CatalogService catalogService;
    private final List<SubscriptionBaseEvent> initialEvents;
    private final InternalCallContextFactory internalCallContextFactory;

    public SubscriptionDataRepair(SubscriptionBuilder builder, List<SubscriptionBaseEvent> initialEvents, SubscriptionBaseApiService apiService, SubscriptionDao dao, Clock clock, AddonUtils addonUtils, CatalogService catalogService, InternalCallContextFactory internalCallContextFactory) {
        super(builder, apiService, clock);
        this.repairDao = dao;
        this.addonUtils = addonUtils;
        this.clock = clock;
        this.catalogService = catalogService;
        this.initialEvents = initialEvents;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public SubscriptionDataRepair(DefaultSubscriptionBase defaultSubscriptionBase, SubscriptionBaseApiService apiService, SubscriptionDao dao, Clock clock, AddonUtils addonUtils, CatalogService catalogService, InternalCallContextFactory internalCallContextFactory) {
        super(defaultSubscriptionBase, apiService, clock);
        this.repairDao = dao;
        this.addonUtils = addonUtils;
        this.clock = clock;
        this.catalogService = catalogService;
        this.initialEvents = defaultSubscriptionBase.getEvents();
        this.internalCallContextFactory = internalCallContextFactory;
    }

    DateTime getLastUserEventEffectiveDate() {
        SubscriptionBaseEvent cur;
        DateTime res = null;
        Iterator i$ = this.events.iterator();
        while (i$.hasNext() && (cur = (SubscriptionBaseEvent)i$.next()).getActiveVersion() == this.getActiveVersion()) {
            if (cur.getType() == SubscriptionBaseEvent.EventType.PHASE) continue;
            res = cur.getEffectiveDate();
        }
        return res;
    }

    public void addNewRepairEvent(DefaultNewEvent input, SubscriptionDataRepair baseSubscription, List<SubscriptionDataRepair> addonSubscriptions, CallContext context) throws SubscriptionBaseRepairException {
        try {
            PlanPhaseSpecifier spec = input.getPlanPhaseSpecifier();
            switch (input.getSubscriptionTransitionType()) {
                case CREATE: 
                case RE_CREATE: {
                    this.recreate(spec, input.getRequestedDate(), context);
                    this.checkAddonRights(baseSubscription);
                    break;
                }
                case CHANGE: {
                    this.changePlanWithDate(spec.getProductName(), spec.getBillingPeriod(), spec.getPriceListName(), input.getRequestedDate(), context);
                    this.checkAddonRights(baseSubscription);
                    this.trickleDownBPEffectForAddon(addonSubscriptions, this.getLastUserEventEffectiveDate(), context);
                    break;
                }
                case CANCEL: {
                    this.cancelWithDate(input.getRequestedDate(), context);
                    this.trickleDownBPEffectForAddon(addonSubscriptions, this.getLastUserEventEffectiveDate(), context);
                    break;
                }
                case PHASE: {
                    break;
                }
                default: {
                    throw new SubscriptionBaseRepairException(ErrorCode.SUB_REPAIR_UNKNOWN_TYPE, new Object[]{input.getSubscriptionTransitionType(), this.id});
                }
            }
        }
        catch (SubscriptionBaseApiException e) {
            throw new SubscriptionBaseRepairException(e);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseRepairException(e);
        }
    }

    public void addFutureAddonCancellation(List<SubscriptionDataRepair> addOnSubscriptionInRepair, CallContext context) {
        if (this.getCategory() != ProductCategory.BASE) {
            return;
        }
        SubscriptionBaseTransition pendingTransition = this.getPendingTransition();
        if (pendingTransition == null) {
            return;
        }
        Product baseProduct = pendingTransition.getTransitionType() == SubscriptionBaseTransitionType.CANCEL ? null : pendingTransition.getNextPlan().getProduct();
        this.addAddonCancellationIfRequired(addOnSubscriptionInRepair, baseProduct, pendingTransition.getEffectiveTransitionTime(), context);
    }

    private void trickleDownBPEffectForAddon(List<SubscriptionDataRepair> addOnSubscriptionInRepair, DateTime effectiveDate, CallContext context) throws SubscriptionBaseApiException {
        if (this.getCategory() != ProductCategory.BASE) {
            return;
        }
        Product baseProduct = this.getState() == Entitlement.EntitlementState.CANCELLED ? null : this.getCurrentPlan().getProduct();
        this.addAddonCancellationIfRequired(addOnSubscriptionInRepair, baseProduct, effectiveDate, context);
    }

    private void addAddonCancellationIfRequired(List<SubscriptionDataRepair> addOnSubscriptionInRepair, Product baseProduct, DateTime effectiveDate, CallContext context) {
        DateTime now = this.clock.getUTCNow();
        for (SubscriptionDataRepair cur : addOnSubscriptionInRepair) {
            if (cur.getState() == Entitlement.EntitlementState.CANCELLED || cur.getCategory() != ProductCategory.ADD_ON) continue;
            Plan addonCurrentPlan = cur.getCurrentPlan();
            if (baseProduct != null && !this.addonUtils.isAddonIncluded(baseProduct, addonCurrentPlan) && this.addonUtils.isAddonAvailable(baseProduct, addonCurrentPlan)) continue;
            ApiEventCancel cancelEvent = new ApiEventCancel(((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(cur.getId())).setActiveVersion(cur.getActiveVersion())).setProcessedDate(now)).setEffectiveDate(effectiveDate)).setRequestedDate(now)).setFromDisk(true));
            this.repairDao.cancelSubscription(cur, cancelEvent, this.internalCallContextFactory.createInternalCallContext(cur.getId(), ObjectType.SUBSCRIPTION, context), 0);
            cur.rebuildTransitions(this.repairDao.getEventsForSubscription(cur.getId(), this.internalCallContextFactory.createInternalTenantContext((TenantContext)context)), this.catalogService.getFullCatalog());
        }
    }

    private void checkAddonRights(SubscriptionDataRepair baseSubscription) throws SubscriptionBaseApiException, CatalogApiException {
        if (this.getCategory() == ProductCategory.ADD_ON) {
            this.addonUtils.checkAddonCreationRights(baseSubscription, this.getCurrentPlan());
        }
    }

    @Override
    public List<SubscriptionBaseEvent> getEvents() {
        return this.events;
    }

    public List<SubscriptionBaseEvent> getInitialEvents() {
        return this.initialEvents;
    }

    public Collection<SubscriptionBaseEvent> getNewEvents() {
        return Collections2.filter((Collection)this.events, (Predicate)new Predicate<SubscriptionBaseEvent>(){

            public boolean apply(SubscriptionBaseEvent input) {
                return !SubscriptionDataRepair.this.initialEvents.contains(input);
            }
        });
    }
}

