/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.addon;

import com.google.inject.Inject;
import com.ning.billing.ErrorCode;
import com.ning.billing.catalog.api.CatalogApiException;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.Product;
import com.ning.billing.entitlement.api.Entitlement;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.SubscriptionBaseApiException;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import org.joda.time.DateTime;

public class AddonUtils {
    private final CatalogService catalogService;

    @Inject
    public AddonUtils(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public void checkAddonCreationRights(DefaultSubscriptionBase baseSubscription, Plan targetAddOnPlan) throws SubscriptionBaseApiException, CatalogApiException {
        if (baseSubscription.getState() != Entitlement.EntitlementState.ACTIVE) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_AO_BP_NON_ACTIVE, new Object[]{targetAddOnPlan.getName()});
        }
        Product baseProduct = baseSubscription.getCurrentPlan().getProduct();
        if (this.isAddonIncluded(baseProduct, targetAddOnPlan)) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_AO_ALREADY_INCLUDED, new Object[]{targetAddOnPlan.getName(), baseSubscription.getCurrentPlan().getProduct().getName()});
        }
        if (!this.isAddonAvailable(baseProduct, targetAddOnPlan)) {
            throw new SubscriptionBaseApiException(ErrorCode.SUB_CREATE_AO_NOT_AVAILABLE, new Object[]{targetAddOnPlan.getName(), baseSubscription.getCurrentPlan().getProduct().getName()});
        }
    }

    public boolean isAddonAvailableFromProdName(String baseProductName, DateTime requestedDate, Plan targetAddOnPlan) {
        try {
            Product product = this.catalogService.getFullCatalog().findProduct(baseProductName, requestedDate);
            return this.isAddonAvailable(product, targetAddOnPlan);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseError(e);
        }
    }

    public boolean isAddonAvailableFromPlanName(String basePlanName, DateTime requestedDate, Plan targetAddOnPlan) {
        try {
            Plan plan = this.catalogService.getFullCatalog().findPlan(basePlanName, requestedDate);
            Product product = plan.getProduct();
            return this.isAddonAvailable(product, targetAddOnPlan);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseError(e);
        }
    }

    public boolean isAddonAvailable(Product baseProduct, Plan targetAddOnPlan) {
        Product[] availableAddOns;
        Product targetAddonProduct = targetAddOnPlan.getProduct();
        for (Product curAv : availableAddOns = baseProduct.getAvailable()) {
            if (!curAv.getName().equals(targetAddonProduct.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAddonIncludedFromProdName(String baseProductName, DateTime requestedDate, Plan targetAddOnPlan) {
        try {
            Product product = this.catalogService.getFullCatalog().findProduct(baseProductName, requestedDate);
            return this.isAddonIncluded(product, targetAddOnPlan);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseError(e);
        }
    }

    public boolean isAddonIncludedFromPlanName(String basePlanName, DateTime requestedDate, Plan targetAddOnPlan) {
        try {
            Plan plan = this.catalogService.getFullCatalog().findPlan(basePlanName, requestedDate);
            Product product = plan.getProduct();
            return this.isAddonIncluded(product, targetAddOnPlan);
        }
        catch (CatalogApiException e) {
            throw new SubscriptionBaseError(e);
        }
    }

    public boolean isAddonIncluded(Product baseProduct, Plan targetAddOnPlan) {
        Product[] includedAddOns;
        Product targetAddonProduct = targetAddOnPlan.getProduct();
        for (Product curAv : includedAddOns = baseProduct.getIncluded()) {
            if (!curAv.getName().equals(targetAddonProduct.getName())) continue;
            return true;
        }
        return false;
    }
}

