/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.core;

import com.google.inject.Inject;
import com.ning.billing.bus.api.BusEvent;
import com.ning.billing.bus.api.PersistentBus;
import com.ning.billing.callcontext.InternalCallContext;
import com.ning.billing.callcontext.InternalTenantContext;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.lifecycle.LifecycleHandlerType;
import com.ning.billing.notificationq.api.NotificationEvent;
import com.ning.billing.notificationq.api.NotificationQueue;
import com.ning.billing.notificationq.api.NotificationQueueService;
import com.ning.billing.subscription.alignment.PlanAligner;
import com.ning.billing.subscription.alignment.TimedPhase;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.SubscriptionBaseService;
import com.ning.billing.subscription.api.user.DefaultEffectiveSubscriptionEvent;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.engine.addon.AddonUtils;
import com.ning.billing.subscription.engine.core.EventListener;
import com.ning.billing.subscription.engine.core.SubscriptionNotificationKey;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEventData;
import com.ning.billing.subscription.events.user.ApiEvent;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.callcontext.CallOrigin;
import com.ning.billing.util.callcontext.InternalCallContextFactory;
import com.ning.billing.util.callcontext.UserType;
import java.util.UUID;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSubscriptionBaseService
implements EventListener,
SubscriptionBaseService {
    public static final String NOTIFICATION_QUEUE_NAME = "subscription-events";
    public static final String SUBSCRIPTION_SERVICE_NAME = "subscription-service";
    private static final Logger log = LoggerFactory.getLogger(DefaultSubscriptionBaseService.class);
    private final Clock clock;
    private final SubscriptionDao dao;
    private final PlanAligner planAligner;
    private final AddonUtils addonUtils;
    private final PersistentBus eventBus;
    private final NotificationQueueService notificationQueueService;
    private final InternalCallContextFactory internalCallContextFactory;
    private NotificationQueue subscriptionEventQueue;
    private final SubscriptionBaseApiService apiService;

    @Inject
    public DefaultSubscriptionBaseService(Clock clock, SubscriptionDao dao, PlanAligner planAligner, AddonUtils addonUtils, PersistentBus eventBus, NotificationQueueService notificationQueueService, InternalCallContextFactory internalCallContextFactory, SubscriptionBaseApiService apiService) {
        this.clock = clock;
        this.dao = dao;
        this.planAligner = planAligner;
        this.addonUtils = addonUtils;
        this.eventBus = eventBus;
        this.notificationQueueService = notificationQueueService;
        this.internalCallContextFactory = internalCallContextFactory;
        this.apiService = apiService;
    }

    public String getName() {
        return SUBSCRIPTION_SERVICE_NAME;
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
    public void initialize() {
        try {
            NotificationQueueService.NotificationQueueHandler queueHandler = new NotificationQueueService.NotificationQueueHandler(){

                public void handleReadyNotification(NotificationEvent inputKey, DateTime eventDateTime, UUID fromNotificationQueueUserToken, Long accountRecordId, Long tenantRecordId) {
                    if (!(inputKey instanceof SubscriptionNotificationKey)) {
                        log.error("SubscriptionBase service received an unexpected event type {}" + inputKey.getClass().getName());
                        return;
                    }
                    SubscriptionNotificationKey key = (SubscriptionNotificationKey)inputKey;
                    SubscriptionBaseEvent event = DefaultSubscriptionBaseService.this.dao.getEventById(key.getEventId(), DefaultSubscriptionBaseService.this.internalCallContextFactory.createInternalTenantContext(tenantRecordId, accountRecordId));
                    if (event == null) {
                        log.info("Failed to extract event for notification key {}", (Object)inputKey);
                        return;
                    }
                    InternalCallContext context = DefaultSubscriptionBaseService.this.internalCallContextFactory.createInternalCallContext(tenantRecordId, accountRecordId, "SubscriptionEventQueue", CallOrigin.INTERNAL, UserType.SYSTEM, fromNotificationQueueUserToken);
                    DefaultSubscriptionBaseService.this.processEventReady(event, key.getSeqId(), context);
                }
            };
            this.subscriptionEventQueue = this.notificationQueueService.createNotificationQueue(SUBSCRIPTION_SERVICE_NAME, NOTIFICATION_QUEUE_NAME, queueHandler);
        }
        catch (NotificationQueueService.NotificationQueueAlreadyExists e) {
            throw new RuntimeException(e);
        }
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.START_SERVICE)
    public void start() {
        this.subscriptionEventQueue.startQueue();
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.STOP_SERVICE)
    public void stop() throws NotificationQueueService.NoSuchNotificationQueue {
        if (this.subscriptionEventQueue != null) {
            this.subscriptionEventQueue.stopQueue();
            this.notificationQueueService.deleteNotificationQueue(this.subscriptionEventQueue.getServiceName(), this.subscriptionEventQueue.getQueueName());
        }
    }

    public void processEventReady(SubscriptionBaseEvent event, int seqId, InternalCallContext context) {
        if (!event.isActive()) {
            return;
        }
        DefaultSubscriptionBase subscription = (DefaultSubscriptionBase)this.dao.getSubscriptionFromId(event.getSubscriptionId(), (InternalTenantContext)context);
        if (subscription == null) {
            log.warn("Failed to retrieve subscription for id %s", (Object)event.getSubscriptionId());
            return;
        }
        if (subscription.getActiveVersion() > event.getActiveVersion()) {
            return;
        }
        int theRealSeqId = seqId;
        if (event.getType() == SubscriptionBaseEvent.EventType.PHASE) {
            this.onPhaseEvent(subscription, context);
        } else if (event.getType() == SubscriptionBaseEvent.EventType.API_USER && subscription.getCategory() == ProductCategory.BASE) {
            theRealSeqId = this.onBasePlanEvent(subscription, (ApiEvent)event, context);
        }
        try {
            SubscriptionBaseTransitionData transition = subscription.getTransitionFromEvent(event, theRealSeqId);
            DefaultEffectiveSubscriptionEvent busEvent = new DefaultEffectiveSubscriptionEvent(transition, subscription.getAlignStartDate(), context.getUserToken(), context.getAccountRecordId(), context.getTenantRecordId());
            this.eventBus.post((BusEvent)busEvent);
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post subscription event " + event, (Throwable)e);
        }
    }

    private void onPhaseEvent(DefaultSubscriptionBase subscription, InternalCallContext context) {
        try {
            PhaseEvent nextPhaseEvent;
            DateTime now = this.clock.getUTCNow();
            TimedPhase nextTimedPhase = this.planAligner.getNextTimedPhase(subscription, now, now);
            PhaseEvent phaseEvent = nextPhaseEvent = nextTimedPhase != null ? PhaseEventData.createNextPhaseEvent(nextTimedPhase.getPhase().getName(), subscription, now, nextTimedPhase.getStartPhase()) : null;
            if (nextPhaseEvent != null) {
                this.dao.createNextPhaseEvent(subscription, nextPhaseEvent, context);
            }
        }
        catch (SubscriptionBaseError e) {
            log.error(String.format("Failed to insert next phase for subscription %s", subscription.getId()), (Throwable)e);
        }
    }

    private int onBasePlanEvent(DefaultSubscriptionBase baseSubscription, ApiEvent event, InternalCallContext context) {
        return this.apiService.cancelAddOnsIfRequired(baseSubscription, event.getEffectiveDate(), context);
    }
}

