/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.dao;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.ning.billing.ErrorCode;
import com.ning.billing.bus.api.BusEvent;
import com.ning.billing.bus.api.PersistentBus;
import com.ning.billing.callcontext.InternalCallContext;
import com.ning.billing.callcontext.InternalTenantContext;
import com.ning.billing.catalog.api.CatalogService;
import com.ning.billing.catalog.api.Plan;
import com.ning.billing.catalog.api.ProductCategory;
import com.ning.billing.clock.Clock;
import com.ning.billing.entitlement.api.SubscriptionApiException;
import com.ning.billing.entity.EntityPersistenceException;
import com.ning.billing.notificationq.api.NotificationEvent;
import com.ning.billing.notificationq.api.NotificationQueue;
import com.ning.billing.notificationq.api.NotificationQueueService;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.migration.AccountMigrationData;
import com.ning.billing.subscription.api.timeline.DefaultRepairSubscriptionEvent;
import com.ning.billing.subscription.api.timeline.SubscriptionDataRepair;
import com.ning.billing.subscription.api.transfer.TransferCancelData;
import com.ning.billing.subscription.api.user.DefaultEffectiveSubscriptionEvent;
import com.ning.billing.subscription.api.user.DefaultRequestedSubscriptionEvent;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseTransitionData;
import com.ning.billing.subscription.api.user.SubscriptionBuilder;
import com.ning.billing.subscription.engine.addon.AddonUtils;
import com.ning.billing.subscription.engine.core.SubscriptionNotificationKey;
import com.ning.billing.subscription.engine.dao.BundleSqlDao;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.engine.dao.SubscriptionEventSqlDao;
import com.ning.billing.subscription.engine.dao.SubscriptionSqlDao;
import com.ning.billing.subscription.engine.dao.model.SubscriptionBundleModelDao;
import com.ning.billing.subscription.engine.dao.model.SubscriptionEventModelDao;
import com.ning.billing.subscription.engine.dao.model.SubscriptionModelDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEvent;
import com.ning.billing.subscription.events.user.ApiEvent;
import com.ning.billing.subscription.events.user.ApiEventBuilder;
import com.ning.billing.subscription.events.user.ApiEventCancel;
import com.ning.billing.subscription.events.user.ApiEventChange;
import com.ning.billing.subscription.events.user.ApiEventMigrateBilling;
import com.ning.billing.subscription.events.user.ApiEventType;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.cache.CacheControllerDispatcher;
import com.ning.billing.util.dao.NonEntityDao;
import com.ning.billing.util.entity.Pagination;
import com.ning.billing.util.entity.dao.DefaultPaginationSqlDaoHelper;
import com.ning.billing.util.entity.dao.EntityDaoBase;
import com.ning.billing.util.entity.dao.EntitySqlDao;
import com.ning.billing.util.entity.dao.EntitySqlDaoTransactionWrapper;
import com.ning.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import com.ning.billing.util.entity.dao.EntitySqlDaoWrapperFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.sqlobject.mixins.Transmogrifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSubscriptionDao
extends EntityDaoBase<SubscriptionBundleModelDao, SubscriptionBaseBundle, SubscriptionApiException>
implements SubscriptionDao {
    private static final Logger log = LoggerFactory.getLogger(DefaultSubscriptionDao.class);
    private final Clock clock;
    private final NotificationQueueService notificationQueueService;
    private final AddonUtils addonUtils;
    private final PersistentBus eventBus;
    private final CatalogService catalogService;

    @Inject
    public DefaultSubscriptionDao(IDBI dbi, Clock clock, AddonUtils addonUtils, NotificationQueueService notificationQueueService, PersistentBus eventBus, CatalogService catalogService, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao) {
        super(new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, cacheControllerDispatcher, nonEntityDao), BundleSqlDao.class);
        this.clock = clock;
        this.notificationQueueService = notificationQueueService;
        this.addonUtils = addonUtils;
        this.eventBus = eventBus;
        this.catalogService = catalogService;
    }

    protected SubscriptionApiException generateAlreadyExistsException(SubscriptionBundleModelDao entity, InternalCallContext context) {
        return new SubscriptionApiException(ErrorCode.SUB_CREATE_ACTIVE_BUNDLE_KEY_EXISTS, new Object[]{entity.getExternalKey()});
    }

    @Override
    public List<SubscriptionBaseBundle> getSubscriptionBundlesForAccountAndKey(final UUID accountId, final String bundleKey, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBaseBundle>>(){

            public List<SubscriptionBaseBundle> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List<SubscriptionBundleModelDao> models = ((BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class)).getBundlesFromAccountAndKey(accountId.toString(), bundleKey, context);
                return new ArrayList<SubscriptionBaseBundle>(Collections2.transform(models, (Function)new Function<SubscriptionBundleModelDao, SubscriptionBaseBundle>(){

                    public SubscriptionBaseBundle apply(@Nullable SubscriptionBundleModelDao input) {
                        return SubscriptionBundleModelDao.toSubscriptionbundle(input);
                    }
                }));
            }
        });
    }

    @Override
    public List<SubscriptionBaseBundle> getSubscriptionBundleForAccount(final UUID accountId, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBaseBundle>>(){

            public List<SubscriptionBaseBundle> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List<SubscriptionBundleModelDao> models = ((BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class)).getBundleFromAccount(accountId.toString(), context);
                return new ArrayList<SubscriptionBaseBundle>(Collections2.transform(models, (Function)new Function<SubscriptionBundleModelDao, SubscriptionBaseBundle>(){

                    public SubscriptionBaseBundle apply(@Nullable SubscriptionBundleModelDao input) {
                        return SubscriptionBundleModelDao.toSubscriptionbundle(input);
                    }
                }));
            }
        });
    }

    @Override
    public SubscriptionBaseBundle getSubscriptionBundleFromId(final UUID bundleId, final InternalTenantContext context) {
        return (SubscriptionBaseBundle)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<SubscriptionBaseBundle>(){

            public SubscriptionBaseBundle inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionBundleModelDao model = (SubscriptionBundleModelDao)((BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class)).getById(bundleId.toString(), context);
                return SubscriptionBundleModelDao.toSubscriptionbundle(model);
            }
        });
    }

    @Override
    public List<SubscriptionBaseBundle> getSubscriptionBundlesForKey(final String bundleKey, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBaseBundle>>(){

            public List<SubscriptionBaseBundle> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List<SubscriptionBundleModelDao> models = ((BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class)).getBundlesForKey(bundleKey, context);
                return new ArrayList<SubscriptionBaseBundle>(Collections2.transform(models, (Function)new Function<SubscriptionBundleModelDao, SubscriptionBaseBundle>(){

                    public SubscriptionBaseBundle apply(@Nullable SubscriptionBundleModelDao input) {
                        return SubscriptionBundleModelDao.toSubscriptionbundle(input);
                    }
                }));
            }
        });
    }

    @Override
    public Pagination<SubscriptionBundleModelDao> searchSubscriptionBundles(final String searchKey, final Long offset, Long limit, final InternalTenantContext context) {
        return this.paginationHelper.getPagination(BundleSqlDao.class, (DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder)new DefaultPaginationSqlDaoHelper.PaginationIteratorBuilder<SubscriptionBundleModelDao, SubscriptionBaseBundle, BundleSqlDao>(){

            public Iterator<SubscriptionBundleModelDao> build(BundleSqlDao bundleSqlDao, Long limit) {
                return bundleSqlDao.searchBundles(searchKey, offset, limit, context);
            }
        }, offset, limit, context);
    }

    @Override
    public Iterable<UUID> getNonAOSubscriptionIdsForKey(final String bundleKey, final InternalTenantContext context) {
        return (Iterable)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Iterable<UUID>>(){

            public Iterable<UUID> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                BundleSqlDao bundleSqlDao = (BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class);
                List<SubscriptionBundleModelDao> bundles = bundleSqlDao.getBundlesForKey(bundleKey, context);
                final SubscriptionSqlDao subscriptionSqlDao = (SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class);
                return Iterables.concat((Iterable)Iterables.transform(bundles, (Function)new Function<SubscriptionBundleModelDao, Iterable<UUID>>(){

                    public Iterable<UUID> apply(SubscriptionBundleModelDao cur) {
                        List<SubscriptionModelDao> subscriptions = subscriptionSqlDao.getSubscriptionsFromBundleId(cur.getId().toString(), context);
                        Iterable nonAddonSubscriptions = Iterables.filter(subscriptions, (Predicate)new Predicate<SubscriptionModelDao>(){

                            public boolean apply(SubscriptionModelDao input) {
                                return input.getCategory() != ProductCategory.ADD_ON;
                            }
                        });
                        return Iterables.transform((Iterable)nonAddonSubscriptions, (Function)new Function<SubscriptionModelDao, UUID>(){

                            public UUID apply(SubscriptionModelDao input) {
                                return input.getId();
                            }
                        });
                    }
                }));
            }
        });
    }

    @Override
    public SubscriptionBaseBundle createSubscriptionBundle(final DefaultSubscriptionBaseBundle bundle, final InternalCallContext context) {
        return (SubscriptionBaseBundle)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<SubscriptionBaseBundle>(){

            public SubscriptionBaseBundle inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws EntityPersistenceException {
                SubscriptionBundleModelDao model = new SubscriptionBundleModelDao(bundle);
                ((BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class)).create(model, context);
                SubscriptionBundleModelDao result = (SubscriptionBundleModelDao)((BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class)).getById(bundle.getId().toString(), (InternalTenantContext)context);
                return SubscriptionBundleModelDao.toSubscriptionbundle(result);
            }
        });
    }

    @Override
    public UUID getAccountIdFromSubscriptionId(final UUID subscriptionId, final InternalTenantContext context) {
        return (UUID)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<UUID>(){

            public UUID inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionModelDao subscriptionModel = (SubscriptionModelDao)((SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class)).getById(subscriptionId.toString(), context);
                if (subscriptionModel == null) {
                    log.error(String.format(ErrorCode.SUB_INVALID_SUBSCRIPTION_ID.getFormat(), subscriptionId.toString()));
                    return null;
                }
                UUID bundleId = subscriptionModel.getBundleId();
                if (bundleId == null) {
                    log.error(String.format(ErrorCode.SUB_GET_NO_BUNDLE_FOR_SUBSCRIPTION.getFormat(), subscriptionId.toString()));
                    return null;
                }
                SubscriptionBundleModelDao bundleModel = (SubscriptionBundleModelDao)((BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class)).getById(bundleId.toString(), context);
                if (bundleModel == null) {
                    log.error(String.format(ErrorCode.SUB_GET_INVALID_BUNDLE_ID.getFormat(), bundleId.toString()));
                    return null;
                }
                return bundleModel.getAccountId();
            }
        });
    }

    @Override
    public SubscriptionBase getBaseSubscription(UUID bundleId, InternalTenantContext context) {
        return this.getBaseSubscription(bundleId, true, context);
    }

    @Override
    public SubscriptionBase getSubscriptionFromId(final UUID subscriptionId, final InternalTenantContext context) {
        SubscriptionBase shellSubscription = (SubscriptionBase)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<SubscriptionBase>(){

            public SubscriptionBase inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionModelDao model = (SubscriptionModelDao)((SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class)).getById(subscriptionId.toString(), context);
                return SubscriptionModelDao.toSubscription(model);
            }
        });
        return this.buildSubscription(shellSubscription, context);
    }

    @Override
    public List<SubscriptionBase> getSubscriptions(UUID bundleId, InternalTenantContext context) {
        return this.buildBundleSubscriptions(this.getSubscriptionFromBundleId(bundleId, context), null, context);
    }

    private List<SubscriptionBase> getSubscriptionFromBundleId(final UUID bundleId, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBase>>(){

            public List<SubscriptionBase> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List<SubscriptionModelDao> models = ((SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class)).getSubscriptionsFromBundleId(bundleId.toString(), context);
                return new ArrayList<SubscriptionBase>(Collections2.transform(models, (Function)new Function<SubscriptionModelDao, SubscriptionBase>(){

                    public SubscriptionBase apply(@Nullable SubscriptionModelDao input) {
                        return SubscriptionModelDao.toSubscription(input);
                    }
                }));
            }
        });
    }

    @Override
    public Map<UUID, List<SubscriptionBase>> getSubscriptionsForAccount(InternalTenantContext context) {
        Map<UUID, List<SubscriptionBase>> subscriptionsFromAccountId = this.getSubscriptionsFromAccountId(context);
        List<SubscriptionBaseEvent> eventsForAccount = this.getEventsForAccountId(context);
        HashMap<UUID, List<SubscriptionBase>> result = new HashMap<UUID, List<SubscriptionBase>>();
        for (UUID bundleId : subscriptionsFromAccountId.keySet()) {
            List<SubscriptionBase> subscriptionsForBundle = subscriptionsFromAccountId.get(bundleId);
            Collection subscriptionIdsForBundle = Collections2.transform(subscriptionsForBundle, (Function)new Function<SubscriptionBase, UUID>(){

                public UUID apply(SubscriptionBase input) {
                    return input.getId();
                }
            });
            ArrayListMultimap eventsForSubscriptions = ArrayListMultimap.create();
            for (final SubscriptionBase cur : subscriptionsForBundle) {
                Collection events = Collections2.filter(eventsForAccount, (Predicate)new Predicate<SubscriptionBaseEvent>(){

                    public boolean apply(SubscriptionBaseEvent input) {
                        return input.getSubscriptionId().equals(cur.getId());
                    }
                });
                eventsForSubscriptions.putAll((Object)cur.getId(), (Iterable)ImmutableList.copyOf((Collection)events));
            }
            result.put(bundleId, this.buildBundleSubscriptions(subscriptionsForBundle, (Multimap<UUID, SubscriptionBaseEvent>)eventsForSubscriptions, context));
        }
        return result;
    }

    private Map<UUID, List<SubscriptionBase>> getSubscriptionsFromAccountId(final InternalTenantContext context) {
        List allSubscriptions = (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBase>>(){

            public List<SubscriptionBase> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List models = ((SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class)).getByAccountRecordId(context);
                return new ArrayList<SubscriptionBase>(Collections2.transform((Collection)models, (Function)new Function<SubscriptionModelDao, SubscriptionBase>(){

                    public SubscriptionBase apply(SubscriptionModelDao input) {
                        return SubscriptionModelDao.toSubscription(input);
                    }
                }));
            }
        });
        HashMap<UUID, List<SubscriptionBase>> result = new HashMap<UUID, List<SubscriptionBase>>();
        for (SubscriptionBase subscriptionBase : allSubscriptions) {
            if (result.get(subscriptionBase.getBundleId()) == null) {
                result.put(subscriptionBase.getBundleId(), new LinkedList());
            }
            ((List)result.get(subscriptionBase.getBundleId())).add(subscriptionBase);
        }
        return result;
    }

    @Override
    public void updateChargedThroughDate(final DefaultSubscriptionBase subscription, final InternalCallContext context) {
        final Date ctd = subscription.getChargedThroughDate() != null ? subscription.getChargedThroughDate().toDate() : null;
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionSqlDao transactionalDao = (SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class);
                transactionalDao.updateChargedThroughDate(subscription.getId().toString(), ctd, context);
                BundleSqlDao bundleSqlDao = (BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class);
                String bundleId = subscription.getBundleId().toString();
                bundleSqlDao.updateBundleLastSysTime(bundleId, DefaultSubscriptionDao.this.clock.getUTCNow().toDate(), context);
                return null;
            }
        });
    }

    @Override
    public void createNextPhaseEvent(final DefaultSubscriptionBase subscription, final SubscriptionBaseEvent nextPhase, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionEventSqlDao transactional = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                UUID subscriptionId = subscription.getId();
                DefaultSubscriptionDao.this.cancelNextPhaseEventFromTransaction(subscriptionId, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, context);
                transactional.create(new SubscriptionEventModelDao(nextPhase), context);
                DefaultSubscriptionDao.this.recordFutureNotificationFromTransaction((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, nextPhase.getEffectiveDate(), new SubscriptionNotificationKey(nextPhase.getId()), context);
                DefaultSubscriptionDao.this.notifyBusOfRequestedChange((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, subscription, nextPhase, context);
                return null;
            }
        });
    }

    @Override
    public SubscriptionBaseEvent getEventById(final UUID eventId, final InternalTenantContext context) {
        return (SubscriptionBaseEvent)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<SubscriptionBaseEvent>(){

            public SubscriptionBaseEvent inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionEventModelDao model = (SubscriptionEventModelDao)((SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class)).getById(eventId.toString(), context);
                return SubscriptionEventModelDao.toSubscriptionEvent(model);
            }
        });
    }

    @Override
    public List<SubscriptionBaseEvent> getEventsForSubscription(final UUID subscriptionId, final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBaseEvent>>(){

            public List<SubscriptionBaseEvent> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List<SubscriptionEventModelDao> models = ((SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class)).getEventsForSubscription(subscriptionId.toString(), context);
                return DefaultSubscriptionDao.this.filterSubscriptionBaseEvents(models);
            }
        });
    }

    @Override
    public Map<UUID, List<SubscriptionBaseEvent>> getEventsForBundle(final UUID bundleId, final InternalTenantContext context) {
        return (Map)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Map<UUID, List<SubscriptionBaseEvent>>>(){

            public Map<UUID, List<SubscriptionBaseEvent>> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionSqlDao transactional = (SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class);
                List<SubscriptionModelDao> subscriptionModels = transactional.getSubscriptionsFromBundleId(bundleId.toString(), context);
                if (subscriptionModels.size() == 0) {
                    return Collections.emptyMap();
                }
                SubscriptionEventSqlDao eventsDaoFromSameTransaction = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                HashMap<UUID, List<SubscriptionBaseEvent>> result = new HashMap<UUID, List<SubscriptionBaseEvent>>();
                for (SubscriptionModelDao cur : subscriptionModels) {
                    List<SubscriptionEventModelDao> eventModels = eventsDaoFromSameTransaction.getEventsForSubscription(cur.getId().toString(), context);
                    ArrayList events = new ArrayList(Collections2.transform(eventModels, (Function)new Function<SubscriptionEventModelDao, SubscriptionBaseEvent>(){

                        public SubscriptionBaseEvent apply(@Nullable SubscriptionEventModelDao input) {
                            return SubscriptionEventModelDao.toSubscriptionEvent(input);
                        }
                    }));
                    result.put(cur.getId(), events);
                }
                return result;
            }
        });
    }

    @Override
    public List<SubscriptionBaseEvent> getPendingEventsForSubscription(final UUID subscriptionId, final InternalTenantContext context) {
        final Date now = this.clock.getUTCNow().toDate();
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBaseEvent>>(){

            public List<SubscriptionBaseEvent> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List<SubscriptionEventModelDao> eventModels = ((SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class)).getFutureActiveEventForSubscription(subscriptionId.toString(), now, context);
                ArrayList<SubscriptionBaseEvent> events = new ArrayList<SubscriptionBaseEvent>(Collections2.transform(eventModels, (Function)new Function<SubscriptionEventModelDao, SubscriptionBaseEvent>(){

                    public SubscriptionBaseEvent apply(@Nullable SubscriptionEventModelDao input) {
                        return SubscriptionEventModelDao.toSubscriptionEvent(input);
                    }
                }));
                return events;
            }
        });
    }

    @Override
    public void createSubscription(final DefaultSubscriptionBase subscription, final List<SubscriptionBaseEvent> initialEvents, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionSqlDao transactional = (SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class);
                transactional.create(new SubscriptionModelDao(subscription), context);
                SubscriptionEventSqlDao eventsDaoFromSameTransaction = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                for (SubscriptionBaseEvent cur : initialEvents) {
                    eventsDaoFromSameTransaction.create(new SubscriptionEventModelDao(cur), context);
                    boolean isBusEvent = cur.getEffectiveDate().compareTo((ReadableInstant)DefaultSubscriptionDao.this.clock.getUTCNow()) <= 0 && cur.getType() == SubscriptionBaseEvent.EventType.API_USER;
                    DefaultSubscriptionDao.this.recordBusOrFutureNotificationFromTransaction(subscription, cur, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, isBusEvent, 0, context);
                }
                if (initialEvents.size() > 0) {
                    DefaultSubscriptionDao.this.notifyBusOfRequestedChange((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, subscription, (SubscriptionBaseEvent)initialEvents.get(initialEvents.size() - 1), context);
                }
                return null;
            }
        });
    }

    @Override
    public void recreateSubscription(final DefaultSubscriptionBase subscription, final List<SubscriptionBaseEvent> recreateEvents, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionEventSqlDao transactional = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                for (SubscriptionBaseEvent cur : recreateEvents) {
                    transactional.create(new SubscriptionEventModelDao(cur), context);
                    boolean isBusEvent = cur.getEffectiveDate().compareTo((ReadableInstant)DefaultSubscriptionDao.this.clock.getUTCNow()) <= 0 && cur.getType() == SubscriptionBaseEvent.EventType.API_USER;
                    DefaultSubscriptionDao.this.recordBusOrFutureNotificationFromTransaction(subscription, cur, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, isBusEvent, 0, context);
                }
                DefaultSubscriptionDao.this.notifyBusOfRequestedChange((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, subscription, (SubscriptionBaseEvent)recreateEvents.get(recreateEvents.size() - 1), context);
                return null;
            }
        });
    }

    @Override
    public void cancelSubscriptions(final List<DefaultSubscriptionBase> subscriptions, final List<SubscriptionBaseEvent> cancelEvents, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                for (int i = 0; i < subscriptions.size(); ++i) {
                    DefaultSubscriptionBase subscription = (DefaultSubscriptionBase)((Object)subscriptions.get(i));
                    SubscriptionBaseEvent cancelEvent = (SubscriptionBaseEvent)cancelEvents.get(i);
                    DefaultSubscriptionDao.this.cancelSubscriptionFromTransaction(subscription, cancelEvent, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, context, i);
                }
                return null;
            }
        });
    }

    @Override
    public void cancelSubscription(final DefaultSubscriptionBase subscription, final SubscriptionBaseEvent cancelEvent, final InternalCallContext context, final int seqId) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                DefaultSubscriptionDao.this.cancelSubscriptionFromTransaction(subscription, cancelEvent, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, context, seqId);
                return null;
            }
        });
    }

    @Override
    public void uncancelSubscription(final DefaultSubscriptionBase subscription, final List<SubscriptionBaseEvent> uncancelEvents, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionEventSqlDao transactional = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                UUID subscriptionId = subscription.getId();
                SubscriptionEventModelDao cancelledEvent = null;
                Date now = DefaultSubscriptionDao.this.clock.getUTCNow().toDate();
                List<SubscriptionEventModelDao> eventModels = transactional.getFutureActiveEventForSubscription(subscriptionId.toString(), now, (InternalTenantContext)context);
                for (SubscriptionEventModelDao cur : eventModels) {
                    if (cur.getUserType() != ApiEventType.CANCEL) continue;
                    if (cancelledEvent != null) {
                        throw new SubscriptionBaseError(String.format("Found multiple cancelWithRequestedDate active events for subscriptions %s", subscriptionId.toString()));
                    }
                    cancelledEvent = cur;
                }
                if (cancelledEvent != null) {
                    String cancelledEventId = cancelledEvent.getId().toString();
                    transactional.unactiveEvent(cancelledEventId, context);
                    for (SubscriptionBaseEvent cur : uncancelEvents) {
                        transactional.create(new SubscriptionEventModelDao(cur), context);
                        DefaultSubscriptionDao.this.recordFutureNotificationFromTransaction((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, cur.getEffectiveDate(), new SubscriptionNotificationKey(cur.getId()), context);
                    }
                    DefaultSubscriptionDao.this.notifyBusOfRequestedChange((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, subscription, (SubscriptionBaseEvent)uncancelEvents.get(uncancelEvents.size() - 1), context);
                }
                return null;
            }
        });
    }

    @Override
    public void changePlan(final DefaultSubscriptionBase subscription, final List<SubscriptionBaseEvent> changeEvents, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionEventSqlDao transactional = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                UUID subscriptionId = subscription.getId();
                List<SubscriptionBaseEvent> changeEventsTweakedWithMigrateBilling = DefaultSubscriptionDao.this.reinsertFutureMigrateBillingEventOnChangeFromTransaction(subscriptionId, changeEvents, entitySqlDaoWrapperFactory, context);
                DefaultSubscriptionDao.this.cancelFutureEventsFromTransaction(subscriptionId, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, context);
                for (SubscriptionBaseEvent cur : changeEventsTweakedWithMigrateBilling) {
                    transactional.create(new SubscriptionEventModelDao(cur), context);
                    boolean isBusEvent = cur.getEffectiveDate().compareTo((ReadableInstant)DefaultSubscriptionDao.this.clock.getUTCNow()) <= 0 && cur.getType() == SubscriptionBaseEvent.EventType.API_USER;
                    DefaultSubscriptionDao.this.recordBusOrFutureNotificationFromTransaction(subscription, cur, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, isBusEvent, 0, context);
                }
                SubscriptionBaseEvent finalEvent = changeEventsTweakedWithMigrateBilling.get(changeEvents.size() - 1);
                DefaultSubscriptionDao.this.notifyBusOfRequestedChange((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, subscription, finalEvent, context);
                return null;
            }
        });
    }

    final List<SubscriptionBaseEvent> reinsertFutureMigrateBillingEventOnChangeFromTransaction(UUID subscriptionId, List<SubscriptionBaseEvent> changeEvents, EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, InternalCallContext context) {
        SubscriptionEventModelDao migrateBillingEvent = this.findFutureEventFromTransaction(subscriptionId, entitySqlDaoWrapperFactory, SubscriptionBaseEvent.EventType.API_USER, ApiEventType.MIGRATE_BILLING, context);
        if (migrateBillingEvent == null) {
            return changeEvents;
        }
        String prevPlan = null;
        String prevPhase = null;
        String prevPriceList = null;
        String curPlan = null;
        String curPhase = null;
        String curPriceList = null;
        for (SubscriptionBaseEvent cur : changeEvents) {
            switch (cur.getType()) {
                case API_USER: {
                    ApiEvent apiEvent = (ApiEvent)cur;
                    curPlan = apiEvent.getEventPlan();
                    curPhase = apiEvent.getEventPlanPhase();
                    curPriceList = apiEvent.getPriceList();
                    break;
                }
                case PHASE: {
                    PhaseEvent phaseEvent = (PhaseEvent)cur;
                    curPhase = phaseEvent.getPhase();
                    break;
                }
                default: {
                    throw new SubscriptionBaseError("Unknown event type " + (Object)((Object)cur.getType()));
                }
            }
            if (cur.getEffectiveDate().compareTo((ReadableInstant)migrateBillingEvent.getEffectiveDate()) > 0) {
                if (cur.getType() != SubscriptionBaseEvent.EventType.API_USER || ((ApiEvent)cur).getEventType() != ApiEventType.CHANGE) break;
                return changeEvents;
            }
            prevPlan = curPlan;
            prevPhase = curPhase;
            prevPriceList = curPriceList;
        }
        if (prevPlan != null) {
            DateTime now = this.clock.getUTCNow();
            ApiEventBuilder builder = ((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setActive(true)).setEventType(ApiEventType.MIGRATE_BILLING).setFromDisk(true).setTotalOrdering(migrateBillingEvent.getTotalOrdering())).setUuid(UUID.randomUUID())).setSubscriptionId(migrateBillingEvent.getSubscriptionId())).setCreatedDate(now)).setUpdatedDate(now)).setRequestedDate(migrateBillingEvent.getRequestedDate())).setEffectiveDate(migrateBillingEvent.getEffectiveDate())).setProcessedDate(now)).setActiveVersion(migrateBillingEvent.getCurrentVersion())).setEventPlan(prevPlan).setEventPlanPhase(prevPhase).setEventPriceList(prevPriceList);
            ApiEventMigrateBilling newMigrateBillingEvent = new ApiEventMigrateBilling(builder);
            changeEvents.add(newMigrateBillingEvent);
            Collections.sort(changeEvents, new Comparator<SubscriptionBaseEvent>(){

                @Override
                public int compare(SubscriptionBaseEvent o1, SubscriptionBaseEvent o2) {
                    return o1.getEffectiveDate().compareTo((ReadableInstant)o2.getEffectiveDate());
                }
            });
        }
        return changeEvents;
    }

    private List<SubscriptionBaseEvent> filterSubscriptionBaseEvents(List<SubscriptionEventModelDao> models) {
        Collection filteredModels = Collections2.filter(models, (Predicate)new Predicate<SubscriptionEventModelDao>(){

            public boolean apply(@Nullable SubscriptionEventModelDao input) {
                return input.getUserType() != ApiEventType.UNCANCEL;
            }
        });
        return new ArrayList<SubscriptionBaseEvent>(Collections2.transform((Collection)filteredModels, (Function)new Function<SubscriptionEventModelDao, SubscriptionBaseEvent>(){

            public SubscriptionBaseEvent apply(@Nullable SubscriptionEventModelDao input) {
                return SubscriptionEventModelDao.toSubscriptionEvent(input);
            }
        }));
    }

    private List<SubscriptionBaseEvent> getEventsForAccountId(final InternalTenantContext context) {
        return (List)this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<List<SubscriptionBaseEvent>>(){

            public List<SubscriptionBaseEvent> inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                List models = ((SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class)).getByAccountRecordId(context);
                return DefaultSubscriptionDao.this.filterSubscriptionBaseEvents(models);
            }
        });
    }

    private void cancelSubscriptionFromTransaction(DefaultSubscriptionBase subscription, SubscriptionBaseEvent cancelEvent, EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, InternalCallContext context, int seqId) throws EntityPersistenceException {
        UUID subscriptionId = subscription.getId();
        this.cancelFutureEventsFromTransaction(subscriptionId, entitySqlDaoWrapperFactory, context);
        ((SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class)).create(new SubscriptionEventModelDao(cancelEvent), context);
        boolean isBusEvent = cancelEvent.getEffectiveDate().compareTo((ReadableInstant)this.clock.getUTCNow()) <= 0;
        this.recordBusOrFutureNotificationFromTransaction(subscription, cancelEvent, entitySqlDaoWrapperFactory, isBusEvent, seqId, context);
        this.notifyBusOfRequestedChange(entitySqlDaoWrapperFactory, subscription, cancelEvent, context);
    }

    private void cancelNextPhaseEventFromTransaction(UUID subscriptionId, EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, InternalCallContext context) {
        this.cancelFutureEventFromTransaction(subscriptionId, entitySqlDaoWrapperFactory, SubscriptionBaseEvent.EventType.PHASE, null, context);
    }

    private void cancelFutureEventsFromTransaction(UUID subscriptionId, EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, InternalCallContext context) {
        Date now = this.clock.getUTCNow().toDate();
        List<SubscriptionEventModelDao> eventModels = ((SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class)).getFutureActiveEventForSubscription(subscriptionId.toString(), now, (InternalTenantContext)context);
        for (SubscriptionEventModelDao cur : eventModels) {
            this.unactivateEventFromTransaction(cur, entitySqlDaoWrapperFactory, context);
        }
    }

    private void cancelFutureEventFromTransaction(UUID subscriptionId, EntitySqlDaoWrapperFactory<EntitySqlDao> dao, SubscriptionBaseEvent.EventType type, @Nullable ApiEventType apiType, InternalCallContext context) {
        SubscriptionEventModelDao futureEvent = this.findFutureEventFromTransaction(subscriptionId, dao, type, apiType, context);
        this.unactivateEventFromTransaction(futureEvent, dao, context);
    }

    private SubscriptionEventModelDao findFutureEventFromTransaction(UUID subscriptionId, EntitySqlDaoWrapperFactory<EntitySqlDao> dao, SubscriptionBaseEvent.EventType type, @Nullable ApiEventType apiType, InternalCallContext context) {
        SubscriptionEventModelDao futureEvent = null;
        Date now = this.clock.getUTCNow().toDate();
        List<SubscriptionEventModelDao> eventModels = ((SubscriptionEventSqlDao)dao.become(SubscriptionEventSqlDao.class)).getFutureActiveEventForSubscription(subscriptionId.toString(), now, (InternalTenantContext)context);
        for (SubscriptionEventModelDao cur : eventModels) {
            if (cur.getEventType() != type || apiType != null && apiType != cur.getUserType()) continue;
            if (futureEvent != null) {
                throw new SubscriptionBaseError(String.format("Found multiple future events for type %s for subscriptions %s", new Object[]{type, subscriptionId.toString()}));
            }
            futureEvent = cur;
        }
        return futureEvent;
    }

    private void unactivateEventFromTransaction(SubscriptionEventModelDao event, EntitySqlDaoWrapperFactory<EntitySqlDao> dao, InternalCallContext context) {
        if (event != null) {
            String eventId = event.getId().toString();
            ((SubscriptionEventSqlDao)dao.become(SubscriptionEventSqlDao.class)).unactiveEvent(eventId, context);
        }
    }

    private SubscriptionBase buildSubscription(SubscriptionBase input, InternalTenantContext context) {
        if (input == null) {
            return null;
        }
        ArrayList<SubscriptionBase> bundleInput = new ArrayList<SubscriptionBase>();
        if (input.getCategory() == ProductCategory.ADD_ON) {
            SubscriptionBase baseSubscription = this.getBaseSubscription(input.getBundleId(), false, context);
            if (baseSubscription == null) {
                return null;
            }
            bundleInput.add(baseSubscription);
            bundleInput.add(input);
        } else {
            bundleInput.add(input);
        }
        List<SubscriptionBase> reloadedSubscriptions = this.buildBundleSubscriptions(bundleInput, null, context);
        for (SubscriptionBase cur : reloadedSubscriptions) {
            if (!cur.getId().equals(input.getId())) continue;
            return cur;
        }
        throw new SubscriptionBaseError("Unexpected code path in buildSubscription");
    }

    private List<SubscriptionBase> buildBundleSubscriptions(List<SubscriptionBase> input, @Nullable Multimap<UUID, SubscriptionBaseEvent> eventsForSubscription, InternalTenantContext context) {
        if (input == null || input.size() == 0) {
            return Collections.emptyList();
        }
        Collections.sort(input, new Comparator<SubscriptionBase>(){

            @Override
            public int compare(SubscriptionBase o1, SubscriptionBase o2) {
                if (o1.getCategory() == ProductCategory.BASE) {
                    return -1;
                }
                if (o2.getCategory() == ProductCategory.BASE) {
                    return 1;
                }
                return ((DefaultSubscriptionBase)o1).getAlignStartDate().compareTo((ReadableInstant)((DefaultSubscriptionBase)o2).getAlignStartDate());
            }
        });
        SubscriptionBaseEvent futureBaseEvent = null;
        ArrayList<SubscriptionBase> result = new ArrayList<SubscriptionBase>(input.size());
        for (SubscriptionBase cur : input) {
            List<SubscriptionBaseEvent> events = eventsForSubscription != null ? (List<SubscriptionBaseEvent>)eventsForSubscription.get((Object)cur.getId()) : this.getEventsForSubscription(cur.getId(), context);
            DefaultSubscriptionBase reloaded = this.createSubscriptionForInternalUse(cur, events);
            switch (cur.getCategory()) {
                case BASE: {
                    Collection futureApiEvents = Collections2.filter(events, (Predicate)new Predicate<SubscriptionBaseEvent>(){

                        public boolean apply(SubscriptionBaseEvent input) {
                            return input.isActive() && input.getEffectiveDate().isAfter((ReadableInstant)DefaultSubscriptionDao.this.clock.getUTCNow()) && (input instanceof ApiEventCancel || input instanceof ApiEventChange);
                        }
                    });
                    futureBaseEvent = futureApiEvents.size() == 0 ? null : (SubscriptionBaseEvent)futureApiEvents.iterator().next();
                    break;
                }
                case ADD_ON: {
                    boolean createCancelEvent;
                    Plan targetAddOnPlan = reloaded.getCurrentPlan();
                    String baseProductName = futureBaseEvent instanceof ApiEventChange ? ((ApiEventChange)futureBaseEvent).getEventPlan() : null;
                    boolean bl = createCancelEvent = futureBaseEvent != null && targetAddOnPlan != null && (futureBaseEvent instanceof ApiEventCancel || !this.addonUtils.isAddonAvailableFromPlanName(baseProductName, futureBaseEvent.getEffectiveDate(), targetAddOnPlan) || this.addonUtils.isAddonIncludedFromPlanName(baseProductName, futureBaseEvent.getEffectiveDate(), targetAddOnPlan));
                    if (!createCancelEvent || reloaded.getFutureEndDate() != null) break;
                    DateTime now = this.clock.getUTCNow();
                    ApiEventCancel addOnCancelEvent = new ApiEventCancel(((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)((ApiEventBuilder)new ApiEventBuilder().setSubscriptionId(reloaded.getId())).setActiveVersion(reloaded.getActiveVersion())).setProcessedDate(now)).setEffectiveDate(futureBaseEvent.getEffectiveDate())).setRequestedDate(now)).setCreatedDate(futureBaseEvent.getCreatedDate())).setFromDisk(false));
                    events.add(addOnCancelEvent);
                    reloaded = this.createSubscriptionForInternalUse(cur, events);
                    break;
                }
            }
            result.add(reloaded);
        }
        return result;
    }

    @Override
    public void migrate(UUID accountId, final AccountMigrationData accountData, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionEventSqlDao transactional = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                for (AccountMigrationData.BundleMigrationData curBundle : accountData.getData()) {
                    DefaultSubscriptionDao.this.migrateBundleDataFromTransaction(curBundle, transactional, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, context);
                }
                return null;
            }
        });
    }

    @Override
    public void repair(final UUID accountId, final UUID bundleId, final List<SubscriptionDataRepair> inRepair, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionSqlDao transactional = (SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class);
                SubscriptionEventSqlDao transEventDao = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                for (SubscriptionDataRepair cur : inRepair) {
                    transactional.updateForRepair(cur.getId().toString(), cur.getActiveVersion(), cur.getAlignStartDate().toDate(), cur.getBundleStartDate().toDate(), context);
                    for (SubscriptionBaseEvent event : cur.getInitialEvents()) {
                        transEventDao.updateVersion(event.getId().toString(), event.getActiveVersion(), context);
                    }
                    for (SubscriptionBaseEvent event : cur.getNewEvents()) {
                        transEventDao.create(new SubscriptionEventModelDao(event), context);
                        if (!event.getEffectiveDate().isAfter((ReadableInstant)DefaultSubscriptionDao.this.clock.getUTCNow())) continue;
                        DefaultSubscriptionDao.this.recordFutureNotificationFromTransaction((EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, event.getEffectiveDate(), new SubscriptionNotificationKey(event.getId()), context);
                    }
                }
                try {
                    DefaultRepairSubscriptionEvent busEvent = new DefaultRepairSubscriptionEvent(accountId, bundleId, DefaultSubscriptionDao.this.clock.getUTCNow(), context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken());
                    DefaultSubscriptionDao.this.eventBus.postFromTransaction((BusEvent)busEvent, (Transmogrifier)entitySqlDaoWrapperFactory.getSqlDao());
                }
                catch (PersistentBus.EventBusException e) {
                    log.warn("Failed to post repair subscription event for bundle " + bundleId, (Throwable)e);
                }
                return null;
            }
        });
    }

    @Override
    public void transfer(UUID srcAccountId, UUID destAccountId, final AccountMigrationData.BundleMigrationData bundleTransferData, final List<TransferCancelData> transferCancelData, final InternalCallContext fromContext, final InternalCallContext toContext) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                SubscriptionEventSqlDao transactional = (SubscriptionEventSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionEventSqlDao.class);
                for (TransferCancelData cancel : transferCancelData) {
                    DefaultSubscriptionDao.this.cancelSubscriptionFromTransaction(cancel.getSubscription(), cancel.getCancelEvent(), (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, fromContext, 0);
                }
                DefaultSubscriptionDao.this.migrateBundleDataFromTransaction(bundleTransferData, transactional, (EntitySqlDaoWrapperFactory<EntitySqlDao>)entitySqlDaoWrapperFactory, toContext);
                return null;
            }
        });
    }

    @Override
    public void updateBundleExternalKey(final UUID bundleId, final String externalKey, final InternalCallContext context) {
        this.transactionalSqlDao.execute((EntitySqlDaoTransactionWrapper)new EntitySqlDaoTransactionWrapper<Void>(){

            public Void inTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory) throws Exception {
                BundleSqlDao bundleSqlDao = (BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class);
                bundleSqlDao.updateBundleExternalKey(bundleId.toString(), externalKey, context);
                return null;
            }
        });
    }

    private DefaultSubscriptionBase createSubscriptionForInternalUse(SubscriptionBase shellSubscription, List<SubscriptionBaseEvent> events) {
        DefaultSubscriptionBase result = new DefaultSubscriptionBase(new SubscriptionBuilder((DefaultSubscriptionBase)shellSubscription), null, this.clock);
        if (events.size() > 0) {
            result.rebuildTransitions(events, this.catalogService.getFullCatalog());
        }
        return result;
    }

    private SubscriptionBase getBaseSubscription(UUID bundleId, boolean rebuildSubscription, InternalTenantContext context) {
        List<SubscriptionBase> subscriptions = this.getSubscriptionFromBundleId(bundleId, context);
        for (SubscriptionBase cur : subscriptions) {
            if (cur.getCategory() != ProductCategory.BASE) continue;
            return rebuildSubscription ? this.buildSubscription(cur, context) : cur;
        }
        return null;
    }

    private void recordBusOrFutureNotificationFromTransaction(DefaultSubscriptionBase subscription, SubscriptionBaseEvent event, EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, boolean busEvent, int seqId, InternalCallContext context) {
        if (busEvent) {
            this.notifyBusOfEffectiveImmediateChange(entitySqlDaoWrapperFactory, subscription, event, seqId, context);
        } else {
            this.recordFutureNotificationFromTransaction(entitySqlDaoWrapperFactory, event.getEffectiveDate(), new SubscriptionNotificationKey(event.getId()), context);
        }
    }

    private void notifyBusOfEffectiveImmediateChange(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, DefaultSubscriptionBase subscription, SubscriptionBaseEvent immediateEvent, int seqId, InternalCallContext context) {
        try {
            DefaultSubscriptionBase upToDateSubscription = this.createSubscriptionWithNewEvent(subscription, immediateEvent);
            SubscriptionBaseTransitionData transition = upToDateSubscription.getTransitionFromEvent(immediateEvent, seqId);
            DefaultEffectiveSubscriptionEvent busEvent = new DefaultEffectiveSubscriptionEvent(transition, upToDateSubscription.getAlignStartDate(), context.getUserToken(), context.getAccountRecordId(), context.getTenantRecordId());
            this.eventBus.postFromTransaction((BusEvent)busEvent, (Transmogrifier)entitySqlDaoWrapperFactory.getSqlDao());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post effective event for subscription " + subscription.getId(), (Throwable)e);
        }
    }

    private void notifyBusOfRequestedChange(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, DefaultSubscriptionBase subscription, SubscriptionBaseEvent nextEvent, InternalCallContext context) {
        try {
            this.eventBus.postFromTransaction((BusEvent)new DefaultRequestedSubscriptionEvent(subscription, nextEvent, context.getAccountRecordId(), context.getTenantRecordId(), context.getUserToken()), (Transmogrifier)entitySqlDaoWrapperFactory.getSqlDao());
        }
        catch (PersistentBus.EventBusException e) {
            log.warn("Failed to post requested change event for subscription " + subscription.getId(), (Throwable)e);
        }
    }

    private void recordFutureNotificationFromTransaction(EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, DateTime effectiveDate, NotificationEvent notificationKey, InternalCallContext context) {
        try {
            NotificationQueue subscriptionEventQueue = this.notificationQueueService.getNotificationQueue("subscription-service", "subscription-events");
            subscriptionEventQueue.recordFutureNotificationFromTransaction((Transmogrifier)entitySqlDaoWrapperFactory.getSqlDao(), effectiveDate, notificationKey, context.getUserToken(), context.getAccountRecordId(), context.getTenantRecordId());
        }
        catch (NotificationQueueService.NoSuchNotificationQueue e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void migrateBundleDataFromTransaction(AccountMigrationData.BundleMigrationData bundleTransferData, SubscriptionEventSqlDao transactional, EntitySqlDaoWrapperFactory<EntitySqlDao> entitySqlDaoWrapperFactory, InternalCallContext context) throws EntityPersistenceException {
        DefaultSubscriptionBaseBundle bundleData;
        SubscriptionSqlDao transSubDao = (SubscriptionSqlDao)entitySqlDaoWrapperFactory.become(SubscriptionSqlDao.class);
        BundleSqlDao transBundleDao = (BundleSqlDao)entitySqlDaoWrapperFactory.become(BundleSqlDao.class);
        List<SubscriptionBundleModelDao> existingBundleModels = transBundleDao.getBundlesFromAccountAndKey((bundleData = bundleTransferData.getData()).getAccountId().toString(), bundleData.getExternalKey(), (InternalTenantContext)context);
        if (existingBundleModels.size() != 0) {
            log.error(String.format("Attempted to create a bundle for account %s and key %s that already existed, skip...", bundleData.getAccountId().toString(), bundleData.getExternalKey()));
            return;
        }
        for (AccountMigrationData.SubscriptionMigrationData curSubscription : bundleTransferData.getSubscriptions()) {
            DefaultSubscriptionBase subData = curSubscription.getData();
            for (SubscriptionBaseEvent curEvent : curSubscription.getInitialEvents()) {
                transactional.create(new SubscriptionEventModelDao(curEvent), context);
                this.recordFutureNotificationFromTransaction(entitySqlDaoWrapperFactory, curEvent.getEffectiveDate(), new SubscriptionNotificationKey(curEvent.getId()), context);
            }
            transSubDao.create(new SubscriptionModelDao(subData), context);
            SubscriptionBaseEvent finalEvent = curSubscription.getInitialEvents().get(curSubscription.getInitialEvents().size() - 1);
            this.notifyBusOfRequestedChange(entitySqlDaoWrapperFactory, subData, finalEvent, context);
        }
        transBundleDao.create(new SubscriptionBundleModelDao(bundleData), context);
    }

    private DefaultSubscriptionBase createSubscriptionWithNewEvent(DefaultSubscriptionBase subscription, SubscriptionBaseEvent newEvent) {
        DefaultSubscriptionBase subscriptionWithNewEvent = new DefaultSubscriptionBase(subscription, null, this.clock);
        LinkedList<SubscriptionBaseEvent> allEvents = new LinkedList<SubscriptionBaseEvent>();
        if (subscriptionWithNewEvent.getEvents() != null) {
            allEvents.addAll(subscriptionWithNewEvent.getEvents());
        }
        allEvents.add(newEvent);
        subscriptionWithNewEvent.rebuildTransitions(allEvents, this.catalogService.getFullCatalog());
        return subscriptionWithNewEvent;
    }
}

