/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.dao;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.ning.billing.ErrorCode;
import com.ning.billing.callcontext.InternalCallContext;
import com.ning.billing.callcontext.InternalTenantContext;
import com.ning.billing.clock.Clock;
import com.ning.billing.entitlement.api.SubscriptionApiException;
import com.ning.billing.subscription.api.SubscriptionBase;
import com.ning.billing.subscription.api.migration.AccountMigrationData;
import com.ning.billing.subscription.api.timeline.RepairSubscriptionLifecycleDao;
import com.ning.billing.subscription.api.timeline.SubscriptionDataRepair;
import com.ning.billing.subscription.api.transfer.TransferCancelData;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBase;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseBundle;
import com.ning.billing.subscription.api.user.SubscriptionBaseBundle;
import com.ning.billing.subscription.engine.dao.BundleSqlDao;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.subscription.engine.dao.model.SubscriptionBundleModelDao;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.cache.CacheControllerDispatcher;
import com.ning.billing.util.dao.NonEntityDao;
import com.ning.billing.util.entity.Pagination;
import com.ning.billing.util.entity.dao.EntityDaoBase;
import com.ning.billing.util.entity.dao.EntitySqlDaoTransactionalJdbiWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.inject.Inject;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.IDBI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepairSubscriptionDao
extends EntityDaoBase<SubscriptionBundleModelDao, SubscriptionBaseBundle, SubscriptionApiException>
implements SubscriptionDao,
RepairSubscriptionLifecycleDao {
    private static final String NOT_IMPLEMENTED = "Not implemented";
    private final ThreadLocal<Map<UUID, SubscriptionRepairEvent>> preThreadsInRepairSubscriptions = new ThreadLocal();

    @Inject
    public RepairSubscriptionDao(IDBI dbi, Clock clock, CacheControllerDispatcher cacheControllerDispatcher, NonEntityDao nonEntityDao) {
        super(new EntitySqlDaoTransactionalJdbiWrapper(dbi, clock, cacheControllerDispatcher, nonEntityDao), BundleSqlDao.class);
    }

    protected SubscriptionApiException generateAlreadyExistsException(SubscriptionBundleModelDao entity, InternalCallContext context) {
        return new SubscriptionApiException(ErrorCode.SUB_CREATE_ACTIVE_BUNDLE_KEY_EXISTS, new Object[]{entity.getExternalKey()});
    }

    private Map<UUID, SubscriptionRepairEvent> getRepairMap() {
        if (this.preThreadsInRepairSubscriptions.get() == null) {
            this.preThreadsInRepairSubscriptions.set(new HashMap());
        }
        return this.preThreadsInRepairSubscriptions.get();
    }

    private SubscriptionRepairEvent getRepairSubscriptionEvents(UUID subscriptionId) {
        Map<UUID, SubscriptionRepairEvent> map = this.getRepairMap();
        return map.get(subscriptionId);
    }

    @Override
    public List<SubscriptionBaseEvent> getEventsForSubscription(UUID subscriptionId, InternalTenantContext context) {
        SubscriptionRepairEvent target = this.getRepairSubscriptionEvents(subscriptionId);
        return new LinkedList<SubscriptionBaseEvent>(target.getEvents());
    }

    @Override
    public void createSubscription(DefaultSubscriptionBase subscription, List<SubscriptionBaseEvent> createEvents, InternalCallContext context) {
        this.addEvents(subscription.getId(), createEvents);
    }

    @Override
    public void recreateSubscription(DefaultSubscriptionBase subscription, List<SubscriptionBaseEvent> recreateEvents, InternalCallContext context) {
        this.addEvents(subscription.getId(), recreateEvents);
    }

    @Override
    public void cancelSubscription(DefaultSubscriptionBase subscription, SubscriptionBaseEvent cancelEvent, InternalCallContext context, int cancelSeq) {
        UUID subscriptionId = subscription.getId();
        long activeVersion = cancelEvent.getActiveVersion();
        this.addEvents(subscriptionId, Collections.singletonList(cancelEvent));
        SubscriptionRepairEvent target = this.getRepairSubscriptionEvents(subscriptionId);
        boolean foundCancelEvent = false;
        for (SubscriptionBaseEvent cur : target.getEvents()) {
            if (cur.getId().equals(cancelEvent.getId())) {
                foundCancelEvent = true;
                continue;
            }
            if (!foundCancelEvent) continue;
            cur.setActiveVersion(activeVersion - 1L);
        }
    }

    @Override
    public void cancelSubscriptions(List<DefaultSubscriptionBase> subscriptions, List<SubscriptionBaseEvent> cancelEvents, InternalCallContext context) {
    }

    @Override
    public void changePlan(DefaultSubscriptionBase subscription, List<SubscriptionBaseEvent> changeEvents, InternalCallContext context) {
        this.addEvents(subscription.getId(), changeEvents);
    }

    @Override
    public void initializeRepair(UUID subscriptionId, List<SubscriptionBaseEvent> initialEvents, InternalTenantContext context) {
        Map<UUID, SubscriptionRepairEvent> map = this.getRepairMap();
        if (map.get(subscriptionId) != null) {
            throw new SubscriptionBaseError(String.format("Unexpected SubscriptionRepairEvent %s for thread %s", subscriptionId, Thread.currentThread().getName()));
        }
        SubscriptionRepairEvent value = new SubscriptionRepairEvent(initialEvents);
        map.put(subscriptionId, value);
    }

    @Override
    public void cleanup(InternalTenantContext context) {
        Map<UUID, SubscriptionRepairEvent> map = this.getRepairMap();
        map.clear();
    }

    private void addEvents(UUID subscriptionId, List<SubscriptionBaseEvent> events) {
        SubscriptionRepairEvent target = this.getRepairSubscriptionEvents(subscriptionId);
        target.addEvents(events);
    }

    @Override
    public void uncancelSubscription(DefaultSubscriptionBase subscription, List<SubscriptionBaseEvent> uncancelEvents, InternalCallContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public List<SubscriptionBaseBundle> getSubscriptionBundleForAccount(UUID accountId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public SubscriptionBaseBundle getSubscriptionBundleFromId(UUID bundleId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public SubscriptionBaseBundle createSubscriptionBundle(DefaultSubscriptionBaseBundle bundle, InternalCallContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public SubscriptionBase getSubscriptionFromId(UUID subscriptionId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public UUID getAccountIdFromSubscriptionId(UUID subscriptionId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public SubscriptionBase getBaseSubscription(UUID bundleId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public List<SubscriptionBase> getSubscriptions(UUID bundleId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public void updateChargedThroughDate(DefaultSubscriptionBase subscription, InternalCallContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public void createNextPhaseEvent(DefaultSubscriptionBase subscription, SubscriptionBaseEvent nextPhase, InternalCallContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public SubscriptionBaseEvent getEventById(UUID eventId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public Map<UUID, List<SubscriptionBase>> getSubscriptionsForAccount(InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public Map<UUID, List<SubscriptionBaseEvent>> getEventsForBundle(UUID bundleId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public List<SubscriptionBaseEvent> getPendingEventsForSubscription(UUID subscriptionId, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public void migrate(UUID accountId, AccountMigrationData data, InternalCallContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public void repair(UUID accountId, UUID bundleId, List<SubscriptionDataRepair> inRepair, InternalCallContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public void transfer(UUID srcAccountId, UUID destAccountId, AccountMigrationData.BundleMigrationData data, List<TransferCancelData> transferCancelData, InternalCallContext fromContext, InternalCallContext toContext) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public void updateBundleExternalKey(UUID bundleId, String externalKey, InternalCallContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public List<SubscriptionBaseBundle> getSubscriptionBundlesForKey(String bundleKey, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public Pagination<SubscriptionBundleModelDao> searchSubscriptionBundles(String searchKey, Long offset, Long limit, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    public List<UUID> getNonAOSubscriptionIdsForKey(String bundleKey, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    @Override
    public List<SubscriptionBaseBundle> getSubscriptionBundlesForAccountAndKey(UUID accountId, String bundleKey, InternalTenantContext context) {
        throw new SubscriptionBaseError(NOT_IMPLEMENTED);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubscriptionRepairEvent {
        private final Set<SubscriptionEventWithOrderingId> events = new TreeSet<SubscriptionEventWithOrderingId>(new Comparator<SubscriptionEventWithOrderingId>(){

            @Override
            public int compare(SubscriptionEventWithOrderingId o1, SubscriptionEventWithOrderingId o2) {
                if (o1 == o2) {
                    return 0;
                }
                int result = o1.getEvent().getEffectiveDate().compareTo((ReadableInstant)o2.getEvent().getEffectiveDate());
                if (result == 0) {
                    if (o1.getOrderingId() < o2.getOrderingId()) {
                        return -1;
                    }
                    if (o1.getOrderingId() > o2.getOrderingId()) {
                        return 1;
                    }
                    throw new RuntimeException(String.format(" Repair subscription events should not have the same orderingId %s, %s ", o1, o2));
                }
                return result;
            }
        });
        private long curOrderingId = 0L;

        public SubscriptionRepairEvent(List<SubscriptionBaseEvent> initialEvents) {
            if (initialEvents != null) {
                this.addEvents(initialEvents);
            }
        }

        public List<SubscriptionBaseEvent> getEvents() {
            return new ArrayList<SubscriptionBaseEvent>(Collections2.transform(this.events, (Function)new Function<SubscriptionEventWithOrderingId, SubscriptionBaseEvent>(){

                public SubscriptionBaseEvent apply(SubscriptionEventWithOrderingId in) {
                    return in.getEvent();
                }
            }));
        }

        public void addEvents(List<SubscriptionBaseEvent> newEvents) {
            for (SubscriptionBaseEvent cur : newEvents) {
                this.events.add(new SubscriptionEventWithOrderingId(cur, this.curOrderingId++));
            }
        }
    }

    private static final class SubscriptionEventWithOrderingId {
        private final SubscriptionBaseEvent event;
        private final long orderingId;

        public SubscriptionEventWithOrderingId(SubscriptionBaseEvent event, long orderingId) {
            this.event = event;
            this.orderingId = orderingId;
        }

        public SubscriptionBaseEvent getEvent() {
            return this.event;
        }

        public long getOrderingId() {
            return this.orderingId;
        }

        public String toString() {
            StringBuilder tmp = new StringBuilder();
            tmp.append("[");
            tmp.append((Object)this.event.getType());
            tmp.append(": effDate=");
            tmp.append(this.event.getEffectiveDate());
            tmp.append(", subId=");
            tmp.append(this.event.getSubscriptionId());
            tmp.append(", ordering=");
            tmp.append(this.event.getTotalOrdering());
            tmp.append("]");
            return tmp.toString();
        }
    }
}

