/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.engine.dao.model;

import com.ning.billing.entity.EntityBase;
import com.ning.billing.subscription.events.EventBase;
import com.ning.billing.subscription.events.EventBaseBuilder;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEvent;
import com.ning.billing.subscription.events.phase.PhaseEventBuilder;
import com.ning.billing.subscription.events.phase.PhaseEventData;
import com.ning.billing.subscription.events.user.ApiEvent;
import com.ning.billing.subscription.events.user.ApiEventBuilder;
import com.ning.billing.subscription.events.user.ApiEventCancel;
import com.ning.billing.subscription.events.user.ApiEventChange;
import com.ning.billing.subscription.events.user.ApiEventCreate;
import com.ning.billing.subscription.events.user.ApiEventMigrateBilling;
import com.ning.billing.subscription.events.user.ApiEventMigrateSubscription;
import com.ning.billing.subscription.events.user.ApiEventReCreate;
import com.ning.billing.subscription.events.user.ApiEventTransfer;
import com.ning.billing.subscription.events.user.ApiEventType;
import com.ning.billing.subscription.events.user.ApiEventUncancel;
import com.ning.billing.subscription.exceptions.SubscriptionBaseError;
import com.ning.billing.util.dao.TableName;
import com.ning.billing.util.entity.dao.EntityModelDao;
import java.util.UUID;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionEventModelDao
extends EntityBase
implements EntityModelDao<SubscriptionBaseEvent> {
    private long totalOrdering;
    private SubscriptionBaseEvent.EventType eventType;
    private ApiEventType userType;
    private DateTime requestedDate;
    private DateTime effectiveDate;
    private UUID subscriptionId;
    private String planName;
    private String phaseName;
    private String priceListName;
    private long currentVersion;
    private boolean isActive;

    public SubscriptionEventModelDao() {
    }

    public SubscriptionEventModelDao(UUID id, long totalOrdering, SubscriptionBaseEvent.EventType eventType, ApiEventType userType, DateTime requestedDate, DateTime effectiveDate, UUID subscriptionId, String planName, String phaseName, String priceListName, long currentVersion, boolean active, DateTime createDate, DateTime updateDate) {
        super(id, createDate, updateDate);
        this.totalOrdering = totalOrdering;
        this.eventType = eventType;
        this.userType = userType;
        this.requestedDate = requestedDate;
        this.effectiveDate = effectiveDate;
        this.subscriptionId = subscriptionId;
        this.planName = planName;
        this.phaseName = phaseName;
        this.priceListName = priceListName;
        this.currentVersion = currentVersion;
        this.isActive = active;
    }

    public SubscriptionEventModelDao(SubscriptionBaseEvent src) {
        super(src.getId(), src.getCreatedDate(), src.getUpdatedDate());
        this.totalOrdering = src.getTotalOrdering();
        this.eventType = src.getType();
        this.userType = this.eventType == SubscriptionBaseEvent.EventType.API_USER ? ((ApiEvent)src).getEventType() : null;
        this.requestedDate = src.getRequestedDate();
        this.effectiveDate = src.getEffectiveDate();
        this.subscriptionId = src.getSubscriptionId();
        this.planName = this.eventType == SubscriptionBaseEvent.EventType.API_USER ? ((ApiEvent)src).getEventPlan() : null;
        this.phaseName = this.eventType == SubscriptionBaseEvent.EventType.API_USER ? ((ApiEvent)src).getEventPlanPhase() : ((PhaseEvent)src).getPhase();
        this.priceListName = this.eventType == SubscriptionBaseEvent.EventType.API_USER ? ((ApiEvent)src).getPriceList() : null;
        this.currentVersion = src.getActiveVersion();
        this.isActive = src.isActive();
    }

    public long getTotalOrdering() {
        return this.totalOrdering;
    }

    public SubscriptionBaseEvent.EventType getEventType() {
        return this.eventType;
    }

    public ApiEventType getUserType() {
        return this.userType;
    }

    public DateTime getRequestedDate() {
        return this.requestedDate;
    }

    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getPlanName() {
        return this.planName;
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public String getPriceListName() {
        return this.priceListName;
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setTotalOrdering(long totalOrdering) {
        this.totalOrdering = totalOrdering;
    }

    public void setEventType(SubscriptionBaseEvent.EventType eventType) {
        this.eventType = eventType;
    }

    public void setUserType(ApiEventType userType) {
        this.userType = userType;
    }

    public void setRequestedDate(DateTime requestedDate) {
        this.requestedDate = requestedDate;
    }

    public void setEffectiveDate(DateTime effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public void setSubscriptionId(UUID subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public void setPriceListName(String priceListName) {
        this.priceListName = priceListName;
    }

    public void setCurrentVersion(long currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public static SubscriptionBaseEvent toSubscriptionEvent(SubscriptionEventModelDao src) {
        if (src == null) {
            return null;
        }
        Object base = ((EventBaseBuilder)((EventBaseBuilder)((EventBaseBuilder)((EventBaseBuilder)((EventBaseBuilder)((EventBaseBuilder)((EventBaseBuilder)((EventBaseBuilder)((EventBaseBuilder)(src.getEventType() == SubscriptionBaseEvent.EventType.PHASE ? new PhaseEventBuilder() : new ApiEventBuilder()).setTotalOrdering(src.getTotalOrdering())).setUuid(src.getId())).setSubscriptionId(src.getSubscriptionId())).setCreatedDate(src.getCreatedDate())).setUpdatedDate(src.getUpdatedDate())).setRequestedDate(src.getRequestedDate())).setEffectiveDate(src.getEffectiveDate())).setProcessedDate(src.getCreatedDate())).setActiveVersion(src.getCurrentVersion())).setActive(src.isActive());
        EventBase result = null;
        if (src.getEventType() == SubscriptionBaseEvent.EventType.PHASE) {
            result = new PhaseEventData(new PhaseEventBuilder((EventBaseBuilder<?>)base).setPhaseName(src.getPhaseName()));
        } else if (src.getEventType() == SubscriptionBaseEvent.EventType.API_USER) {
            ApiEventBuilder builder = new ApiEventBuilder((EventBaseBuilder<?>)base).setEventPlan(src.getPlanName()).setEventPlanPhase(src.getPhaseName()).setEventPriceList(src.getPriceListName()).setEventType(src.getUserType()).setFromDisk(true);
            if (src.getUserType() == ApiEventType.CREATE) {
                result = new ApiEventCreate(builder);
            } else if (src.getUserType() == ApiEventType.RE_CREATE) {
                result = new ApiEventReCreate(builder);
            } else if (src.getUserType() == ApiEventType.MIGRATE_ENTITLEMENT) {
                result = new ApiEventMigrateSubscription(builder);
            } else if (src.getUserType() == ApiEventType.MIGRATE_BILLING) {
                result = new ApiEventMigrateBilling(builder);
            } else if (src.getUserType() == ApiEventType.TRANSFER) {
                result = new ApiEventTransfer(builder);
            } else if (src.getUserType() == ApiEventType.CHANGE) {
                result = new ApiEventChange(builder);
            } else if (src.getUserType() == ApiEventType.CANCEL) {
                result = new ApiEventCancel(builder);
            } else if (src.getUserType() == ApiEventType.RE_CREATE) {
                result = new ApiEventReCreate(builder);
            } else if (src.getUserType() == ApiEventType.UNCANCEL) {
                result = new ApiEventUncancel(builder);
            }
        } else {
            throw new SubscriptionBaseError(String.format("Can't figure out event %s", new Object[]{src.getEventType()}));
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriptionEventModelDao");
        sb.append("{totalOrdering=").append(this.totalOrdering);
        sb.append(", eventType=").append((Object)this.eventType);
        sb.append(", userType=").append((Object)this.userType);
        sb.append(", requestedDate=").append(this.requestedDate);
        sb.append(", effectiveDate=").append(this.effectiveDate);
        sb.append(", subscriptionId=").append(this.subscriptionId);
        sb.append(", planName='").append(this.planName).append('\'');
        sb.append(", phaseName='").append(this.phaseName).append('\'');
        sb.append(", priceListName='").append(this.priceListName).append('\'');
        sb.append(", currentVersion=").append(this.currentVersion);
        sb.append(", isActive=").append(this.isActive);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubscriptionEventModelDao that = (SubscriptionEventModelDao)((Object)o);
        if (this.currentVersion != that.currentVersion) {
            return false;
        }
        if (this.isActive != that.isActive) {
            return false;
        }
        if (this.totalOrdering != that.totalOrdering) {
            return false;
        }
        if (this.effectiveDate != null ? !this.effectiveDate.equals((Object)that.effectiveDate) : that.effectiveDate != null) {
            return false;
        }
        if (this.eventType != that.eventType) {
            return false;
        }
        if (this.phaseName != null ? !this.phaseName.equals(that.phaseName) : that.phaseName != null) {
            return false;
        }
        if (this.planName != null ? !this.planName.equals(that.planName) : that.planName != null) {
            return false;
        }
        if (this.priceListName != null ? !this.priceListName.equals(that.priceListName) : that.priceListName != null) {
            return false;
        }
        if (this.requestedDate != null ? !this.requestedDate.equals((Object)that.requestedDate) : that.requestedDate != null) {
            return false;
        }
        if (this.subscriptionId != null ? !this.subscriptionId.equals(that.subscriptionId) : that.subscriptionId != null) {
            return false;
        }
        return this.userType == that.userType;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.totalOrdering ^ this.totalOrdering >>> 32);
        result = 31 * result + (this.eventType != null ? this.eventType.hashCode() : 0);
        result = 31 * result + (this.userType != null ? this.userType.hashCode() : 0);
        result = 31 * result + (this.requestedDate != null ? this.requestedDate.hashCode() : 0);
        result = 31 * result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
        result = 31 * result + (this.subscriptionId != null ? this.subscriptionId.hashCode() : 0);
        result = 31 * result + (this.planName != null ? this.planName.hashCode() : 0);
        result = 31 * result + (this.phaseName != null ? this.phaseName.hashCode() : 0);
        result = 31 * result + (this.priceListName != null ? this.priceListName.hashCode() : 0);
        result = 31 * result + (int)(this.currentVersion ^ this.currentVersion >>> 32);
        result = 31 * result + (this.isActive ? 1 : 0);
        return result;
    }

    public TableName getTableName() {
        return TableName.SUBSCRIPTION_EVENTS;
    }

    public TableName getHistoryTableName() {
        return null;
    }
}

