/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.events;

import com.ning.billing.subscription.events.EventBaseBuilder;
import com.ning.billing.subscription.events.SubscriptionBaseEvent;
import com.ning.billing.subscription.events.user.ApiEvent;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventBase
implements SubscriptionBaseEvent {
    private final long totalOrdering;
    private final UUID uuid;
    private final UUID subscriptionId;
    private final DateTime createdDate;
    private final DateTime updatedDate;
    private final DateTime requestedDate;
    private final DateTime effectiveDate;
    private final DateTime processedDate;
    private long activeVersion;
    private boolean isActive;

    public EventBase(EventBaseBuilder<?> builder) {
        this.totalOrdering = builder.getTotalOrdering();
        this.uuid = builder.getUuid();
        this.subscriptionId = builder.getSubscriptionId();
        this.createdDate = builder.getCreatedDate();
        this.updatedDate = builder.getUpdatedDate();
        this.requestedDate = builder.getRequestedDate();
        this.effectiveDate = builder.getEffectiveDate();
        this.processedDate = builder.getProcessedDate();
        this.activeVersion = builder.getActiveVersion();
        this.isActive = builder.isActive();
    }

    @Override
    public DateTime getRequestedDate() {
        return this.requestedDate;
    }

    @Override
    public DateTime getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public DateTime getProcessedDate() {
        return this.processedDate;
    }

    @Override
    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public long getTotalOrdering() {
        return this.totalOrdering;
    }

    public UUID getId() {
        return this.uuid;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getUpdatedDate() {
        return this.updatedDate;
    }

    @Override
    public long getActiveVersion() {
        return this.activeVersion;
    }

    @Override
    public void setActiveVersion(long activeVersion) {
        this.activeVersion = activeVersion;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void deactivate() {
        this.isActive = false;
    }

    @Override
    public void reactivate() {
        this.isActive = true;
    }

    @Override
    public int compareTo(SubscriptionBaseEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("IEvent is compared to a null instance");
        }
        if (this.effectiveDate.isBefore((ReadableInstant)other.getEffectiveDate())) {
            return -1;
        }
        if (this.effectiveDate.isAfter((ReadableInstant)other.getEffectiveDate())) {
            return 1;
        }
        if (this.processedDate.isBefore((ReadableInstant)other.getProcessedDate())) {
            return -1;
        }
        if (this.processedDate.isAfter((ReadableInstant)other.getProcessedDate())) {
            return 1;
        }
        if (this.requestedDate.isBefore((ReadableInstant)other.getRequestedDate())) {
            return -1;
        }
        if (this.requestedDate.isAfter((ReadableInstant)other.getRequestedDate())) {
            return 1;
        }
        if (this.getType() != other.getType()) {
            return this.getType() == SubscriptionBaseEvent.EventType.PHASE ? -1 : 1;
        }
        if (this.getType() == SubscriptionBaseEvent.EventType.API_USER) {
            return ((ApiEvent)((Object)this)).getEventType().compareTo(((ApiEvent)other).getEventType());
        }
        return this.uuid.compareTo(other.getId());
    }

    public boolean equals(Object other) {
        if (!(other instanceof SubscriptionBaseEvent)) {
            return false;
        }
        return this.compareTo((SubscriptionBaseEvent)other) == 0;
    }

    @Override
    public abstract SubscriptionBaseEvent.EventType getType();
}

