/*
 * Decompiled with CFR 0.152.
 */
package com.ning.billing.subscription.glue;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import com.ning.billing.glue.SubscriptionModule;
import com.ning.billing.subscription.alignment.MigrationPlanAligner;
import com.ning.billing.subscription.alignment.PlanAligner;
import com.ning.billing.subscription.api.SubscriptionBaseApiService;
import com.ning.billing.subscription.api.SubscriptionBaseInternalApi;
import com.ning.billing.subscription.api.SubscriptionBaseService;
import com.ning.billing.subscription.api.migration.DefaultSubscriptionBaseMigrationApi;
import com.ning.billing.subscription.api.migration.SubscriptionBaseMigrationApi;
import com.ning.billing.subscription.api.svcs.DefaultSubscriptionInternalApi;
import com.ning.billing.subscription.api.timeline.DefaultSubscriptionBaseTimelineApi;
import com.ning.billing.subscription.api.timeline.RepairSubscriptionApiService;
import com.ning.billing.subscription.api.timeline.RepairSubscriptionLifecycleDao;
import com.ning.billing.subscription.api.timeline.SubscriptionBaseTimelineApi;
import com.ning.billing.subscription.api.transfer.DefaultSubscriptionBaseTransferApi;
import com.ning.billing.subscription.api.transfer.SubscriptionBaseTransferApi;
import com.ning.billing.subscription.api.user.DefaultSubscriptionBaseApiService;
import com.ning.billing.subscription.engine.addon.AddonUtils;
import com.ning.billing.subscription.engine.core.DefaultSubscriptionBaseService;
import com.ning.billing.subscription.engine.dao.DefaultSubscriptionDao;
import com.ning.billing.subscription.engine.dao.RepairSubscriptionDao;
import com.ning.billing.subscription.engine.dao.SubscriptionDao;
import com.ning.billing.util.config.SubscriptionConfig;
import java.lang.annotation.Annotation;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;

public class DefaultSubscriptionModule
extends AbstractModule
implements SubscriptionModule {
    public static final String REPAIR_NAMED = "repair";
    protected final ConfigSource configSource;

    public DefaultSubscriptionModule(ConfigSource configSource) {
        this.configSource = configSource;
    }

    protected void installConfig() {
        SubscriptionConfig config = (SubscriptionConfig)new ConfigurationObjectFactory(this.configSource).build(SubscriptionConfig.class);
        this.bind(SubscriptionConfig.class).toInstance((Object)config);
    }

    protected void installSubscriptionDao() {
        this.bind(SubscriptionDao.class).to(DefaultSubscriptionDao.class).asEagerSingleton();
        this.bind(SubscriptionDao.class).annotatedWith((Annotation)Names.named((String)REPAIR_NAMED)).to(RepairSubscriptionDao.class);
        this.bind(RepairSubscriptionLifecycleDao.class).annotatedWith((Annotation)Names.named((String)REPAIR_NAMED)).to(RepairSubscriptionDao.class);
        this.bind(RepairSubscriptionDao.class).asEagerSingleton();
    }

    protected void installSubscriptionCore() {
        this.bind(SubscriptionBaseApiService.class).annotatedWith((Annotation)Names.named((String)REPAIR_NAMED)).to(RepairSubscriptionApiService.class).asEagerSingleton();
        this.bind(SubscriptionBaseApiService.class).to(DefaultSubscriptionBaseApiService.class).asEagerSingleton();
        this.bind(DefaultSubscriptionBaseService.class).asEagerSingleton();
        this.bind(PlanAligner.class).asEagerSingleton();
        this.bind(AddonUtils.class).asEagerSingleton();
        this.bind(MigrationPlanAligner.class).asEagerSingleton();
        this.installSubscriptionService();
        this.installSubscriptionTimelineApi();
        this.installSubscriptionMigrationApi();
        this.installSubscriptionInternalApi();
        this.installSubscriptionTransferApi();
    }

    protected void configure() {
        this.installConfig();
        this.installSubscriptionDao();
        this.installSubscriptionCore();
    }

    public void installSubscriptionService() {
        this.bind(SubscriptionBaseService.class).to(DefaultSubscriptionBaseService.class).asEagerSingleton();
    }

    public void installSubscriptionTimelineApi() {
        this.bind(SubscriptionBaseTimelineApi.class).to(DefaultSubscriptionBaseTimelineApi.class).asEagerSingleton();
    }

    public void installSubscriptionMigrationApi() {
        this.bind(SubscriptionBaseMigrationApi.class).to(DefaultSubscriptionBaseMigrationApi.class).asEagerSingleton();
    }

    public void installSubscriptionInternalApi() {
        this.bind(SubscriptionBaseInternalApi.class).to(DefaultSubscriptionInternalApi.class).asEagerSingleton();
    }

    public void installSubscriptionTransferApi() {
        this.bind(SubscriptionBaseTransferApi.class).to(DefaultSubscriptionBaseTransferApi.class).asEagerSingleton();
    }
}

