/*
 * Copyright 2015-2020 Ritense BV, the Netherlands.
 *
 * Licensed under EUPL, Version 1.2 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://joinup.ec.europa.eu/collection/eupl/eupl-text-eupl-12
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.ritense.form.security.config;

import com.ritense.form.security.jwt.FormIoJwtSecurityConfigurerAdapter;
import com.ritense.valtimo.contract.security.config.HttpConfigurerConfigurationException;
import com.ritense.valtimo.contract.security.config.HttpSecurityConfigurer;
import com.ritense.valtimo.security.jwt.authentication.TokenAuthenticationService;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;

public class FormFileJwtHttpSecurityConfigurer implements HttpSecurityConfigurer {

    private final TokenAuthenticationService tokenAuthenticationService;

    public FormFileJwtHttpSecurityConfigurer(TokenAuthenticationService tokenAuthenticationService) {
        this.tokenAuthenticationService = tokenAuthenticationService;
    }

    @Override
    public void configure(HttpSecurity http) {
        try {
            http.apply(formIoJwtSecurityConfigurerAdapter());
        } catch (Exception e) {
            throw new HttpConfigurerConfigurationException(e);
        }
    }

    private FormIoJwtSecurityConfigurerAdapter formIoJwtSecurityConfigurerAdapter() {
        return new FormIoJwtSecurityConfigurerAdapter(tokenAuthenticationService);
    }

}