/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.ext.definition.internal.DefinitionOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.block.BlockParser;
import com.vladsch.flexmark.parser.block.BlockPreProcessor;
import com.vladsch.flexmark.parser.block.BlockPreProcessorFactory;
import com.vladsch.flexmark.parser.block.ParserState;
import com.vladsch.flexmark.parser.core.ParagraphParser;
import com.vladsch.flexmark.util.ast.BlankLine;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefinitionListItemBlockPreProcessor
implements BlockPreProcessor {
    private final DefinitionOptions options;
    Boolean blankLinesInAst;

    public DefinitionListItemBlockPreProcessor(DataHolder options) {
        this.options = new DefinitionOptions(options);
        this.blankLinesInAst = (Boolean)Parser.BLANK_LINES_IN_AST.get(options);
    }

    public void preProcess(ParserState state, Block block) {
        if (block instanceof DefinitionItem) {
            DefinitionItem definitionItem = (DefinitionItem)block;
            Node previous = block.getPreviousAnyNot(new Class[]{BlankLine.class});
            DefinitionList trailingBlankLines = new DefinitionList();
            Node blankLine = definitionItem.getNext();
            if (blankLine instanceof BlankLine) {
                blankLine.extractChainTo((Node)trailingBlankLines);
            }
            if (previous instanceof Paragraph) {
                boolean hadPreviousList;
                Paragraph paragraph = (Paragraph)previous;
                Node afterParagraph = previous.getNext();
                Node paragraphPrevNonBlank = paragraph.getPreviousAnyNot(new Class[]{BlankLine.class});
                Node paragraphPrevious = paragraph.getPrevious();
                Block paragraphParent = paragraph.getParent();
                definitionItem.unlink();
                paragraph.unlink();
                state.blockRemovedWithChildren((Block)paragraph);
                if (this.options.doubleBlankLineBreaksList) {
                    BasedSequence interSpace = paragraphPrevNonBlank == null ? BasedSequence.NULL : BasedSequence.of((CharSequence)paragraphPrevNonBlank.baseSubSequence(paragraphPrevNonBlank.getEndOffset(), paragraph.getStartOffset()).normalizeEOL());
                    hadPreviousList = paragraphPrevNonBlank instanceof DefinitionList && interSpace.countLeading(CharPredicate.EOL) < 2;
                } else {
                    hadPreviousList = paragraphPrevNonBlank instanceof DefinitionList;
                }
                DefinitionList definitionList = new DefinitionList();
                definitionList.setTight(true);
                List lines = paragraph.getContentLines();
                DefinitionTerm definitionTerm = null;
                int lineIndex = 0;
                for (BasedSequence line : lines) {
                    definitionTerm = new DefinitionTerm();
                    ParagraphParser parser = new ParagraphParser();
                    BlockContent content = new BlockContent();
                    content.add(line, paragraph.getLineIndent(lineIndex++));
                    parser.getBlock().setContent(content);
                    parser.getBlock().setCharsFromContent();
                    definitionTerm.appendChild((Node)parser.getBlock());
                    definitionTerm.setCharsFromContent();
                    state.blockParserAdded((BlockParser)parser);
                    definitionList.appendChild((Node)definitionTerm);
                    state.blockAdded((Block)definitionTerm);
                }
                if (this.blankLinesInAst.booleanValue() && afterParagraph instanceof BlankLine) {
                    while (afterParagraph instanceof BlankLine) {
                        Node next = afterParagraph.getNext();
                        afterParagraph.unlink();
                        definitionList.appendChild(afterParagraph);
                        afterParagraph = next;
                    }
                }
                definitionList.appendChild((Node)definitionItem);
                definitionList.takeChildren((Node)trailingBlankLines);
                if (hadPreviousList) {
                    DefinitionList previousList = (DefinitionList)paragraphPrevNonBlank;
                    previousList.takeChildren((Node)definitionList);
                    for (Node node : definitionList.getChildren()) {
                        node.unlink();
                        previousList.appendChild(node);
                        state.blockAddedWithChildren((Block)node);
                    }
                    previousList.setCharsFromContent();
                } else {
                    if (paragraphPrevNonBlank != null) {
                        paragraphPrevious.insertAfter((Node)definitionList);
                    } else if (paragraphParent.getFirstChild() != null) {
                        paragraphParent.getFirstChild().insertBefore((Node)definitionList);
                    } else {
                        paragraphParent.appendChild((Node)definitionList);
                    }
                    definitionList.setCharsFromContent();
                    state.blockAddedWithChildren((Block)definitionList);
                }
            } else if (previous instanceof DefinitionList) {
                DefinitionList previousList = (DefinitionList)previous;
                definitionItem.unlink();
                previousList.appendChild((Node)definitionItem);
                previousList.takeChildren((Node)trailingBlankLines);
                previousList.setCharsFromContent();
            }
        }
    }

    public static class Factory
    implements BlockPreProcessorFactory {
        @NotNull
        public Set<Class<? extends Block>> getBlockTypes() {
            HashSet<Class<? extends Block>> set = new HashSet<Class<? extends Block>>();
            set.add(DefinitionItem.class);
            return set;
        }

        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return true;
        }

        @NotNull
        public BlockPreProcessor apply(@NotNull ParserState state) {
            return new DefinitionListItemBlockPreProcessor((DataHolder)state.getProperties());
        }
    }
}

