/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.gfm.issues.internal;

import com.vladsch.flexmark.ext.gfm.issues.GfmIssue;
import com.vladsch.flexmark.ext.gfm.issues.internal.GfmIssuesOptions;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class GfmIssuesJiraRenderer
implements NodeRenderer {
    private final GfmIssuesOptions options;

    public GfmIssuesJiraRenderer(DataHolder options) {
        this.options = new GfmIssuesOptions(options);
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler(GfmIssue.class, (CustomNodeRenderer)new CustomNodeRenderer<GfmIssue>(){

            public void render(GfmIssue node, NodeRendererContext context, HtmlWriter html) {
                GfmIssuesJiraRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(GfmIssue node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            html.raw((CharSequence)node.getChars());
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.options.gitHubIssuesUrlRoot).append(this.options.gitHubIssueUrlPrefix).append((CharSequence)node.getText()).append(this.options.gitHubIssueUrlSuffix);
            html.raw((CharSequence)"[");
            html.raw((CharSequence)node.getChars());
            ((HtmlWriter)((HtmlWriter)html.raw((CharSequence)"|")).raw((CharSequence)sb.toString())).raw((CharSequence)"]");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new GfmIssuesJiraRenderer(options);
        }
    }
}

