/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.MongoDatabase;
import de.bwaldvogel.mongo.backend.CollectionOptions;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.oplog.NoopOplog;
import java.util.Collections;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutStage
implements AggregationStage {
    private static final Logger log = LoggerFactory.getLogger(OutStage.class);
    private final MongoDatabase database;
    private final String collectionName;

    public OutStage(MongoDatabase database, Object collectionName) {
        this.database = database;
        this.collectionName = (String)collectionName;
        if (this.collectionName.contains("$")) {
            throw new MongoServerError(17385, "Can't $out to special collection: " + this.collectionName);
        }
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        String tempCollectionName = "_tmp" + System.currentTimeMillis() + "_" + this.collectionName;
        MongoCollection<?> tempCollection = this.database.createCollectionOrThrowIfExists(tempCollectionName, CollectionOptions.withDefaults());
        stream.forEach(document -> tempCollection.insertDocuments(Collections.singletonList(document)));
        MongoCollection<?> existingCollection = this.database.resolveCollection(this.collectionName, false);
        if (existingCollection != null) {
            log.info("Dropping existing collection {}", existingCollection);
            this.database.dropCollection(this.collectionName, NoopOplog.get());
        }
        this.database.moveCollection(this.database, tempCollection, this.collectionName);
        return Stream.empty();
    }
}

