/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.wire;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.backend.QueryResult;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.CursorNotFoundException;
import de.bwaldvogel.mongo.exception.MongoServerError;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.exception.NoSuchCommandException;
import de.bwaldvogel.mongo.util.FutureUtils;
import de.bwaldvogel.mongo.wire.MongoWireProtocolHandler;
import de.bwaldvogel.mongo.wire.ReplyFlag;
import de.bwaldvogel.mongo.wire.message.ClientRequest;
import de.bwaldvogel.mongo.wire.message.MessageHeader;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoGetMore;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoKillCursors;
import de.bwaldvogel.mongo.wire.message.MongoMessage;
import de.bwaldvogel.mongo.wire.message.MongoQuery;
import de.bwaldvogel.mongo.wire.message.MongoReply;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDatabaseHandler
extends SimpleChannelInboundHandler<ClientRequest> {
    private static final Logger log = LoggerFactory.getLogger(MongoWireProtocolHandler.class);
    private final AtomicInteger idSequence = new AtomicInteger();
    private final MongoBackend mongoBackend;
    private final ChannelGroup channelGroup;

    public MongoDatabaseHandler(MongoBackend mongoBackend, ChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
        this.mongoBackend = mongoBackend;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channelGroup.add((Object)ctx.channel());
        log.info("client {} connected", (Object)ctx.channel());
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        log.info("channel {} closed", (Object)ctx.channel());
        this.channelGroup.remove((Object)ctx.channel());
        this.mongoBackend.handleCloseAsync(ctx.channel()).thenAcceptAsync(aVoid -> {
            try {
                super.channelInactive(ctx);
            }
            catch (Exception e) {
                ctx.fireExceptionCaught((Throwable)e);
            }
        }, (Executor)ctx.executor());
    }

    protected void channelRead0(ChannelHandlerContext ctx, ClientRequest object) {
        if (object instanceof MongoQuery) {
            this.handleQueryAsync((MongoQuery)object).thenAccept(response -> ctx.channel().writeAndFlush(response));
        } else if (object instanceof MongoInsert) {
            this.mongoBackend.handleInsertAsync((MongoInsert)object);
        } else if (object instanceof MongoDelete) {
            this.mongoBackend.handleDeleteAsync((MongoDelete)object);
        } else if (object instanceof MongoUpdate) {
            this.mongoBackend.handleUpdateAsync((MongoUpdate)object);
        } else if (object instanceof MongoGetMore) {
            this.handleGetMoreAsync((MongoGetMore)object).thenAccept(response -> ctx.channel().writeAndFlush(response));
        } else if (object instanceof MongoKillCursors) {
            this.mongoBackend.handleKillCursorsAsync((MongoKillCursors)object);
        } else if (object instanceof MongoMessage) {
            this.handleMessageAsync((MongoMessage)object).thenAccept(response -> ctx.channel().writeAndFlush(response));
        } else {
            throw new MongoServerException("unknown message: " + object);
        }
    }

    CompletionStage<MongoMessage> handleMessageAsync(MongoMessage message) {
        return this.mongoBackend.handleMessageAsync(message).handle((document, ex) -> this.createResponseMongoMessage(message, (Document)document, (Throwable)ex));
    }

    private MongoMessage createResponseMongoMessage(MongoMessage message, Document document, Throwable ex) {
        if (ex != null) {
            MongoServerException e;
            if (ex instanceof MongoServerException) {
                e = (MongoServerException)ex;
                if (e.isLogError()) {
                    log.error("failed to handle {}", (Object)message.getDocument(), (Object)e);
                }
            } else {
                log.error("Unknown error!", ex);
                e = new MongoServerException("Unknown error: " + ex.getMessage(), ex);
            }
            document = this.errorResponse(e, Collections.emptyMap());
        }
        return new MongoMessage(message.getChannel(), this.createResponseHeader(message), document);
    }

    CompletionStage<MongoReply> handleQueryAsync(MongoQuery query) {
        if (query.getCollectionName().startsWith("$cmd")) {
            return this.handleCommandAsync(query).handle((document, ex) -> this.createResponseMongoReplyForCommand(query, (Document)document, (Throwable)ex));
        }
        return this.mongoBackend.handleQueryAsync(query).handle((queryResult, ex) -> this.createResponseMongoReplyForQuery(query, (QueryResult)queryResult, (Throwable)ex));
    }

    private MongoReply createResponseMongoReplyForCommand(MongoQuery query, Document document, Throwable t) {
        MessageHeader header = this.createResponseHeader(query);
        if (t != null) {
            return this.createResponseMongoReplyForQueryFailure(header, query, t);
        }
        return new MongoReply(header, document != null ? Collections.singletonList(document) : Collections.emptyList(), 0L, new ReplyFlag[0]);
    }

    private MongoReply createResponseMongoReplyForQuery(MongoQuery query, QueryResult queryResult, Throwable t) {
        MessageHeader header = this.createResponseHeader(query);
        if (t != null) {
            return this.createResponseMongoReplyForQueryFailure(header, query, t);
        }
        return new MongoReply(header, queryResult != null ? queryResult.collectDocuments() : Collections.emptyList(), queryResult != null ? queryResult.getCursorId() : 0L, new ReplyFlag[0]);
    }

    private MongoReply createResponseMongoReplyForQueryFailure(MessageHeader header, MongoQuery query, Throwable t) {
        if (t instanceof NoSuchCommandException) {
            log.error("unknown command: {}", (Object)query, (Object)t);
            Map<String, Document> additionalInfo = Collections.singletonMap("bad cmd", query.getQuery());
            return this.queryFailure(header, (NoSuchCommandException)t, additionalInfo);
        }
        if (t instanceof MongoServerException) {
            if (((MongoServerException)t).isLogError()) {
                log.error("failed to handle query {}", (Object)query, (Object)t);
            }
            return this.queryFailure(header, (MongoServerException)t, Collections.emptyMap());
        }
        log.error("Unknown error!", t);
        return this.queryFailure(header, new MongoServerException("Unknown error: " + t.getMessage(), t), Collections.emptyMap());
    }

    CompletionStage<MongoReply> handleGetMoreAsync(MongoGetMore getMore) {
        return this.mongoBackend.handleGetMoreAsync(getMore).handle((queryResult, ex) -> this.createResponseMongoReplyForGetMore(getMore, (QueryResult)queryResult, (Throwable)ex));
    }

    private MongoReply createResponseMongoReplyForGetMore(MongoGetMore getMore, QueryResult queryResult, Throwable t) {
        MessageHeader header = this.createResponseHeader(getMore);
        if (t != null) {
            return this.createResponseMongoReplyForGetMoreFailure(header, getMore, t);
        }
        return new MongoReply(header, queryResult != null ? queryResult.collectDocuments() : Collections.emptyList(), queryResult != null ? queryResult.getCursorId() : 0L, new ReplyFlag[0]);
    }

    private MongoReply createResponseMongoReplyForGetMoreFailure(MessageHeader header, MongoGetMore getMore, Throwable t) {
        if (t instanceof CursorNotFoundException) {
            return new MongoReply(header, Collections.emptyList(), getMore != null ? getMore.getCursorId() : 0L, ReplyFlag.CURSOR_NOT_FOUND);
        }
        log.error("Unknown error!", t);
        return this.queryFailure(header, new MongoServerException("Unknown error: " + t.getMessage(), t), Collections.emptyMap());
    }

    private MessageHeader createResponseHeader(ClientRequest request) {
        return new MessageHeader(this.idSequence.incrementAndGet(), request.getHeader().getRequestID());
    }

    private MongoReply queryFailure(MessageHeader header, MongoServerException exception, Map<String, ?> additionalInfo) {
        return new MongoReply(header, this.errorResponse(exception, additionalInfo), ReplyFlag.QUERY_FAILURE);
    }

    private Document errorResponse(MongoServerException exception, Map<String, ?> additionalInfo) {
        Document obj = new Document();
        obj.put("$err", (Object)exception.getMessageWithoutErrorCode());
        obj.put("errmsg", (Object)exception.getMessageWithoutErrorCode());
        if (exception instanceof MongoServerError) {
            MongoServerError error = (MongoServerError)exception;
            obj.put("code", (Object)error.getCode());
            obj.putIfNotNull("codeName", error.getCodeName());
        }
        obj.putAll((Map<? extends String, ?>)additionalInfo);
        obj.put("ok", (Object)0);
        return obj;
    }

    CompletionStage<Document> handleCommandAsync(MongoQuery query) {
        String collectionName = query.getCollectionName();
        if ("$cmd.sys.inprog".equals(collectionName)) {
            return FutureUtils.wrap(() -> this.mongoBackend.getCurrentOperations(query)).thenApply(currentOperations -> new Document("inprog", currentOperations));
        }
        if ("$cmd".equals(collectionName)) {
            String command;
            switch (command = query.getQuery().keySet().iterator().next()) {
                case "serverStatus": {
                    return FutureUtils.wrap(this.mongoBackend::getServerStatus);
                }
                case "ping": {
                    return FutureUtils.wrap(() -> {
                        Document response = new Document();
                        Utils.markOkay(response);
                        return response;
                    });
                }
            }
            Document actualQuery = query.getQuery();
            if ("$query".equals(command)) {
                command = ((Document)query.getQuery().get("$query")).keySet().iterator().next();
                actualQuery = (Document)actualQuery.get("$query");
            }
            return this.mongoBackend.handleCommandAsync(query.getChannel(), query.getDatabaseName(), command, actualQuery);
        }
        return FutureUtils.failedFuture(new MongoServerException("unknown collection: " + collectionName));
    }
}

