/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import io.cdap.common.internal.asm.ClassDefinition;
import io.cdap.common.internal.asm.Methods;
import io.cdap.common.internal.asm.Signatures;
import io.cdap.common.internal.io.DatumWriter;
import io.cdap.common.internal.io.FieldAccessor;
import io.cdap.common.internal.io.FieldAccessorFactory;
import io.cdap.common.internal.io.Schema;
import io.cdap.common.internal.io.SchemaHash;
import io.cdap.common.internal.lang.Fields;
import io.cdap.common.io.Encoder;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@NotThreadSafe
final class DatumWriterGenerator {
    private final Map<String, Method> encodeMethods = Maps.newHashMap();
    private final Multimap<TypeToken<?>, String> fieldAccessorRequests = HashMultimap.create();
    private ClassWriter classWriter;
    private org.objectweb.asm.Type classType;
    private List<Class<?>> preservedClasses;

    DatumWriterGenerator() {
    }

    ClassDefinition generate(TypeToken<?> outputType, Schema schema) {
        this.classWriter = new ClassWriter(2);
        this.preservedClasses = Lists.newArrayList();
        TypeToken<DatumWriter<?>> interfaceType = this.getInterfaceType(outputType);
        String className = this.getClassName(interfaceType, schema);
        this.classType = org.objectweb.asm.Type.getObjectType((String)className);
        this.classWriter.visit(50, 17, className, Signatures.getClassSignature(interfaceType), org.objectweb.asm.Type.getInternalName(Object.class), new String[]{org.objectweb.asm.Type.getInternalName((Class)interfaceType.getRawType())});
        this.classWriter.visitField(26, "SCHEMA_HASH", org.objectweb.asm.Type.getDescriptor(String.class), null, (Object)schema.getSchemaHash().toString()).visitEnd();
        this.classWriter.visitField(18, "schema", org.objectweb.asm.Type.getDescriptor(Schema.class), null, null).visitEnd();
        this.generateEncode(outputType, schema);
        this.generateConstructor();
        ClassDefinition classDefinition = new ClassDefinition(this.classWriter.toByteArray(), className, this.preservedClasses);
        return classDefinition;
    }

    private void generateConstructor() {
        Method constructor = this.getMethod(Void.TYPE, "<init>", Schema.class, FieldAccessorFactory.class);
        GeneratorAdapter mg = new GeneratorAdapter(1, constructor, null, null, (ClassVisitor)this.classWriter);
        mg.loadThis();
        mg.invokeConstructor(org.objectweb.asm.Type.getType(Object.class), this.getMethod(Void.TYPE, "<init>", new Class[0]));
        mg.getStatic(this.classType, "SCHEMA_HASH", org.objectweb.asm.Type.getType(String.class));
        mg.loadArg(0);
        mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.class), this.getMethod(SchemaHash.class, "getSchemaHash", new Class[0]));
        mg.invokeVirtual(org.objectweb.asm.Type.getType(SchemaHash.class), this.getMethod(String.class, "toString", new Class[0]));
        mg.invokeVirtual(org.objectweb.asm.Type.getType(String.class), this.getMethod(Boolean.TYPE, "equals", Object.class));
        Label hashEquals = mg.newLabel();
        mg.ifZCmp(154, hashEquals);
        mg.throwException(org.objectweb.asm.Type.getType(IllegalArgumentException.class), "Schema not match.");
        mg.mark(hashEquals);
        mg.loadThis();
        mg.loadArg(0);
        mg.putField(this.classType, "schema", org.objectweb.asm.Type.getType(Schema.class));
        for (Map.Entry entry : this.fieldAccessorRequests.entries()) {
            String fieldAccessorName = this.getFieldAccessorName((TypeToken)entry.getKey(), (String)entry.getValue());
            this.classWriter.visitField(18, fieldAccessorName, org.objectweb.asm.Type.getDescriptor(FieldAccessor.class), null, null);
            mg.loadThis();
            mg.loadArg(1);
            mg.push(((TypeToken)entry.getKey()).getRawType().getName());
            mg.invokeStatic(org.objectweb.asm.Type.getType(Class.class), this.getMethod(Class.class, "forName", String.class));
            mg.invokeStatic(org.objectweb.asm.Type.getType(TypeToken.class), this.getMethod(TypeToken.class, "of", Class.class));
            mg.push((String)entry.getValue());
            mg.invokeInterface(org.objectweb.asm.Type.getType(FieldAccessorFactory.class), this.getMethod(FieldAccessor.class, "getFieldAccessor", TypeToken.class, String.class));
            mg.putField(this.classType, fieldAccessorName, org.objectweb.asm.Type.getType(FieldAccessor.class));
        }
        mg.returnValue();
        mg.endMethod();
    }

    private void generateEncode(TypeToken<?> outputType, Schema schema) {
        GeneratorAdapter mg;
        TypeToken<?> callOutputType = this.getCallTypeToken(outputType, schema);
        Method encodeMethod = this.getMethod(Void.TYPE, "encode", callOutputType.getRawType(), Encoder.class);
        if (!Object.class.equals((Object)callOutputType.getRawType())) {
            Method method = this.getMethod(Void.TYPE, "encode", Object.class, Encoder.class);
            mg = new GeneratorAdapter(4161, method, null, new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(IOException.class)}, (ClassVisitor)this.classWriter);
            mg.loadThis();
            mg.loadArg(0);
            mg.checkCast(org.objectweb.asm.Type.getType((Class)callOutputType.getRawType()));
            mg.loadArg(1);
            mg.invokeVirtual(this.classType, encodeMethod);
            mg.returnValue();
            mg.endMethod();
        }
        String methodSignature = null;
        if (callOutputType.getType() instanceof ParameterizedType) {
            methodSignature = Signatures.getMethodSignature(encodeMethod, callOutputType, null);
        }
        mg = new GeneratorAdapter(1, encodeMethod, methodSignature, new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(IOException.class)}, (ClassVisitor)this.classWriter);
        mg.loadThis();
        mg.loadArg(0);
        mg.loadArg(1);
        mg.loadThis();
        mg.getField(this.classType, "schema", org.objectweb.asm.Type.getType(Schema.class));
        mg.invokeStatic(org.objectweb.asm.Type.getType(Sets.class), this.getMethod(Set.class, "newIdentityHashSet", new Class[0]));
        mg.invokeVirtual(this.classType, this.getEncodeMethod(outputType, schema));
        mg.returnValue();
        mg.endMethod();
    }

    private Method getEncodeMethod(TypeToken<?> outputType, Schema schema) {
        String key = String.format("%s%s", this.normalizeTypeName(outputType), schema.getSchemaHash());
        Method method = this.encodeMethods.get(key);
        if (method != null) {
            return method;
        }
        TypeToken<?> callOutputType = this.getCallTypeToken(outputType, schema);
        String methodName = String.format("encode%s", key);
        method = this.getMethod(Void.TYPE, methodName, callOutputType.getRawType(), Encoder.class, Schema.class, Set.class);
        this.encodeMethods.put(key, method);
        String methodSignature = Signatures.getMethodSignature(method, callOutputType, null, null, new TypeToken<Set<Object>>(){});
        GeneratorAdapter mg = new GeneratorAdapter(2, method, methodSignature, new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(IOException.class)}, (ClassVisitor)this.classWriter);
        this.generateEncodeBody(mg, schema, outputType, 0, 1, 2, 3);
        mg.returnValue();
        mg.endMethod();
        return method;
    }

    private void generateEncodeBody(GeneratorAdapter mg, Schema schema, TypeToken<?> outputType, int value, int encoder, int schemaLocal, int seenRefs) {
        Schema.Type schemaType = schema.getType();
        switch (schemaType) {
            case NULL: {
                break;
            }
            case BOOLEAN: {
                this.encodeSimple(mg, outputType, schema, "writeBool", value, encoder);
                break;
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BYTES: 
            case STRING: {
                String encodeMethod = "write" + schemaType.name().charAt(0) + schemaType.name().substring(1).toLowerCase();
                this.encodeSimple(mg, outputType, schema, encodeMethod, value, encoder);
                break;
            }
            case ENUM: {
                this.encodeEnum(mg, outputType, value, encoder, schemaLocal);
                break;
            }
            case ARRAY: {
                if (Collection.class.isAssignableFrom(outputType.getRawType())) {
                    Preconditions.checkArgument((boolean)(outputType.getType() instanceof ParameterizedType), (Object)"Only support parameterized collection type.");
                    TypeToken componentType = TypeToken.of((Type)((ParameterizedType)outputType.getType()).getActualTypeArguments()[0]);
                    this.encodeCollection(mg, componentType, schema.getComponentSchema(), value, encoder, schemaLocal, seenRefs);
                    break;
                }
                if (!outputType.isArray()) break;
                TypeToken componentType = outputType.getComponentType();
                this.encodeArray(mg, componentType, schema.getComponentSchema(), value, encoder, schemaLocal, seenRefs);
                break;
            }
            case MAP: {
                Preconditions.checkArgument((boolean)Map.class.isAssignableFrom(outputType.getRawType()), (String)"Only %s type is supported.", (Object[])new Object[]{Map.class.getName()});
                Preconditions.checkArgument((boolean)(outputType.getType() instanceof ParameterizedType), (Object)"Only support parameterized map type.");
                Type[] mapArgs = ((ParameterizedType)outputType.getType()).getActualTypeArguments();
                Map.Entry<Schema, Schema> mapSchema = schema.getMapSchema();
                this.encodeMap(mg, TypeToken.of((Type)mapArgs[0]), TypeToken.of((Type)mapArgs[1]), mapSchema.getKey(), mapSchema.getValue(), value, encoder, schemaLocal, seenRefs);
                break;
            }
            case RECORD: {
                this.encodeRecord(mg, schema, outputType, value, encoder, schemaLocal, seenRefs);
                break;
            }
            case UNION: {
                this.encodeUnion(mg, outputType, schema, value, encoder, schemaLocal, seenRefs);
            }
        }
    }

    private void encodeInt(GeneratorAdapter mg, int intValue, int encoder) {
        mg.loadArg(encoder);
        mg.push(intValue);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Encoder.class), this.getMethod(Encoder.class, "writeInt", Integer.TYPE));
        mg.pop();
    }

    private void encodeSimple(GeneratorAdapter mg, TypeToken<?> type, Schema schema, String encodeMethod, int value, int encoder) {
        TypeToken encodeType = type;
        mg.loadArg(encoder);
        mg.loadArg(value);
        if (Primitives.isWrapperType((Class)encodeType.getRawType())) {
            encodeType = TypeToken.of((Class)Primitives.unwrap((Class)encodeType.getRawType()));
            mg.unbox(org.objectweb.asm.Type.getType((Class)encodeType.getRawType()));
            if (schema.getType() == Schema.Type.INT && !Integer.TYPE.equals(encodeType.getRawType())) {
                encodeType = TypeToken.of(Integer.TYPE);
            }
        } else if (schema.getType() == Schema.Type.STRING && !String.class.equals((Object)encodeType.getRawType())) {
            mg.invokeVirtual(org.objectweb.asm.Type.getType((Class)encodeType.getRawType()), this.getMethod(String.class, "toString", new Class[0]));
            encodeType = TypeToken.of(String.class);
        } else if (schema.getType() == Schema.Type.BYTES && UUID.class.equals((Object)encodeType.getRawType())) {
            org.objectweb.asm.Type byteBufferType = org.objectweb.asm.Type.getType(ByteBuffer.class);
            org.objectweb.asm.Type uuidType = org.objectweb.asm.Type.getType(UUID.class);
            mg.push(16);
            mg.invokeStatic(byteBufferType, this.getMethod(ByteBuffer.class, "allocate", Integer.TYPE));
            mg.swap();
            mg.invokeVirtual(uuidType, this.getMethod(Long.TYPE, "getMostSignificantBits", new Class[0]));
            mg.invokeVirtual(byteBufferType, this.getMethod(ByteBuffer.class, "putLong", Long.TYPE));
            mg.loadArg(value);
            mg.invokeVirtual(uuidType, this.getMethod(Long.TYPE, "getLeastSignificantBits", new Class[0]));
            mg.invokeVirtual(byteBufferType, this.getMethod(ByteBuffer.class, "putLong", Long.TYPE));
            mg.invokeVirtual(org.objectweb.asm.Type.getType(Buffer.class), this.getMethod(Buffer.class, "flip", new Class[0]));
            mg.checkCast(byteBufferType);
            encodeType = TypeToken.of(ByteBuffer.class);
        }
        mg.invokeInterface(org.objectweb.asm.Type.getType(Encoder.class), this.getMethod(Encoder.class, encodeMethod, encodeType.getRawType()));
        mg.pop();
    }

    private void encodeEnum(GeneratorAdapter mg, TypeToken<?> outputType, int value, int encoder, int schemaLocal) {
        this.preservedClasses.add(outputType.getRawType());
        mg.loadArg(encoder);
        mg.loadArg(schemaLocal);
        mg.loadArg(value);
        mg.invokeVirtual(org.objectweb.asm.Type.getType((Class)outputType.getRawType()), this.getMethod(String.class, "name", new Class[0]));
        mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.class), this.getMethod(Integer.TYPE, "getEnumIndex", String.class));
        mg.invokeInterface(org.objectweb.asm.Type.getType(Encoder.class), this.getMethod(Encoder.class, "writeInt", Integer.TYPE));
        mg.pop();
    }

    private void encodeCollection(GeneratorAdapter mg, TypeToken<?> componentType, Schema componentSchema, int value, int encoder, int schemaLocal, int seenRefs) {
        mg.loadArg(value);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Collection.class), this.getMethod(Integer.TYPE, "size", new Class[0]));
        int length = mg.newLocal(org.objectweb.asm.Type.INT_TYPE);
        mg.storeLocal(length);
        mg.loadArg(encoder);
        mg.loadLocal(length);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Encoder.class), this.getMethod(Encoder.class, "writeInt", Integer.TYPE));
        mg.pop();
        mg.loadArg(schemaLocal);
        mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.class), this.getMethod(Schema.class, "getComponentSchema", new Class[0]));
        int componentSchemaLocal = mg.newLocal(org.objectweb.asm.Type.getType(Schema.class));
        mg.storeLocal(componentSchemaLocal);
        int iterator = mg.newLocal(org.objectweb.asm.Type.getType(Iterator.class));
        mg.loadArg(value);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Collection.class), this.getMethod(Iterator.class, "iterator", new Class[0]));
        mg.storeLocal(iterator);
        Label beginFor = mg.mark();
        Label endFor = mg.newLabel();
        mg.loadLocal(iterator);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Iterator.class), this.getMethod(Boolean.TYPE, "hasNext", new Class[0]));
        mg.ifZCmp(153, endFor);
        mg.loadThis();
        mg.loadLocal(iterator);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Iterator.class), this.getMethod(Object.class, "next", new Class[0]));
        this.doCast(mg, componentType, componentSchema);
        mg.loadArg(encoder);
        mg.loadLocal(componentSchemaLocal);
        mg.loadArg(seenRefs);
        mg.invokeVirtual(this.classType, this.getEncodeMethod(componentType, componentSchema));
        mg.goTo(beginFor);
        mg.mark(endFor);
        Label zeroLength = mg.newLabel();
        mg.loadLocal(length);
        mg.ifZCmp(158, zeroLength);
        this.encodeInt(mg, 0, encoder);
        mg.mark(zeroLength);
    }

    private void encodeArray(GeneratorAdapter mg, TypeToken<?> componentType, Schema componentSchema, int value, int encoder, int schemaLocal, int seenRefs) {
        mg.loadArg(value);
        mg.arrayLength();
        int length = mg.newLocal(org.objectweb.asm.Type.INT_TYPE);
        mg.storeLocal(length);
        mg.loadArg(encoder);
        mg.loadLocal(length);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Encoder.class), this.getMethod(Encoder.class, "writeInt", Integer.TYPE));
        mg.pop();
        mg.loadArg(schemaLocal);
        mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.class), this.getMethod(Schema.class, "getComponentSchema", new Class[0]));
        int componentSchemaLocal = mg.newLocal(org.objectweb.asm.Type.getType(Schema.class));
        mg.storeLocal(componentSchemaLocal);
        mg.push(0);
        int idx = mg.newLocal(org.objectweb.asm.Type.INT_TYPE);
        mg.storeLocal(idx);
        Label beginFor = mg.mark();
        Label endFor = mg.newLabel();
        mg.loadLocal(idx);
        mg.loadLocal(length);
        mg.ifICmp(156, endFor);
        mg.loadThis();
        mg.loadArg(value);
        mg.loadLocal(idx);
        TypeToken<?> callTypeToken = this.getCallTypeToken(componentType, componentSchema);
        mg.arrayLoad(org.objectweb.asm.Type.getType((Class)callTypeToken.getRawType()));
        mg.loadArg(encoder);
        mg.loadLocal(componentSchemaLocal);
        mg.loadArg(seenRefs);
        mg.invokeVirtual(this.classType, this.getEncodeMethod(componentType, componentSchema));
        mg.iinc(idx, 1);
        mg.goTo(beginFor);
        mg.mark(endFor);
        Label zeroLength = mg.newLabel();
        mg.loadLocal(length);
        mg.ifZCmp(158, zeroLength);
        this.encodeInt(mg, 0, encoder);
        mg.mark(zeroLength);
    }

    private void encodeMap(GeneratorAdapter mg, TypeToken<?> keyType, TypeToken<?> valueType, Schema keySchema, Schema valueSchema, int value, int encoder, int schemaLocal, int seenRefs) {
        mg.loadArg(value);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Map.class), this.getMethod(Integer.TYPE, "size", new Class[0]));
        int length = mg.newLocal(org.objectweb.asm.Type.INT_TYPE);
        mg.storeLocal(length);
        mg.loadArg(encoder);
        mg.loadLocal(length);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Encoder.class), this.getMethod(Encoder.class, "writeInt", Integer.TYPE));
        mg.pop();
        mg.loadArg(schemaLocal);
        mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.class), this.getMethod(Map.Entry.class, "getMapSchema", new Class[0]));
        mg.dup();
        int keySchemaLocal = mg.newLocal(org.objectweb.asm.Type.getType(Schema.class));
        mg.invokeInterface(org.objectweb.asm.Type.getType(Map.Entry.class), this.getMethod(Object.class, "getKey", new Class[0]));
        mg.checkCast(org.objectweb.asm.Type.getType(Schema.class));
        mg.storeLocal(keySchemaLocal);
        int valueSchemaLocal = mg.newLocal(org.objectweb.asm.Type.getType(Schema.class));
        mg.invokeInterface(org.objectweb.asm.Type.getType(Map.Entry.class), this.getMethod(Object.class, "getValue", new Class[0]));
        mg.checkCast(org.objectweb.asm.Type.getType(Schema.class));
        mg.storeLocal(valueSchemaLocal);
        int iterator = mg.newLocal(org.objectweb.asm.Type.getType(Iterator.class));
        mg.loadArg(value);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Map.class), this.getMethod(Set.class, "entrySet", new Class[0]));
        mg.invokeInterface(org.objectweb.asm.Type.getType(Set.class), this.getMethod(Iterator.class, "iterator", new Class[0]));
        mg.storeLocal(iterator);
        Label beginFor = mg.mark();
        Label endFor = mg.newLabel();
        mg.loadLocal(iterator);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Iterator.class), this.getMethod(Boolean.TYPE, "hasNext", new Class[0]));
        mg.ifZCmp(153, endFor);
        int entry = mg.newLocal(org.objectweb.asm.Type.getType(Map.Entry.class));
        mg.loadLocal(iterator);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Iterator.class), this.getMethod(Object.class, "next", new Class[0]));
        mg.checkCast(org.objectweb.asm.Type.getType(Map.Entry.class));
        mg.storeLocal(entry);
        mg.loadThis();
        mg.loadLocal(entry);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Map.Entry.class), this.getMethod(Object.class, "getKey", new Class[0]));
        this.doCast(mg, keyType, keySchema);
        mg.loadArg(encoder);
        mg.loadLocal(keySchemaLocal);
        mg.loadArg(seenRefs);
        mg.invokeVirtual(this.classType, this.getEncodeMethod(keyType, keySchema));
        mg.loadThis();
        mg.loadLocal(entry);
        mg.invokeInterface(org.objectweb.asm.Type.getType(Map.Entry.class), this.getMethod(Object.class, "getValue", new Class[0]));
        this.doCast(mg, valueType, valueSchema);
        mg.loadArg(encoder);
        mg.loadLocal(valueSchemaLocal);
        mg.loadArg(seenRefs);
        mg.invokeVirtual(this.classType, this.getEncodeMethod(valueType, valueSchema));
        mg.goTo(beginFor);
        mg.mark(endFor);
        Label zeroLength = mg.newLabel();
        mg.loadLocal(length);
        mg.ifZCmp(158, zeroLength);
        this.encodeInt(mg, 0, encoder);
        mg.mark(zeroLength);
    }

    private void encodeRecord(GeneratorAdapter mg, Schema schema, TypeToken<?> outputType, int value, int encoder, int schemaLocal, int seenRefs) {
        try {
            Class rawType = outputType.getRawType();
            this.preservedClasses.add(rawType);
            boolean isInterface = rawType.isInterface();
            Label notSeen = mg.newLabel();
            mg.loadArg(value);
            mg.ifNull(notSeen);
            mg.loadArg(seenRefs);
            mg.loadArg(value);
            mg.invokeInterface(org.objectweb.asm.Type.getType(Set.class), this.getMethod(Boolean.TYPE, "add", Object.class));
            mg.ifZCmp(154, notSeen);
            mg.throwException(org.objectweb.asm.Type.getType(IOException.class), "Circular reference not supported.");
            mg.mark(notSeen);
            mg.loadArg(schemaLocal);
            mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.class), this.getMethod(List.class, "getFields", new Class[0]));
            int fieldSchemas = mg.newLocal(org.objectweb.asm.Type.getType(List.class));
            mg.storeLocal(fieldSchemas);
            List<Schema.Field> fields = schema.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                TypeToken fieldType;
                Schema.Field field = fields.get(i);
                if (isInterface) {
                    mg.loadThis();
                    mg.loadArg(value);
                    Method getter = this.getGetter(outputType, field.getName());
                    fieldType = outputType.resolveType(rawType.getMethod(getter.getName(), new Class[0]).getGenericReturnType());
                    mg.invokeInterface(org.objectweb.asm.Type.getType((Class)rawType), getter);
                } else {
                    fieldType = outputType.resolveType(Fields.findField(outputType, (String)field.getName()).getGenericType());
                    this.fieldAccessorRequests.put(outputType, (Object)field.getName());
                    mg.loadThis();
                    mg.dup();
                    mg.getField(this.classType, this.getFieldAccessorName(outputType, field.getName()), org.objectweb.asm.Type.getType(FieldAccessor.class));
                    mg.loadArg(value);
                    mg.invokeInterface(org.objectweb.asm.Type.getType(FieldAccessor.class), this.getAccessorMethod(fieldType));
                    if (!fieldType.getRawType().isPrimitive()) {
                        this.doCast(mg, fieldType, field.getSchema());
                    }
                }
                mg.loadArg(encoder);
                mg.loadLocal(fieldSchemas);
                mg.push(i);
                mg.invokeInterface(org.objectweb.asm.Type.getType(List.class), this.getMethod(Object.class, "get", Integer.TYPE));
                mg.checkCast(org.objectweb.asm.Type.getType(Schema.Field.class));
                mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.Field.class), this.getMethod(Schema.class, "getSchema", new Class[0]));
                mg.loadArg(seenRefs);
                mg.invokeVirtual(this.classType, this.getEncodeMethod(fieldType, field.getSchema()));
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void encodeUnion(GeneratorAdapter mg, TypeToken<?> outputType, Schema schema, int value, int encoder, int schemaLocal, int seenRefs) {
        Label nullLabel = mg.newLabel();
        Label endLabel = mg.newLabel();
        mg.loadArg(value);
        mg.ifNull(nullLabel);
        this.encodeInt(mg, 0, encoder);
        mg.loadThis();
        mg.loadArg(value);
        this.doCast(mg, outputType, schema.getUnionSchema(0));
        mg.loadArg(encoder);
        mg.loadArg(schemaLocal);
        mg.push(0);
        mg.invokeVirtual(org.objectweb.asm.Type.getType(Schema.class), this.getMethod(Schema.class, "getUnionSchema", Integer.TYPE));
        mg.loadArg(seenRefs);
        mg.invokeVirtual(this.classType, this.getEncodeMethod(outputType, schema.getUnionSchema(0)));
        mg.goTo(endLabel);
        mg.mark(nullLabel);
        this.encodeInt(mg, 1, encoder);
        mg.mark(endLabel);
    }

    private <T> TypeToken<DatumWriter<T>> getInterfaceType(TypeToken<T> type) {
        return new TypeToken<DatumWriter<T>>(){}.where(new TypeParameter<T>(){}, type);
    }

    private <T> TypeToken<T[]> getArrayType(TypeToken<T> type) {
        return new TypeToken<T[]>(){}.where(new TypeParameter<T>(){}, type);
    }

    private String getClassName(TypeToken<?> interfaceType, Schema schema) {
        return String.format("%s/%s%s%s", interfaceType.getRawType().getPackage().getName().replace('.', '/'), this.normalizeTypeName(TypeToken.of((Type)((ParameterizedType)interfaceType.getType()).getActualTypeArguments()[0])), interfaceType.getRawType().getSimpleName(), schema.getSchemaHash());
    }

    private String normalizeTypeName(TypeToken<?> type) {
        String typeName = type.toString();
        int dimension = 0;
        while (type.isArray()) {
            type = type.getComponentType();
            typeName = type.toString();
            ++dimension;
        }
        typeName = typeName.replace(".", "").replace("<", "Of").replace(">", "").replace(",", "To").replace(" ", "").replace("$", "");
        if (dimension > 0) {
            typeName = "Array" + dimension + typeName;
        }
        return typeName;
    }

    private Method getMethod(Class<?> returnType, String name, Class<?> ... args) {
        return Methods.getMethod(returnType, name, args);
    }

    private Method getGetter(TypeToken<?> outputType, String fieldName) {
        Class rawType = outputType.getRawType();
        try {
            return Method.getMethod((java.lang.reflect.Method)rawType.getMethod(String.format("get%c%s", Character.valueOf(Character.toUpperCase(fieldName.charAt(0))), fieldName.substring(1)), new Class[0]));
        }
        catch (NoSuchMethodException e) {
            try {
                return Method.getMethod((java.lang.reflect.Method)rawType.getMethod(String.format("is%c%s", Character.valueOf(Character.toUpperCase(fieldName.charAt(0))), fieldName.substring(1)), new Class[0]));
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("Getter method not found for field " + fieldName, ex);
            }
        }
    }

    private TypeToken<?> getCallTypeToken(TypeToken<?> outputType, Schema schema) {
        Schema.Type schemaType = schema.getType();
        if (schemaType == Schema.Type.RECORD || schemaType == Schema.Type.UNION) {
            return TypeToken.of(Object.class);
        }
        if (schemaType == Schema.Type.ARRAY && outputType.isArray()) {
            return this.getArrayType(this.getCallTypeToken(outputType.getComponentType(), schema.getComponentSchema()));
        }
        return outputType;
    }

    private void doCast(GeneratorAdapter mg, TypeToken<?> outputType, Schema schema) {
        TypeToken<?> callTypeToken = this.getCallTypeToken(outputType, schema);
        if (!Object.class.equals((Object)callTypeToken.getRawType()) && !outputType.getRawType().isPrimitive()) {
            mg.checkCast(org.objectweb.asm.Type.getType((Class)callTypeToken.getRawType()));
        }
    }

    private Method getAccessorMethod(TypeToken<?> type) {
        Class rawType = type.getRawType();
        if (rawType.isPrimitive()) {
            return this.getMethod(rawType, String.format("get%c%s", Character.valueOf(Character.toUpperCase(rawType.getName().charAt(0))), rawType.getName().substring(1)), Object.class);
        }
        return this.getMethod(Object.class, "get", Object.class);
    }

    private String getFieldAccessorName(TypeToken<?> recordType, String fieldName) {
        return String.format("%s$%s", this.normalizeTypeName(recordType), fieldName);
    }
}

