/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.io;

import com.google.common.base.Function;
import io.cdap.common.io.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class BufferedEncoder
implements Encoder {
    private final Encoder encoder;
    private final ByteArrayOutputStream output;

    public BufferedEncoder(int size, Function<OutputStream, Encoder> encoderFactory) {
        this.output = new ByteArrayOutputStream(size);
        this.encoder = (Encoder)encoderFactory.apply((Object)this.output);
    }

    public void reset() {
        this.output.reset();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.output.writeTo(out);
        this.output.reset();
    }

    public int size() {
        return this.output.size();
    }

    public Encoder writeRaw(byte[] rawBytes) throws IOException {
        return this.writeRaw(rawBytes, 0, rawBytes.length);
    }

    public Encoder writeRaw(byte[] rawBytes, int off, int len) throws IOException {
        this.output.write(rawBytes, off, len);
        return this;
    }

    @Override
    public Encoder writeNull() throws IOException {
        return this.encoder.writeNull();
    }

    @Override
    public Encoder writeBool(boolean b) throws IOException {
        return this.encoder.writeBool(b);
    }

    @Override
    public Encoder writeInt(int i) throws IOException {
        return this.encoder.writeInt(i);
    }

    @Override
    public Encoder writeLong(long l) throws IOException {
        return this.encoder.writeLong(l);
    }

    @Override
    public Encoder writeFloat(float f) throws IOException {
        return this.encoder.writeFloat(f);
    }

    @Override
    public Encoder writeDouble(double d) throws IOException {
        return this.encoder.writeDouble(d);
    }

    @Override
    public Encoder writeString(String s) throws IOException {
        return this.encoder.writeString(s);
    }

    @Override
    public Encoder writeBytes(byte[] bytes) throws IOException {
        return this.encoder.writeBytes(bytes);
    }

    @Override
    public Encoder writeBytes(byte[] bytes, int off, int len) throws IOException {
        return this.encoder.writeBytes(bytes, off, len);
    }

    @Override
    public Encoder writeBytes(ByteBuffer bytes) throws IOException {
        return this.encoder.writeBytes(bytes);
    }
}

