/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.lang;

import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CombineClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(CombineClassLoader.class);
    private final Iterable<ClassLoader> delegates;

    public CombineClassLoader(ClassLoader parent, Iterable<ClassLoader> delegates) {
        super(parent);
        this.delegates = delegates;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassLoader classLoader : this.delegates) {
            try {
                return classLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                LOG.trace("Class {} not found in ClassLoader {}", (Object)name, (Object)classLoader);
            }
        }
        throw new ClassNotFoundException("Class not found in all delegated ClassLoaders: " + name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader classLoader : this.delegates) {
            URL url = classLoader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        HashSet urls = Sets.newHashSet();
        for (ClassLoader classLoader : this.delegates) {
            Iterators.addAll((Collection)urls, (Iterator)Iterators.forEnumeration(classLoader.getResources(name)));
        }
        return Iterators.asEnumeration(urls.iterator());
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader classLoader : this.delegates) {
            InputStream is = classLoader.getResourceAsStream(name);
            if (is == null) continue;
            return is;
        }
        return null;
    }
}

