/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.lang;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import io.cdap.common.internal.lang.Reflections;
import io.cdap.common.internal.lang.Visitor;
import io.cdap.common.lang.FieldInitializer;
import io.cdap.common.lang.Instantiator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import sun.misc.Unsafe;

public final class InstantiatorFactory {
    private static final Unsafe UNSAFE;
    private final LoadingCache<TypeToken<?>, Instantiator<?>> instantiatorCache;

    public InstantiatorFactory(final boolean useKnownType) {
        this.instantiatorCache = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, Instantiator<?>>(){

            public Instantiator<?> load(TypeToken<?> type) throws Exception {
                Instantiator creator = InstantiatorFactory.this.getByDefaultConstructor(type);
                if (creator != null) {
                    return creator;
                }
                if (useKnownType && (creator = InstantiatorFactory.this.getByKnownType(type)) != null) {
                    return creator;
                }
                return InstantiatorFactory.this.getByUnsafe(type);
            }
        });
    }

    public <T> Instantiator<T> get(TypeToken<T> type) {
        return (Instantiator)this.instantiatorCache.getUnchecked(type);
    }

    private <T> Instantiator<T> getByDefaultConstructor(TypeToken<T> type) {
        try {
            final Constructor defaultCons = type.getRawType().getDeclaredConstructor(new Class[0]);
            defaultCons.setAccessible(true);
            return new Instantiator<T>(){

                @Override
                public T create() {
                    try {
                        return defaultCons.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private <T> Instantiator<T> getByKnownType(TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (rawType.isArray()) {
            return new Instantiator<T>(){

                @Override
                public T create() {
                    return Lists.newLinkedList();
                }
            };
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return new Instantiator<T>(){

                    @Override
                    public T create() {
                        return Sets.newTreeSet();
                    }
                };
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return new Instantiator<T>(){

                    @Override
                    public T create() {
                        return Sets.newHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return new Instantiator<T>(){

                    @Override
                    public T create() {
                        return Lists.newLinkedList();
                    }
                };
            }
            return new Instantiator<T>(){

                @Override
                public T create() {
                    return Lists.newArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (SortedMap.class.isAssignableFrom(rawType)) {
                return new Instantiator<T>(){

                    @Override
                    public T create() {
                        return Maps.newTreeMap();
                    }
                };
            }
            return new Instantiator<T>(){

                @Override
                public T create() {
                    return Maps.newHashMap();
                }
            };
        }
        return null;
    }

    private <T> Instantiator<T> getByUnsafe(final TypeToken<T> type) {
        return new Instantiator<T>(){

            @Override
            public T create() {
                try {
                    Object instance = UNSAFE.allocateInstance(type.getRawType());
                    Reflections.visit(instance, type, new FieldInitializer(), new Visitor[0]);
                    return instance;
                }
                catch (InstantiationException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }

    static {
        Unsafe unsafe;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            unsafe = null;
        }
        UNSAFE = unsafe;
    }
}

