/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cienvironment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class GithubEventParser {
    private static final Pattern GITHUB_EVENT_PATTERN = Pattern.compile("^\\{.*?\"pull_request\" *: *\\{.*?\"head\" *: *\\{.*?\"sha\" *: *\"([a-z0-9]+)\".*}.*}.*}$");

    GithubEventParser() {
    }

    static String evaluateRevisionGithub(Map<String, String> env) {
        if (!"pull_request".equals(env.get("GITHUB_EVENT_NAME"))) {
            return null;
        }
        if (env.get("GITHUB_EVENT_PATH") == null) {
            return null;
        }
        try {
            Path path = Paths.get(env.get("GITHUB_EVENT_PATH"), new String[0]);
            String event = String.join((CharSequence)" ", Files.readAllLines(path));
            return GithubEventParser.parsePullRequestHeadSha(event);
        }
        catch (IOException e) {
            return null;
        }
    }

    static String parsePullRequestHeadSha(String eventJson) {
        Matcher matcher = GITHUB_EVENT_PATTERN.matcher(eventJson.trim());
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }
}

