/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.options.RerunPath;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;

class FeatureWithLinesOrRerunPath {
    private final FeatureWithLines featureWithLines;
    private final Collection<FeatureWithLines> featuresWithLinesToRerun;

    FeatureWithLinesOrRerunPath(FeatureWithLines featureWithLines, Collection<FeatureWithLines> featuresWithLinesToRerun) {
        this.featureWithLines = featureWithLines;
        this.featuresWithLinesToRerun = featuresWithLinesToRerun;
    }

    static FeatureWithLinesOrRerunPath parse(String arg) {
        if (arg.startsWith("@")) {
            Path rerunFileOrDirectory = Paths.get(arg.substring(1), new String[0]);
            return new FeatureWithLinesOrRerunPath(null, RerunPath.parse(rerunFileOrDirectory));
        }
        return new FeatureWithLinesOrRerunPath(FeatureWithLines.parse(arg), null);
    }

    Optional<Collection<FeatureWithLines>> getFeaturesToRerun() {
        return Optional.ofNullable(this.featuresWithLinesToRerun);
    }

    Optional<FeatureWithLines> getFeatureWithLines() {
        return Optional.ofNullable(this.featureWithLines);
    }
}

