/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.logging.Logger;
import io.cucumber.core.logging.LoggerFactory;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.junit.CucumberOptions;
import io.cucumber.junit.NoObjectFactory;
import io.cucumber.junit.NoUuidGenerator;
import java.lang.annotation.Annotation;

final class JUnitCucumberOptionsProvider
implements CucumberOptionsAnnotationParser.OptionsProvider {
    private static final Logger log = LoggerFactory.getLogger(JUnitCucumberOptionsProvider.class);

    JUnitCucumberOptionsProvider() {
    }

    public CucumberOptionsAnnotationParser.CucumberOptions getOptions(Class<?> clazz) {
        CucumberOptions annotation = clazz.getAnnotation(CucumberOptions.class);
        if (annotation != null) {
            return new JunitCucumberOptions(annotation);
        }
        JUnitCucumberOptionsProvider.warnWhenTestNGCucumberOptionsAreUsed(clazz);
        return null;
    }

    private static void warnWhenTestNGCucumberOptionsAreUsed(Class<?> clazz) {
        for (Annotation clazzAnnotation : clazz.getAnnotations()) {
            String name = clazzAnnotation.annotationType().getName();
            if (!"io.cucumber.testng.CucumberOptions".equals(name)) continue;
            log.warn(() -> "Ignoring options provided by " + name + " on " + clazz.getName() + ". It is recommend to use separate runner classes for JUnit and TestNG.");
        }
    }

    private static class JunitCucumberOptions
    implements CucumberOptionsAnnotationParser.CucumberOptions {
        private final CucumberOptions annotation;

        JunitCucumberOptions(CucumberOptions annotation) {
            this.annotation = annotation;
        }

        public boolean dryRun() {
            return this.annotation.dryRun();
        }

        public String[] features() {
            return this.annotation.features();
        }

        public String[] glue() {
            return this.annotation.glue();
        }

        public String[] extraGlue() {
            return this.annotation.extraGlue();
        }

        public String tags() {
            return this.annotation.tags();
        }

        public String[] plugin() {
            return this.annotation.plugin();
        }

        public boolean publish() {
            return this.annotation.publish();
        }

        public boolean monochrome() {
            return this.annotation.monochrome();
        }

        public String[] name() {
            return this.annotation.name();
        }

        public SnippetType snippets() {
            switch (this.annotation.snippets()) {
                case UNDERSCORE: {
                    return SnippetType.UNDERSCORE;
                }
                case CAMELCASE: {
                    return SnippetType.CAMELCASE;
                }
            }
            throw new IllegalArgumentException("" + (Object)((Object)this.annotation.snippets()));
        }

        public Class<? extends ObjectFactory> objectFactory() {
            return this.annotation.objectFactory() == NoObjectFactory.class ? null : this.annotation.objectFactory();
        }

        public Class<? extends UuidGenerator> uuidGenerator() {
            return this.annotation.uuidGenerator() == NoUuidGenerator.class ? null : this.annotation.uuidGenerator();
        }
    }
}

