/*
 * Decompiled with CFR 0.152.
 */
package kamon.statsd;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.ExtensionId;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.config.Config;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import kamon.Kamon;
import kamon.Kamon$;
import kamon.metrics.ActorMetrics$;
import kamon.metrics.MetricGroupCategory;
import kamon.metrics.Metrics$;
import kamon.metrics.MetricsExtension;
import kamon.metrics.TickMetricSnapshotBuffer$;
import kamon.metrics.TraceMetrics$;
import kamon.statsd.StatsDMetricsSender$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u0001\u001d\u0011qb\u0015;biN$U\t\u001f;f]NLwN\u001c\u0006\u0003\u0007\u0011\taa\u001d;biN$'\"A\u0003\u0002\u000b-\fWn\u001c8\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty1C\u0004\u0002\u0011#5\tA!\u0003\u0002\u0013\t\u0005)1*Y7p]&\u0011A#\u0006\u0002\n\u000bb$XM\\:j_:T!A\u0005\u0003\t\u0011]\u0001!\u0011!Q\u0001\na\taa]=ti\u0016l\u0007CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003\u0015\t7\r^8s\u0015\u0005i\u0012\u0001B1lW\u0006L!a\b\u000e\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u0018A\u0001\u0007\u0001\u0004C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\u0002\u00071|w-F\u0001*!\tQS&D\u0001,\u0015\taC$A\u0003fm\u0016tG/\u0003\u0002/W\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\bB\u0002\u0019\u0001A\u0003%\u0011&\u0001\u0003m_\u001e\u0004\u0003b\u0002\u001a\u0001\u0005\u0004%IaM\u0001\rgR\fGo\u001d#D_:4\u0017nZ\u000b\u0002iA\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\u0007G>tg-[4\u000b\u0005eR\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\n1aY8n\u0013\tidG\u0001\u0004D_:4\u0017n\u001a\u0005\u0007\u007f\u0001\u0001\u000b\u0011\u0002\u001b\u0002\u001bM$\u0018\r^:E\u0007>tg-[4!\u0011\u001d\t\u0005A1A\u0005\u0002\t\u000b!b\u001d;biN$\u0005j\\:u+\u0005\u0019\u0005C\u0001#J\u001b\u0005)%B\u0001$H\u0003\rqW\r\u001e\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUIA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgNDa\u0001\u0014\u0001!\u0002\u0013\u0019\u0015aC:uCR\u001cH\tS8ti\u0002BqA\u0014\u0001C\u0002\u0013\u0005q*A\u0007gYV\u001c\b.\u00138uKJ4\u0018\r\\\u000b\u0002!B\u0011\u0011\"U\u0005\u0003%*\u0011A\u0001T8oO\"1A\u000b\u0001Q\u0001\nA\u000baB\u001a7vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0004W\u0001\t\u0007I\u0011A,\u0002\u001b5\f\u0007\u0010U1dW\u0016$8+\u001b>f+\u0005A\u0006CA\u0005Z\u0013\tQ&BA\u0002J]RDa\u0001\u0018\u0001!\u0002\u0013A\u0016AD7bqB\u000b7m[3u'&TX\r\t\u0005\b=\u0002\u0011\r\u0011\"\u0001P\u00031!\u0018nY6J]R,'O^1m\u0011\u0019\u0001\u0007\u0001)A\u0005!\u0006iA/[2l\u0013:$XM\u001d<bY\u0002BqA\u0019\u0001C\u0002\u0013\u00051-A\u000bti\u0006$8\u000fR'fiJL7m\u001d'jgR,g.\u001a:\u0016\u0003\u0011\u0004\"!G3\n\u0005\u0019T\"\u0001C!di>\u0014(+\u001a4\t\r!\u0004\u0001\u0015!\u0003e\u0003Y\u0019H/\u0019;t\t6+GO]5dg2K7\u000f^3oKJ\u0004\u0003b\u00026\u0001\u0005\u0004%\ta[\u0001\u000fS:\u001cG.\u001e3fI\u0006\u001bGo\u001c:t+\u0005a\u0007cA7si6\taN\u0003\u0002pa\u00069Q.\u001e;bE2,'BA9\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003g:\u0014aAQ;gM\u0016\u0014\bCA;y\u001b\u00051(BA<H\u0003\u0011a\u0017M\\4\n\u0005e4(AB*ue&tw\r\u0003\u0004|\u0001\u0001\u0006I\u0001\\\u0001\u0010S:\u001cG.\u001e3fI\u0006\u001bGo\u001c:tA!9Q\u0010\u0001b\u0001\n\u0003Y\u0017AD5oG2,H-\u001a3Ue\u0006\u001cWm\u001d\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u00027\u0002\u001f%t7\r\\;eK\u0012$&/Y2fg\u0002Bq!a\u0001\u0001\t\u0003\t)!\u0001\u000bck&dG-T3ue&\u001c7\u000fT5ti\u0016tWM\u001d\u000b\u0006I\u0006\u001d\u0011\u0011\u0002\u0005\u0007=\u0006\u0005\u0001\u0019\u0001)\t\r9\u000b\t\u00011\u0001Q\u0001")
public class StatsDExtension
implements Kamon.Extension {
    public final ExtendedActorSystem kamon$statsd$StatsDExtension$$system;
    private final LoggingAdapter log;
    private final Config statsDConfig;
    private final InetSocketAddress statsDHost;
    private final long flushInterval;
    private final int maxPacketSize;
    private final long tickInterval;
    private final ActorRef statsDMetricsListener;
    private final Buffer<String> includedActors;
    private final Buffer<String> includedTraces;

    public void publishInfoMessage(ActorSystem system, String msg) {
        Kamon.Extension$class.publishInfoMessage((Kamon.Extension)this, (ActorSystem)system, (String)msg);
    }

    public void publishErrorMessage(ActorSystem system, String msg, Throwable cause) {
        Kamon.Extension$class.publishErrorMessage((Kamon.Extension)this, (ActorSystem)system, (String)msg, (Throwable)cause);
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private Config statsDConfig() {
        return this.statsDConfig;
    }

    public InetSocketAddress statsDHost() {
        return this.statsDHost;
    }

    public long flushInterval() {
        return this.flushInterval;
    }

    public int maxPacketSize() {
        return this.maxPacketSize;
    }

    public long tickInterval() {
        return this.tickInterval;
    }

    public ActorRef statsDMetricsListener() {
        return this.statsDMetricsListener;
    }

    public Buffer<String> includedActors() {
        return this.includedActors;
    }

    public Buffer<String> includedTraces() {
        return this.includedTraces;
    }

    public ActorRef buildMetricsListener(long tickInterval, long flushInterval) {
        Predef$.MODULE$.assert(flushInterval >= tickInterval, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "StatsD flush-interval needs to be equal or greater to the tick-interval";
            }
        });
        ActorRef metricsTranslator = this.kamon$statsd$StatsDExtension$$system.actorOf(StatsDMetricsSender$.MODULE$.props(this.statsDHost(), this.maxPacketSize()), "statsd-metrics-sender");
        return flushInterval == tickInterval ? metricsTranslator : this.kamon$statsd$StatsDExtension$$system.actorOf(TickMetricSnapshotBuffer$.MODULE$.props(new package.DurationInt(package$.MODULE$.DurationInt((int)flushInterval)).millis(), metricsTranslator), "statsd-metrics-buffer");
    }

    public StatsDExtension(ExtendedActorSystem system) {
        this.kamon$statsd$StatsDExtension$$system = system;
        Kamon.Extension$class.$init$((Kamon.Extension)this);
        this.log = Logging$.MODULE$.apply((ActorSystem)system, StatsDExtension.class, LogSource$.MODULE$.fromAnyClass());
        this.log().info("Starting the Kamon(StatsD) extension");
        this.statsDConfig = system.settings().config().getConfig("kamon.statsd");
        this.statsDHost = new InetSocketAddress(this.statsDConfig().getString("hostname"), this.statsDConfig().getInt("port"));
        this.flushInterval = this.statsDConfig().getDuration("flush-interval", TimeUnit.MILLISECONDS);
        this.maxPacketSize = this.statsDConfig().getInt("max-packet-size");
        this.tickInterval = system.settings().config().getDuration("kamon.metrics.tick-interval", TimeUnit.MILLISECONDS);
        this.statsDMetricsListener = this.buildMetricsListener(this.tickInterval(), this.flushInterval());
        this.includedActors = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.statsDConfig().getStringList("includes.actor")).asScala();
        this.includedActors().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDExtension $outer;

            public final void apply(String actorPathPattern) {
                ((MetricsExtension)Kamon$.MODULE$.apply((ExtensionId)Metrics$.MODULE$, (ActorSystem)this.$outer.kamon$statsd$StatsDExtension$$system)).subscribe((MetricGroupCategory)ActorMetrics$.MODULE$, actorPathPattern, this.$outer.statsDMetricsListener(), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.includedTraces = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.statsDConfig().getStringList("includes.trace")).asScala();
        this.includedTraces().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsDExtension $outer;

            public final void apply(String tracePathPattern) {
                ((MetricsExtension)Kamon$.MODULE$.apply((ExtensionId)Metrics$.MODULE$, (ActorSystem)this.$outer.kamon$statsd$StatsDExtension$$system)).subscribe((MetricGroupCategory)TraceMetrics$.MODULE$, tracePathPattern, this.$outer.statsDMetricsListener(), true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

