/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.maven;

import com.puppycrawl.tools.checkstyle.Checker;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.moderne.maven.MeterRegistryProvider;
import io.moderne.serialization.OriginHelper;
import io.moderne.serialization.TreeSerializer;
import io.moderne.serialization.bloom.Bloom;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.config.Environment;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.hcl.tree.Hcl;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.CountLinesVisitor;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.java.tree.J;
import org.openrewrite.json.tree.Json;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.marker.ci.BuildEnvironment;
import org.openrewrite.maven.ConfigurableRewriteMojo;
import org.openrewrite.maven.MavenMojoProjectParser;
import org.openrewrite.protobuf.tree.Proto;
import org.openrewrite.xml.tree.Xml;
import org.openrewrite.yaml.tree.Yaml;

@Mojo(name="ast", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PACKAGE)
public class ModerneAstMojo
extends ConfigurableRewriteMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private RuntimeInformation runtime;
    @Parameter(defaultValue="${session}", readonly=true)
    protected MavenSession mavenSession;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(property="organization")
    private String organization;
    @Parameter(property="repository")
    private String repository;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File astJarFile = new File(this.outputDirectory, this.finalName + "-ast.jar");
        if (astJarFile.exists()) {
            if (!astJarFile.delete()) {
                throw new MojoFailureException("Unable to overwrite AST jar file: " + astJarFile.getAbsolutePath());
            }
        } else if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoFailureException("Output directory for AST file does not exist and cannot be created: " + this.outputDirectory.getAbsolutePath());
        }
        List<SourceFile> asts = this.listAsts();
        Properties scmProvenance = this.getScmProvenanceProps(asts);
        try (OutputStream outputStream = Files.newOutputStream(astJarFile.toPath(), new OpenOption[0]);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
             JarOutputStream jarOutputStream = new JarOutputStream(bufferedOutputStream);){
            jarOutputStream.putNextEntry(new JarEntry("scm.properties"));
            scmProvenance.store(jarOutputStream, null);
            jarOutputStream.closeEntry();
            jarOutputStream.putNextEntry(new JarEntry(this.project.getName() + ".ast"));
            new TreeSerializer().write(asts, jarOutputStream);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.projectHelper.attachArtifact(this.project, "jar", "ast", astJarFile);
    }

    private String getBuildId() {
        String buildId;
        block17: {
            MavenProject firstSessionProject = (MavenProject)this.mavenSession.getProjects().get(0);
            Path buildIdPath = firstSessionProject.getBasedir().toPath().resolve("target/moderne/buildId.txt");
            if (this.project.getId().equals(firstSessionProject.getId())) {
                buildId = UUID.randomUUID().toString();
                try {
                    Files.createDirectories(buildIdPath.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(buildIdPath, new OpenOption[0]);){
                        writer.write(buildId);
                        break block17;
                    }
                }
                catch (IOException e2) {
                    throw new UncheckedIOException(e2);
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(buildIdPath);){
                buildId = reader.readLine();
            }
            catch (IOException e3) {
                throw new UncheckedIOException(e3);
            }
        }
        return buildId;
    }

    private Properties getScmProvenanceProps(List<SourceFile> asts) throws MojoFailureException {
        Properties scmProperties = this.getAstStats(asts);
        GitProvenance gitProvenance = GitProvenance.fromProjectDirectory((Path)this.getBaseDir(), (BuildEnvironment)BuildEnvironment.build(System::getenv));
        scmProperties.setProperty("buildId", this.getBuildId());
        if (gitProvenance == null) {
            if (this.organization == null || this.repository == null) {
                throw new MojoFailureException("Organization and repository parameters are required for projects that are not git repositories.");
            }
            scmProperties.setProperty("path", this.organization + "/" + this.repository);
        } else {
            if (gitProvenance.getOrigin() == null) {
                throw new MojoFailureException("Unable to determine the git remote origin for this repository.");
            }
            scmProperties.setProperty("cloneUrl", gitProvenance.getOrigin());
            scmProperties.setProperty("origin", OriginHelper.stripOrigin(gitProvenance.getOrigin()));
            if (gitProvenance.getBranch() == null) {
                throw new MojoFailureException("Unable to determine the git branch for this repository.");
            }
            scmProperties.setProperty("branch", gitProvenance.getBranch());
            scmProperties.setProperty("change", gitProvenance.getChange());
            if (gitProvenance.getOrganizationName() == null || gitProvenance.getRepositoryName() == null) {
                throw new MojoFailureException("Unable to determine the organization or repository name for this repository.");
            }
            scmProperties.setProperty("path", gitProvenance.getOrganizationName() + "/" + gitProvenance.getRepositoryName());
            scmProperties.setProperty("created", this.mavenSession.getStartTime().toString());
        }
        scmProperties.setProperty("groupId", this.project.getGroupId());
        scmProperties.setProperty("artifactId", this.project.getArtifactId());
        scmProperties.setProperty("version", this.project.getVersion());
        this.addModernePluginProperties(scmProperties);
        return scmProperties;
    }

    private Properties getAstStats(List<SourceFile> sourceFiles) {
        int groovyLineCount = 0;
        int hclLineCount = 0;
        int javaLineCount = 0;
        int jsonLineCount = 0;
        int propertiesLineCount = 0;
        int protobufLineCount = 0;
        int xmlLineCount = 0;
        int yamlLineCount = 0;
        Bloom bloom = Bloom.construct(new long[0], 1.0);
        long weight = 0L;
        for (SourceFile sourceFile : sourceFiles) {
            weight += sourceFile.getWeight(t2 -> {
                int id = System.identityHashCode(t2);
                if (bloom.mayContain(id)) {
                    return false;
                }
                bloom.add(id);
                return true;
            });
            if (sourceFile instanceof G) {
                groovyLineCount += org.openrewrite.groovy.CountLinesVisitor.countLines((Tree)sourceFile);
                continue;
            }
            if (sourceFile instanceof J) {
                javaLineCount += CountLinesVisitor.countLines((Tree)sourceFile);
                continue;
            }
            if (sourceFile instanceof Hcl) {
                hclLineCount += org.openrewrite.hcl.CountLinesVisitor.countLines((Tree)sourceFile);
                continue;
            }
            if (sourceFile instanceof Json) {
                jsonLineCount += org.openrewrite.json.CountLinesVisitor.countLines((Tree)sourceFile);
                continue;
            }
            if (sourceFile instanceof Properties) {
                propertiesLineCount += org.openrewrite.properties.CountLinesVisitor.countLines((Tree)sourceFile);
                continue;
            }
            if (sourceFile instanceof Proto) {
                protobufLineCount += org.openrewrite.protobuf.CountLinesVisitor.countLines((Tree)sourceFile);
                continue;
            }
            if (sourceFile instanceof Xml) {
                xmlLineCount += org.openrewrite.xml.CountLinesVisitor.countLines((Tree)sourceFile);
                continue;
            }
            if (!(sourceFile instanceof Yaml)) continue;
            yamlLineCount += org.openrewrite.yaml.CountLinesVisitor.countLines((Tree)sourceFile);
        }
        Properties results = new Properties();
        results.put("groovyLineCount", Integer.toString(groovyLineCount));
        results.put("hclLineCount", Integer.toString(hclLineCount));
        results.put("javaLineCount", Integer.toString(javaLineCount));
        results.put("jsonLineCount", Integer.toString(jsonLineCount));
        results.put("propertiesLineCount", Integer.toString(propertiesLineCount));
        results.put("protobufLineCount", Integer.toString(protobufLineCount));
        results.put("xmlLineCount", Integer.toString(xmlLineCount));
        results.put("yamlLineCount", Integer.toString(yamlLineCount));
        results.put("astWeight", Long.toString(weight));
        return results;
    }

    private void addModernePluginProperties(Properties scmProperties) {
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/io.moderne/moderne-maven-plugin/pom.properties");){
            if (inputStream != null) {
                Properties props = new Properties();
                props.load(inputStream);
                scmProperties.setProperty("buildPluginName", "moderne-maven-plugin");
                scmProperties.setProperty("buildPluginVersion", props.getProperty("version"));
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    protected Environment environment() throws MojoExecutionException {
        File rewriteConfig;
        Environment.Builder env = Environment.builder((Properties)this.project.getProperties()).scanRuntimeClasspath(new String[0]).scanUserHome();
        Path absoluteConfigLocation = Paths.get(this.configLocation, new String[0]);
        if (!absoluteConfigLocation.isAbsolute()) {
            absoluteConfigLocation = this.project.getBasedir().toPath().resolve(this.configLocation);
        }
        if ((rewriteConfig = absoluteConfigLocation.toFile()).exists()) {
            try (FileInputStream is = new FileInputStream(rewriteConfig);){
                env.load((ResourceLoader)new YamlResourceLoader((InputStream)is, rewriteConfig.toURI(), this.project.getProperties()));
            }
            catch (IOException e2) {
                throw new MojoExecutionException("Unable to load rewrite configuration", (Exception)e2);
            }
        }
        return env.build();
    }

    ExecutionContext executionContext() {
        return new InMemoryExecutionContext(t2 -> {
            this.getLog().warn((CharSequence)t2.getMessage());
            this.getLog().debug(t2);
        });
    }

    protected Path getBaseDir() {
        Object maybeMultiModuleDir = System.getProperties().get("maven.multiModuleProjectDirectory");
        try {
            if (maybeMultiModuleDir instanceof String) {
                return Paths.get((String)maybeMultiModuleDir, new String[0]).toRealPath(new LinkOption[0]);
            }
            return this.project.getBasedir().toPath().toRealPath(new LinkOption[0]);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected List<SourceFile> listAsts() throws MojoExecutionException {
        MeterRegistryProvider meterRegistryProvider = new MeterRegistryProvider(this.getLog(), this.metricsUri, this.metricsUsername, this.metricsPassword);
        try {
            List styles;
            Path baseDir;
            block18: {
                Metrics.addRegistry((MeterRegistry)meterRegistryProvider.registry());
                baseDir = this.getBaseDir();
                Environment env = this.environment();
                styles = env.activateStyles((Iterable)this.activeStyles);
                try {
                    Object checkstyleConfRaw;
                    Plugin checkstylePlugin = this.project.getPlugin("org.apache.maven.plugins:maven-checkstyle-plugin");
                    if (this.checkstyleConfigFile != null && !this.checkstyleConfigFile.isEmpty()) {
                        styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)Paths.get(this.checkstyleConfigFile, new String[0]), Collections.emptyMap()));
                        break block18;
                    }
                    if (checkstylePlugin == null || !((checkstyleConfRaw = checkstylePlugin.getConfiguration()) instanceof Xpp3Dom)) break block18;
                    Xpp3Dom xmlCheckstyleConf = (Xpp3Dom)checkstyleConfRaw;
                    Xpp3Dom xmlConfigLocation = xmlCheckstyleConf.getChild("configLocation");
                    if (xmlConfigLocation == null) {
                        try (InputStream is = Checker.class.getResourceAsStream("/sun_checks.xml");){
                            if (is != null) {
                                styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((InputStream)is, Collections.emptyMap()));
                            }
                            break block18;
                        }
                    }
                    Path configPath = Paths.get(xmlConfigLocation.getValue(), new String[0]);
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)configPath, Collections.emptyMap()));
                }
                catch (Exception e2) {
                    this.getLog().warn((CharSequence)"Unable to parse checkstyle configuration. Checkstyle will not inform rewrite execution.", (Throwable)e2);
                }
            }
            ExecutionContext ctx = this.executionContext();
            MavenMojoProjectParser projectParser = new MavenMojoProjectParser(this.getLog(), baseDir, this.pomCacheEnabled, this.pomCacheDirectory, this.runtime, this.skipMavenParsing, (Collection)this.getExclusions(), (Collection)this.getPlainTextMasks(), this.sizeThresholdMb, this.mavenSession, this.settingsDecrypter);
            List sourceFiles = projectParser.listSourceFiles(this.project, styles, ctx);
            projectParser.resetTypeCache();
            Metrics.removeRegistry((MeterRegistry)meterRegistryProvider.registry());
            List list = sourceFiles;
            meterRegistryProvider.close();
            return list;
        }
        catch (Throwable throwable) {
            try {
                try {
                    meterRegistryProvider.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (DependencyResolutionRequiredException e3) {
                throw new MojoExecutionException("Dependency resolution required", (Exception)((Object)e3));
            }
        }
    }
}

