/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.NoPool;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.ZstdIOException;
import com.github.luben.zstd.util.Native;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ZstdInputStreamNoFinalizer
extends FilterInputStream {
    private final long stream;
    private long dstPos = 0L;
    private long srcPos = 0L;
    private long srcSize = 0L;
    private boolean needRead = true;
    private final BufferPool bufferPool;
    private final ByteBuffer srcByteBuffer;
    private final byte[] src;
    private static final int srcBuffSize;
    private boolean isContinuous = false;
    private boolean frameFinished = true;
    private boolean isClosed = false;

    public static native long recommendedDInSize();

    public static native long recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native int decompressStream(long var1, byte[] var3, int var4, byte[] var5, int var6);

    public ZstdInputStreamNoFinalizer(InputStream inputStream) throws IOException {
        this(inputStream, NoPool.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdInputStreamNoFinalizer(InputStream inputStream, BufferPool bufferPool) throws IOException {
        super(inputStream);
        this.bufferPool = bufferPool;
        this.srcByteBuffer = bufferPool.get(srcBuffSize);
        if (this.srcByteBuffer == null) {
            throw new ZstdIOException(Zstd.errMemoryAllocation(), "Cannot get ByteBuffer of size " + srcBuffSize + " from the BufferPool");
        }
        this.src = Zstd.extractArray(this.srcByteBuffer);
        ZstdInputStreamNoFinalizer zstdInputStreamNoFinalizer = this;
        synchronized (zstdInputStreamNoFinalizer) {
            this.stream = ZstdInputStreamNoFinalizer.createDStream();
            this.initDStream(this.stream);
        }
    }

    public synchronized ZstdInputStreamNoFinalizer setContinuous(boolean bl) {
        this.isContinuous = bl;
        return this;
    }

    public synchronized boolean getContinuous() {
        return this.isContinuous;
    }

    public synchronized ZstdInputStreamNoFinalizer setDict(byte[] byArray) throws IOException {
        int n2 = Zstd.loadDictDecompress(this.stream, byArray, byArray.length);
        if (Zstd.isError(n2)) {
            throw new ZstdIOException(n2);
        }
        return this;
    }

    public synchronized ZstdInputStreamNoFinalizer setDict(ZstdDictDecompress zstdDictDecompress) throws IOException {
        zstdDictDecompress.acquireSharedLock();
        try {
            int n2 = Zstd.loadFastDictDecompress(this.stream, zstdDictDecompress);
            if (Zstd.isError(n2)) {
                throw new ZstdIOException(n2);
            }
        }
        finally {
            zstdDictDecompress.releaseSharedLock();
        }
        return this;
    }

    public synchronized ZstdInputStreamNoFinalizer setLongMax(int n2) throws IOException {
        int n3 = Zstd.setDecompressionLongMax(this.stream, n2);
        if (Zstd.isError(n3)) {
            throw new ZstdIOException(n3);
        }
        return this;
    }

    public synchronized ZstdInputStreamNoFinalizer setRefMultipleDDicts(boolean bl) throws IOException {
        int n2 = Zstd.setRefMultipleDDicts(this.stream, bl);
        if (Zstd.isError(n2)) {
            throw new ZstdIOException(n2);
        }
        return this;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException("Requested length " + n3 + " from offset " + n2 + " in buffer of size " + byArray.length);
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = 0;
        while (n4 == 0) {
            n4 = this.readInternal(byArray, n2, n3);
        }
        return n4;
    }

    int readInternal(byte[] byArray, int n2, int n3) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (n2 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException("Requested length " + n3 + " from offset " + n2 + " in buffer of size " + byArray.length);
        }
        int n4 = n2 + n3;
        this.dstPos = n2;
        long l2 = -1L;
        while (this.dstPos < (long)n4 && l2 < this.dstPos) {
            if (this.needRead && (this.in.available() > 0 || this.dstPos == (long)n2)) {
                this.srcSize = this.in.read(this.src, 0, srcBuffSize);
                this.srcPos = 0L;
                if (this.srcSize < 0L) {
                    this.srcSize = 0L;
                    if (this.frameFinished) {
                        return -1;
                    }
                    if (this.isContinuous) {
                        this.srcSize = (int)(this.dstPos - (long)n2);
                        if (this.srcSize > 0L) {
                            return (int)this.srcSize;
                        }
                        return -1;
                    }
                    throw new ZstdIOException(Zstd.errCorruptionDetected(), "Truncated source");
                }
                this.frameFinished = false;
            }
            l2 = this.dstPos;
            int n5 = this.decompressStream(this.stream, byArray, n4, this.src, (int)this.srcSize);
            if (Zstd.isError(n5)) {
                throw new ZstdIOException(n5);
            }
            if (n5 == 0) {
                this.frameFinished = true;
                this.needRead = this.srcPos == this.srcSize;
                return (int)(this.dstPos - (long)n2);
            }
            this.needRead = this.dstPos < (long)n4;
        }
        return (int)(this.dstPos - (long)n2);
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = 0;
        while (n2 == 0) {
            n2 = this.readInternal(byArray, 0, 1);
        }
        if (n2 == 1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int available() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.needRead) {
            return 1;
        }
        return this.in.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long skip(long l2) throws IOException {
        long l3;
        if (this.isClosed) {
            throw new IOException("Stream closed");
        }
        if (l2 <= 0L) {
            return 0L;
        }
        int n2 = (int)ZstdInputStreamNoFinalizer.recommendedDOutSize();
        if ((long)n2 > l2) {
            n2 = (int)l2;
        }
        ByteBuffer byteBuffer = this.bufferPool.get(n2);
        try {
            int n3;
            byte[] byArray = Zstd.extractArray(byteBuffer);
            for (l3 = l2; l3 > 0L; l3 -= (long)n3) {
                n3 = this.read(byArray, 0, (int)Math.min((long)n2, l3));
                if (n3 >= 0) continue;
                break;
            }
        }
        finally {
            this.bufferPool.release(byteBuffer);
        }
        return l2 - l3;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.bufferPool.release(this.srcByteBuffer);
        ZstdInputStreamNoFinalizer.freeDStream(this.stream);
        this.in.close();
    }

    static {
        Native.load();
        srcBuffSize = (int)ZstdInputStreamNoFinalizer.recommendedDInSize();
    }
}

