/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class BootstrapTest {
    private static final EventLoopGroup groupA = new DefaultEventLoopGroup(1);
    private static final EventLoopGroup groupB = new DefaultEventLoopGroup(1);
    private static final ChannelInboundHandler dummyHandler = new DummyHandler();

    @AfterAll
    public static void destroy() {
        groupA.shutdownGracefully();
        groupB.shutdownGracefully();
        groupA.terminationFuture().syncUninterruptibly();
        groupB.terminationFuture().syncUninterruptibly();
    }

    @Test
    public void testOptionsCopied() {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.option(ChannelOption.AUTO_READ, (Object)true);
        Map.Entry[] channelOptions = bootstrapA.newOptionsArray();
        bootstrapA.option(ChannelOption.AUTO_READ, (Object)false);
        Assertions.assertEquals((Object)ChannelOption.AUTO_READ, channelOptions[0].getKey());
        Assertions.assertEquals((Object)true, channelOptions[0].getValue());
    }

    @Test
    public void testAttributesCopied() {
        AttributeKey key = AttributeKey.valueOf((String)UUID.randomUUID().toString());
        String value = "value";
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.attr(key, (Object)value);
        Map.Entry[] attributesArray = bootstrapA.newAttributesArray();
        bootstrapA.attr(key, (Object)"value2");
        Assertions.assertEquals((Object)key, attributesArray[0].getKey());
        Assertions.assertEquals((Object)value, attributesArray[0].getValue());
    }

    @Test
    public void optionsAndAttributesMustBeAvailableOnChannelInit() throws InterruptedException {
        final AttributeKey key = AttributeKey.valueOf((String)UUID.randomUUID().toString());
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(groupA)).channel(LocalChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)4242)).attr(key, (Object)"value")).handler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                Integer option = (Integer)ch.config().getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS);
                Assertions.assertEquals((int)4242, (int)option);
                Assertions.assertEquals((Object)"value", (Object)ch.attr(key).get());
            }
        })).bind((SocketAddress)LocalAddress.ANY).sync();
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testBindDeadLock() throws Exception {
        final Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.handler((ChannelHandler)dummyHandler);
        final Bootstrap bootstrapB = new Bootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalChannel.class);
        bootstrapB.handler((ChannelHandler)dummyHandler);
        ArrayList<Future> bindFutures = new ArrayList<Future>();
        for (int i = 0; i < 1024; ++i) {
            bindFutures.add(groupA.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapB.bind((SocketAddress)LocalAddress.ANY);
                }
            }));
            bindFutures.add(groupB.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapA.bind((SocketAddress)LocalAddress.ANY);
                }
            }));
        }
        for (Future f : bindFutures) {
            f.sync();
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testConnectDeadLock() throws Exception {
        final Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.handler((ChannelHandler)dummyHandler);
        final Bootstrap bootstrapB = new Bootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalChannel.class);
        bootstrapB.handler((ChannelHandler)dummyHandler);
        ArrayList<Future> bindFutures = new ArrayList<Future>();
        for (int i = 0; i < 1024; ++i) {
            bindFutures.add(groupA.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapB.connect((SocketAddress)LocalAddress.ANY);
                }
            }));
            bindFutures.add(groupB.next().submit(new Runnable(){

                @Override
                public void run() {
                    bootstrapA.connect((SocketAddress)LocalAddress.ANY);
                }
            }));
        }
        for (Future f : bindFutures) {
            f.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLateRegisterSuccess() throws Exception {
        TestEventLoopGroup group = new TestEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)group);
            bootstrap.channel(LocalServerChannel.class);
            bootstrap.childHandler((ChannelHandler)new DummyHandler());
            bootstrap.localAddress((SocketAddress)new LocalAddress("1"));
            ChannelFuture future = bootstrap.bind();
            Assertions.assertFalse((boolean)future.isDone());
            group.promise.setSuccess();
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    queue.add(future.channel().eventLoop().inEventLoop(Thread.currentThread()));
                    queue.add(future.isSuccess());
                }
            });
            Assertions.assertTrue((boolean)((Boolean)queue.take()));
            Assertions.assertTrue((boolean)((Boolean)queue.take()));
        }
        finally {
            group.shutdownGracefully();
            group.terminationFuture().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLateRegisterSuccessBindFailed() throws Exception {
        TestEventLoopGroup group = new TestEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.group((EventLoopGroup)group);
            bootstrap.channelFactory((ChannelFactory)new ChannelFactory<ServerChannel>(){

                public ServerChannel newChannel() {
                    return new LocalServerChannel(){

                        public ChannelFuture bind(SocketAddress localAddress) {
                            this.close();
                            return this.newFailedFuture(new SocketException());
                        }

                        public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
                            this.close();
                            return promise.setFailure((Throwable)new SocketException());
                        }
                    };
                }
            });
            bootstrap.childHandler((ChannelHandler)new DummyHandler());
            bootstrap.localAddress((SocketAddress)new LocalAddress("1"));
            ChannelFuture future = bootstrap.bind();
            Assertions.assertFalse((boolean)future.isDone());
            group.promise.setSuccess();
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    queue.add(future.channel().eventLoop().inEventLoop(Thread.currentThread()));
                    queue.add(future.isSuccess());
                }
            });
            Assertions.assertTrue((boolean)((Boolean)queue.take()));
            Assertions.assertFalse((boolean)((Boolean)queue.take()));
        }
        finally {
            group.shutdownGracefully();
            group.terminationFuture().sync();
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testLateRegistrationConnect() throws Exception {
        DelayedEventLoopGroup group = new DelayedEventLoopGroup();
        try {
            final Bootstrap bootstrapA = new Bootstrap();
            bootstrapA.group((EventLoopGroup)group);
            bootstrapA.channel(LocalChannel.class);
            bootstrapA.handler((ChannelHandler)dummyHandler);
            Assertions.assertThrows(ConnectException.class, (Executable)new Executable(){

                public void execute() {
                    bootstrapA.connect((SocketAddress)LocalAddress.ANY).syncUninterruptibly();
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testAsyncResolutionSuccess() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new TestAddressResolverGroup(true));
        bootstrapA.handler((ChannelHandler)dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler((ChannelHandler)dummyHandler);
        SocketAddress localAddress = bootstrapB.bind((SocketAddress)LocalAddress.ANY).sync().channel().localAddress();
        bootstrapA.connect(localAddress).sync();
    }

    @Test
    public void testAsyncResolutionFailure() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new TestAddressResolverGroup(false));
        bootstrapA.handler((ChannelHandler)dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler((ChannelHandler)dummyHandler);
        SocketAddress localAddress = bootstrapB.bind((SocketAddress)LocalAddress.ANY).sync().channel().localAddress();
        ChannelFuture connectFuture = bootstrapA.connect(localAddress);
        MatcherAssert.assertThat((Object)connectFuture.await(10000L), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)connectFuture.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(UnknownHostException.class)));
        MatcherAssert.assertThat((Object)connectFuture.channel().isOpen(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testGetResolverFailed() throws Exception {
        Bootstrap bootstrapA = new Bootstrap();
        bootstrapA.group(groupA);
        bootstrapA.channel(LocalChannel.class);
        bootstrapA.resolver((AddressResolverGroup)new AddressResolverGroup<SocketAddress>(){

            protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) {
                class TestException
                extends RuntimeException {
                    TestException() {
                    }
                }
                throw new TestException();
            }
        });
        bootstrapA.handler((ChannelHandler)dummyHandler);
        ServerBootstrap bootstrapB = new ServerBootstrap();
        bootstrapB.group(groupB);
        bootstrapB.channel(LocalServerChannel.class);
        bootstrapB.childHandler((ChannelHandler)dummyHandler);
        SocketAddress localAddress = bootstrapB.bind((SocketAddress)LocalAddress.ANY).sync().channel().localAddress();
        ChannelFuture connectFuture = bootstrapA.connect(localAddress);
        MatcherAssert.assertThat((Object)connectFuture.await(10000L), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)connectFuture.cause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        MatcherAssert.assertThat((Object)connectFuture.cause().getCause(), (Matcher)Matchers.instanceOf(TestException.class));
        MatcherAssert.assertThat((Object)connectFuture.channel().isOpen(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testChannelFactoryFailureNotifiesPromise() throws Exception {
        final RuntimeException exception = new RuntimeException("newChannel crash");
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().handler((ChannelHandler)dummyHandler)).group(groupA)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

            public Channel newChannel() {
                throw exception;
            }
        });
        ChannelFuture connectFuture = bootstrap.connect((SocketAddress)LocalAddress.ANY);
        MatcherAssert.assertThat((Object)connectFuture.await(10000L), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)connectFuture.cause(), (Matcher)Matchers.sameInstance((Object)exception));
        MatcherAssert.assertThat((Object)connectFuture.channel(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
    }

    @Test
    public void testChannelOptionOrderPreserve() throws InterruptedException {
        final LinkedBlockingQueue options = new LinkedBlockingQueue();
        final CountDownLatch latch = new CountDownLatch(1);
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                latch.countDown();
            }
        })).group(groupA)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

            public Channel newChannel() {
                return new LocalChannel(){
                    private 1ChannelConfigValidator config;

                    public synchronized ChannelConfig config() {
                        class ChannelConfigValidator
                        extends DefaultChannelConfig {
                            final /* synthetic */ BlockingQueue val$options;

                            ChannelConfigValidator(Channel channel) {
                                this.val$options = blockingQueue;
                                super(channel);
                            }

                            public <T> boolean setOption(ChannelOption<T> option, T value) {
                                this.val$options.add(option);
                                return super.setOption(option, value);
                            }
                        }
                        if (this.config == null) {
                            this.config = new ChannelConfigValidator(BootstrapTest.this, (Channel)this, options);
                        }
                        return this.config;
                    }
                };
            }
        })).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)1)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)2);
        bootstrap.register().syncUninterruptibly();
        latch.await();
        Assertions.assertSame((Object)ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, options.take());
        Assertions.assertSame((Object)ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, options.take());
    }

    private static final class TestAddressResolverGroup
    extends AddressResolverGroup<SocketAddress> {
        private final boolean success;

        TestAddressResolverGroup(boolean success) {
            this.success = success;
        }

        protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) throws Exception {
            return new AbstractAddressResolver<SocketAddress>(executor){

                protected boolean doIsResolved(SocketAddress address) {
                    return false;
                }

                protected void doResolve(final SocketAddress unresolvedAddress, final Promise<SocketAddress> promise) {
                    this.executor().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (TestAddressResolverGroup.this.success) {
                                promise.setSuccess((Object)unresolvedAddress);
                            } else {
                                promise.setFailure((Throwable)new UnknownHostException(unresolvedAddress.toString()));
                            }
                        }
                    });
                }

                protected void doResolveAll(final SocketAddress unresolvedAddress, final Promise<List<SocketAddress>> promise) throws Exception {
                    this.executor().execute(new Runnable(){

                        @Override
                        public void run() {
                            if (TestAddressResolverGroup.this.success) {
                                promise.setSuccess(Collections.singletonList(unresolvedAddress));
                            } else {
                                promise.setFailure((Throwable)new UnknownHostException(unresolvedAddress.toString()));
                            }
                        }
                    });
                }
            };
        }
    }

    @ChannelHandler.Sharable
    private static final class DummyHandler
    extends ChannelInboundHandlerAdapter {
        private DummyHandler() {
        }
    }

    private static final class TestEventLoopGroup
    extends DefaultEventLoopGroup {
        ChannelPromise promise;

        TestEventLoopGroup() {
            super(1);
        }

        public ChannelFuture register(Channel channel) {
            super.register(channel).syncUninterruptibly();
            this.promise = channel.newPromise();
            return this.promise;
        }

        public ChannelFuture register(ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture register(Channel channel, ChannelPromise promise) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DelayedEventLoopGroup
    extends DefaultEventLoop {
        private DelayedEventLoopGroup() {
        }

        public ChannelFuture register(final Channel channel, final ChannelPromise promise) {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    DelayedEventLoopGroup.super.register(channel, promise);
                }
            });
            return promise;
        }
    }
}

