/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleUserEventChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SimpleUserEventChannelHandlerTest {
    private FooEventCatcher fooEventCatcher;
    private AllEventCatcher allEventCatcher;
    private EmbeddedChannel channel;

    @BeforeEach
    public void setUp() {
        this.fooEventCatcher = new FooEventCatcher();
        this.allEventCatcher = new AllEventCatcher();
        this.channel = new EmbeddedChannel(new ChannelHandler[]{this.fooEventCatcher, this.allEventCatcher});
    }

    @Test
    public void testTypeMatch() {
        FooEvent fooEvent = new FooEvent();
        this.channel.pipeline().fireUserEventTriggered((Object)fooEvent);
        Assertions.assertEquals((int)1, (int)this.fooEventCatcher.caughtEvents.size());
        Assertions.assertEquals((int)0, (int)this.allEventCatcher.caughtEvents.size());
        Assertions.assertEquals((int)0, (int)fooEvent.refCnt());
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testTypeMismatch() {
        BarEvent barEvent = new BarEvent();
        this.channel.pipeline().fireUserEventTriggered((Object)barEvent);
        Assertions.assertEquals((int)0, (int)this.fooEventCatcher.caughtEvents.size());
        Assertions.assertEquals((int)1, (int)this.allEventCatcher.caughtEvents.size());
        Assertions.assertTrue((boolean)barEvent.release());
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    static final class AllEventCatcher
    extends ChannelInboundHandlerAdapter {
        public List<Object> caughtEvents = new ArrayList<Object>();

        AllEventCatcher() {
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            this.caughtEvents.add(evt);
        }
    }

    static final class FooEventCatcher
    extends SimpleUserEventChannelHandler<FooEvent> {
        public List<FooEvent> caughtEvents = new ArrayList<FooEvent>();

        FooEventCatcher() {
        }

        protected void eventReceived(ChannelHandlerContext ctx, FooEvent evt) {
            this.caughtEvents.add(evt);
        }
    }

    static final class BarEvent
    extends DefaultByteBufHolder {
        BarEvent() {
            super(Unpooled.buffer());
        }
    }

    static final class FooEvent
    extends DefaultByteBufHolder {
        FooEvent() {
            super(Unpooled.buffer());
        }
    }
}

