/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.nio.SelectedSelectionKeySet;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

public class SelectedSelectionKeySetTest {
    @Mock
    private SelectionKey mockKey;
    @Mock
    private SelectionKey mockKey2;
    @Mock
    private SelectionKey mockKey3;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void addElements() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        int expectedSize = 1000000;
        for (int i = 0; i < 1000000; ++i) {
            Assertions.assertTrue((boolean)set.add(this.mockKey));
        }
        Assertions.assertEquals((int)1000000, (int)set.size());
        Assertions.assertFalse((boolean)set.isEmpty());
    }

    @Test
    public void resetSet() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assertions.assertTrue((boolean)set.add(this.mockKey));
        Assertions.assertTrue((boolean)set.add(this.mockKey2));
        set.reset(1);
        Assertions.assertSame((Object)this.mockKey, (Object)set.keys[0]);
        Assertions.assertNull((Object)set.keys[1]);
        Assertions.assertEquals((int)0, (int)set.size());
        Assertions.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void iterator() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assertions.assertTrue((boolean)set.add(this.mockKey));
        Assertions.assertTrue((boolean)set.add(this.mockKey2));
        Iterator keys = set.iterator();
        Assertions.assertTrue((boolean)keys.hasNext());
        Assertions.assertSame((Object)this.mockKey, keys.next());
        Assertions.assertTrue((boolean)keys.hasNext());
        Assertions.assertSame((Object)this.mockKey2, keys.next());
        Assertions.assertFalse((boolean)keys.hasNext());
        try {
            keys.next();
            Assertions.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            keys.remove();
            Assertions.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void contains() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assertions.assertTrue((boolean)set.add(this.mockKey));
        Assertions.assertTrue((boolean)set.add(this.mockKey2));
        Assertions.assertFalse((boolean)set.contains((Object)this.mockKey));
        Assertions.assertFalse((boolean)set.contains((Object)this.mockKey2));
        Assertions.assertFalse((boolean)set.contains((Object)this.mockKey3));
    }

    @Test
    public void remove() {
        SelectedSelectionKeySet set = new SelectedSelectionKeySet();
        Assertions.assertTrue((boolean)set.add(this.mockKey));
        Assertions.assertFalse((boolean)set.remove((Object)this.mockKey));
        Assertions.assertFalse((boolean)set.remove((Object)this.mockKey2));
    }
}

