/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalEventLoopGroup;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolTestUtils;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class AbstractChannelPoolMapTest {
    @Test
    public void testMap() throws Exception {
        LocalEventLoopGroup group = new LocalEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        final Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        AbstractChannelPoolMap<EventLoop, SimpleChannelPool> poolMap = new AbstractChannelPoolMap<EventLoop, SimpleChannelPool>(){

            protected SimpleChannelPool newPool(EventLoop key) {
                return new SimpleChannelPool(cb.clone((EventLoopGroup)key), (ChannelPoolHandler)new TestChannelPoolHandler());
            }
        };
        EventLoop loop = group.next();
        Assertions.assertFalse((boolean)poolMap.iterator().hasNext());
        Assertions.assertEquals((int)0, (int)poolMap.size());
        final SimpleChannelPool pool = (SimpleChannelPool)poolMap.get((Object)loop);
        Assertions.assertEquals((int)1, (int)poolMap.size());
        Assertions.assertTrue((boolean)poolMap.iterator().hasNext());
        Assertions.assertSame((Object)pool, (Object)poolMap.get((Object)loop));
        Assertions.assertTrue((boolean)poolMap.remove((Object)loop));
        Assertions.assertFalse((boolean)poolMap.remove((Object)loop));
        Assertions.assertFalse((boolean)poolMap.iterator().hasNext());
        Assertions.assertEquals((int)0, (int)poolMap.size());
        Assertions.assertThrows(ConnectException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                pool.acquire().syncUninterruptibly();
            }
        });
        poolMap.close();
    }

    @Test
    public void testRemoveClosesChannelPool() {
        LocalEventLoopGroup group = new LocalEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        final Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        AbstractChannelPoolMap<EventLoop, TestPool> poolMap = new AbstractChannelPoolMap<EventLoop, TestPool>(){

            protected TestPool newPool(EventLoop key) {
                return new TestPool(cb.clone((EventLoopGroup)key), (ChannelPoolHandler)new TestChannelPoolHandler());
            }
        };
        EventLoop loop = group.next();
        TestPool pool = (TestPool)poolMap.get((Object)loop);
        Assertions.assertTrue((boolean)poolMap.remove((Object)loop));
        pool.closeFuture.awaitUninterruptibly(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)pool.closeFuture.isDone());
        poolMap.close();
    }

    @Test
    public void testCloseClosesPoolsImmediately() {
        LocalEventLoopGroup group = new LocalEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        final Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        AbstractChannelPoolMap<EventLoop, TestPool> poolMap = new AbstractChannelPoolMap<EventLoop, TestPool>(){

            protected TestPool newPool(EventLoop key) {
                return new TestPool(cb.clone((EventLoopGroup)key), (ChannelPoolHandler)new TestChannelPoolHandler());
            }
        };
        EventLoop loop = group.next();
        TestPool pool = (TestPool)poolMap.get((Object)loop);
        Assertions.assertFalse((boolean)pool.closeFuture.isDone());
        poolMap.close();
        Assertions.assertTrue((boolean)pool.closeFuture.isDone());
    }

    private static final class TestPool
    extends SimpleChannelPool {
        private final Promise<Void> closeFuture;

        TestPool(Bootstrap bootstrap, ChannelPoolHandler handler) {
            super(bootstrap, handler);
            EventLoop executor = bootstrap.config().group().next();
            this.closeFuture = executor.newPromise();
        }

        public Future<Void> closeAsync() {
            Future poolClose = super.closeAsync();
            poolClose.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> future) throws Exception {
                    if (future.isSuccess()) {
                        TestPool.this.closeFuture.setSuccess(null);
                    } else {
                        TestPool.this.closeFuture.setFailure(future.cause());
                    }
                }
            });
            return poolClose;
        }
    }

    private static final class TestChannelPoolHandler
    extends AbstractChannelPoolHandler {
        private TestChannelPoolHandler() {
        }

        public void channelCreated(Channel ch) throws Exception {
        }
    }
}

