/*
 * Decompiled with CFR 0.152.
 */
package io.netty.nativeimage;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.channel.ChannelHandler;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public final class ChannelHandlerMetadataUtil {
    private static final Type HANDLER_METADATA_LIST_TYPE = new TypeToken<List<HandlerMetadata>>(){}.getType();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private ChannelHandlerMetadataUtil() {
    }

    public static void generateMetadata(String ... packageNames) {
        String projectGroupId = System.getProperty("nativeImage.handlerMetadataGroupId");
        String projectArtifactId = System.getProperty("nativeimage.handlerMetadataArtifactId");
        Set<Class<? extends ChannelHandler>> subtypes = ChannelHandlerMetadataUtil.findChannelHandlerSubclasses(packageNames);
        if (Arrays.asList(packageNames).contains("io.netty.channel")) {
            subtypes.add(ChannelHandler.class);
        }
        HashSet<HandlerMetadata> handlerMetadata = new HashSet<HandlerMetadata>();
        for (Class<? extends ChannelHandler> subtype : subtypes) {
            handlerMetadata.add(new HandlerMetadata(subtype.getName(), new Condition(subtype.getName()), true));
        }
        String projectRelativeResourcePath = "src/main/resources/META-INF/native-image/" + projectGroupId + "/" + projectArtifactId + "/generated/handlers/reflect-config.json";
        File existingMetadataFile = new File(projectRelativeResourcePath);
        String existingMetadataPath = existingMetadataFile.getAbsolutePath();
        if (!existingMetadataFile.exists()) {
            if (handlerMetadata.size() == 0) {
                return;
            }
            String message = "Native Image reflection metadata is required for handlers in this project. This metadata was not found under " + existingMetadataPath + "\nPlease create this file with the following content: \n" + ChannelHandlerMetadataUtil.getMetadataJsonString(handlerMetadata) + "\n";
            Assertions.fail((String)message);
        }
        List existingMetadata = null;
        try {
            FileReader reader = new FileReader(existingMetadataFile);
            existingMetadata = (List)gson.fromJson((Reader)reader, HANDLER_METADATA_LIST_TYPE);
        }
        catch (IOException e) {
            Assertions.fail((String)("Failed to open the native-image metadata file at: " + existingMetadataPath), (Throwable)e);
        }
        HashSet<HandlerMetadata> newMetadata = new HashSet<HandlerMetadata>(handlerMetadata);
        newMetadata.removeAll(existingMetadata);
        HashSet<HandlerMetadata> removedMetadata = new HashSet<HandlerMetadata>(existingMetadata);
        removedMetadata.removeAll(handlerMetadata);
        if (!newMetadata.isEmpty() || !removedMetadata.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("In the native-image handler metadata file at ").append(existingMetadataPath).append("\n");
            if (!newMetadata.isEmpty()) {
                builder.append("The following new metadata must be added:\n\n").append(ChannelHandlerMetadataUtil.getMetadataJsonString(newMetadata)).append("\n\n");
            }
            if (!removedMetadata.isEmpty()) {
                builder.append("The following metadata must be removed:\n\n").append(ChannelHandlerMetadataUtil.getMetadataJsonString(removedMetadata)).append("\n\n");
            }
            builder.append("Expected metadata file contents:\n\n").append(ChannelHandlerMetadataUtil.getMetadataJsonString(handlerMetadata)).append("\n");
            Assertions.fail((String)builder.toString());
        }
    }

    private static Set<Class<? extends ChannelHandler>> findChannelHandlerSubclasses(String ... packageNames) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().forPackages(packageNames));
        Set allSubtypes = reflections.getSubTypesOf(ChannelHandler.class);
        HashSet<Class<? extends ChannelHandler>> targetSubtypes = new HashSet<Class<? extends ChannelHandler>>();
        for (Class subtype : allSubtypes) {
            if (ChannelHandlerMetadataUtil.isTestClass(subtype)) continue;
            String className = subtype.getName();
            boolean shouldInclude = false;
            for (String packageName : packageNames) {
                if (!className.startsWith(packageName)) continue;
                shouldInclude = true;
                break;
            }
            if (!shouldInclude) continue;
            targetSubtypes.add(subtype);
        }
        return targetSubtypes;
    }

    private static boolean isTestClass(Class<? extends ChannelHandler> clazz) {
        URL classFile;
        String[] parts = clazz.getName().split("\\.");
        if (parts.length > 0 && (classFile = clazz.getResource(parts[parts.length - 1] + ".class")) != null) {
            return classFile.toString().contains("/test-classes/");
        }
        return false;
    }

    private static String getMetadataJsonString(Set<HandlerMetadata> metadata) {
        ArrayList<HandlerMetadata> metadataList = new ArrayList<HandlerMetadata>(metadata);
        Collections.sort(metadataList, new Comparator<HandlerMetadata>(){

            @Override
            public int compare(HandlerMetadata h1, HandlerMetadata h2) {
                return Collator.getInstance().compare(h1.name, h2.name);
            }
        });
        return gson.toJson(metadataList, HANDLER_METADATA_LIST_TYPE);
    }

    private static final class HandlerMetadata {
        final String name;
        final Condition condition;
        final boolean queryAllPublicMethods;

        HandlerMetadata(String name, Condition condition, boolean queryAllPublicMethods) {
            this.name = name;
            this.condition = condition;
            this.queryAllPublicMethods = queryAllPublicMethods;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HandlerMetadata that = (HandlerMetadata)o;
            return this.queryAllPublicMethods == that.queryAllPublicMethods && this.name != null && this.name.equals(that.name) && this.condition != null && this.condition.equals(that.condition);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static final class Condition {
        final String typeReachable;

        Condition(String typeReachable) {
            this.typeReachable = typeReachable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Condition condition = (Condition)o;
            return this.typeReachable != null && this.typeReachable.equals(condition.typeReachable);
        }

        public int hashCode() {
            return this.typeReachable.hashCode();
        }
    }
}

