/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.DefaultMaxMessagesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.embedded.EmbeddedChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultMaxMessagesRecvByteBufAllocatorTest {
    private DefaultMaxMessagesRecvByteBufAllocator newAllocator(boolean ignoreReadBytes) {
        return new DefaultMaxMessagesRecvByteBufAllocator(2, ignoreReadBytes){

            public RecvByteBufAllocator.Handle newHandle() {
                return new DefaultMaxMessagesRecvByteBufAllocator.MaxMessageHandle(){

                    public int guess() {
                        return 0;
                    }
                };
            }
        };
    }

    @Test
    public void testRespectReadBytes() {
        DefaultMaxMessagesRecvByteBufAllocator allocator = this.newAllocator(false);
        RecvByteBufAllocator.Handle handle = allocator.newHandle();
        EmbeddedChannel channel = new EmbeddedChannel();
        handle.reset(channel.config());
        handle.incMessagesRead(1);
        Assertions.assertFalse((boolean)handle.continueReading());
        handle.reset(channel.config());
        handle.incMessagesRead(1);
        handle.attemptedBytesRead(1);
        handle.lastBytesRead(1);
        Assertions.assertTrue((boolean)handle.continueReading());
        channel.finish();
    }

    @Test
    public void testIgnoreReadBytes() {
        DefaultMaxMessagesRecvByteBufAllocator allocator = this.newAllocator(true);
        RecvByteBufAllocator.Handle handle = allocator.newHandle();
        EmbeddedChannel channel = new EmbeddedChannel();
        handle.reset(channel.config());
        handle.incMessagesRead(1);
        Assertions.assertTrue((boolean)handle.continueReading());
        handle.incMessagesRead(1);
        Assertions.assertFalse((boolean)handle.continueReading());
        handle.reset(channel.config());
        handle.attemptedBytesRead(0);
        handle.lastBytesRead(0);
        Assertions.assertTrue((boolean)handle.continueReading());
        channel.finish();
    }
}

