/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.encryption;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.encryption.AuditCrypto;
import com.ibm.ws.security.audit.source.utils.ByteArray;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuditKeyEncryptor {
    byte[] password;
    byte[] desKey;
    AuditCrypto des;
    static final long serialVersionUID = 456406585203529128L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public AuditKeyEncryptor(byte[] password) {
        this.password = password;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
            this.desKey = new byte[24];
            byte[] digest = md.digest(this.password);
            ByteArray.copy(digest, 0, digest.length, this.desKey, 0);
            this.desKey[20] = 0;
            this.desKey[21] = 0;
            this.desKey[22] = 0;
            this.desKey[23] = 0;
        }
        catch (NoSuchAlgorithmException digest) {
            void e;
            FFDCFilter.processException((Throwable)digest, (String)"com.ibm.ws.security.audit.encryption.AuditKeyEncryptor", (String)"37", (Object)this, (Object[])new Object[]{password});
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.ltpa.KeyEncryptor.KeyEncryptor", (String)"21", (Object)this);
        }
        this.des = new AuditCrypto();
    }

    public byte[] decrypt(byte[] encrKey) {
        return AuditCrypto.decrypt(encrKey, this.desKey);
    }

    public byte[] encrypt(byte[] key) {
        return AuditCrypto.encrypt(key, this.desKey);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.audit.encryption.AuditKeyEncryptor", AuditKeyEncryptor.class, (String)"audit", (String)"com.ibm.ws.security.audit.source.internal.resources.AuditMessages");
    }
}

