/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.acme.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.acme.AcmeCertificate;
import com.ibm.ws.security.acme.internal.AcmeHistoryEntry;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.StringTokenizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AcmeHistory {
    private static final TraceComponent tc = Tr.register(AcmeHistory.class, (String)"ACMECA", (String)"com.ibm.ws.security.acme.resources.AcmeMessages");
    private String spaceDelim = "                  ";
    private final String acmeFileName = "acmeca/acmeca-history.txt";
    private final int FILE_EXISTS = 0;
    private final int FILE_CREATED = 1;
    private final int FILE_NOT_CREATED = 2;
    private File acmeFile;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("uuuuMMddHHmmss").withZone(ZoneId.systemDefault());
    private ArrayList<String> headers;
    static final long serialVersionUID = 4747263653648385673L;

    /*
     * WARNING - void declaration
     */
    protected boolean directoryURIChanged(String currentDirectoryURI, WsLocationAdmin wslocation, boolean disableRenewOnNewHistory) {
        int acmefilecreation = this.createAcmeFile(wslocation);
        if (acmefilecreation == 1 && disableRenewOnNewHistory) {
            return false;
        }
        if (acmefilecreation > 0) {
            return true;
        }
        File file = wslocation.getServerWorkareaResource("acmeca/acmeca-history.txt").asFile();
        String fileDirURI = currentDirectoryURI;
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            String lastLine = null;
            while ((line = br.readLine()) != null && !line.isEmpty()) {
                lastLine = line;
            }
            br.close();
            if (lastLine != null && !lastLine.isEmpty()) {
                StringTokenizer tok = new StringTokenizer(lastLine);
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    fileDirURI = tok.nextToken();
                }
            }
        }
        catch (Exception br) {
            void e;
            FFDCFilter.processException((Throwable)br, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"86", (Object)this, (Object[])new Object[]{currentDirectoryURI, wslocation, disableRenewOnNewHistory});
            Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
            return true;
        }
        return !currentDirectoryURI.equals(fileDirURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int createAcmeFile(WsLocationAdmin wslocation) {
        this.acmeFile = wslocation.getServerWorkareaResource("acmeca/acmeca-history.txt").asFile();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Acme history filed prepped from workarea " + this.acmeFile.getAbsolutePath()), (Object[])new Object[0]);
        }
        if (this.acmeFile.exists()) {
            return 0;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Acme history does not exist, write initial entry", (Object[])new Object[0]);
        }
        this.headers = new ArrayList();
        this.acmeFile.getParentFile().mkdirs();
        LocalDateTime now = LocalDateTime.now();
        String date = FORMATTER.format(now);
        this.headers.add("# WARNING!!! DO NOT MODIFY THIS FILE. IT HAS BEEN AUTO-GENERATED: " + date);
        this.headers.add("# Version 1.0");
        this.headers.add("# Date" + this.spaceDelim + "Serial" + this.spaceDelim + "DirectoryURI" + this.spaceDelim + "Account URI" + this.spaceDelim + "Expiration");
        this.headers.add("# -------------------------------------------------------------------------------------------------------------------------");
        OutputStreamWriter fr = null;
        this.acmeFile.createNewFile();
        fr = new FileWriter(this.acmeFile, false);
        for (String h : this.headers) {
            fr.write(h + "\n");
        }
        fr.close();
        int n = 1;
        if (fr == null) return n;
        try {
            fr.close();
            return n;
        }
        catch (IOException h) {
            void e;
            FFDCFilter.processException((Throwable)h, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"146", (Object)this, (Object[])new Object[]{wslocation});
            Tr.event((TraceComponent)tc, (String)"Stack trace of IOException while closing", (Object[])new Object[]{e});
            Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{this.acmeFile.getAbsolutePath(), e.getMessage()});
        }
        return n;
        catch (IOException iOException) {
            try {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"139", (Object)this, (Object[])new Object[]{wslocation});
                Tr.event((TraceComponent)tc, (String)"Stack trace of IOException", (Object[])new Object[]{e});
                Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{this.acmeFile.getAbsolutePath(), e.getMessage()});
                if (fr == null) return 2;
            }
            catch (Throwable throwable) {
                if (fr == null) throw throwable;
                try {
                    fr.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"146", (Object)this, (Object[])new Object[]{wslocation});
                    Tr.event((TraceComponent)tc, (String)"Stack trace of IOException while closing", (Object[])new Object[]{e});
                    Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{this.acmeFile.getAbsolutePath(), e.getMessage()});
                }
                throw throwable;
            }
            try {
                fr.close();
                return 2;
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"146", (Object)this, (Object[])new Object[]{wslocation});
                Tr.event((TraceComponent)tc, (String)"Stack trace of IOException while closing", (Object[])new Object[]{e});
                Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{this.acmeFile.getAbsolutePath(), e.getMessage()});
            }
            return 2;
        }
    }

    protected void updateAcmeFile(X509Certificate certificate, String directoryURI, String accountURI, WsLocationAdmin wslocation) {
        this.updateAcmeFile(null, certificate, directoryURI, accountURI, wslocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateAcmeFile(AcmeCertificate acmeCertificate, X509Certificate certificate, String directoryURI, String accountURI, WsLocationAdmin wslocation) {
        if (this.createAcmeFile(wslocation) == 2) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        String date = FORMATTER.format(now);
        String serial = null;
        String expirationDate = null;
        X509Certificate cert = certificate;
        if (acmeCertificate != null) {
            cert = acmeCertificate.getCertificate();
        }
        serial = cert.getSerialNumber().toString(16);
        expirationDate = FORMATTER.format(cert.getNotAfter().toInstant());
        ArrayList<AcmeHistoryEntry> acmeHistoryEntries = this.getAcmeHistoryEntries(this.acmeFile);
        if (acmeHistoryEntries == null) {
            acmeHistoryEntries = new ArrayList();
        }
        AcmeHistoryEntry newEntry = new AcmeHistoryEntry(date, serial, directoryURI, accountURI, expirationDate);
        acmeHistoryEntries.add(newEntry);
        boolean rewriteFile = false;
        if (acmeHistoryEntries.size() > 10) {
            rewriteFile = true;
            acmeHistoryEntries.remove(0);
        }
        File file = wslocation.getServerWorkareaResource("acmeca/acmeca-history.txt").asFile();
        OutputStreamWriter fr = null;
        if (rewriteFile) {
            fr = new FileWriter(file, false);
            for (String h : this.headers) {
                fr.write(h);
                fr.write("\n");
            }
            for (AcmeHistoryEntry entry : acmeHistoryEntries) {
                fr.write(entry.toString());
                fr.write("\n");
            }
        } else {
            fr = new FileWriter(file, true);
            fr.write(newEntry.toString() + "\n");
        }
        if (fr == null) return;
        try {
            fr.close();
            return;
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"226", (Object)this, (Object[])new Object[]{acmeCertificate, certificate, directoryURI, accountURI, wslocation});
            Tr.event((TraceComponent)tc, (String)"Stack trace of IOException while closing", (Object[])new Object[]{e});
            Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{this.acmeFile.getAbsolutePath(), e.getMessage()});
        }
        return;
        catch (IOException e) {
            try {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"220", (Object)this, (Object[])new Object[]{acmeCertificate, certificate, directoryURI, accountURI, wslocation});
                Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
                if (fr == null) return;
            }
            catch (Throwable throwable) {
                if (fr == null) throw throwable;
                try {
                    fr.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    void e2;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"226", (Object)this, (Object[])new Object[]{acmeCertificate, certificate, directoryURI, accountURI, wslocation});
                    Tr.event((TraceComponent)tc, (String)"Stack trace of IOException while closing", (Object[])new Object[]{e2});
                    Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{this.acmeFile.getAbsolutePath(), e2.getMessage()});
                }
                throw throwable;
            }
            try {
                fr.close();
                return;
            }
            catch (IOException e3) {
                FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"226", (Object)this, (Object[])new Object[]{acmeCertificate, certificate, directoryURI, accountURI, wslocation});
                Tr.event((TraceComponent)tc, (String)"Stack trace of IOException while closing", (Object[])new Object[]{e3});
                Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{this.acmeFile.getAbsolutePath(), e3.getMessage()});
            }
            return;
        }
    }

    public ArrayList<String> getDirectoryURIHistory(File file) {
        ArrayList<String> entries = new ArrayList<String>();
        ArrayList<AcmeHistoryEntry> acmeentries = this.getAcmeHistoryEntries(file);
        for (AcmeHistoryEntry e : acmeentries) {
            entries.add(e.getDirectoryURI());
        }
        return entries;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayList<AcmeHistoryEntry> getAcmeHistoryEntries(File file) {
        ArrayList<AcmeHistoryEntry> entries = new ArrayList<AcmeHistoryEntry>();
        if (!file.exists()) {
            return entries;
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null && !line.isEmpty() && line.startsWith("#")) {
            }
            if (line == null) {
                br.close();
                return entries;
            }
            do {
                String date = null;
                String serial = null;
                String directoryURI = null;
                String accountURI = null;
                String expiration = null;
                StringTokenizer tok = new StringTokenizer(line);
                if (tok.hasMoreTokens()) {
                    date = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    serial = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    directoryURI = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    accountURI = tok.nextToken();
                }
                if (tok.hasMoreTokens()) {
                    expiration = tok.nextToken();
                }
                entries.add(new AcmeHistoryEntry(date, serial, directoryURI, accountURI, expiration));
            } while ((line = br.readLine()) != null && !line.isEmpty());
            br.close();
        }
        catch (Exception br) {
            void e;
            FFDCFilter.processException((Throwable)br, (String)"com.ibm.ws.security.acme.internal.AcmeHistory", (String)"292", (Object)this, (Object[])new Object[]{file});
            Tr.error((TraceComponent)tc, (String)"CWPKI2072W", (Object[])new Object[]{file.getAbsolutePath(), e.getMessage()});
            return null;
        }
        return entries;
    }

    public String getDirectoryURI(String serial) {
        ArrayList<AcmeHistoryEntry> entries = this.getAcmeHistoryEntries(this.acmeFile);
        if (entries == null) {
            return null;
        }
        for (AcmeHistoryEntry entry : entries) {
            if (!serial.equals(entry.getSerial())) continue;
            return entry.getDirectoryURI();
        }
        return null;
    }
}

