/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.objectstore.LogInstance;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

class LogInstance {
    private Uid _logName;
    private String _typeName;
    private boolean _frozen;
    private Stack<TransactionData> _transactions = new Stack();
    private HashMap<Uid, Uid> _ids = new HashMap();
    private long _used = 0L;
    private long _totalSize;

    public LogInstance(String tn, long size) {
        this._logName = new Uid();
        this._typeName = tn;
        this._frozen = false;
        this._totalSize = size;
    }

    public final boolean isFrozen() {
        return this._frozen;
    }

    public final void freeze() {
        this._frozen = true;
    }

    public final int numberOfUsers() {
        return this._transactions.size();
    }

    public final Uid getName() {
        return this._logName;
    }

    public final String getTypeName() {
        return this._typeName;
    }

    public final InputObjectState allObjUids() throws ObjectStoreException {
        OutputObjectState state = new OutputObjectState();
        Iterator iter = this._ids.keySet().iterator();
        try {
            while (iter.hasNext()) {
                UidHelper.packInto((Uid)((Uid)iter.next()), (OutputBuffer)state);
            }
            UidHelper.packInto((Uid)Uid.nullUid(), (OutputBuffer)state);
        }
        catch (IOException ex) {
            throw new ObjectStoreException((Throwable)ex);
        }
        return new InputObjectState(state);
    }

    public final boolean present(Uid id) {
        return this._ids.containsKey(id);
    }

    public final TransactionData getTxId(Uid txId) {
        return new TransactionData(this, txId, this._used, this);
    }

    public final TransactionData addTxId(Uid txId, long size) {
        TransactionData td = new TransactionData(this, txId, this._used, this);
        this._transactions.add(td);
        this._ids.put(txId, txId);
        this._used += size;
        return td;
    }

    public final long remaining() {
        return this._totalSize - this._used;
    }

    public final void resize(long size) {
        this._totalSize = size;
    }

    public String toString() {
        return "LogInstance < " + this._logName + ", " + this._typeName + ", " + this.numberOfUsers() + ", " + this.remaining() + " >";
    }
}

