/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.api;

import io.narayana.lra.Current;
import io.narayana.lra.RequestBuilder;
import io.narayana.lra.ResponseHolder;
import io.narayana.lra.coordinator.api.Coordinator;
import io.narayana.lra.coordinator.domain.model.LRAData;
import io.narayana.lra.coordinator.domain.model.LRAStatusHolder;
import io.narayana.lra.coordinator.domain.model.Transaction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.logging.LRALogger;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.headers.Header;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;

/*
 * Exception performing whole class analysis ignored.
 */
@ApplicationScoped
@Path(value="lra-coordinator")
@Tag(name="LRA Coordinator")
public class Coordinator {
    @Context
    private UriInfo context;
    @Inject
    LRAService lraService;

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @Operation(summary="Returns all LRAs", description="Gets both active and recovering LRAs")
    @APIResponse(description="The LRA", content={@Content(schema=@Schema(type=SchemaType.ARRAY, implementation=LRAData.class))})
    public List<LRAData> getAllLRAs(@Parameter(name="Status", description="Filter the returned LRAs to only those in the give state (see CompensatorStatus)") @QueryParam(value="Status") @DefaultValue(value="") String state) {
        List lras = this.lraService.getAll(state);
        if (lras == null) {
            LRALogger.i18NLogger.error_invalidQueryForGettingLraStatuses(state);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Invalid query '%s' to get LRAs", state)).build());
        }
        return lras.stream().map(Coordinator::convert).collect(Collectors.toList());
    }

    private static LRAData convert(LRAStatusHolder lra) {
        return new LRAData(lra.getLraId(), lra.getClientId(), lra.getStatus().name(), lra.isClosed(), lra.isCancelled(), lra.isRecovering(), lra.isActive(), lra.isTopLevel(), lra.getStartTime(), lra.getFinishTime());
    }

    @GET
    @Path(value="{LraId}/status")
    @Produces(value={"text/plain"})
    @Operation(summary="Obtain the status of an LRA as a string")
    @Schema(implementation=String.class)
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA"), @APIResponse(responseCode="204", description="The LRA exists and has not yet been asked to close or cancel"), @APIResponse(responseCode="200", description="The LRA exists. The status is reported in the content body.")})
    public Response getLRAStatus(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId) throws NotFoundException {
        Transaction transaction = this.lraService.getTransaction(this.toURI(lraId));
        LRAStatus status = transaction.getLRAStatus();
        if (status == null) {
            status = LRAStatus.Active;
        }
        return Response.ok((Object)status.name()).build();
    }

    @GET
    @Path(value="{LraId}")
    @Produces(value={"application/json"})
    @Operation(summary="Obtain the status of an LRA as a JSON structure")
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA", content={@Content(schema=@Schema(implementation=LRAData.class))}), @APIResponse(responseCode="204", description="The LRA exists and has not yet been asked to close or cancel", content={@Content(schema=@Schema(implementation=LRAData.class))}), @APIResponse(responseCode="200", description="The LRA exists. The status is reported in the content body.", content={@Content(schema=@Schema(implementation=LRAData.class))})})
    public LRAData getLRAInfo(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId) throws NotFoundException {
        return this.lraService.getLRA(this.toURI(lraId));
    }

    @POST
    @Path(value="start")
    @Produces(value={"text/plain"})
    @Operation(summary="Start a new LRA", description="The LRA model uses a presumed nothing protocol: the coordinator must communicate\nwith Compensators in order to inform them of the LRA activity. Every time a\nCompensator is enrolled with a LRA, the coordinator must make information about\nit durable so that the Compensator can be contacted when the LRA terminates,\neven in the event of subsequent failures. Compensators, clients and coordinators\ncannot make any presumption about the state of the global transaction without\nconsulting the coordinator and all compensators, respectively.")
    @APIResponses(value={@APIResponse(responseCode="201", description="The request was successful and the response body contains the id of the new LRA", content={@Content(schema=@Schema(title="An LRA id", description="An URI of the new LRA"))}), @APIResponse(responseCode="500", description="A new LRA could not be started")})
    public Response startLRA(@Parameter(name="ClientID", description="Each client is expected to have a unique identity (which can be a URL).", required=true) @QueryParam(value="ClientID") @DefaultValue(value="") String clientId, @Parameter(name="TimeLimit", description="Specifies the maximum time in milli seconds that the LRA will exist for.\nIf the LRA is terminated because of a timeout, the LRA URL is deleted.\nAll further invocations on the URL will return 404.\nThe invoker can assume this was equivalent to a compensate operation.") @QueryParam(value="TimeLimit") @DefaultValue(value="0") Long timelimit, @Parameter(name="ParentLRA", description="The enclosing LRA if this new LRA is nested") @QueryParam(value="ParentLRA") @DefaultValue(value="") String parentLRA, @HeaderParam(value="Long-Running-Action") String parentId) throws WebApplicationException {
        URI parentLRAUrl = null;
        if (parentLRA != null && !parentLRA.isEmpty()) {
            parentLRAUrl = this.toDecodedURI(parentLRA);
        }
        String coordinatorUrl = String.format("%s%s", this.context.getBaseUri(), "lra-coordinator");
        URI lraId = this.lraService.startLRA(coordinatorUrl, parentLRAUrl, clientId, timelimit);
        if (parentLRAUrl != null) {
            String compensatorUrl = String.format("%s/nested/%s", coordinatorUrl, lraId.getPath().substring(lraId.getPath().lastIndexOf(47)));
            if (this.lraService.hasTransaction(parentLRAUrl)) {
                Response response = this.joinLRAViaBody(parentLRAUrl.toASCIIString(), timelimit.longValue(), null, compensatorUrl);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    return Response.status((int)response.getStatus()).build();
                }
            } else {
                ResponseHolder resp = new RequestBuilder(parentLRAUrl).request().async(2L, TimeUnit.SECONDS).put(compensatorUrl, "text/plain");
                if (resp.getStatus() != Response.Status.OK.getStatusCode()) {
                    return Response.status((int)resp.getStatus()).build();
                }
            }
        }
        Current.push((URI)lraId);
        return Response.created((URI)lraId).entity((Object)lraId).header("Long-Running-Action", (Object)Current.getContexts()).build();
    }

    @PUT
    @Path(value="{LraId}/renew")
    @Operation(summary="Update the TimeLimit for an existing LRA", description="LRAs can be automatically cancelled if they aren't closed or cancelled before the TimeLimit\nspecified at creation time is reached.\nThe time limit can be updated.\n")
    @APIResponses(value={@APIResponse(responseCode="200", description="If the LRA timelimit has been updated"), @APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA"), @APIResponse(responseCode="412", description="The LRA is not longer active (ie the complete or compensate messages have been sent")})
    public Response renewTimeLimit(@Parameter(name="TimeLimit", description="The new time limit for the LRA", required=true) @QueryParam(value="TimeLimit") @DefaultValue(value="0") Long timelimit, @PathParam(value="LraId") String lraId) throws NotFoundException {
        return Response.status((int)this.lraService.renewTimeLimit(this.toURI(lraId), timelimit)).build();
    }

    @GET
    @Path(value="nested/{NestedLraId}/status")
    public Response getNestedLRAStatus(@PathParam(value="NestedLraId") String nestedLraId) {
        if (!this.lraService.hasTransaction(nestedLraId)) {
            return Response.ok((Object)ParticipantStatus.Compensated.name()).build();
        }
        Transaction lra = this.lraService.getTransaction(this.toURI(nestedLraId));
        LRAStatus status = lra.getLRAStatus();
        if (status == null || lra.getLRAStatus() == null) {
            LRALogger.i18NLogger.error_cannotGetStatusOfNestedLraURI(nestedLraId, lra.getId());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("LRA is in the wrong state for operation '%s': %s", "getNestedLRAStatus", "The LRA is still  active")).build());
        }
        return Response.ok((Object)this.mapToParticipantStatus(lra.getLRAStatus()).name()).build();
    }

    private ParticipantStatus mapToParticipantStatus(LRAStatus lraStatus) {
        switch (1.$SwitchMap$org$eclipse$microprofile$lra$annotation$LRAStatus[lraStatus.ordinal()]) {
            case 1: {
                return ParticipantStatus.Active;
            }
            case 2: {
                return ParticipantStatus.Completed;
            }
            case 3: {
                return ParticipantStatus.Compensated;
            }
            case 4: {
                return ParticipantStatus.Completing;
            }
            case 5: {
                return ParticipantStatus.Compensating;
            }
            case 6: {
                return ParticipantStatus.FailedToComplete;
            }
            case 7: {
                return ParticipantStatus.FailedToCompensate;
            }
        }
        return null;
    }

    @PUT
    @Path(value="nested/{NestedLraId}/complete")
    public Response completeNestedLRA(@PathParam(value="NestedLraId") String nestedLraId) {
        return Response.ok((Object)this.mapToParticipantStatus(this.endLRA(this.toURI(nestedLraId), false, true)).name()).build();
    }

    @PUT
    @Path(value="nested/{NestedLraId}/compensate")
    public Response compensateNestedLRA(@PathParam(value="NestedLraId") String nestedLraId) {
        return Response.ok((Object)this.mapToParticipantStatus(this.endLRA(this.toURI(nestedLraId), true, true)).name()).build();
    }

    @PUT
    @Path(value="nested/{NestedLraId}/forget")
    public Response forgetNestedLRA(@PathParam(value="NestedLraId") String nestedLraId) {
        this.lraService.remove(this.toURI(nestedLraId));
        return Response.ok().build();
    }

    @PUT
    @Path(value="{LraId}/close")
    @Produces(value={"text/plain"})
    @Operation(summary="Attempt to close an LRA", description="Trigger the successful completion of the LRA. All compensators will be dropped by the coordinator. The complete message will be sent to the compensators. Upon termination, the URL is implicitly deleted. The invoker cannot know for sure whether the lra completed or compensated without enlisting a participant.")
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA"), @APIResponse(responseCode="200", description="The complete message was sent to all coordinators", content={@Content(schema=@Schema(title="one of the LRAStatus enum values", implementation=String.class))})})
    public Response closeLRA(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String txId) throws NotFoundException {
        return Response.ok((Object)this.endLRA(this.toURI(txId), false, false).name()).build();
    }

    @PUT
    @Path(value="{LraId}/cancel")
    @Produces(value={"application/json"})
    @Operation(summary="Attempt to cancel an LRA", description=" Trigger the compensation of the LRA. All compensators will be triggered by the coordinator (ie the compensate message will be sent to each compensators). Upon termination, the URL is implicitly deleted. The invoker cannot know for sure whether the lra completed or compensated without enlisting a participant.")
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA"), @APIResponse(responseCode="200", description="The compensate message was sent to all coordinators", content={@Content(schema=@Schema(title="one of the LRAStatus enum values", implementation=String.class))})})
    public Response cancelLRA(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId) throws NotFoundException {
        return Response.ok((Object)this.endLRA(this.toURI(lraId), true, false).name()).build();
    }

    private LRAStatus endLRA(URI lraId, boolean compensate, boolean fromHierarchy) throws NotFoundException {
        LRAStatusHolder status = this.lraService.endLRA(lraId, compensate, fromHierarchy);
        return status.getStatus();
    }

    @PUT
    @Path(value="{LraId}")
    @Produces(value={"application/json"})
    @Operation(summary="A Compensator can join with the LRA at any time prior to the completion of an activity")
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA"), @APIResponse(responseCode="412", description="The LRA is not longer active (ie in the complete or compensate messages have been sent"), @APIResponse(responseCode="200", description="The participant was successfully registered with the LRA and the response body contains a unique resource reference for that participant:\n - HTTP GET on the reference returns the original participant URL;\n - HTTP PUT on the reference will overwrite the old participant URL with the new one supplied.", headers={@Header(name="Long-Running-Action-Recovery", description="If the participant is successfully registered with the LRA then this header\n will contain a unique resource reference for that participant:\n - HTTP GET on the reference returns the original participant URL;\n - HTTP PUT on the reference will overwrite the old participant URL with the new one supplied.", schema=@Schema(implementation=String.class))}, content={@Content(schema=@Schema(title="A new LRA recovery id", description="An URI representing the recovery id of this join request"))})})
    public Response joinLRAViaBody(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId, @Parameter(name="TimeLimit", description="The time limit (in seconds) that the Compensator can guarantee that it can compensate the work performed by the service. After this time period has elapsed, it may no longer be possible to undo the work within the scope of this (or any enclosing) LRA. It may therefore be necessary for the application or service to start other activities to explicitly try to compensate this work. The application or coordinator may use this information to control the lifecycle of a LRA.") @QueryParam(value="TimeLimit") @DefaultValue(value="0") long timeLimit, @Parameter(name="Link", description="The resource paths that the coordinator will use to complete or compensate and to request the status of the participant. The link rel names are complete, compensate and status.") @HeaderParam(value="Link") @DefaultValue(value="") String compensatorLink, @RequestBody(name="Compensator data", description="opaque data that will be stored with the coordinator and passed back to\nthe participant when the LRA is closed or cancelled.\n") String compensatorData) throws NotFoundException {
        boolean isLink = this.isLink(compensatorData);
        if (compensatorLink != null && !compensatorLink.isEmpty()) {
            return this.joinLRA(this.toURI(lraId), timeLimit, null, compensatorLink, compensatorData);
        }
        if (!isLink) {
            compensatorData = compensatorData + "/";
            HashMap<String, String> terminateURIs = new HashMap<String, String>();
            try {
                terminateURIs.put("compensate", new URL(compensatorData + "compensate").toExternalForm());
                terminateURIs.put("complete", new URL(compensatorData + "complete").toExternalForm());
                terminateURIs.put("status", new URL(compensatorData + "status").toExternalForm());
            }
            catch (MalformedURLException e) {
                if (LRALogger.logger.isTraceEnabled()) {
                    LRALogger.logger.tracef((Throwable)e, "Cannot join to LRA id '%s' with body as compensator url '%s' is invalid", (Object)lraId, (Object)compensatorData);
                }
                return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
            }
            StringBuilder linkHeaderValue = new StringBuilder();
            terminateURIs.forEach((k, v) -> Coordinator.makeLink((StringBuilder)linkHeaderValue, (String)"", (String)k, (String)v));
            compensatorData = linkHeaderValue.toString();
        }
        return this.joinLRA(this.toURI(lraId), timeLimit, null, compensatorData, null);
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private boolean isLink(String linkString) {
        try {
            Link.valueOf((String)linkString);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Response joinLRA(URI lraId, long timeLimit, String compensatorUrl, String linkHeader, String userData) throws NotFoundException {
        String recoveryUrlBase = String.format("http://%s/%s/", this.context.getRequestUri().getAuthority(), "lra-recovery-coordinator");
        StringBuilder recoveryUrl = new StringBuilder();
        int status = this.lraService.joinLRA(recoveryUrl, lraId, timeLimit, compensatorUrl, linkHeader, recoveryUrlBase, userData);
        try {
            return Response.status((int)status).entity((Object)recoveryUrl.toString()).location(new URI(recoveryUrl.toString())).header("Long-Running-Action-Recovery", (Object)recoveryUrl).build();
        }
        catch (URISyntaxException e) {
            LRALogger.i18NLogger.error_invalidRecoveryUrlToJoinLRAURI(recoveryUrl.toString(), lraId);
            throw new WebApplicationException("Invalid recovery URL", (Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="{LraId}/remove")
    @Produces(value={"application/json"})
    @Operation(summary="A Compensator can resign from the LRA at any time prior to the completion of an activity")
    @APIResponses(value={@APIResponse(responseCode="404", description="The coordinator has no knowledge of this LRA"), @APIResponse(responseCode="412", description="The LRA is not longer active (ie in the complete or compensate messages have been sent"), @APIResponse(responseCode="200", description="If the participant was successfully removed from the LRA")})
    public Response leaveLRA(@Parameter(name="LraId", description="The unique identifier of the LRA", required=true) @PathParam(value="LraId") String lraId, String compensatorUrl) throws NotFoundException, URISyntaxException {
        String reqUri = this.context.getRequestUri().toString();
        reqUri = reqUri.substring(0, reqUri.lastIndexOf(47));
        int status = 0;
        status = this.lraService.leave(new URI(reqUri), compensatorUrl);
        return Response.status((int)status).build();
    }

    private URI toURI(String lraId) {
        return this.toURI(lraId, "Invalid LRA id format");
    }

    private URI toDecodedURI(String lraId) {
        try {
            return this.toURI(URLDecoder.decode(lraId, StandardCharsets.UTF_8.toString()));
        }
        catch (UnsupportedEncodingException e) {
            LRALogger.i18NLogger.error_invalidStringFormatOfUrl(lraId, (Throwable)e);
            throw new WebApplicationException("Invalid LRA id format", (Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    private URI toURI(String lraId, String message) {
        URL url;
        try {
            url = new URL(lraId);
            url.toURI();
        }
        catch (Exception e) {
            try {
                url = new URL(String.format("%s%s/%s", this.context.getBaseUri(), "lra-coordinator", lraId));
            }
            catch (MalformedURLException e1) {
                LRALogger.i18NLogger.error_invalidStringFormatOfUrl(lraId, (Throwable)e1);
                throw new WebApplicationException(message, (Throwable)e1, Response.Status.BAD_REQUEST);
            }
        }
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            LRALogger.i18NLogger.error_invalidStringFormatOfUrl(lraId, (Throwable)e);
            throw new WebApplicationException(message, (Throwable)e, Response.Status.BAD_REQUEST);
        }
    }
}

