/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.service;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import io.narayana.lra.coordinator.domain.model.LRAData;
import io.narayana.lra.coordinator.domain.model.LRARecord;
import io.narayana.lra.coordinator.domain.model.LRAStatusHolder;
import io.narayana.lra.coordinator.domain.model.Transaction;
import io.narayana.lra.coordinator.internal.Implementations;
import io.narayana.lra.coordinator.internal.LRARecoveryModule;
import io.narayana.lra.logging.LRALogger;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

@ApplicationScoped
public class LRAService {
    private Map<URI, Transaction> lras = new ConcurrentHashMap();
    private Map<URI, Transaction> recoveringLRAs = new ConcurrentHashMap();
    private Map<URI, ReentrantLock> locks = new ConcurrentHashMap();
    private Map<String, String> participants = new ConcurrentHashMap();
    private LRARecoveryModule lraRecoveryModule;

    public Transaction getTransaction(URI lraId) throws NotFoundException {
        if (!this.lras.containsKey(lraId)) {
            String uid = this.getUid(lraId);
            for (Transaction lra : this.lras.values()) {
                if (!uid.equals(lra.getUid())) continue;
                return lra;
            }
            if (!this.recoveringLRAs.containsKey(lraId)) {
                for (Transaction lra : this.recoveringLRAs.values()) {
                    if (!uid.equals(lra.getUid())) continue;
                    return lra;
                }
                throw new NotFoundException(Response.status((int)404).entity((Object)("Invalid transaction id: " + lraId)).build());
            }
            return (Transaction)this.recoveringLRAs.get(lraId);
        }
        return (Transaction)this.lras.get(lraId);
    }

    private String getUid(URI lraId) {
        String path = lraId.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public LRAData getLRA(URI lraId) {
        Transaction lra = this.getTransaction(lraId);
        return lra.getLRAData();
    }

    public synchronized ReentrantLock lockTransaction(URI lraId) {
        ReentrantLock lock = this.locks.computeIfAbsent(lraId, k -> new ReentrantLock());
        lock.lock();
        return lock;
    }

    public synchronized ReentrantLock tryLockTransaction(URI lraId) {
        ReentrantLock lock = this.locks.computeIfAbsent(lraId, k -> new ReentrantLock());
        return lock.tryLock() ? lock : null;
    }

    public List<LRAStatusHolder> getAll(String state) {
        if (state == null || state.isEmpty()) {
            Set all = this.getAllActive();
            all.addAll(this.getAllRecovering());
            return new ArrayList<LRAStatusHolder>(all);
        }
        if (LRAStatus.Cancelling.name().equals(state)) {
            return this.recoveringLRAs.values().stream().map(LRAStatusHolder::new).filter(LRAStatusHolder::isCancelling).collect(Collectors.toList());
        }
        if (LRAStatus.Cancelled.name().equals(state)) {
            return this.recoveringLRAs.values().stream().map(LRAStatusHolder::new).filter(LRAStatusHolder::isCancelled).collect(Collectors.toList());
        }
        if (LRAStatus.FailedToCancel.name().equals(state)) {
            return this.recoveringLRAs.values().stream().map(LRAStatusHolder::new).filter(LRAStatusHolder::isFailedToCancel).collect(Collectors.toList());
        }
        if (LRAStatus.Closing.name().equals(state)) {
            return this.recoveringLRAs.values().stream().map(LRAStatusHolder::new).filter(LRAStatusHolder::isClosing).collect(Collectors.toList());
        }
        if (LRAStatus.Closed.name().equals(state)) {
            return this.recoveringLRAs.values().stream().map(LRAStatusHolder::new).filter(LRAStatusHolder::isClosed).collect(Collectors.toList());
        }
        if (LRAStatus.FailedToClose.name().equals(state)) {
            return this.recoveringLRAs.values().stream().map(LRAStatusHolder::new).filter(LRAStatusHolder::isFailedToClose).collect(Collectors.toList());
        }
        return null;
    }

    private Set<LRAStatusHolder> getAllActive() {
        return this.lras.values().stream().map(LRAStatusHolder::new).collect(Collectors.toSet());
    }

    public List<LRAStatusHolder> getAllRecovering(boolean scan) {
        if (scan) {
            RecoveryManager.manager().scan();
        }
        return this.recoveringLRAs.values().stream().map(LRAStatusHolder::new).collect(Collectors.toList());
    }

    public List<LRAStatusHolder> getAllRecovering() {
        return this.getAllRecovering(false);
    }

    public void addTransaction(Transaction lra) {
        this.lras.put(lra.getId(), lra);
    }

    public void finished(Transaction transaction, boolean fromHierarchy) {
        if (transaction.isRecovering()) {
            this.recoveringLRAs.put(transaction.getId(), transaction);
        } else if ((fromHierarchy || transaction.isTopLevel()) && !transaction.hasPendingActions()) {
            this.remove(transaction);
        }
    }

    public boolean removeLog(String lraId) {
        String uid = lraId.substring(lraId.lastIndexOf(47) + 1);
        try {
            return this.lraRecoveryModule.removeCommitted(new Uid(uid));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean remove(Transaction lra) {
        if (lra.isFailed()) {
            lra.deactivate();
        }
        return this.remove(lra.getId());
    }

    public boolean remove(URI lraId) {
        this.lraTrace(lraId, "remove LRA");
        if (this.lras.containsKey(lraId)) {
            this.lras.get(lraId);
            this.lras.remove(lraId);
        }
        this.recoveringLRAs.remove(lraId);
        this.locks.remove(lraId);
        return true;
    }

    public void updateRecoveryURI(URI lraId, String compensatorUrl, String recoveryURI, boolean persist) {
        assert (recoveryURI != null);
        assert (compensatorUrl != null);
        this.participants.put(recoveryURI, compensatorUrl);
        if (persist && lraId != null) {
            Transaction transaction = this.getTransaction(lraId);
            transaction.updateRecoveryURI(compensatorUrl, recoveryURI);
        }
    }

    public String getParticipant(String rcvCoordId) {
        return (String)this.participants.get(rcvCoordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized URI startLRA(String baseUri, URI parentLRA, String clientId, Long timelimit) {
        int status;
        Transaction lra;
        try {
            lra = new Transaction(this, baseUri, parentLRA, clientId);
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("Invalid base URI: '%s'", baseUri)).build());
        }
        if (lra.currentLRA() != null && LRALogger.logger.isInfoEnabled()) {
            LRALogger.logger.infof("LRAServicve.startLRA LRA %s is already associated%n", (Object)lra.currentLRA().get_uid().fileStringForm());
        }
        if ((status = lra.begin(timelimit)) != 0) {
            this.lraTrace(lra.getId(), "failed to start LRA");
            lra.abort();
            throw new InternalServerErrorException("Could not start LRA: " + ActionStatus.stringForm((int)status));
        }
        try {
            this.addTransaction(lra);
            this.lraTrace(lra.getId(), "started LRA");
            URI uRI = lra.getId();
            return uRI;
        }
        finally {
            AtomicAction.suspend();
        }
    }

    public LRAStatusHolder endLRA(URI lraId, boolean compensate, boolean fromHierarchy) {
        this.lraTrace(lraId, "end LRA");
        Transaction transaction = this.getTransaction(lraId);
        if (!transaction.isActive().booleanValue() && !transaction.isRecovering() && transaction.isTopLevel()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)String.format("%s: LRA is closing or closed: endLRA", lraId)).build());
        }
        transaction.end(compensate);
        if (transaction.currentLRA() != null && LRALogger.logger.isInfoEnabled()) {
            LRALogger.logger.infof("LRAServicve.endLRA LRA %s ended but is still associated with %s%n", (Object)lraId, (Object)transaction.currentLRA().get_uid().fileStringForm());
        }
        this.finished(transaction, fromHierarchy);
        return new LRAStatusHolder(transaction);
    }

    public int leave(URI lraId, String compensatorUrl) {
        this.lraTrace(lraId, "leave LRA");
        Transaction transaction = this.getTransaction(lraId);
        if (!transaction.isActive().booleanValue()) {
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        try {
            if (!transaction.forgetParticipant(compensatorUrl) && LRALogger.logger.isInfoEnabled()) {
                LRALogger.logger.infof("LRAServicve.forget %s failed%n", (Object)lraId);
            }
            return Response.Status.OK.getStatusCode();
        }
        catch (Exception e) {
            return Response.Status.BAD_REQUEST.getStatusCode();
        }
    }

    public synchronized int joinLRA(StringBuilder recoveryUrl, URI lra, long timeLimit, String compensatorUrl, String linkHeader, String recoveryUrlBase, String compensatorData) {
        LRARecord participant;
        if (lra == null) {
            this.lraTrace(null, "Error missing LRA header in join request");
        } else {
            this.lraTrace(lra, "join LRA");
        }
        Transaction transaction = this.getTransaction(lra);
        if (timeLimit < 0L) {
            timeLimit = 0L;
        }
        if (!transaction.isActive().booleanValue() && !transaction.isRecovering() && linkHeader != null) {
            Pattern linkRelPattern = Pattern.compile("(\\w+)=\"([^\"]+)\"|([^\\s]+)");
            Matcher relMatcher = linkRelPattern.matcher(linkHeader);
            while (relMatcher.find()) {
                String rel;
                String key = relMatcher.group(1);
                if (key == null || !key.equals("rel")) continue;
                String string = rel = relMatcher.group(2) == null ? relMatcher.group(3) : relMatcher.group(2);
                if (!"after".equals(rel)) {
                    return Response.Status.PRECONDITION_FAILED.getStatusCode();
                }
                if (transaction.isRecovering()) continue;
                return Response.Status.PRECONDITION_FAILED.getStatusCode();
            }
        }
        try {
            participant = transaction.enlistParticipant(lra, linkHeader != null ? linkHeader : compensatorUrl, recoveryUrlBase, timeLimit, compensatorData);
        }
        catch (UnsupportedEncodingException e) {
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        if (participant == null || participant.getRecoveryURI() == null) {
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        String recoveryURI = participant.getRecoveryURI().toASCIIString();
        this.updateRecoveryURI(lra, participant.getParticipantURI(), recoveryURI, false);
        recoveryUrl.append(recoveryURI);
        return Response.Status.OK.getStatusCode();
    }

    public boolean hasTransaction(URI id) {
        return this.lras.containsKey(id);
    }

    public boolean hasTransaction(String id) {
        try {
            return this.lras.containsKey(new URI(id));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private void lraTrace(URI lraId, String reason) {
        if (LRALogger.logger.isTraceEnabled()) {
            if (lraId != null && this.lras.containsKey(lraId)) {
                Transaction lra = (Transaction)this.lras.get(lraId);
                LRALogger.logger.tracef("LRAService: '%s' (%s) in state %s: %s%n", new Object[]{reason, lra.getClientId(), ActionStatus.stringForm((int)lra.status()), lra.getId()});
            } else {
                LRALogger.logger.tracef("LRAService: '%s', not found: %s%n", (Object)reason, (Object)lraId);
            }
        }
    }

    public int renewTimeLimit(URI lraId, Long timelimit) {
        Transaction lra = (Transaction)this.lras.get(lraId);
        if (lra == null) {
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        return lra.setTimeLimit(timelimit);
    }

    public boolean isLocal(URI lraId) {
        return this.hasTransaction(lraId);
    }

    public List<LRAStatusHolder> getFailedLRAs() {
        ConcurrentHashMap failedLRAs = new ConcurrentHashMap();
        this.lraRecoveryModule.getFailedLRAs(failedLRAs);
        return failedLRAs.values().stream().map(LRAStatusHolder::new).collect(Collectors.toList());
    }

    @PostConstruct
    void enableRecovery() {
        assert (this.lraRecoveryModule == null);
        if (LRALogger.logger.isDebugEnabled()) {
            LRALogger.logger.debugf("LRAServicve.enableRecovery", new Object[0]);
        }
        this.lraRecoveryModule = new LRARecoveryModule(this);
        RecoveryManager.manager().addModule((RecoveryModule)this.lraRecoveryModule);
        Implementations.install();
        this.lraRecoveryModule.getRecoveringLRAs(this.recoveringLRAs);
        for (Transaction transaction : this.recoveringLRAs.values()) {
            transaction.getRecoveryCoordinatorUrls(this.participants);
        }
    }

    @PreDestroy
    void disableRecovery() {
        if (this.lraRecoveryModule != null) {
            RecoveryManager.manager().removeModule((RecoveryModule)this.lraRecoveryModule, false);
            Implementations.uninstall();
            this.lraRecoveryModule = null;
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf("LRAServicve.disableRecovery", new Object[0]);
            }
        }
    }
}

