/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import jakarta.resource.ResourceException;
import jakarta.transaction.Transaction;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;

public class DB2Helper
extends DatabaseHelper {
    private static TraceComponent tc = com.ibm.websphere.ras.Tr.register(DB2Helper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private static final String ZOS_CURRENT_SQLID = "currentSQLID";
    protected static final TraceComponent db2Tc = Tr.register((String)"com.ibm.ws.db2.logwriter", (String)"WAS.database", null);
    HashMap<Object, Class<?>> db2ErrorMap = new HashMap(37);
    private String currentSQLid = null;
    String osType;
    boolean isRRSTransaction = false;
    int threadIdentitySupport = 0;
    boolean threadSecurity = false;
    boolean localZOS = false;
    String productName = null;
    static int JDBC = 1;
    static int SQLJ = 2;
    int connType = 0;

    DB2Helper(WSManagedConnectionFactoryImpl mcf) throws Exception {
        super(mcf);
        mcf.defaultIsolationLevel = 4;
        mcf.doesStatementCacheIsoLevel = true;
        mcf.supportsGetTypeMap = false;
        Properties props = mcf.dsConfig.get().vendorProps;
        this.currentSQLid = (String)props.get(ZOS_CURRENT_SQLID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"ZOS_CURRENT_SQLID is", (Object[])new Object[]{this.currentSQLid});
        }
        if (AdapterUtil.isZOS()) {
            this.localZOS = true;
        }
        if (this.localZOS) {
            this.isRRSTransaction = true;
            this.threadIdentitySupport = 1;
            this.threadSecurity = true;
        }
        Collections.addAll(this.staleConCodes, -30108, -60161, -6036, -1229, -1224, -1035, -1034, -1015, -924, -923, -906, "58004");
        this.staleConCodes.remove("S1000");
        Collections.addAll(this.staleStmtCodes, -518, -514);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void doConnectionSetup(Connection conn) throws SQLException {
        EmbeddableWebSphereTransactionManager tm;
        Transaction suspendedTx;
        Statement stmt;
        boolean isTraceOn;
        block34: {
            if (this.dataStoreHelper != null) {
                this.doConnectionSetupLegacy(conn);
                return;
            }
            isTraceOn = TraceComponent.isAnyTracingEnabled();
            if (isTraceOn && tc.isEntryEnabled()) {
                com.ibm.websphere.ras.Tr.entry((Object)this, (TraceComponent)tc, (String)"doConnectionSetup", (Object[])new Object[0]);
            }
            stmt = null;
            suspendedTx = null;
            tm = this.mcf.connectorSvc.getTransactionManager();
            try {
                boolean inGlobalTransaction;
                if (this.currentSQLid == null || this.currentSQLid.equals("")) break block34;
                UOWCurrent uow = (UOWCurrent)tm;
                UOWCoordinator coord = uow == null ? null : uow.getUOWCoord();
                boolean bl = inGlobalTransaction = coord != null && coord.isGlobal();
                if (inGlobalTransaction) {
                    try {
                        suspendedTx = tm.suspend();
                    }
                    catch (Throwable t) {
                        throw new SQLException(t);
                    }
                }
                if (isTraceOn && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)("Setting currentSQLID : " + this.currentSQLid), (Object[])new Object[0]);
                }
                stmt = conn.createStatement();
                String sql = "set current sqlid = '" + this.currentSQLid + "'";
                stmt.executeUpdate(sql);
            }
            catch (Throwable throwable) {
                try {
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"231", (Object)this);
                    if (!isTraceOn) throw throwable;
                    if (!tc.isDebugEnabled()) throw throwable;
                    com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object[])new Object[]{e});
                    throw throwable;
                }
                finally {
                    if (suspendedTx != null) {
                        try {
                            tm.resume(suspendedTx);
                        }
                        catch (Throwable t) {
                            throw new SQLException(t);
                        }
                    }
                }
            }
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"231", (Object)this);
            if (isTraceOn && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"SQLException occured in closing the statement ", (Object[])new Object[]{e});
            }
        }
        finally {
            if (suspendedTx != null) {
                try {
                    tm.resume(suspendedTx);
                }
                catch (Throwable t) {
                    throw new SQLException(t);
                }
            }
        }
        if (!isTraceOn) return;
        if (!tc.isEntryEnabled()) return;
        com.ibm.websphere.ras.Tr.exit((Object)this, (TraceComponent)tc, (String)"doConnectionSetup");
    }

    @Override
    public boolean getRRSTransactional() {
        return this.isRRSTransaction;
    }

    @Override
    public int getThreadIdentitySupport() {
        return this.threadIdentitySupport;
    }

    @Override
    public boolean getThreadSecurity() {
        return this.threadSecurity;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return null;
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (this.genPw == null) {
            this.genPw = new PrintWriter((Writer)new TraceWriter(db2Tc), true);
        }
        if (trace && tc.isDebugEnabled()) {
            com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"returning", (Object[])new Object[]{this.genPw});
        }
        return this.genPw;
    }

    @Override
    boolean isAuthException(SQLException x) {
        int ec = x.getErrorCode();
        return x instanceof SQLInvalidAuthorizationSpecException || "28000".equals(x.getSQLState()) || -1403 == ec || -4214 == ec || -30082 == ec || x.getMessage() != null && x.getMessage().indexOf("[2013]") > 0;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return db2Tc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return !db2Tc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }

    @Override
    public void gatherAndDisplayMetaDataInfo(Connection conn, WSManagedConnectionFactoryImpl mcf) throws SQLException {
        super.gatherAndDisplayMetaDataInfo(conn, mcf);
        if (this.getDriverName().equalsIgnoreCase("DSNAJDBC")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                com.ibm.websphere.ras.Tr.debug((Object)this, (TraceComponent)tc, (String)"application using <DB2 for zOS Local JDBC Provider (RRS)> which is not supported anymore in WAS6.1", (Object[])new Object[0]);
            }
            com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"PROVIDER_NOT_SUPPORTED", (Object[])new Object[]{"DB2 for zOS Local JDBC Provider (RRS)", "DB2 Universal JDBC Driver Provider Type 2"});
            throw new SQLException(AdapterUtil.getNLSMessage("PROVIDER_NOT_SUPPORTED", "DB2 for zOS Local JDBC Provider (RRS)", "DB2 Universal JDBC Driver Provider Type 2"));
        }
    }

    @Override
    public int branchCouplingSupported(int couplingType) {
        if (couplingType == 1) {
            DSConfig config = this.mcf.dsConfig.get();
            com.ibm.websphere.ras.Tr.warning((TraceComponent)tc, (String)"TBC_NOT_SUPPORTED", (Object[])new Object[]{config.jndiName == null ? config.id : config.jndiName});
            return -1;
        }
        return 0;
    }
}

