/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.ws.sib.api.jms.JmsSession;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;

public class JmsSharedUtilsImpl
implements JmsSharedUtils {
    private static TraceComponent tc = SibTr.register(JmsSharedUtilsImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static final String SUB_CONCATENATOR = "##";

    @Override
    public String getCoreDurableSubName(String jmsClientID, String jmsSubName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getCoreDurableSubName", (Object)new Object[]{jmsClientID, jmsSubName});
        }
        String retSubName = jmsClientID == null || "".equals(jmsClientID) ? jmsSubName : jmsClientID + SUB_CONCATENATOR + jmsSubName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getCoreDurableSubName", (Object)retSubName);
        }
        return retSubName;
    }

    @Override
    public Message inboundMessagePath(SIBusMessage sibMsg, JmsSession theSession, Map passThruProps) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"inboundMessagePath", (Object)new Object[]{sibMsg, theSession, passThruProps});
        }
        Message msg = null;
        try {
            JsMessage jsMsg = (JsMessage)sibMsg;
            JmsSessionImpl sessionImpl = null;
            if (theSession != null) {
                sessionImpl = (JmsSessionImpl)theSession;
            }
            if (sibMsg != null) {
                JsJmsMessage jsJmsMsg = jsMsg.makeInboundJmsMessage();
                msg = JmsMessageImpl.inboundJmsInstance(jsJmsMsg, sessionImpl, passThruProps);
            }
        }
        catch (ClassCastException cce) {
            JMSException jmse = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{cce, "JmsSharedUtilsImpl.inboundMessagePath"}, cce, "JmsSharedUtilsImpl#1", this, tc);
            throw jmse;
        }
        catch (IncorrectMessageTypeException imte) {
            JMSException jmse = (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{imte, "JsMessage.makeInboundJmsMessage"}, imte, "JmsSharedUtilsImpl#2", this, tc);
            throw jmse;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"inboundMessagePath", (Object)msg);
        }
        return msg;
    }

    @Override
    public Integer convertJSFeedbackToMQ(int fb) {
        return this.convertJSFeedbackToMQ((Integer)fb);
    }

    @Override
    public Integer convertJSFeedbackToMQ(Integer fb) {
        Integer result = null;
        result = SIApiConstants.REPORT_COA.equals(fb) ? Integer.valueOf(259) : (SIApiConstants.REPORT_COD.equals(fb) ? Integer.valueOf(260) : (SIApiConstants.REPORT_EXPIRY.equals(fb) ? Integer.valueOf(258) : (SIApiConstants.REPORT_PAN.equals(fb) ? Integer.valueOf(275) : (SIApiConstants.REPORT_NAN.equals(fb) ? Integer.valueOf(276) : fb))));
        return result;
    }

    @Override
    public Integer convertMQFeedbackToJS(int fb) {
        Integer result;
        switch (fb) {
            case 259: {
                result = SIApiConstants.REPORT_COA;
                break;
            }
            case 260: {
                result = SIApiConstants.REPORT_COD;
                break;
            }
            case 258: {
                result = SIApiConstants.REPORT_EXPIRY;
                break;
            }
            case 275: {
                result = SIApiConstants.REPORT_PAN;
                break;
            }
            case 276: {
                result = SIApiConstants.REPORT_NAN;
                break;
            }
            default: {
                result = fb;
            }
        }
        return result;
    }

    @Override
    public Integer convertMQFeedbackToJS(Integer fb) {
        Integer result = null;
        if (fb != null) {
            result = this.convertMQFeedbackToJS((int)fb);
        }
        return result;
    }
}

