/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.utils.JsonUtils;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.utils.HashUtils;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.InitialRequest;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class InitialRequestUtil {
    private static final TraceComponent tc = Tr.register(InitialRequestUtil.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static final long serialVersionUID = -4008446782729713095L;

    public String updateInitialRequestCookieNameWithRelayState(String append) {
        if (append != null) {
            return "WASInitialRequest_" + append;
        }
        return append;
    }

    @FFDCIgnore(value={KeyStoreException.class, CertificateException.class})
    public String digestInitialRequestCookieValue(String irBytes, SsoSamlService ssoService) {
        String retVal = new String(irBytes);
        String key_alias_pass = "samlsp";
        PrivateKey key = null;
        try {
            key = ssoService.getPrivateKey();
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (key != null) {
            byte[] encodedKey = key.getEncoded();
            if (encodedKey != null) {
                key_alias_pass.concat(JsonUtils.convertToBase64((byte[])encodedKey));
            }
        } else {
            String default_ks_pass = ssoService.getDefaultKeyStorePassword();
            if (default_ks_pass != null) {
                key_alias_pass.concat(default_ks_pass);
            }
        }
        String tmpStr = new String(irBytes);
        tmpStr = tmpStr.concat("_").concat(key_alias_pass);
        retVal = retVal.concat("_").concat(HashUtils.digest(tmpStr));
        return retVal;
    }

    @FFDCIgnore(value={IndexOutOfBoundsException.class})
    public String getInitialRequestCookie(String initialrequest_cookie_value, SsoSamlService ssoservice) {
        String initial;
        block7: {
            initial = null;
            try {
                String cookieToCompare;
                int lastindex = initialrequest_cookie_value.lastIndexOf("_");
                if (lastindex < 1 && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The cookie may have been tampered with.", (Object[])new Object[0]);
                    if (lastindex < 0) {
                        Tr.debug((TraceComponent)tc, (String)"The cookie does not contain an underscore.", (Object[])new Object[0]);
                    }
                    if (lastindex == 0) {
                        Tr.debug((TraceComponent)tc, (String)"The cookie does not contain a value before the underscore.", (Object[])new Object[0]);
                    }
                }
                if (!initialrequest_cookie_value.equals(cookieToCompare = this.digestInitialRequestCookieValue(initial = initialrequest_cookie_value.substring(0, lastindex), ssoservice))) {
                    String msg = "The value for the inital request cookie [" + initial + "] failed validation.";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                    }
                    initial = null;
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"unexpected exception:", (Object[])new Object[]{e});
            }
        }
        return initial;
    }

    public HttpRequestInfo createHttpRequestInfoFromInitialRequest(InitialRequest ir) {
        HttpRequestInfo httprequestinfo = null;
        if (ir.getRequestUrlWithEncodedQueryString() != null) {
            httprequestinfo = new HttpRequestInfo(ir.getRequestUrl(), ir.getRequestUrlWithEncodedQueryString(), ir.getMethod(), ir.getInResponseToId(), ir.getFormLogoutExitPage(), ir.getPostParamsMap());
        }
        return httprequestinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class})
    public InitialRequest handleDeserializingInitialRequest(String serializedInitialRequest) throws IOException, ClassNotFoundException {
        InitialRequest ir = null;
        if (serializedInitialRequest != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(JsonUtils.decodeFromBase64((String)serializedInitialRequest));
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(bis);
                ir = (InitialRequest)in.readObject();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return ir;
    }

    @FFDCIgnore(value={IOException.class, ClassNotFoundException.class})
    public HttpRequestInfo recreateHttpRequestInfo(String relayState, HttpServletRequest request, HttpServletResponse response, SsoSamlService ssoService) throws SamlException {
        HttpRequestInfo requestInfo = null;
        String initialrequest_cookie_name = this.updateInitialRequestCookieNameWithRelayState(relayState);
        String initialrequest_cookie_value_digest = null;
        if (initialrequest_cookie_name != null && request != null && response != null) {
            initialrequest_cookie_value_digest = RequestUtil.getCookieId((IExtendedRequest)request, response, initialrequest_cookie_name);
            RequestUtil.removeCookie(request, response, initialrequest_cookie_name);
        }
        String serializedInitialRequest = null;
        if (initialrequest_cookie_value_digest == null) {
            return requestInfo;
        }
        serializedInitialRequest = this.getInitialRequestCookie(initialrequest_cookie_value_digest, ssoService);
        InitialRequest ir = null;
        try {
            ir = this.handleDeserializingInitialRequest(serializedInitialRequest);
        }
        catch (ClassNotFoundException e) {
            throw new SamlException(e);
        }
        catch (IOException e) {
            throw new SamlException(e);
        }
        if (ir != null) {
            ir.setPostParamsMap(request);
            requestInfo = this.createHttpRequestInfoFromInitialRequest(ir);
        }
        return requestInfo;
    }

    public void removeCookie(String relayState, HttpServletRequest request, HttpServletResponse response) {
        String initialCookieName = this.updateInitialRequestCookieNameWithRelayState(relayState);
        if (initialCookieName != null && request != null && response != null) {
            RequestUtil.removeCookie(request, response, initialCookieName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String handleSerializingInitialRequest(HttpServletRequest req, HttpServletResponse resp, String sp_idp_initial, String shortRelayState, HttpRequestInfo requestInfo, SsoSamlService ssoService) {
        InitialRequest ir = null;
        try {
            ir = this.createInitialRequestFromHttpRequestInfo(req, requestInfo);
        }
        catch (SamlException samlException) {
            FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil", (String)"236", (Object)this, (Object[])new Object[]{req, resp, sp_idp_initial, shortRelayState, requestInfo, ssoService});
        }
        byte[] irBytes = null;
        String irBytesStr = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(ir);
                out.flush();
                irBytes = bos.toByteArray();
                if (irBytes != null) {
                    irBytesStr = JsonUtils.convertToBase64((byte[])irBytes);
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil", (String)"252", (Object)this, (Object[])new Object[]{req, resp, sp_idp_initial, shortRelayState, requestInfo, ssoService});
            }
        }
        catch (Throwable throwable) {
            try {
                bos.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil", (String)"259", (Object)this, (Object[])new Object[]{req, resp, sp_idp_initial, shortRelayState, requestInfo, ssoService});
            }
            throw throwable;
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil", (String)"259", (Object)this, (Object[])new Object[]{req, resp, sp_idp_initial, shortRelayState, requestInfo, ssoService});
        }
        if (irBytesStr != null) {
            String relayState = sp_idp_initial + shortRelayState;
            String initialrequest_cookie_name = this.updateInitialRequestCookieNameWithRelayState(relayState);
            String initialrequest_cookie_value = this.digestInitialRequestCookieValue(irBytesStr, ssoService);
            if (initialrequest_cookie_name != null && initialrequest_cookie_value != null) {
                RequestUtil.createCookie(req, resp, initialrequest_cookie_name, initialrequest_cookie_value);
            }
        }
        return irBytesStr;
    }

    private InitialRequest createInitialRequestFromHttpRequestInfo(HttpServletRequest req, HttpRequestInfo requestInfo) throws SamlException {
        InitialRequest ir = null;
        if (requestInfo != null) {
            ir = new InitialRequest(req, requestInfo.getReqUrl(), requestInfo.getRequestUrl(), req.getMethod(), requestInfo.getInResponseToId(), requestInfo.getFormLogoutExitPage(), (HashMap)requestInfo.getSavedPostParams());
        }
        return ir;
    }

    public static String toStringFromByteArray(byte[] b) {
        StringBuffer sb = new StringBuffer();
        int len = b.length;
        for (int i = 0; i < len; ++i) {
            sb.append((char)(b[i] & 0xFF));
        }
        String str = sb.toString();
        return str;
    }
}

