/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.persistence.InMemoryMappingFile;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import io.openliberty.data.internal.persistence.AttributeInfoImpl;
import io.openliberty.data.internal.persistence.ClassDefiner;
import io.openliberty.data.internal.persistence.EntityInfo;
import jakarta.data.exceptions.MappingException;
import jakarta.data.model.AttributeInfo;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EntityDefiner
implements Runnable {
    private static final String EOLN = String.format("%n", new Object[0]);
    private static final TraceComponent tc = Tr.register(EntityDefiner.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final ClassDefiner classDefiner = new ClassDefiner();
    private final String databaseId;
    private final Set<Class<?>> entities = new HashSet();
    final ConcurrentHashMap<Class<?>, CompletableFuture<EntityInfo>> entityInfoMap = new ConcurrentHashMap();
    private final ClassLoader loader;
    static final long serialVersionUID = -6473975814876829898L;

    public EntityDefiner(String databaseId, ClassLoader loader) {
        this.databaseId = databaseId;
        this.loader = loader;
    }

    @Trivial
    public void add(Class<?> entityClass) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("add: " + entityClass.getName()), (Object[])new Object[0]);
        }
        this.entities.add(entityClass);
    }

    private static void addDefaultCtor(ClassWriter cw, String parent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"    adding method : <init> ()V", (Object[])new Object[0]);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private static void addRecordCtor(Class<?> recordClass, String internalEntityClassName, ClassWriter cw, String parent) {
        Method constructor = Method.getMethod((String)("void <init> (" + recordClass.getTypeName() + ")"));
        GeneratorAdapter mg = new GeneratorAdapter(1, constructor, null, null, (ClassVisitor)cw);
        mg.loadThis();
        mg.invokeConstructor(org.objectweb.asm.Type.getType(Object.class), Method.getMethod((String)"void <init> ()"));
        for (RecordComponent component : recordClass.getRecordComponents()) {
            String componentName = component.getName();
            String typeDesc = component.getType().getTypeName();
            String methodName = "set" + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
            int componentValue = mg.newLocal(org.objectweb.asm.Type.getType(component.getType()));
            mg.loadArg(0);
            mg.invokeVirtual(org.objectweb.asm.Type.getType(recordClass), Method.getMethod((String)(typeDesc + " " + componentName + " ()")));
            mg.storeLocal(componentValue);
            mg.loadThis();
            mg.loadLocal(componentValue);
            mg.invokeVirtual(org.objectweb.asm.Type.getObjectType((String)internalEntityClassName), Method.getMethod((String)("void " + methodName + " (" + typeDesc + ")")));
        }
        mg.returnValue();
        mg.endMethod();
    }

    @ManualTrace
    private byte[] generateEntityClassBytes(Class<?> recordClass, String entityClassName) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        ClassWriter cw = new ClassWriter(1);
        String internal_entityClassName = entityClassName.replace('.', '/');
        cw.visit(61, 33, internal_entityClassName, null, "java/lang/Object", null);
        String sourceFileName = entityClassName.substring(entityClassName.lastIndexOf(".") + 1) + ".java";
        cw.visitSource(sourceFileName, null);
        EntityDefiner.addDefaultCtor(cw, null);
        for (RecordComponent component : recordClass.getRecordComponents()) {
            String componentName = component.getName();
            String typeDesc = org.objectweb.asm.Type.getDescriptor(component.getType());
            if (trace && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     adding field : " + componentName + " " + typeDesc), (Object[])new Object[0]);
            }
            FieldVisitor fv = cw.visitField(1, componentName, typeDesc, null, null);
            fv.visitEnd();
            if (trace && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("     adding field : " + component.getName() + " " + component.getType().descriptorString()), (Object[])new Object[0]);
            }
            String methodName = "set" + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
            MethodVisitor mv = cw.visitMethod(1, methodName, "(" + typeDesc + ")V", null, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(org.objectweb.asm.Type.getType(component.getType()).getOpcode(21), 1);
            mv.visitFieldInsn(181, internal_entityClassName, componentName, typeDesc);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            methodName = "get" + componentName.substring(0, 1).toUpperCase() + componentName.substring(1);
            mv = cw.visitMethod(1, methodName, "()" + typeDesc, null, null);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, internal_entityClassName, componentName, typeDesc);
            mv.visitInsn(org.objectweb.asm.Type.getType(component.getType()).getOpcode(172));
            mv.visitMaxs(1, 1);
            mv.visitEnd();
        }
        EntityDefiner.addRecordCtor(recordClass, internal_entityClassName, cw, null);
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        if (trace && tc.isEntryEnabled()) {
            Object classByteString = "";
            for (int i = 0; i < classBytes.length; ++i) {
                classByteString = (String)classByteString + (i % 8 == 0 ? "\t" : "");
                classByteString = (String)classByteString + (i % 32 == 0 ? System.lineSeparator() : "");
                classByteString = (String)classByteString + String.format("%02X", classBytes[i]) + " ";
            }
            Tr.exit((TraceComponent)tc, (String)("generateClassBytes: " + classBytes.length + " bytes" + (String)classByteString));
        }
        return classBytes;
    }

    @Trivial
    private Class<?> getEntityClass(Type type) {
        Class c = null;
        if (type instanceof ParameterizedType) {
            Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
            Type type2 = type = typeParams.length == 1 ? typeParams[0] : null;
            if (type instanceof Class && ((Class)type).isAnnotationPresent(Entity.class)) {
                c = (Class)type;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("getEntityClass from parameterized " + type + ": " + c), (Object[])new Object[0]);
            }
        }
        return c;
    }

    @Trivial
    @FFDCIgnore(value={RuntimeException.class})
    private static jakarta.persistence.metamodel.Type<?> getIdType(EntityType<?> entityType) {
        jakarta.persistence.metamodel.Type idType;
        try {
            idType = entityType.getIdType();
        }
        catch (RuntimeException x) {
            if ("ConversionException".equals(x.getClass().getSimpleName())) {
                idType = null;
            }
            throw x;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(entityType.getName() + " getIdType: " + idType), (Object[])new Object[0]);
        }
        return idType;
    }

    public void populateStaticMetamodelClasses(Map<Class<?>, List<Class<?>>> staticMetamodels) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        for (Class<?> entityClass : this.entities) {
            List<Class<?>> metamodelClasses = staticMetamodels.get(entityClass);
            if (metamodelClasses == null) continue;
            CompletableFuture entityInfoFuture = this.entityInfoMap.computeIfAbsent(entityClass, EntityInfo::newFuture);
            EntityInfo entityInfo = (EntityInfo)entityInfoFuture.join();
            for (Class<?> metamodelClass : metamodelClasses) {
                for (Field field : metamodelClass.getFields()) {
                    int mod = field.getModifiers();
                    if (!jakarta.data.model.Attribute.class.equals(field.getType()) || !Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
                    String fieldName = field.getName();
                    String attrName = entityInfo.attributeNames.get(fieldName.toLowerCase());
                    jakarta.data.model.Attribute attribute = null;
                    if (attrName != null) {
                        try {
                            attribute = (jakarta.data.model.Attribute)field.get(null);
                        }
                        catch (IllegalAccessException | IllegalArgumentException exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.data.internal.persistence.EntityDefiner", (String)"360", (Object)this, (Object[])new Object[]{staticMetamodels});
                            System.out.println("Unable to initialize the " + fieldName + " field of the " + metamodelClass.getName() + " StaticMetamodel class.");
                        }
                    }
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("initialize " + metamodelClass.getSimpleName() + "." + fieldName + " (" + attrName + "): " + attribute), (Object[])new Object[0]);
                    }
                    if (attribute == null) continue;
                    attribute.init((AttributeInfo)AttributeInfoImpl.create(fieldName));
                }
            }
        }
    }

    @Override
    @Trivial
    @ManualTrace
    public void run() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"run: define entities", (Object[])new Object[]{this.entities});
        }
        try (EntityManager em = null;){
            Class c;
            Object type;
            StringBuilder xml;
            BundleContext bc = FrameworkUtil.getBundle(DatabaseStore.class).getBundleContext();
            Collection refs = bc.getServiceReferences(DatabaseStore.class, FilterUtils.createPropertyFilter((String)"id", (String)this.databaseId));
            if (refs.isEmpty()) {
                throw new IllegalArgumentException("Not found: " + this.databaseId);
            }
            ServiceReference ref = (ServiceReference)refs.iterator().next();
            String tablePrefix = (String)ref.getProperty("tablePrefix");
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(this.databaseId + " databaseStore reference"), (Object[])new Object[]{ref});
            }
            HashSet<String> entityClassNames = new HashSet<String>(this.entities.size() * 2);
            HashMap generatedToRecordClass = new HashMap();
            ArrayList<InMemoryMappingFile> generatedEntities = new ArrayList<InMemoryMappingFile>();
            LinkedList annotatedEntityClassQueue = new LinkedList();
            ArrayList<String> entityClassInfo = new ArrayList<String>(this.entities.size());
            LinkedList embeddableTypesQueue = new LinkedList();
            HashSet<Class> converterTypes = new HashSet<Class>();
            for (Class<?> c2 : this.entities) {
                if (c2.isAnnotationPresent(Entity.class)) {
                    annotatedEntityClassQueue.add(c2);
                    for (Field field : c2.getFields()) {
                        Convert convert = field.getAnnotation(Convert.class);
                        if (convert == null) continue;
                        converterTypes.add(convert.converter());
                    }
                    for (AccessibleObject accessibleObject : c2.getMethods()) {
                        Convert convert = ((java.lang.reflect.Method)accessibleObject).getAnnotation(Convert.class);
                        if (convert == null) continue;
                        converterTypes.add(convert.converter());
                    }
                    continue;
                }
                if (c2.isRecord()) {
                    String entityClassName = c2.getName() + "Entity";
                    byte[] generatedEntityBytes = this.generateEntityClassBytes(c2, entityClassName);
                    generatedEntities.add(new InMemoryMappingFile(generatedEntityBytes, entityClassName.replace('.', '/') + ".class"));
                    Class<?> generatedEntity = this.classDefiner.findLoadedOrDefineClass(this.loader, entityClassName, generatedEntityBytes);
                    generatedToRecordClass.put(generatedEntity, c2);
                    c2 = generatedEntity;
                }
                xml = new StringBuilder(500).append(" <entity class=\"").append(c2.getName()).append("\">").append(EOLN);
                xml.append("  <table name=\"").append(tablePrefix).append(c2.getSimpleName()).append("\"/>").append(EOLN);
                this.writeAttributes(xml, c2, false, embeddableTypesQueue);
                xml.append(" </entity>").append(EOLN);
                entityClassInfo.add(xml.toString());
            }
            HashSet<Class> embeddableTypes = new HashSet<Class>();
            while ((type = (Class)embeddableTypesQueue.poll()) != null) {
                if (!embeddableTypes.add((Class)type)) continue;
                xml = new StringBuilder(500).append(" <embeddable class=\"").append(((Class)type).getName()).append("\">").append(EOLN);
                this.writeAttributes(xml, (Class<?>)type, true, embeddableTypesQueue);
                xml.append(" </embeddable>").append(EOLN);
                entityClassInfo.add(xml.toString());
            }
            for (Class type2 : converterTypes) {
                StringBuilder xml2 = new StringBuilder(500).append(" <converter class=\"").append(type2.getName()).append("\"></converter>").append(EOLN);
                entityClassInfo.add(xml2.toString());
            }
            while ((c = (Class)annotatedEntityClassQueue.poll()) != null) {
                Class<?> e;
                if (!entityClassNames.add(c.getName())) continue;
                for (Field field : c.getFields()) {
                    if (field.getType().isAnnotationPresent(Entity.class)) {
                        annotatedEntityClassQueue.add(field.getType());
                        continue;
                    }
                    e = this.getEntityClass(field.getGenericType());
                    if (e == null) continue;
                    annotatedEntityClassQueue.add(e);
                }
                for (AccessibleObject accessibleObject : c.getMethods()) {
                    if (((java.lang.reflect.Method)accessibleObject).getReturnType().isAnnotationPresent(Entity.class)) {
                        annotatedEntityClassQueue.add(((java.lang.reflect.Method)accessibleObject).getReturnType());
                        continue;
                    }
                    e = this.getEntityClass(((java.lang.reflect.Method)accessibleObject).getGenericReturnType());
                    if (e == null) continue;
                    annotatedEntityClassQueue.add(e);
                }
            }
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("io.openliberty.persistence.internal.entityClassInfo", entityClassInfo.toArray(new String[entityClassInfo.size()]));
            if (!generatedEntities.isEmpty()) {
                properties.put("io.openliberty.persistence.internal.generatedEntities", generatedEntities);
            }
            DatabaseStore dbstore = (DatabaseStore)bc.getService(ref);
            PersistenceServiceUnit punit = dbstore.createPersistenceServiceUnit(this.loader, properties, entityClassNames.toArray(new String[entityClassNames.size()]));
            em = punit.createEntityManager();
            Metamodel model = em.getMetamodel();
            for (EntityType entityType : model.getEntities()) {
                Set idClassAttributes;
                jakarta.persistence.metamodel.Type<?> idClassType;
                Attribute attr;
                HashMap<String, String> attributeNames = new HashMap<String, String>();
                HashMap<String, List<Member>> attributeAccessors = new HashMap<String, List<Member>>();
                TreeMap attributeTypes = new TreeMap();
                HashMap collectionElementTypes = new HashMap();
                HashMap relationAttributeNames = new HashMap();
                LinkedList<Attribute> relationships = new LinkedList<Attribute>();
                LinkedList<Object> relationPrefixes = new LinkedList<Object>();
                LinkedList<List<Member>> relationAccessors = new LinkedList<List<Member>>();
                Class recordClass = (Class)generatedToRecordClass.get(entityType.getJavaType());
                Class idType = null;
                TreeMap<String, Member> idClassAttributeAccessors = null;
                String versionAttrName = null;
                for (Attribute attr2 : entityType.getAttributes()) {
                    SingularAttribute singleAttr;
                    String attributeName = attr2.getName();
                    Attribute.PersistentAttributeType attributeType = attr2.getPersistentAttributeType();
                    if (Attribute.PersistentAttributeType.EMBEDDED.equals((Object)attributeType) || Attribute.PersistentAttributeType.ONE_TO_ONE.equals((Object)attributeType) || Attribute.PersistentAttributeType.MANY_TO_ONE.equals((Object)attributeType)) {
                        relationAttributeNames.put(attr2.getJavaType(), new ArrayList());
                        relationships.add(attr2);
                        relationPrefixes.add(attributeName);
                        relationAccessors.add(Collections.singletonList(attr2.getJavaMember()));
                    }
                    Member accessor = recordClass == null ? attr2.getJavaMember() : recordClass.getMethod(attributeName, new Class[0]);
                    attributeNames.put(attributeName.toLowerCase(), attributeName);
                    attributeAccessors.put(attributeName, Collections.singletonList(accessor));
                    attributeTypes.put(attributeName, attr2.getJavaType());
                    if (attr2.isCollection()) {
                        if (!(attr2 instanceof PluralAttribute)) continue;
                        collectionElementTypes.put(attributeName, ((PluralAttribute)attr2).getElementType().getJavaType());
                        continue;
                    }
                    SingularAttribute singularAttribute = singleAttr = attr2 instanceof SingularAttribute ? (SingularAttribute)attr2 : null;
                    if (singleAttr != null && singleAttr.isId()) {
                        attributeNames.put("id", attributeName);
                        idType = singleAttr.getJavaType();
                        continue;
                    }
                    if (singleAttr != null && singleAttr.isVersion()) {
                        versionAttrName = attributeName;
                        continue;
                    }
                    if (!Collection.class.isAssignableFrom(attr2.getJavaType())) continue;
                    collectionElementTypes.put(attributeName, Object.class);
                }
                HashSet<Class> entityTypeClasses = new HashSet<Class>();
                entityTypeClasses.add(entityType.getJavaType());
                while ((attr = (Attribute)relationships.poll()) != null) {
                    String prefix = (String)relationPrefixes.poll();
                    List accessors = (List)relationAccessors.poll();
                    ManagedType relation = model.managedType(attr.getJavaType());
                    if (relation instanceof EntityType && !entityTypeClasses.add(attr.getJavaType())) break;
                    List relAttributeList = (List)relationAttributeNames.get(attr.getJavaType());
                    for (Attribute relAttr : relation.getAttributes()) {
                        String relationAttributeName = relAttr.getName();
                        String fullAttributeName = prefix + "." + relationAttributeName;
                        LinkedList<Member> relAccessors = new LinkedList<Member>(accessors);
                        relAccessors.add(relAttr.getJavaMember());
                        relAttributeList.add(fullAttributeName);
                        Attribute.PersistentAttributeType attributeType = relAttr.getPersistentAttributeType();
                        if (Attribute.PersistentAttributeType.EMBEDDED.equals((Object)attributeType) || Attribute.PersistentAttributeType.ONE_TO_ONE.equals((Object)attributeType) || Attribute.PersistentAttributeType.MANY_TO_ONE.equals((Object)attributeType)) {
                            relationAttributeNames.put(relAttr.getJavaType(), new ArrayList());
                            relationships.add(relAttr);
                            relationPrefixes.add(fullAttributeName);
                            relationAccessors.add(relAccessors);
                        }
                        relationAttributeName = relationAttributeName.toLowerCase();
                        attributeNames.putIfAbsent(relationAttributeName, fullAttributeName);
                        relationAttributeName = fullAttributeName.toLowerCase();
                        attributeNames.put(relationAttributeName, fullAttributeName);
                        String relationAttributeName_ = relationAttributeName.replace('.', '_');
                        attributeNames.putIfAbsent(relationAttributeName_, fullAttributeName);
                        String relationAttributeNameUndelimited = relationAttributeName.replace(".", "");
                        attributeNames.putIfAbsent(relationAttributeNameUndelimited, fullAttributeName);
                        attributeAccessors.put(fullAttributeName, relAccessors);
                        attributeTypes.put(fullAttributeName, relAttr.getJavaType());
                        if (relAttr.isCollection()) {
                            if (!(relAttr instanceof PluralAttribute)) continue;
                            collectionElementTypes.put(fullAttributeName, ((PluralAttribute)relAttr).getElementType().getJavaType());
                            continue;
                        }
                        if (!(relAttr instanceof SingularAttribute)) continue;
                        SingularAttribute singleAttr = (SingularAttribute)relAttr;
                        if (singleAttr.isId()) {
                            attributeNames.put("id", fullAttributeName);
                            idType = singleAttr.getJavaType();
                            continue;
                        }
                        if (!singleAttr.isVersion()) continue;
                        versionAttrName = relationAttributeName_;
                    }
                }
                if (!entityType.hasSingleIdAttribute() && (idClassType = EntityDefiner.getIdType(entityType)) != null && (idClassAttributes = entityType.getIdClassAttributes()) != null) {
                    attributeNames.remove("id");
                    idType = idClassType.getJavaType();
                    idClassAttributeAccessors = new TreeMap<String, Member>();
                    for (SingularAttribute attr3 : idClassAttributes) {
                        Member entityMember = attr3.getJavaMember();
                        Field idClassMember = entityMember instanceof Field ? idType.getField(entityMember.getName()) : idType.getMethod(entityMember.getName(), new Class[0]);
                        idClassAttributeAccessors.put(attr3.getName().toLowerCase(), idClassMember);
                    }
                }
                Class entityClass = entityType.getJavaType();
                EntityInfo entityInfo = new EntityInfo(entityType.getName(), entityClass, (Class)generatedToRecordClass.get(entityClass), attributeAccessors, attributeNames, attributeTypes, collectionElementTypes, relationAttributeNames, idType, idClassAttributeAccessors, versionAttrName, punit);
                this.entityInfoMap.computeIfAbsent(entityClass, EntityInfo::newFuture).complete(entityInfo);
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run: define entities");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeAttributes(StringBuilder xml, Class<?> c, boolean isEmbeddable, Queue<Class<?>> embeddableTypesQueue) {
        TreeMap attributes = new TreeMap();
        for (Field f : c.getFields()) {
            attributes.putIfAbsent(f.getName(), f.getType());
        }
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(c).getPropertyDescriptors();
            if (propertyDescriptors != null) {
                for (PropertyDescriptor p : propertyDescriptors) {
                    java.lang.reflect.Method setter = p.getWriteMethod();
                    if (setter == null) continue;
                    attributes.putIfAbsent(p.getName(), p.getPropertyType());
                }
            }
        }
        catch (IntrospectionException propertyDescriptors) {
            void x;
            FFDCFilter.processException((Throwable)propertyDescriptors, (String)"io.openliberty.data.internal.persistence.EntityDefiner", (String)"701", (Object)this, (Object[])new Object[]{xml, c, isEmbeddable, embeddableTypesQueue});
            throw new MappingException((Throwable)x);
        }
        String keyAttributeName = null;
        if (!isEmbeddable) {
            int precedence = 10;
            for (Map.Entry attribute : attributes.entrySet()) {
                String name = (String)attribute.getKey();
                Class type = (Class)attribute.getValue();
                if (name.length() > 2) {
                    if (precedence <= 2) continue;
                    char i = name.charAt(name.length() - 2);
                    if (i == 'I') {
                        char d = name.charAt(name.length() - 1);
                        if (d == 'd') {
                            keyAttributeName = name;
                            precedence = 2;
                            continue;
                        }
                        if (d != 'D' || precedence <= 3) continue;
                        keyAttributeName = name;
                        precedence = 3;
                        continue;
                    }
                    if (i != 'i' || precedence <= 5 || name.charAt(name.length() - 1) != 'd') continue;
                    keyAttributeName = name;
                    precedence = 5;
                    continue;
                }
                if (name.equalsIgnoreCase("ID")) {
                    keyAttributeName = name;
                    precedence = 1;
                    break;
                }
                if (precedence <= 4 || !UUID.class.equals((Object)type)) continue;
                keyAttributeName = name;
                precedence = 4;
            }
            if (keyAttributeName == null) {
                throw new MappingException("Entity class " + c.getName() + " lacks a public field of the form *ID or public method of the form get*ID.");
            }
        }
        xml.append("  <attributes>").append(EOLN);
        for (Map.Entry attributeInfo : attributes.entrySet()) {
            String columnType;
            String attributeName = (String)attributeInfo.getKey();
            Class attributeType = (Class)attributeInfo.getValue();
            boolean isCollection = Collection.class.isAssignableFrom(attributeType);
            boolean isPrimitive = attributeType.isPrimitive();
            if (isPrimitive || attributeType.isInterface() || Serializable.class.isAssignableFrom(attributeType)) {
                columnType = keyAttributeName != null && keyAttributeName.equalsIgnoreCase(attributeName) ? "id" : ("version".equalsIgnoreCase(attributeName) ? "version" : (isCollection ? "element-collection" : "basic"));
            } else {
                columnType = "embedded";
                embeddableTypesQueue.add(attributeType);
            }
            xml.append("   <" + columnType + " name=\"" + attributeName + "\">").append(EOLN);
            if (isEmbeddable) {
                if (!"embedded".equals(columnType)) {
                    xml.append("    <column name=\"").append(c.getSimpleName().toUpperCase()).append(attributeName.toUpperCase()).append("\"/>").append(EOLN);
                }
            } else if (isPrimitive) {
                xml.append("    <column nullable=\"false\"/>").append(EOLN);
            }
            xml.append("   </" + columnType + ">").append(EOLN);
        }
        xml.append("  </attributes>").append(EOLN);
    }
}

