/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import jakarta.data.Sort;
import jakarta.data.exceptions.DataException;
import jakarta.data.page.KeysetAwarePage;
import jakarta.data.page.Pageable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KeysetAwarePageImpl<T>
implements KeysetAwarePage<T> {
    private static final TraceComponent tc = Tr.register(KeysetAwarePageImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final Object[] args;
    private final boolean isForward;
    private final Pageable pagination;
    private final QueryInfo queryInfo;
    private final List<T> results;
    private long totalElements = -1L;
    static final long serialVersionUID = 6720934398857062481L;

    @FFDCIgnore(value={Exception.class})
    KeysetAwarePageImpl(QueryInfo queryInfo, Pageable pagination, Object[] args) {
        this.args = args;
        this.queryInfo = queryInfo;
        this.pagination = pagination == null ? Pageable.ofSize((int)100) : pagination;
        this.isForward = this.pagination.mode() != Pageable.Mode.CURSOR_PREVIOUS;
        Optional keysetCursor = this.pagination.cursor();
        int maxPageSize = this.pagination.size();
        int firstResult = this.pagination.mode() == Pageable.Mode.OFFSET ? RepositoryImpl.computeOffset(this.pagination) : 0;
        try (EntityManager em = queryInfo.entityInfo.persister.createEntityManager();){
            String jpql = keysetCursor.isEmpty() ? queryInfo.jpql : (this.isForward ? queryInfo.jpqlAfterKeyset : queryInfo.jpqlBeforeKeyset);
            TypedQuery query = em.createQuery(jpql, queryInfo.entityInfo.entityClass);
            queryInfo.setParameters((Query)query, args);
            if (keysetCursor.isPresent()) {
                queryInfo.setKeysetParameters((Query)query, (Pageable.Cursor)keysetCursor.get());
            }
            query.setFirstResult(firstResult);
            query.setMaxResults(maxPageSize + (maxPageSize == Integer.MAX_VALUE ? 0 : 1));
            this.results = query.getResultList();
            if (!this.isForward) {
                int size = this.results.size();
                int i = 0;
                for (int j = size - (size > maxPageSize ? 2 : 1); i < j; ++i, --j) {
                    Collections.swap(this.results, i, j);
                }
            }
        }
    }

    @FFDCIgnore(value={Exception.class})
    private long countTotalElements() {
        try (EntityManager em = this.queryInfo.entityInfo.persister.createEntityManager();){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("query for count: " + this.queryInfo.jpqlCount), (Object[])new Object[0]);
            }
            TypedQuery query = em.createQuery(this.queryInfo.jpqlCount, Long.class);
            this.queryInfo.setParameters((Query)query, this.args);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    public List<T> content() {
        int max;
        int size = this.results.size();
        return size > (max = this.pagination.size()) ? new ResultList(max) : this.results;
    }

    /*
     * WARNING - void declaration
     */
    public Pageable.Cursor getKeysetCursor(int index) {
        if (index < 0 || index >= this.pagination.size()) {
            throw new IllegalArgumentException("index: " + index);
        }
        T entity = this.results.get(index);
        Object[] keyValues = new Object[this.queryInfo.sorts.size()];
        int k = 0;
        for (Sort keyInfo : this.queryInfo.sorts) {
            try {
                List<Member> accessors = this.queryInfo.entityInfo.attributeAccessors.get(keyInfo.property());
                Object value = entity;
                for (Member accessor : accessors) {
                    if (accessor instanceof Method) {
                        value = ((Method)accessor).invoke(value, new Object[0]);
                        continue;
                    }
                    value = ((Field)accessor).get(value);
                }
                keyValues[k++] = value;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException accessors) {
                void x;
                FFDCFilter.processException((Throwable)accessors, (String)"io.openliberty.data.internal.persistence.KeysetAwarePageImpl", (String)"145", (Object)this, (Object[])new Object[]{index});
                throw new DataException(x.getCause());
            }
        }
        return new Cursor(keyValues);
    }

    public long number() {
        return this.pagination.page();
    }

    public int numberOfElements() {
        int max;
        int size = this.results.size();
        return size > (max = this.pagination.size()) ? max : size;
    }

    public Pageable pageable() {
        return this.pagination;
    }

    public long totalElements() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements;
    }

    public long totalPages() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements / (long)this.pagination.size() + (long)(this.totalElements % (long)this.pagination.size() > 0L ? 1 : 0);
    }

    public boolean hasContent() {
        return !this.results.isEmpty();
    }

    public Iterator<T> iterator() {
        int max;
        int size = this.results.size();
        return size > (max = this.pagination.size()) ? new ResultIterator(max) : this.results.iterator();
    }

    public Pageable nextPageable() {
        int minToHaveNextPage;
        int n = this.isForward ? this.pagination.size() + (this.pagination.size() == Integer.MAX_VALUE ? 0 : 1) : (minToHaveNextPage = 1);
        if (this.results.size() < minToHaveNextPage) {
            return null;
        }
        Pageable p = this.pagination.page() == Long.MAX_VALUE ? this.pagination : this.pagination.page(this.pagination.page() + 1L);
        return p.afterKeyset(this.queryInfo.getKeysetValues(this.results.get(Math.min(this.results.size(), this.pagination.size()) - 1)));
    }

    public Pageable previousPageable() {
        int minToHavePreviousPage;
        int n = this.isForward ? 1 : (minToHavePreviousPage = this.pagination.size() + (this.pagination.size() == Integer.MAX_VALUE ? 0 : 1));
        if (this.results.size() < minToHavePreviousPage) {
            return null;
        }
        Pageable p = this.pagination.page() == 1L ? this.pagination : this.pagination.page(this.pagination.page() - 1L);
        return p.beforeKeyset(this.queryInfo.getKeysetValues(this.results.get(0)));
    }

    public Stream<T> stream() {
        return this.content().stream();
    }

    @Trivial
    private class ResultList
    extends AbstractList<T>
    implements RandomAccess {
        private final int size;

        private ResultList(int size) {
            this.size = size;
        }

        @Override
        public T get(int index) {
            if (index < this.size) {
                return KeysetAwarePageImpl.this.results.get(index);
            }
            throw new IndexOutOfBoundsException(index);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @Trivial
    private static class Cursor
    implements Pageable.Cursor {
        private final Object[] keyValues;

        private Cursor(Object[] keyValues) {
            this.keyValues = keyValues;
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.keyValues, ((Cursor)o).keyValues);
        }

        public Object getKeysetElement(int index) {
            return this.keyValues[index];
        }

        public int hashCode() {
            return Arrays.hashCode(this.keyValues);
        }

        public int size() {
            return this.keyValues.length;
        }

        public String toString() {
            return new StringBuilder(47).append("KeysetAwarePageImpl.Cursor@").append(Integer.toHexString(this.hashCode())).append(" with ").append(this.keyValues.length).append(" keys").toString();
        }
    }

    @Trivial
    private class ResultIterator
    implements Iterator<T> {
        private int index;
        private final Iterator<T> iterator;
        private final int size;

        private ResultIterator(int size) {
            this.size = size;
            this.iterator = KeysetAwarePageImpl.this.results.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("Element at index " + this.index);
            }
            Object result = this.iterator.next();
            ++this.index;
            return result;
        }
    }
}

