/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import jakarta.data.page.Page;
import jakarta.data.page.Pageable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PageImpl<T>
implements Page<T> {
    private static final TraceComponent tc = Tr.register(PageImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final Object[] args;
    private final Pageable pagination;
    private final QueryInfo queryInfo;
    private final List<T> results;
    private long totalElements = -1L;
    static final long serialVersionUID = 8899930601456069256L;

    @FFDCIgnore(value={Exception.class})
    PageImpl(QueryInfo queryInfo, Pageable pagination, Object[] args) {
        this.queryInfo = queryInfo;
        this.pagination = pagination == null ? Pageable.ofSize((int)100) : pagination;
        this.args = args;
        if (pagination == null && queryInfo.paramCount == 0 && queryInfo.method.getParameterCount() == 1 && Pageable.class.equals(queryInfo.method.getParameterTypes()[0])) {
            throw new NullPointerException("Pageable: null");
        }
        try (EntityManager em = queryInfo.entityInfo.persister.createEntityManager();){
            TypedQuery query = em.createQuery(queryInfo.jpql, queryInfo.entityInfo.entityClass);
            queryInfo.setParameters((Query)query, args);
            int maxPageSize = pagination.size();
            query.setFirstResult(RepositoryImpl.computeOffset(pagination));
            query.setMaxResults(maxPageSize + (maxPageSize == Integer.MAX_VALUE ? 0 : 1));
            this.results = query.getResultList();
        }
    }

    @FFDCIgnore(value={Exception.class})
    private long countTotalElements() {
        if (this.pagination.page() == 1L && this.results.size() <= this.pagination.size() && this.pagination.size() < Integer.MAX_VALUE) {
            return this.results.size();
        }
        try (EntityManager em = this.queryInfo.entityInfo.persister.createEntityManager();){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("query for count: " + this.queryInfo.jpqlCount), (Object[])new Object[0]);
            }
            TypedQuery query = em.createQuery(this.queryInfo.jpqlCount, Long.class);
            this.queryInfo.setParameters((Query)query, this.args);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    public List<T> content() {
        int max;
        int size = this.results.size();
        return size > (max = this.pagination.size()) ? new ResultList(max) : this.results;
    }

    public long number() {
        return this.pagination.page();
    }

    public int numberOfElements() {
        int max;
        int size = this.results.size();
        return size > (max = this.pagination.size()) ? max : size;
    }

    public Pageable pageable() {
        return this.pagination;
    }

    public long totalElements() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements;
    }

    public long totalPages() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements / (long)this.pagination.size() + (long)(this.totalElements % (long)this.pagination.size() > 0L ? 1 : 0);
    }

    public boolean hasContent() {
        return !this.results.isEmpty();
    }

    public Iterator<T> iterator() {
        int max;
        int size = this.results.size();
        return size > (max = this.pagination.size()) ? new ResultIterator(max) : this.results.iterator();
    }

    public Pageable nextPageable() {
        if (this.results.size() <= this.pagination.size() && this.pagination.size() < Integer.MAX_VALUE) {
            return null;
        }
        return this.pagination.next();
    }

    public Stream<T> stream() {
        return this.content().stream();
    }

    @Trivial
    private class ResultList
    extends AbstractList<T>
    implements RandomAccess {
        private final int size;

        private ResultList(int size) {
            this.size = size;
        }

        @Override
        public T get(int index) {
            if (index < this.size) {
                return PageImpl.this.results.get(index);
            }
            throw new IndexOutOfBoundsException(index);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @Trivial
    private class ResultIterator
    implements Iterator<T> {
        private int index;
        private final Iterator<T> iterator;
        private final int size;

        private ResultIterator(int size) {
            this.size = size;
            this.iterator = PageImpl.this.results.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("Element at index " + this.index);
            }
            Object result = this.iterator.next();
            ++this.index;
            return result;
        }
    }
}

