/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.RepositoryImpl;
import jakarta.data.page.Pageable;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public class PaginatedIterator<T>
implements Iterator<T> {
    private final TraceComponent tc = Tr.register(PaginatedIterator.class);
    private final Object[] args;
    private int index;
    private Boolean hasNext;
    private List<T> page;
    private Pageable pagination;
    private final QueryInfo queryInfo;

    PaginatedIterator(QueryInfo queryInfo, Pageable pagination, Object[] args) {
        this.queryInfo = queryInfo;
        this.pagination = pagination == null ? Pageable.ofSize((int)100) : pagination;
        this.args = args;
        this.getPage();
    }

    @Trivial
    @FFDCIgnore(value={Exception.class})
    private void getPage() {
        int startAt;
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)this.tc, (String)("getPage " + this.pagination.page()), (Object[])new Object[0]);
        }
        Optional keysetCursor = this.pagination.cursor();
        int maxPageSize = this.pagination.size();
        int n = startAt = keysetCursor.isEmpty() ? RepositoryImpl.computeOffset(this.pagination) : 0;
        String jpql = keysetCursor.isEmpty() ? this.queryInfo.jpql : (this.pagination.mode() == Pageable.Mode.CURSOR_NEXT ? this.queryInfo.jpqlAfterKeyset : this.queryInfo.jpqlBeforeKeyset);
        try (EntityManager em = this.queryInfo.entityInfo.persister.createEntityManager();){
            TypedQuery query = em.createQuery(jpql, this.queryInfo.entityInfo.entityClass);
            this.queryInfo.setParameters((Query)query, this.args);
            if (keysetCursor.isPresent()) {
                this.queryInfo.setKeysetParameters((Query)query, (Pageable.Cursor)keysetCursor.get());
            }
            if (startAt > 0) {
                query.setFirstResult(startAt);
            }
            query.setMaxResults(maxPageSize);
            this.page = query.getResultList();
            this.index = -1;
            this.hasNext = !this.page.isEmpty();
            if (this.hasNext.booleanValue() && this.pagination.mode() == Pageable.Mode.CURSOR_PREVIOUS) {
                Collections.reverse(this.page);
            }
            if (this.page.size() == maxPageSize) {
                if (keysetCursor.isEmpty()) {
                    this.pagination = this.pagination.next();
                } else if (this.pagination.mode() == Pageable.Mode.CURSOR_NEXT) {
                    Pageable next = this.pagination.page() == Long.MAX_VALUE ? this.pagination : this.pagination.page(this.pagination.page() + 1L);
                    this.pagination = next.afterKeyset(this.queryInfo.getKeysetValues(this.page.get(this.page.size() - 1)));
                } else {
                    Pageable prev = this.pagination.page() == 1L ? this.pagination : this.pagination.page(this.pagination.page() - 1L);
                    this.pagination = prev.beforeKeyset(this.queryInfo.getKeysetValues(this.page.get(0)));
                }
            } else {
                this.pagination = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && this.tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)this.tc, (String)("getPage size " + this.page.size()));
        }
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext == null) {
            if (this.index + 1 < this.page.size()) {
                this.hasNext = true;
            } else if (this.pagination == null) {
                this.hasNext = false;
            } else {
                this.getPage();
            }
        }
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.hasNext = null;
        return this.page.get(++this.index);
    }
}

