/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.repository.Count;
import io.openliberty.data.repository.Exists;
import io.openliberty.data.repository.Select;
import jakarta.data.Sort;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.page.Pageable;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Insert;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.Query;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class QueryInfo {
    private static final TraceComponent tc = Tr.register(QueryInfo.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final Set<Class<?>> RETURN_TYPES_FOR_DELETE_ONLY = Set.of(Void.TYPE, Void.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Number.class);
    private static final Map<Class<?>, Class<?>> WRAPPER_CLASSES = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Void.TYPE, Void.class);
    EntityInfo entityInfo;
    final Class<?> entityParamType;
    String entityVar = "o";
    boolean hasWhere;
    String jpql;
    String jpqlAfterKeyset;
    String jpqlBeforeKeyset;
    String jpqlCount;
    String jpqlDelete;
    int maxResults;
    final Method method;
    int paramCount;
    int paramAddedCount;
    List<String> paramNames;
    final Class<?> returnArrayType;
    final List<Class<?>> returnTypeAtDepth;
    List<Sort> sorts;
    Type type;
    boolean validateParams;
    boolean validateResult;
    static final long serialVersionUID = 3338060399176170354L;

    public QueryInfo(Method method, Class<?> entityParamType, Class<?> returnArrayType, List<Class<?>> returnTypeAtDepth) {
        this.method = method;
        this.entityParamType = entityParamType;
        this.returnArrayType = returnArrayType;
        this.returnTypeAtDepth = returnTypeAtDepth;
    }

    public QueryInfo(Method method, Type type) {
        this.method = method;
        this.entityParamType = null;
        this.returnArrayType = null;
        this.returnTypeAtDepth = null;
        this.type = type;
    }

    @Trivial
    void addSort(boolean ignoreCase, String attribute, boolean descending) {
        Set<String> names = this.entityInfo.idClassAttributeAccessors != null && "id".equalsIgnoreCase(attribute) ? this.entityInfo.idClassAttributeAccessors.keySet() : Set.of(attribute);
        for (String name : names) {
            name = this.entityInfo.getAttributeName(name, true);
            this.sorts.add(ignoreCase ? (descending ? Sort.descIgnoreCase((String)name) : Sort.ascIgnoreCase((String)name)) : (descending ? Sort.desc((String)name) : Sort.asc((String)name)));
        }
    }

    @Trivial
    List<Sort> combineSorts(List<Sort> combined, List<Sort> additional) {
        boolean hasIdClass;
        boolean bl = hasIdClass = this.entityInfo.idClassAttributeAccessors != null;
        if (combined == null && !additional.isEmpty()) {
            combined = this.sorts == null ? new ArrayList<Sort>() : new ArrayList<Sort>(this.sorts);
        }
        for (Sort sort : additional) {
            if (sort == null) {
                throw new DataException((Throwable)new IllegalArgumentException("Sort: null"));
            }
            if (hasIdClass && sort.property().equalsIgnoreCase("id")) {
                for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    combined.add(this.entityInfo.getWithAttributeName(this.entityInfo.getAttributeName(name, true), sort));
                }
                continue;
            }
            combined.add(this.entityInfo.getWithAttributeName(sort.property(), sort));
        }
        return combined;
    }

    @Trivial
    List<Sort> combineSorts(List<Sort> combined, Sort ... additional) {
        boolean hasIdClass;
        boolean bl = hasIdClass = this.entityInfo.idClassAttributeAccessors != null;
        if (combined == null && additional.length > 0) {
            combined = this.sorts == null ? new ArrayList<Sort>() : new ArrayList<Sort>(this.sorts);
        }
        for (Sort sort : additional) {
            if (sort == null) {
                throw new DataException((Throwable)new IllegalArgumentException("Sort: null"));
            }
            if (hasIdClass && sort.property().equalsIgnoreCase("id")) {
                for (String name : this.entityInfo.idClassAttributeAccessors.keySet()) {
                    combined.add(this.entityInfo.getWithAttributeName(this.entityInfo.getAttributeName(name, true), sort));
                }
                continue;
            }
            combined.add(this.entityInfo.getWithAttributeName(sort.property(), sort));
        }
        return combined;
    }

    private static int find(String lookFor, String findIn, int startAt) {
        int nextPosition;
        int foundAt;
        int totalLength = findIn.length();
        while (startAt < totalLength && (foundAt = findIn.indexOf(lookFor, startAt)) > 0 && (nextPosition = foundAt + lookFor.length()) < totalLength) {
            char ch = findIn.charAt(nextPosition);
            if (!(Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isDigit(ch) || ch == '_')) {
                return foundAt;
            }
            startAt = foundAt + 1;
        }
        return -1;
    }

    private static String findEntityVariable(String findIn, int startAt) {
        int length = findIn.length();
        boolean foundStart = false;
        for (int c = startAt; c < length; ++c) {
            char ch = findIn.charAt(c);
            if (Character.isLowerCase(ch) || Character.isUpperCase(ch) || Character.isDigit(ch) || ch == '_') {
                if (foundStart) continue;
                startAt = c;
                foundStart = true;
                continue;
            }
            if (!foundStart) continue;
            String found = findIn.substring(startAt, c);
            if ("AS".equalsIgnoreCase(found)) {
                foundStart = false;
                continue;
            }
            return found;
        }
        return foundStart ? findIn.substring(startAt) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    Object[] getKeysetValues(Object entity) {
        if (!this.entityInfo.getType().isInstance(entity)) {
            throw new MappingException("Unable to obtain keyset values from the " + (entity == null ? null : entity.getClass().getName()) + " type query result. Queries that use keyset pagination must return results of the same type as the entity type, which is " + this.entityInfo.getType().getName() + ".");
        }
        ArrayList<Object> keyValues = new ArrayList<Object>();
        for (Sort keyInfo : this.sorts) {
            try {
                List<Member> accessors = this.entityInfo.attributeAccessors.get(keyInfo.property());
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("getKeysetValues for " + entity), (Object[])new Object[]{accessors});
                }
                Object value = entity;
                for (Member accessor : accessors) {
                    if (accessor instanceof Method) {
                        value = ((Method)accessor).invoke(value, new Object[0]);
                        continue;
                    }
                    value = ((Field)accessor).get(value);
                }
                keyValues.add(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException accessors) {
                void x;
                FFDCFilter.processException((Throwable)accessors, (String)"io.openliberty.data.internal.persistence.QueryInfo", (String)"393", (Object)this, (Object[])new Object[]{entity});
                throw new DataException((Throwable)(x instanceof InvocationTargetException ? x.getCause() : x));
            }
        }
        return keyValues.toArray();
    }

    @Trivial
    Class<?> getMultipleResultType() {
        Class<?> type = null;
        int depth = this.returnTypeAtDepth.size();
        for (int d = 0; d < depth - 1 && type == null; ++d) {
            type = this.returnTypeAtDepth.get(d);
            if (!Optional.class.equals(type) && !CompletionStage.class.equals(type) && !CompletableFuture.class.equals(type)) continue;
            type = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getMultipleResultType: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        return type;
    }

    @Trivial
    Class<?> getOptionalResultType() {
        Class<?> type = null;
        int depth = this.returnTypeAtDepth.size();
        for (int d = 0; d < depth - 1; ++d) {
            type = this.returnTypeAtDepth.get(d);
            if (Optional.class.equals(type)) {
                type = this.returnTypeAtDepth.get(d + 1);
                break;
            }
            type = null;
            if (!CompletionStage.class.equals(type) || !CompletableFuture.class.equals(type)) break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getOptionalResultType: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        return type;
    }

    @Trivial
    Class<?> getSingleResultType() {
        Class<?> type = this.returnTypeAtDepth.get(this.returnTypeAtDepth.size() - 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("getSingleResultType: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        return type;
    }

    @Trivial
    boolean hasDynamicSortCriteria() {
        boolean hasDynamicSort = false;
        Class<?>[] paramTypes = this.method.getParameterTypes();
        for (int i = this.paramCount - this.paramAddedCount; i < paramTypes.length && !hasDynamicSort; ++i) {
            hasDynamicSort = Pageable.class.equals(paramTypes[i]) || Sort[].class.equals(paramTypes[i]) || Sort.class.equals(paramTypes[i]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("hasDynamicSortCriteria? " + hasDynamicSort), (Object[])new Object[0]);
        }
        return hasDynamicSort;
    }

    void init(Class<? extends Annotation> annoClass, Type operationType) {
        this.type = operationType;
        if (this.entityParamType == null) {
            throw new UnsupportedOperationException("Repository @" + annoClass.getSimpleName() + " operations must have exactly 1 parameter, which can be the entity or a collection or array of entities. The " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + " method has " + this.method.getParameterCount() + " parameters.");
        }
    }

    void initForQuery(String queryJPQL, String queryCountJPQL, boolean countPages) {
        this.jpql = queryJPQL;
        String upper = this.jpql.toUpperCase();
        String upperTrimmed = upper.stripLeading();
        if (upperTrimmed.startsWith("SELECT")) {
            int order = upper.lastIndexOf("ORDER BY");
            this.type = Type.FIND;
            this.sorts = this.sorts == null ? new ArrayList() : this.sorts;
            this.jpqlCount = queryCountJPQL.length() > 0 ? queryCountJPQL : null;
            int selectIndex = upper.length() - upperTrimmed.length();
            int from = QueryInfo.find("FROM", upper, selectIndex + 9);
            if (from > 0) {
                int entityName = QueryInfo.find(this.entityInfo.name.toUpperCase(), upper, from + 5);
                if (entityName > 0) {
                    this.entityVar = QueryInfo.findEntityVariable(this.jpql, entityName + this.entityInfo.name.length() + 1);
                }
                if (countPages && this.jpqlCount == null) {
                    String s = this.jpql.substring(selectIndex + 6, from);
                    int comma = s.indexOf(44);
                    if (comma > 0) {
                        s = s.substring(0, comma);
                    }
                    this.jpqlCount = new StringBuilder(this.jpql.length() + 7).append("SELECT COUNT(").append(s.trim()).append(") ").append(order > from ? this.jpql.substring(from, order) : this.jpql.substring(from)).toString();
                }
            }
        } else if (upperTrimmed.startsWith("UPDATE")) {
            this.type = Type.UPDATE;
        } else if (upperTrimmed.startsWith("DELETE")) {
            this.type = Type.DELETE;
        } else {
            throw new UnsupportedOperationException(this.jpql);
        }
        this.hasWhere = upperTrimmed.contains("WHERE");
    }

    @Trivial
    boolean isFindAndDelete() {
        boolean isMultiple;
        boolean isOptional;
        boolean isFindAndDelete = true;
        int d = 0;
        Class<?> type = this.returnTypeAtDepth.get(0);
        if (CompletionStage.class.equals(type) || CompletableFuture.class.equals(type)) {
            type = this.returnTypeAtDepth.get(++d);
        }
        if (isOptional = Optional.class.equals(type)) {
            type = this.returnTypeAtDepth.get(++d);
        }
        if (isMultiple = d < this.returnTypeAtDepth.size() - 1) {
            type = this.returnTypeAtDepth.get(++d);
        }
        boolean bl = isFindAndDelete = isOptional || isMultiple || !RETURN_TYPES_FOR_DELETE_ONLY.contains(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("isFindAndDelete? " + isFindAndDelete + " isOptional? " + isOptional + " isMultiple? " + isMultiple + " type: " + (type == null ? null : type.getName())), (Object[])new Object[0]);
        }
        if (!(!isFindAndDelete || type == null || type.equals(this.entityInfo.entityClass) || type.equals(this.entityInfo.recordClass) || type.equals(Object.class) || QueryInfo.wrapperClassIfPrimitive(type).equals(QueryInfo.wrapperClassIfPrimitive(this.entityInfo.idType)))) {
            throw new MappingException("Results for find-and-delete repository queries must be the entity class (" + (this.entityInfo.recordClass == null ? this.entityInfo.entityClass : this.entityInfo.recordClass).getName() + ") or the id class (" + this.entityInfo.idType + "), not the " + type.getName() + " class.");
        }
        return isFindAndDelete;
    }

    @Trivial
    private void keysetSizeMismatchError(Pageable.Cursor keysetCursor) {
        ArrayList<String> keyTypes = new ArrayList<String>();
        for (int i = 0; i < keysetCursor.size(); ++i) {
            keyTypes.add(keysetCursor.getKeysetElement(i) == null ? null : keysetCursor.getKeysetElement(i).getClass().getName());
        }
        throw new MappingException("The keyset cursor with key types " + keyTypes + " cannot be used with sort criteria of " + this.sorts + " because they have different numbers of elements. The keyset size is " + keysetCursor.size() + " and the sort criteria size is " + this.sorts.size() + ".");
    }

    void setKeysetParameters(jakarta.persistence.Query query, Pageable.Cursor keysetCursor) throws Exception {
        int paramNum = this.paramCount;
        if (this.paramNames == null) {
            for (int i = 0; i < keysetCursor.size(); ++i) {
                Object value = keysetCursor.getKeysetElement(i);
                if (this.entityInfo.idClassAttributeAccessors != null && this.entityInfo.idType.isInstance(value)) {
                    for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                        Object v;
                        Object object = v = accessor instanceof Field ? ((Field)accessor).get(value) : ((Method)accessor).invoke(value, new Object[0]);
                        if (++paramNum - this.paramCount > this.sorts.size()) {
                            this.keysetSizeMismatchError(keysetCursor);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter ?" + paramNum + " " + value.getClass().getName() + "-->" + (v == null ? null : v.getClass().getSimpleName())), (Object[])new Object[0]);
                        }
                        query.setParameter(paramNum, v);
                    }
                    continue;
                }
                if (++paramNum - this.paramCount > this.sorts.size()) {
                    this.keysetSizeMismatchError(keysetCursor);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter ?" + paramNum + " " + (value == null ? null : value.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter(paramNum, value);
            }
        } else {
            for (int i = 0; i < keysetCursor.size(); ++i) {
                Object value = keysetCursor.getKeysetElement(i);
                if (this.entityInfo.idClassAttributeAccessors != null && this.entityInfo.idType.isInstance(value)) {
                    for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                        Object v;
                        Object object = v = accessor instanceof Field ? ((Field)accessor).get(value) : ((Method)accessor).invoke(value, new Object[0]);
                        if (++paramNum - this.paramCount > this.sorts.size()) {
                            this.keysetSizeMismatchError(keysetCursor);
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter :keyset" + paramNum + " " + value.getClass().getName() + "-->" + (v == null ? null : v.getClass().getSimpleName())), (Object[])new Object[0]);
                        }
                        query.setParameter("keyset" + paramNum, v);
                    }
                    continue;
                }
                if (++paramNum - this.paramCount > this.sorts.size()) {
                    this.keysetSizeMismatchError(keysetCursor);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set keyset parameter :keyset" + paramNum + " " + (value == null ? null : value.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter("keyset" + paramNum, value);
            }
        }
        if (this.sorts.size() > paramNum - this.paramCount) {
            this.keysetSizeMismatchError(keysetCursor);
        }
    }

    @Trivial
    static void setParameter(int p, jakarta.persistence.Query query, Object entity, List<Member> accessors) throws Exception {
        Object v = entity;
        for (Member accessor : accessors) {
            v = accessor instanceof Method ? ((Method)accessor).invoke(v, new Object[0]) : ((Field)accessor).get(v);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + (v == null ? null : v.getClass().getSimpleName())), (Object[])new Object[0]);
        }
        query.setParameter(p, v);
    }

    void setParameters(jakarta.persistence.Query query, Object ... args) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int methodParamForQueryCount = this.paramCount - this.paramAddedCount;
        if (args != null && args.length < methodParamForQueryCount) {
            throw new MappingException("The " + this.method.getName() + " repository method has " + args.length + " parameters, but requires " + methodParamForQueryCount + " method parameters. The generated JPQL query is: " + this.jpql + ".");
        }
        int namedParamCount = this.paramNames == null ? 0 : this.paramNames.size();
        int p = 0;
        for (int i = 0; i < methodParamForQueryCount; ++i) {
            Object arg = args[i];
            if (arg == null || this.entityInfo.idClassAttributeAccessors == null || !this.entityInfo.idType.isInstance(arg)) {
                if (p < namedParamCount) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("set :" + this.paramNames.get(p) + " " + (arg == null ? null : arg.getClass().getSimpleName())), (Object[])new Object[0]);
                    }
                    query.setParameter(this.paramNames.get(p++), arg);
                    continue;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + (arg == null ? null : arg.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter(++p, arg);
                continue;
            }
            for (Member accessor : this.entityInfo.idClassAttributeAccessors.values()) {
                Object param;
                Object object = param = accessor instanceof Method ? ((Method)accessor).invoke(arg, new Object[0]) : ((Field)accessor).get(arg);
                if (p < namedParamCount) {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("set :" + this.paramNames.get(p) + " " + (param == null ? null : param.getClass().getSimpleName())), (Object[])new Object[0]);
                    }
                    query.setParameter(this.paramNames.get(p++), param);
                    continue;
                }
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + (param == null ? null : param.getClass().getSimpleName())), (Object[])new Object[0]);
                }
                query.setParameter(++p, param);
            }
        }
    }

    void setParametersFromIdClassAndVersion(jakarta.persistence.Query query, Object entity, Object version) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int p = 0;
        for (String idClassAttr : this.entityInfo.idClassAttributeAccessors.keySet()) {
            QueryInfo.setParameter(++p, query, entity, this.entityInfo.attributeAccessors.get(this.entityInfo.getAttributeName(idClassAttr, true)));
        }
        if (version != null) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("set ?" + (p + 1) + " " + version), (Object[])new Object[0]);
            }
            query.setParameter(++p, version);
        }
    }

    @Trivial
    public String toString() {
        StringBuilder b = new StringBuilder("QueryInfo@").append(Integer.toHexString(this.hashCode())).append(' ').append(this.method.getReturnType().getSimpleName()).append(' ').append(this.method.getName());
        boolean first = true;
        for (Class<?> p : this.method.getParameterTypes()) {
            b.append(first ? "(" : ", ").append(p.getSimpleName());
            first = false;
        }
        b.append(first ? "() " : ") ");
        if (this.jpql != null) {
            b.append(this.jpql);
        }
        if (this.paramCount > 0) {
            b.append(" [").append(this.paramCount).append(this.paramNames == null ? " positional params" : " named params");
            if (this.paramAddedCount != 0) {
                b.append(", ").append(this.paramCount - this.paramAddedCount).append(" method params");
            }
            b.append(']');
        }
        return b.toString();
    }

    @Trivial
    Annotation validateAnnotationCombinations(Delete delete, Insert insert, Update update, Save save, Query query, OrderBy[] orderBy, Count count, Exists exists, Select select) {
        int o = orderBy.length == 0 ? 0 : 1;
        int q = query == null ? 0 : 1;
        int s = select == null ? 0 : 1;
        int ius = (insert == null ? 0 : 1) + (update == null ? 0 : 1) + (save == null ? 0 : 1);
        int iusdce = ius + (delete == null ? 0 : 1) + (count == null ? 0 : 1) + (exists == null ? 0 : 1);
        if (ius > 1 || iusdce > 1 || iusdce + o > 1 || iusdce + q + s > 1) {
            ArrayList<String> annoClassNames = new ArrayList<String>();
            for (Annotation anno : Arrays.asList(delete, insert, query, save, update)) {
                if (anno == null) continue;
                annoClassNames.add(anno.annotationType().getName());
            }
            if (orderBy.length > 0) {
                annoClassNames.add(OrderBy.class.getName());
            }
            for (Annotation anno : Arrays.asList(count, exists, select)) {
                if (anno == null) continue;
                annoClassNames.add(anno.annotationType().getName());
            }
            throw new UnsupportedOperationException("The " + this.method.getDeclaringClass().getName() + "." + this.method.getName() + " repository method cannot be annotated with the following combination of annotations: " + annoClassNames);
        }
        return ius == 1 ? (insert != null ? insert : (update != null ? update : save)) : (iusdce == 1 ? (delete != null ? delete : (count != null ? count : exists)) : (q == 1 ? query : null));
    }

    QueryInfo withJPQL(String jpql, List<Sort> sorts) {
        QueryInfo q = new QueryInfo(this.method, this.entityParamType, this.returnArrayType, this.returnTypeAtDepth);
        q.entityInfo = this.entityInfo;
        q.entityVar = this.entityVar;
        q.hasWhere = this.hasWhere;
        q.jpql = jpql;
        q.jpqlAfterKeyset = this.jpqlAfterKeyset;
        q.jpqlBeforeKeyset = this.jpqlBeforeKeyset;
        q.jpqlCount = this.jpqlCount;
        q.jpqlDelete = this.jpqlDelete;
        q.maxResults = this.maxResults;
        q.paramCount = this.paramCount;
        q.paramAddedCount = this.paramAddedCount;
        q.paramNames = this.paramNames;
        q.sorts = sorts;
        q.type = this.type;
        q.validateParams = this.validateParams;
        q.validateParams = this.validateResult;
        return q;
    }

    @Trivial
    static final Class<?> wrapperClassIfPrimitive(Class<?> c) {
        Class<?> w = WRAPPER_CLASSES.get(c);
        return w == null ? c : w;
    }

    public static enum Type {
        COUNT,
        DELETE,
        DELETE_WITH_ENTITY_PARAM,
        EXISTS,
        FIND,
        FIND_AND_DELETE,
        INSERT,
        SAVE,
        RESOURCE_ACCESS,
        UPDATE,
        UPDATE_WITH_ENTITY_PARAM,
        UPDATE_WITH_ENTITY_PARAM_AND_RESULT;

    }
}

