/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.Condition;
import io.openliberty.data.internal.persistence.EntityDefiner;
import io.openliberty.data.internal.persistence.EntityInfo;
import io.openliberty.data.internal.persistence.EntityValidator;
import io.openliberty.data.internal.persistence.KeysetAwarePageImpl;
import io.openliberty.data.internal.persistence.PageImpl;
import io.openliberty.data.internal.persistence.PaginatedIterator;
import io.openliberty.data.internal.persistence.ParamInfo;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.StreamableImpl;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.cdi.DataExtensionProvider;
import io.openliberty.data.repository.Count;
import io.openliberty.data.repository.Exists;
import io.openliberty.data.repository.Or;
import io.openliberty.data.repository.Select;
import io.openliberty.data.repository.comparison.Contains;
import io.openliberty.data.repository.comparison.EndsWith;
import io.openliberty.data.repository.comparison.GreaterThan;
import io.openliberty.data.repository.comparison.GreaterThanEqual;
import io.openliberty.data.repository.comparison.In;
import io.openliberty.data.repository.comparison.LessThan;
import io.openliberty.data.repository.comparison.LessThanEqual;
import io.openliberty.data.repository.comparison.Like;
import io.openliberty.data.repository.comparison.StartsWith;
import io.openliberty.data.repository.function.AbsoluteValue;
import io.openliberty.data.repository.function.CharCount;
import io.openliberty.data.repository.function.ElementCount;
import io.openliberty.data.repository.function.Extract;
import io.openliberty.data.repository.function.IgnoreCase;
import io.openliberty.data.repository.function.Not;
import io.openliberty.data.repository.function.Rounded;
import io.openliberty.data.repository.function.Trimmed;
import io.openliberty.data.repository.update.Add;
import io.openliberty.data.repository.update.Assign;
import io.openliberty.data.repository.update.Divide;
import io.openliberty.data.repository.update.Multiply;
import io.openliberty.data.repository.update.SubtractFrom;
import jakarta.data.Limit;
import jakarta.data.Sort;
import jakarta.data.Streamable;
import jakarta.data.exceptions.DataConnectionException;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.EntityExistsException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.data.page.KeysetAwarePage;
import jakarta.data.page.KeysetAwareSlice;
import jakarta.data.page.Page;
import jakarta.data.page.Pageable;
import jakarta.data.page.Slice;
import jakarta.data.repository.BasicRepository;
import jakarta.data.repository.By;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Insert;
import jakarta.data.repository.OrderBy;
import jakarta.data.repository.Param;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Inheritance;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.RecordComponent;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransientConnectionException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RepositoryImpl<R>
implements InvocationHandler {
    private static final TraceComponent tc = Tr.register(RepositoryImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final String COMPARISON_ANNO_PACKAGE = In.class.getPackageName();
    private static final String FUNCTION_ANNO_PACKAGE = Not.class.getPackageName();
    private static final String UPDATE_ANNO_PACKAGE = Add.class.getPackageName();
    private static final Map<String, String> FUNCTION_CALLS = new HashMap<String, String>();
    private static final Set<Class<?>> SPECIAL_PARAM_TYPES;
    private static final Set<Class<?>> UPDATE_COUNT_TYPES;
    private static final ThreadLocal<Deque<EntityManager>> defaultMethodResources;
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final CompletableFuture<EntityInfo> primaryEntityInfoFuture;
    private final DataExtensionProvider provider;
    final Map<Method, CompletableFuture<QueryInfo>> queries = new HashMap<Method, CompletableFuture<QueryInfo>>();
    private final Class<R> repositoryInterface;
    private final EntityValidator validator;
    static final long serialVersionUID = -8277815094371678524L;

    /*
     * WARNING - void declaration
     */
    public RepositoryImpl(DataExtensionProvider provider, DataExtension extension, EntityDefiner definer, Class<R> repositoryInterface, Class<?> primaryEntityClass, Map<Class<?>, List<QueryInfo>> queriesPerEntityClass) {
        this.primaryEntityInfoFuture = primaryEntityClass == null ? null : definer.entityInfoMap.computeIfAbsent(primaryEntityClass, EntityInfo::newFuture);
        this.provider = provider;
        this.repositoryInterface = repositoryInterface;
        Object validation = provider.validationService();
        this.validator = validation == null ? null : EntityValidator.newInstance(validation, repositoryInterface);
        for (Map.Entry<Class<?>, List<QueryInfo>> entry : queriesPerEntityClass.entrySet()) {
            Class<?> entityClass = entry.getKey();
            for (QueryInfo queryInfo : entry.getValue()) {
                Class<?> jpaEntityClass;
                if (queryInfo.type == QueryInfo.Type.RESOURCE_ACCESS) {
                    queryInfo.validateParams = this.validator != null && this.validator.isValidatable(queryInfo.method)[1];
                    this.queries.put(queryInfo.method, CompletableFuture.completedFuture(queryInfo));
                    continue;
                }
                boolean inheritance = entityClass.getAnnotation(Inheritance.class) != null;
                Class<?> recordClass = null;
                if (entityClass.isRecord()) {
                    try {
                        recordClass = entityClass;
                        jpaEntityClass = recordClass.getClassLoader().loadClass(recordClass.getName() + "Entity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        void x;
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"io.openliberty.data.internal.persistence.RepositoryImpl", (String)"197", (Object)this, (Object[])new Object[]{provider, extension, definer, repositoryInterface, primaryEntityClass, queriesPerEntityClass});
                        throw new MappingException("Unable to load generated entity class for record " + recordClass, (Throwable)x);
                    }
                } else {
                    jpaEntityClass = entityClass;
                }
                CompletableFuture entityInfoFuture = definer.entityInfoMap.computeIfAbsent(jpaEntityClass, EntityInfo::newFuture);
                this.queries.put(queryInfo.method, (CompletableFuture<QueryInfo>)entityInfoFuture.thenCombine(CompletableFuture.completedFuture(queryInfo), this::completeQueryInfo));
            }
        }
    }

    @Trivial
    private static StringBuilder appendParam(StringBuilder q, boolean lower, int num) {
        q.append(lower ? "LOWER(?" : Character.valueOf('?')).append(num);
        return lower ? q.append(')') : q;
    }

    @Trivial
    private void appendSort(StringBuilder q, String o, Sort sort, boolean sameDirection) {
        q.append(sort.ignoreCase() ? "LOWER(" : "").append(o).append('.').append(sort.property());
        if (sort.ignoreCase()) {
            q.append(")");
        }
        if (sameDirection) {
            if (sort.isDescending()) {
                q.append(" DESC");
            }
        } else if (sort.isAscending()) {
            q.append(" DESC");
        }
    }

    public void beanDisposed() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QueryInfo completeQueryInfo(EntityInfo entityInfo, QueryInfo queryInfo) {
        queryInfo.entityInfo = entityInfo;
        if (this.validator != null) {
            boolean[] v = this.validator.isValidatable(queryInfo.method);
            queryInfo.validateParams = v[0];
            queryInfo.validateResult = v[1];
        }
        Method method = queryInfo.method;
        Class<?> multiType = queryInfo.getMultipleResultType();
        boolean countPages = Page.class.equals(multiType) || KeysetAwarePage.class.equals(multiType);
        StringBuilder q = null;
        Delete delete = method.getAnnotation(Delete.class);
        Insert insert = method.getAnnotation(Insert.class);
        Update update = method.getAnnotation(Update.class);
        Save save = method.getAnnotation(Save.class);
        jakarta.data.repository.Query query = method.getAnnotation(jakarta.data.repository.Query.class);
        OrderBy[] orderBy = (OrderBy[])method.getAnnotationsByType(OrderBy.class);
        Count count = method.getAnnotation(Count.class);
        Exists exists = method.getAnnotation(Exists.class);
        Select select = method.getAnnotation(Select.class);
        Annotation methodTypeAnno = queryInfo.validateAnnotationCombinations(delete, insert, update, save, query, orderBy, count, exists, select);
        if (query != null) {
            queryInfo.initForQuery(query.value(), query.count(), countPages);
        } else if (save != null) {
            queryInfo.init(Save.class, QueryInfo.Type.SAVE);
        } else if (insert != null) {
            queryInfo.init(Insert.class, QueryInfo.Type.INSERT);
        } else if (queryInfo.entityParamType != null) {
            if (update != null) {
                q = this.generateUpdateEntity(queryInfo);
            } else {
                if (delete == null) throw new UnsupportedOperationException("The " + method.getName() + " method of the " + this.repositoryInterface.getName() + " repository interface must be annotated with one of (Delete, Insert, Save, Update) because the method's parameter accepts entity instances. The following annotations were found: " + Arrays.toString(method.getAnnotations()));
                q = this.generateDeleteEntity(queryInfo);
            }
        } else {
            q = this.generateQueryFromMethod(queryInfo, methodTypeAnno, countPages);
            if (q == null && queryInfo.type == null && select != null) {
                queryInfo.type = QueryInfo.Type.FIND;
                q = this.generateSelectClause(queryInfo, select, new String[0]);
                if (countPages) {
                    this.generateCount(queryInfo, null);
                }
            }
        }
        if (query != null || queryInfo.paramNames != null) {
            Class<?> paramType;
            int initialParamCount = queryInfo.paramCount;
            Parameter[] params = method.getParameters();
            List<Integer> paramPositions = null;
            boolean hasParamAnnotation = false;
            for (int i = 0; i < params.length && !SPECIAL_PARAM_TYPES.contains(paramType = params[i].getType()); ++i) {
                int numParamNames;
                String paramName;
                Param param = params[i].getAnnotation(Param.class);
                hasParamAnnotation |= param != null;
                String string = paramName = param == null ? null : param.value();
                if (param == null && queryInfo.jpql != null && params[i].isNamePresent()) {
                    String name = params[i].getName();
                    if (paramPositions == null) {
                        paramPositions = this.getParameterPositions(queryInfo.jpql);
                    }
                    for (int p = 0; p < paramPositions.size() && paramName == null; ++p) {
                        int pos = paramPositions.get(p);
                        int next = pos + name.length();
                        if (!queryInfo.jpql.regionMatches(paramPositions.get(p), name, 0, name.length()) || next < queryInfo.jpql.length() && Character.isLetterOrDigit(queryInfo.jpql.charAt(next))) continue;
                        paramName = name;
                        paramPositions.remove(p);
                    }
                }
                if (paramName != null) {
                    if (queryInfo.paramNames == null) {
                        queryInfo.paramNames = new ArrayList<String>();
                    }
                    if (entityInfo.idClassAttributeAccessors != null && paramType.equals(entityInfo.idType)) {
                        int numIdClassParams = entityInfo.idClassAttributeAccessors.size();
                        for (int p = 1; p <= numIdClassParams; ++p) {
                            queryInfo.paramNames.add(paramName + '_' + p);
                            if (p <= 1) continue;
                            ++queryInfo.paramCount;
                            ++queryInfo.paramAddedCount;
                        }
                    } else {
                        queryInfo.paramNames.add(paramName);
                    }
                }
                ++queryInfo.paramCount;
                if (initialParamCount != 0) {
                    throw new MappingException("Cannot mix positional and named parameters on repository method " + method.getDeclaringClass().getName() + "." + method.getName());
                }
                int n = numParamNames = queryInfo.paramNames == null ? 0 : queryInfo.paramNames.size();
                if (numParamNames <= 0 || numParamNames == queryInfo.paramCount) continue;
                if (hasParamAnnotation) {
                    throw new MappingException("Cannot mix positional and named parameters on repository method " + method.getDeclaringClass().getName() + "." + method.getName());
                }
                queryInfo.paramNames = null;
                queryInfo.paramCount -= queryInfo.paramAddedCount;
                queryInfo.paramAddedCount = 0;
            }
        }
        if (orderBy.length > 0) {
            queryInfo.type = queryInfo.type == null ? QueryInfo.Type.FIND : queryInfo.type;
            List<Object> list = queryInfo.sorts = queryInfo.sorts == null ? new ArrayList(orderBy.length + 2) : queryInfo.sorts;
            if (q == null) {
                if (queryInfo.jpql == null) {
                    q = this.generateSelectClause(queryInfo, select, new String[0]);
                    if (countPages) {
                        this.generateCount(queryInfo, null);
                    }
                } else {
                    q = new StringBuilder(queryInfo.jpql);
                }
            }
            for (int i = 0; i < orderBy.length; ++i) {
                queryInfo.addSort(orderBy[i].ignoreCase(), orderBy[i].value(), orderBy[i].descending());
            }
            if (!queryInfo.hasDynamicSortCriteria()) {
                this.generateOrderBy(queryInfo, q);
            }
        }
        String string = queryInfo.jpql = q == null ? queryInfo.jpql : q.toString();
        if (queryInfo.type != null) return queryInfo;
        throw new MappingException("Repository method name " + method.getName() + " does not map to a valid query. Some examples of valid method names are: save(entity), findById(id), findByPriceLessThanEqual(maxPrice), deleteById(id), existsById(id), countByPriceBetween(min, max), updateByIdSetPrice(id, newPrice)");
    }

    static int computeOffset(Limit range) {
        long startIndex = range.startAt() - 1L;
        if (startIndex >= 0L && startIndex <= Integer.MAX_VALUE) {
            return (int)startIndex;
        }
        throw new DataException((Throwable)new IllegalArgumentException("The starting point for " + range + " is not within 1 to Integer.MAX_VALUE (2147483647)."));
    }

    static int computeOffset(Pageable pagination) {
        long pageIndex;
        if (pagination.mode() != Pageable.Mode.OFFSET) {
            throw new DataException((Throwable)new IllegalArgumentException("Keyset pagination mode " + pagination.mode() + " can only be used with repository methods with the following return types: " + KeysetAwarePage.class.getName() + ", " + KeysetAwareSlice.class.getName() + ", " + Iterator.class.getName() + ". For offset pagination, use a Pageable without a keyset."));
        }
        int maxPageSize = pagination.size();
        if ((long)(Integer.MAX_VALUE / maxPageSize) >= (pageIndex = pagination.page() - 1L)) {
            return (int)(pageIndex * (long)maxPageSize);
        }
        throw new DataException((Throwable)new IllegalArgumentException("The offset for " + pagination.page() + " pages of size " + maxPageSize + " exceeds Integer.MAX_VALUE (2147483647)."));
    }

    @Trivial
    private static boolean endsWith(String searchFor, String text, int minStart, int endBefore) {
        int searchLen = searchFor.length();
        return endBefore - minStart >= searchLen && text.regionMatches(endBefore - searchLen, searchFor, 0, searchLen);
    }

    @Trivial
    static RuntimeException failure(Exception original) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Object x = null;
        if (original instanceof PersistenceException) {
            for (Throwable cause = original; x == null && cause != null; cause = cause.getCause()) {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checking " + cause.getClass().getName() + " with message " + cause.getMessage()), (Object[])new Object[0]);
                }
                if (cause instanceof SQLRecoverableException || cause instanceof SQLNonTransientConnectionException || cause instanceof SQLTransientConnectionException) {
                    x = new DataConnectionException((Throwable)original);
                    continue;
                }
                if (cause instanceof SQLSyntaxErrorException) {
                    x = new MappingException((Throwable)original);
                    continue;
                }
                if (!(cause instanceof SQLIntegrityConstraintViolationException)) continue;
                x = new EntityExistsException((Throwable)original);
            }
            if (x == null) {
                x = original instanceof OptimisticLockException ? new OptimisticLockingFailureException((Throwable)original) : (original instanceof jakarta.persistence.EntityExistsException ? new EntityExistsException((Throwable)original) : (original instanceof NoResultException ? new EmptyResultException((Throwable)original) : (original instanceof NonUniqueResultException ? new jakarta.data.exceptions.NonUniqueResultException((Throwable)original) : new DataException((Throwable)original))));
            }
        } else {
            Throwable cause;
            x = original instanceof CompletionException ? ((cause = original.getCause()) == null ? new MappingException((Throwable)original) : (DataException.class.equals(cause.getClass()) ? new DataException(cause.getMessage(), (Throwable)original) : (DataConnectionException.class.equals(cause.getClass()) ? new DataConnectionException(cause.getMessage(), (Throwable)original) : (EmptyResultException.class.equals(cause.getClass()) ? new EmptyResultException(cause.getMessage(), (Throwable)original) : (MappingException.class.equals(cause.getClass()) ? new MappingException(cause.getMessage(), (Throwable)original) : (jakarta.data.exceptions.NonUniqueResultException.class.equals(cause.getClass()) ? new jakarta.data.exceptions.NonUniqueResultException(cause.getMessage(), (Throwable)original) : new MappingException((Throwable)original))))))) : (original instanceof IllegalArgumentException ? new MappingException((Throwable)original) : (original instanceof RuntimeException ? ("org.eclipse.persistence.exceptions.DescriptorException".equals(original.getClass().getName()) ? new MappingException((Throwable)original) : (RuntimeException)original) : new DataException((Throwable)original)));
        }
        if (trace && tc.isDebugEnabled()) {
            if (x == original) {
                Tr.debug((TraceComponent)tc, (String)("Failure occurred: " + x.getClass().getName()), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)(original.getClass().getName() + " replaced with " + x.getClass().getName()), (Object[])new Object[0]);
            }
        }
        return x;
    }

    private Object findAndUpdate(Object arg, QueryInfo queryInfo, EntityManager em) throws Exception {
        Object returnValue;
        ArrayList<Object> results;
        if (queryInfo.entityParamType.isArray()) {
            int length = Array.getLength(arg);
            results = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                entity = this.findAndUpdateOne(Array.get(arg, i), queryInfo, em);
                if (entity == null) continue;
                results.add(entity);
            }
        } else {
            arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
            results = new ArrayList();
            if (arg instanceof Iterable) {
                for (Object e : (Iterable)arg) {
                    entity = this.findAndUpdateOne(e, queryInfo, em);
                    if (entity == null) continue;
                    results.add(entity);
                }
            } else {
                results = new ArrayList(1);
                Object entity = this.findAndUpdateOne(arg, queryInfo, em);
                if (entity != null) {
                    results.add(entity);
                }
            }
        }
        em.flush();
        if (queryInfo.entityInfo.recordClass != null) {
            for (int i = 0; i < results.size(); ++i) {
                results.set(i, queryInfo.entityInfo.toRecord(results.get(i)));
            }
        }
        if (queryInfo.returnArrayType != null) {
            Object[] newArray = (Object[])Array.newInstance(queryInfo.returnArrayType, results.size());
            returnValue = results.toArray(newArray);
        } else {
            Class<?> multiType = queryInfo.getMultipleResultType();
            if (multiType == null) {
                returnValue = results.isEmpty() ? null : results.get(0);
            } else if (multiType.isInstance(results)) {
                returnValue = results;
            } else if (Stream.class.equals(multiType)) {
                returnValue = results.stream();
            } else if (Iterable.class.isAssignableFrom(multiType)) {
                returnValue = RepositoryImpl.toIterable(multiType, null, results);
            } else if (Iterator.class.equals(multiType)) {
                returnValue = results.iterator();
            } else {
                throw new UnsupportedOperationException(multiType + " is an unsupported return type.");
            }
        }
        Class<?> returnType = queryInfo.method.getReturnType();
        if (Optional.class.equals(returnType)) {
            returnValue = returnValue == null ? Optional.empty() : Optional.of(returnValue);
        } else if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            returnValue = CompletableFuture.completedFuture(returnValue);
        } else if (returnValue != null && !returnType.isInstance(returnValue)) {
            throw new MappingException("The " + returnType.getName() + " return type of the " + queryInfo.method.getName() + " method of the " + queryInfo.method.getDeclaringClass().getName() + " class is not a valid return type for a repository @Update method.");
        }
        return returnValue;
    }

    private Object findAndUpdateOne(Object e, QueryInfo queryInfo, EntityManager em) throws Exception {
        Object entity;
        List results;
        Object id;
        Class<?> singleType = queryInfo.getSingleResultType();
        String jpql = queryInfo.jpql;
        EntityInfo entityInfo = queryInfo.entityInfo;
        int versionParamIndex = 2;
        Object version = null;
        if (entityInfo.versionAttributeName != null && (version = entityInfo.getAttribute(e, entityInfo.versionAttributeName)) == null) {
            jpql = jpql.replace("=?" + versionParamIndex, " IS NULL");
        }
        if ((id = entityInfo.getAttribute(e, entityInfo.getAttributeName("id", true))) == null) {
            jpql = jpql.replace("=?" + (versionParamIndex - 1), " IS NULL");
            if (version != null) {
                jpql = jpql.replace("=?" + versionParamIndex, "=?" + (versionParamIndex - 1));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && jpql != queryInfo.jpql) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JPQL adjusted for NULL id or version", (Object[])new Object[]{jpql});
        }
        TypedQuery query = em.createQuery(jpql, singleType);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        int p = 0;
        if (entityInfo.idClassAttributeAccessors != null) {
            throw new UnsupportedOperationException();
        }
        if (id != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("set ?" + (p + 1) + " " + id.getClass().getSimpleName()), (Object[])new Object[0]);
            }
            query.setParameter(++p, id);
        }
        if (entityInfo.versionAttributeName != null && version != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("set ?" + (p + 1) + " " + version.getClass().getSimpleName()), (Object[])new Object[0]);
            }
            query.setParameter(++p, version);
        }
        if ((results = query.getResultList()).isEmpty()) {
            entity = null;
        } else {
            entity = results.get(0);
            entity = em.merge(RepositoryImpl.toEntity(e));
        }
        return entity;
    }

    private String generateDeleteById(QueryInfo queryInfo) {
        StringBuilder q;
        EntityInfo entityInfo = queryInfo.entityInfo;
        String o = queryInfo.entityVar;
        if (entityInfo.idClassAttributeAccessors == null) {
            String idAttrName = entityInfo.attributeNames.get("id");
            q = new StringBuilder(24 + entityInfo.name.length() + o.length() * 2 + idAttrName.length()).append("DELETE FROM ").append(entityInfo.name).append(' ').append(o).append(" WHERE ").append(o).append('.').append(idAttrName).append("=?1");
        } else {
            q = new StringBuilder(200).append("DELETE FROM ").append(entityInfo.name).append(' ').append(o).append(" WHERE ");
            int count = 0;
            for (String idClassAttrName : entityInfo.idClassAttributeAccessors.keySet()) {
                if (++count != 1) {
                    q.append(" AND ");
                }
                q.append(o).append('.').append(entityInfo.getAttributeName(idClassAttrName, true)).append("=?").append(count);
            }
        }
        return q.toString();
    }

    private StringBuilder generateDeleteEntity(QueryInfo queryInfo) {
        EntityInfo entityInfo = queryInfo.entityInfo;
        String o = queryInfo.entityVar;
        StringBuilder q = new StringBuilder(100).append("DELETE FROM ").append(entityInfo.name).append(' ').append(o);
        if (queryInfo.method.getParameterCount() == 0) {
            queryInfo.type = QueryInfo.Type.DELETE;
            queryInfo.hasWhere = false;
        } else {
            queryInfo.init(Delete.class, QueryInfo.Type.DELETE_WITH_ENTITY_PARAM);
            queryInfo.hasWhere = true;
            q.append(" WHERE (");
            String idName = entityInfo.getAttributeName("id", true);
            if (idName == null && entityInfo.idClassAttributeAccessors != null) {
                boolean first = true;
                for (String name : entityInfo.idClassAttributeAccessors.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        q.append(" AND ");
                    }
                    name = entityInfo.attributeNames.get(name);
                    q.append(o).append('.').append(name).append("=?").append(++queryInfo.paramCount);
                }
            } else {
                q.append(o).append('.').append(idName).append("=?").append(++queryInfo.paramCount);
            }
            if (entityInfo.versionAttributeName != null) {
                q.append(" AND ").append(o).append('.').append(entityInfo.versionAttributeName).append("=?").append(++queryInfo.paramCount);
            }
            q.append(')');
        }
        return q;
    }

    private void generateCondition(QueryInfo queryInfo, String methodName, int start, int endBefore, StringBuilder q) {
        boolean isCollection;
        Condition negatedCondition;
        int length = endBefore - start;
        Condition condition = Condition.EQUALS;
        switch (methodName.charAt(endBefore - 1)) {
            case 'n': {
                if (length <= 2) break;
                char ch = methodName.charAt(endBefore - 2);
                if (ch == 'a') {
                    if (RepositoryImpl.endsWith("GreaterTh", methodName, start, endBefore - 2)) {
                        condition = Condition.GREATER_THAN;
                        break;
                    }
                    if (!RepositoryImpl.endsWith("LessTh", methodName, start, endBefore - 2)) break;
                    condition = Condition.LESS_THAN;
                    break;
                }
                if (ch == 'I') {
                    condition = Condition.IN;
                    break;
                }
                if (ch != 'e' || !RepositoryImpl.endsWith("Betwe", methodName, start, endBefore - 2)) break;
                condition = Condition.BETWEEN;
                break;
            }
            case 'l': {
                if (length <= 4) break;
                char ch = methodName.charAt(endBefore - 2);
                if (ch == 'a') {
                    if (RepositoryImpl.endsWith("GreaterThanEqu", methodName, start, endBefore - 2)) {
                        condition = Condition.GREATER_THAN_EQUAL;
                        break;
                    }
                    if (!RepositoryImpl.endsWith("LessThanEqu", methodName, start, endBefore - 2)) break;
                    condition = Condition.LESS_THAN_EQUAL;
                    break;
                }
                if (!(ch == 'l' & methodName.charAt(endBefore - 3) == 'u') || methodName.charAt(endBefore - 4) != 'N') break;
                condition = Condition.NULL;
                break;
            }
            case 'e': {
                if (length <= 4) break;
                char ch = methodName.charAt(endBefore - 4);
                if (ch == 'L') {
                    if (methodName.charAt(endBefore - 3) != 'i' || methodName.charAt(endBefore - 2) != 'k') break;
                    condition = Condition.LIKE;
                    break;
                }
                if (ch == 'T') {
                    if (methodName.charAt(endBefore - 3) != 'r' || methodName.charAt(endBefore - 2) != 'u') break;
                    condition = Condition.TRUE;
                    break;
                }
                if (!RepositoryImpl.endsWith("Fals", methodName, start, endBefore - 1)) break;
                condition = Condition.FALSE;
                break;
            }
            case 'h': {
                if (length <= 8) break;
                char ch = methodName.charAt(endBefore - 8);
                if (ch == 'E') {
                    if (!RepositoryImpl.endsWith("ndsWit", methodName, start, endBefore - 1)) break;
                    condition = Condition.ENDS_WITH;
                    break;
                }
                if (endBefore <= 10 || ch != 'a' || !RepositoryImpl.endsWith("StartsWit", methodName, start, endBefore - 1)) break;
                condition = Condition.STARTS_WITH;
                break;
            }
            case 's': {
                if (!RepositoryImpl.endsWith("Contain", methodName, start, endBefore - 1)) break;
                condition = Condition.CONTAINS;
                break;
            }
            case 'y': {
                if (!RepositoryImpl.endsWith("Empt", methodName, start, endBefore - 1)) break;
                condition = Condition.EMPTY;
            }
        }
        boolean negated = RepositoryImpl.endsWith("Not", methodName, start, endBefore -= condition.length);
        int n = negated ? 3 : 0;
        String function = null;
        boolean ignoreCase = false;
        boolean rounded = false;
        switch (methodName.charAt((endBefore -= n) - 1)) {
            case 'e': {
                ignoreCase = RepositoryImpl.endsWith("IgnoreCas", methodName, start, endBefore - 1);
                if (ignoreCase) {
                    function = "LOWER(";
                    endBefore -= 10;
                    break;
                }
                if (RepositoryImpl.endsWith("WithMinut", methodName, start, endBefore - 1)) {
                    function = "EXTRACT (MINUTE FROM ";
                    endBefore -= 10;
                    break;
                }
                if (!RepositoryImpl.endsWith("AbsoluteValu", methodName, start, endBefore - 1)) break;
                function = "ABS(";
                endBefore -= 13;
                break;
            }
            case 'd': {
                rounded = RepositoryImpl.endsWith("Rounde", methodName, start, endBefore - 1);
                if (rounded) {
                    function = "ROUND(";
                    endBefore -= 7;
                    break;
                }
                if (!RepositoryImpl.endsWith("WithSecon", methodName, start, endBefore - 1)) break;
                function = "EXTRACT (SECOND FROM ";
                endBefore -= 10;
                break;
            }
            case 'n': {
                if (!RepositoryImpl.endsWith("RoundedDow", methodName, start, endBefore - 1)) break;
                function = "FLOOR(";
                endBefore -= 11;
                break;
            }
            case 'p': {
                if (!RepositoryImpl.endsWith("RoundedU", methodName, start, endBefore - 1)) break;
                function = "CEILING(";
                endBefore -= 9;
                break;
            }
            case 'r': {
                if (RepositoryImpl.endsWith("WithYea", methodName, start, endBefore - 1)) {
                    function = "EXTRACT (YEAR FROM ";
                    endBefore -= 8;
                    break;
                }
                if (RepositoryImpl.endsWith("WithHou", methodName, start, endBefore - 1)) {
                    function = "EXTRACT (HOUR FROM ";
                    endBefore -= 8;
                    break;
                }
                if (!RepositoryImpl.endsWith("WithQuarte", methodName, start, endBefore - 1)) break;
                function = "EXTRACT (QUARTER FROM ";
                endBefore -= 11;
                break;
            }
            case 't': {
                if (RepositoryImpl.endsWith("CharCoun", methodName, start, endBefore - 1)) {
                    function = "LENGTH(";
                    endBefore -= 9;
                    break;
                }
                if (!RepositoryImpl.endsWith("ElementCoun", methodName, start, endBefore - 1)) break;
                function = "SIZE(";
                endBefore -= 12;
                break;
            }
            case 'y': {
                if (!RepositoryImpl.endsWith("WithDa", methodName, start, endBefore - 1)) break;
                function = "EXTRACT (DAY FROM ";
                endBefore -= 7;
                break;
            }
            case 'h': {
                if (!RepositoryImpl.endsWith("WithMont", methodName, start, endBefore - 1)) break;
                function = "EXTRACT (MONTH FROM ";
                endBefore -= 9;
                break;
            }
            case 'k': {
                if (!RepositoryImpl.endsWith("WithWee", methodName, start, endBefore - 1)) break;
                function = "EXTRACT (WEEK FROM ";
                endBefore -= 8;
            }
        }
        boolean trimmed = RepositoryImpl.endsWith("Trimmed", methodName, start, endBefore);
        String attribute = methodName.substring(start, endBefore -= trimmed ? 7 : 0);
        if (attribute.length() == 0) {
            throw new MappingException("Entity property name is missing.");
        }
        String name = queryInfo.entityInfo.getAttributeName(attribute, true);
        if (name == null) {
            if (attribute.length() == 3) {
                int len = q.length();
                int where = q.lastIndexOf(" WHERE (");
                if (where + 8 == len) {
                    q.delete(where, len);
                }
                queryInfo.hasWhere = false;
            } else if (queryInfo.entityInfo.idClassAttributeAccessors != null && attribute.equalsIgnoreCase("id")) {
                this.generateConditionsForIdClass(queryInfo, condition, ignoreCase, negated, q);
            }
            return;
        }
        StringBuilder attributeExpr = new StringBuilder();
        if (function != null) {
            attributeExpr.append(function);
        }
        if (trimmed) {
            attributeExpr.append("TRIM(");
        }
        String o = queryInfo.entityVar;
        attributeExpr.append(o).append('.').append(name);
        if (trimmed) {
            attributeExpr.append(')');
        }
        if (function != null) {
            if (rounded) {
                attributeExpr.append(", 0)");
            } else {
                attributeExpr.append(')');
            }
        }
        if (negated && (negatedCondition = condition.negate()) != null) {
            condition = negatedCondition;
            negated = false;
        }
        if (isCollection = queryInfo.entityInfo.collectionElementTypes.containsKey(name)) {
            condition.verifyCollectionsSupported(name, ignoreCase);
        }
        switch (condition) {
            case STARTS_WITH: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE CONCAT(");
                RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount).append(", '%')");
                break;
            }
            case ENDS_WITH: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE CONCAT('%', ");
                RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount).append(")");
                break;
            }
            case LIKE: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE ");
                RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount);
                break;
            }
            case BETWEEN: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("BETWEEN ");
                RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount).append(" AND ");
                RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount);
                break;
            }
            case CONTAINS: {
                if (isCollection) {
                    q.append(" ?").append(++queryInfo.paramCount).append(negated ? " NOT " : " ").append("MEMBER OF ").append((CharSequence)attributeExpr);
                    break;
                }
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : " ").append("LIKE CONCAT('%', ");
                RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount).append(", '%')");
                break;
            }
            case NULL: 
            case NOT_NULL: 
            case TRUE: 
            case FALSE: {
                q.append((CharSequence)attributeExpr).append(condition.operator);
                break;
            }
            case EMPTY: {
                q.append((CharSequence)attributeExpr).append(isCollection ? Condition.EMPTY.operator : Condition.NULL.operator);
                break;
            }
            case NOT_EMPTY: {
                q.append((CharSequence)attributeExpr).append(isCollection ? Condition.NOT_EMPTY.operator : Condition.NOT_NULL.operator);
                break;
            }
            case IN: {
                if (ignoreCase) {
                    throw new MappingException((Throwable)new UnsupportedOperationException("Repository keyword IgnoreCase cannot be combined with the In keyword."));
                }
            }
            default: {
                q.append((CharSequence)attributeExpr).append(negated ? " NOT " : "").append(condition.operator);
                RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount);
            }
        }
    }

    private void generateConditionsForIdClass(QueryInfo queryInfo, Condition condition, boolean ignoreCase, boolean negate, StringBuilder q) {
        String o = queryInfo.entityVar;
        q.append(negate ? "NOT (" : "(");
        int count = 0;
        block5: for (String idClassAttr : queryInfo.entityInfo.idClassAttributeAccessors.keySet()) {
            if (++count != 1) {
                q.append(" AND ");
            }
            String name = queryInfo.entityInfo.getAttributeName(idClassAttr, true);
            if (ignoreCase) {
                q.append("LOWER(").append(o).append('.').append(name).append(')');
            } else {
                q.append(o).append('.').append(name);
            }
            switch (condition) {
                case EQUALS: 
                case NOT_EQUALS: {
                    q.append(condition.operator);
                    RepositoryImpl.appendParam(q, ignoreCase, ++queryInfo.paramCount);
                    if (count == 1) continue block5;
                    ++queryInfo.paramAddedCount;
                    continue block5;
                }
                case NULL: 
                case EMPTY: {
                    q.append(Condition.NULL.operator);
                    continue block5;
                }
                case NOT_NULL: 
                case NOT_EMPTY: {
                    q.append(Condition.NOT_NULL.operator);
                    continue block5;
                }
            }
            throw new MappingException("Repository keyword " + condition.name() + " cannot be used when the Id of the entity is an IdClass.");
        }
        q.append(')');
    }

    private int generateConditionsForIdClass(QueryInfo queryInfo, ParamInfo paramInfo, int qp, StringBuilder q) {
        if (paramInfo.comparisonAnno != null && !(paramInfo.comparisonAnno instanceof Assign)) {
            throw new MappingException("The " + paramInfo.comparisonAnno.annotationType().getSimpleName() + " annotation cannot be applied to a parameter of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository because the parameter type is an IdClass.");
        }
        boolean ignoreCase = false;
        if (paramInfo.functionAnnos != null) {
            ListIterator<Annotation> fn = paramInfo.functionAnnos.listIterator(paramInfo.functionAnnos.size());
            while (fn.hasPrevious()) {
                Annotation anno = fn.previous();
                if (anno instanceof IgnoreCase) {
                    ignoreCase = true;
                    continue;
                }
                if (anno instanceof Not) {
                    q.append(" NOT ");
                    continue;
                }
                throw new MappingException("The " + anno.annotationType().getSimpleName() + " annotation cannot be applied to a parameter of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository because the parameter type is an IdClass.");
            }
        }
        q.append('(');
        String o = queryInfo.entityVar;
        int count = 0;
        for (String idClassAttr : queryInfo.entityInfo.idClassAttributeAccessors.keySet()) {
            if (count != 0) {
                q.append(" AND ");
            }
            String name = queryInfo.entityInfo.getAttributeName(idClassAttr, true);
            if (ignoreCase) {
                q.append("LOWER(").append(o).append('.').append(name).append(')');
            } else {
                q.append(o).append('.').append(name);
            }
            q.append('=');
            RepositoryImpl.appendParam(q, ignoreCase, count++ + qp);
        }
        q.append(')');
        queryInfo.paramCount += count;
        queryInfo.paramAddedCount += count - 1;
        return count - 1;
    }

    private void generateCount(QueryInfo queryInfo, String where) {
        String o = queryInfo.entityVar;
        StringBuilder q = new StringBuilder(21 + 2 * o.length() + queryInfo.entityInfo.name.length() + (where == null ? 0 : where.length())).append("SELECT COUNT(").append(o).append(") FROM ").append(queryInfo.entityInfo.name).append(' ').append(o);
        if (where != null) {
            q.append(where);
        }
        queryInfo.jpqlCount = q.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringBuilder generateFromParameters(QueryInfo queryInfo, StringBuilder q, Annotation methodAnno, boolean countPages, boolean hasUpdateParam, ParamInfo[] allParamInfo) {
        String name;
        ParamInfo paramInfo;
        int p;
        int qp;
        int numAttributeParams;
        String o = queryInfo.entityVar;
        Boolean isNamePresent = null;
        Parameter[] params = null;
        Class<?>[] paramTypes = queryInfo.method.getParameterTypes();
        for (numAttributeParams = paramTypes.length; numAttributeParams > 0 && SPECIAL_PARAM_TYPES.contains(paramTypes[numAttributeParams - 1]); --numAttributeParams) {
        }
        if (numAttributeParams < paramTypes.length && !(methodAnno instanceof Delete) && (methodAnno != null || hasUpdateParam)) {
            String string;
            String string2 = queryInfo.method.getName();
            String string3 = this.repositoryInterface.getName();
            if (methodAnno == null) {
                string = "Update";
                throw new MappingException("The special parameter types " + SPECIAL_PARAM_TYPES + " must not be used on the " + string2 + " method of the " + string3 + " repository because the repository method is a " + string + " operation.");
            }
            string = methodAnno.annotationType().getSimpleName();
            throw new MappingException("The special parameter types " + SPECIAL_PARAM_TYPES + " must not be used on the " + string2 + " method of the " + string3 + " repository because the repository method is a " + string + " operation.");
        }
        if (queryInfo.entityInfo.idClassAttributeAccessors != null) {
            for (int p2 = 0; p2 < numAttributeParams; ++p2) {
                if (!paramTypes[p2].equals(queryInfo.entityInfo.idType)) continue;
                if (allParamInfo[p2] == null) {
                    allParamInfo[p2] = new ParamInfo();
                }
                allParamInfo[p2].isIdClass = true;
            }
        }
        if (q == null) {
            if (!hasUpdateParam) {
                queryInfo.type = QueryInfo.Type.FIND;
                q = this.generateSelectClause(queryInfo, queryInfo.method.getAnnotation(Select.class), new String[0]);
            } else {
                queryInfo.type = QueryInfo.Type.UPDATE;
                q = new StringBuilder(250).append("UPDATE ").append(queryInfo.entityInfo.name).append(' ').append(o).append(" SET");
                boolean first = true;
                qp = 1;
                for (p = 0; p < numAttributeParams; ++p, ++qp) {
                    char op;
                    String attribute;
                    paramInfo = allParamInfo[p];
                    if (paramInfo == null) continue;
                    if (paramInfo.isIdClass) {
                        if (paramInfo.updateAnno != null) {
                            if (!(paramInfo.updateAnno instanceof Assign)) throw new MappingException("The " + paramInfo.updateAnno.annotationType().getName() + " annotation cannot be used on parameter " + (p + 1) + " of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository when the Id is an IdClass.");
                            throw new UnsupportedOperationException("@Assign IdClass");
                        }
                        qp += queryInfo.entityInfo.idClassAttributeAccessors.size() - 1;
                        continue;
                    }
                    if (paramInfo.updateAnno == null) continue;
                    Annotation anno = paramInfo.updateAnno;
                    if (anno instanceof Assign) {
                        attribute = ((Assign)anno).value();
                        op = '=';
                    } else if (anno instanceof Add) {
                        attribute = ((Add)anno).value();
                        op = '+';
                    } else if (anno instanceof Multiply) {
                        attribute = ((Multiply)anno).value();
                        op = '*';
                    } else if (anno instanceof Divide) {
                        attribute = ((Divide)anno).value();
                        op = '/';
                    } else {
                        if (!(anno instanceof SubtractFrom)) throw new UnsupportedOperationException(anno.toString());
                        attribute = ((SubtractFrom)anno).value();
                        op = '-';
                    }
                    if ("".equals(attribute)) {
                        if (isNamePresent == null) {
                            params = queryInfo.method.getParameters();
                            isNamePresent = params[p].isNamePresent();
                        }
                        if (!Boolean.TRUE.equals(isNamePresent)) throw new MappingException("You must specify an entity attribute name as the value of the " + anno.annotationType().getName() + " annotation on parameter " + (p + 1) + " of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository or compile the application with the -parameters compiler option that preserves the parameter names.");
                        attribute = params[p].getName();
                    }
                    name = queryInfo.entityInfo.getAttributeName(attribute, true);
                    q.append(first ? " " : ", ").append(o).append('.').append(name).append("=");
                    first = false;
                    boolean withFunction = false;
                    switch (op) {
                        case '=': {
                            break;
                        }
                        case '+': {
                            withFunction = CharSequence.class.isAssignableFrom((Class)queryInfo.entityInfo.attributeTypes.get(name));
                            if (withFunction) {
                                q.append("CONCAT(").append(o).append('.').append(name).append(',');
                                break;
                            }
                            q.append(o).append('.').append(name).append('+');
                            break;
                        }
                        default: {
                            q.append(o).append('.').append(name).append(op);
                        }
                    }
                    ++queryInfo.paramCount;
                    q.append('?').append(qp);
                    if (!withFunction) continue;
                    q.append(')');
                }
            }
        }
        int startIndexForWhereClause = q.length();
        p = 0;
        qp = 1;
        while (true) {
            block61: {
                boolean isCollection;
                StringBuilder attributeExpr;
                boolean ignoreCase;
                String attribute;
                block65: {
                    ListIterator<Annotation> fn;
                    block66: {
                        block62: {
                            block63: {
                                block64: {
                                    if (p >= numAttributeParams) break block62;
                                    paramInfo = allParamInfo[p];
                                    if (paramInfo != null && paramInfo.updateAnno != null) break block63;
                                    if (queryInfo.hasWhere) {
                                        q.append(paramInfo != null && paramInfo.or ? " OR " : " AND ");
                                    } else {
                                        q.append(" WHERE (");
                                        queryInfo.hasWhere = true;
                                    }
                                    String string = attribute = paramInfo == null ? null : paramInfo.byAttribute;
                                    if (attribute == null) {
                                        if (isNamePresent == null) {
                                            params = queryInfo.method.getParameters();
                                            isNamePresent = params[p].isNamePresent();
                                        }
                                        if (!Boolean.TRUE.equals(isNamePresent)) throw new MappingException("You must specify an entity attribute name as the value of the " + By.class.getName() + " annotation on parameter " + (p + 1) + " of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository or compile the application with the -parameters compiler option that preserves the parameter names.");
                                        attribute = params[p].getName();
                                    }
                                    if (paramInfo == null || !paramInfo.isIdClass) break block64;
                                    qp += this.generateConditionsForIdClass(queryInfo, paramInfo, qp, q);
                                    break block61;
                                }
                                ignoreCase = false;
                                attributeExpr = new StringBuilder();
                                if (paramInfo == null || paramInfo.functionAnnos == null) break block65;
                                fn = paramInfo.functionAnnos.listIterator(paramInfo.functionAnnos.size());
                                break block66;
                            }
                            if (paramInfo.isIdClass) {
                                qp += queryInfo.entityInfo.idClassAttributeAccessors.size() - 1;
                            }
                            break block61;
                        }
                        if (queryInfo.hasWhere) {
                            q.append(')');
                        }
                        if (!countPages) return q;
                        if (queryInfo.type != QueryInfo.Type.FIND) return q;
                        this.generateCount(queryInfo, numAttributeParams == 0 ? null : q.substring(startIndexForWhereClause));
                        return q;
                    }
                    while (fn.hasPrevious()) {
                        Annotation anno = fn.previous();
                        ignoreCase |= anno instanceof IgnoreCase;
                        String functionType = anno instanceof Extract ? ((Extract)anno).value().name() : (anno instanceof Rounded ? ((Rounded)anno).value().name() : anno.annotationType().getSimpleName());
                        String functionCall = FUNCTION_CALLS.get(functionType);
                        if (functionCall == null) {
                            throw new UnsupportedOperationException(anno.toString());
                        }
                        attributeExpr.append(functionCall);
                    }
                }
                name = queryInfo.entityInfo.getAttributeName(attribute, true);
                attributeExpr.append(o).append('.').append(name);
                if (paramInfo != null && paramInfo.functionAnnos != null) {
                    for (Annotation anno : paramInfo.functionAnnos) {
                        if (anno instanceof Rounded && ((Rounded)anno).value() == Rounded.Direction.NEAREST) {
                            attributeExpr.append(", 0)");
                            continue;
                        }
                        attributeExpr.append(')');
                    }
                }
                if (isCollection = queryInfo.entityInfo.collectionElementTypes.containsKey(name)) {
                    RepositoryImpl.verifyCollectionsSupported(name, ignoreCase, paramInfo == null ? null : paramInfo.comparisonAnno);
                }
                ++queryInfo.paramCount;
                if (paramInfo == null || paramInfo.comparisonAnno == null) {
                    q.append((CharSequence)attributeExpr).append('=');
                    RepositoryImpl.appendParam(q, ignoreCase, qp);
                } else if (paramInfo.comparisonAnno instanceof GreaterThan) {
                    q.append((CharSequence)attributeExpr).append('>');
                    RepositoryImpl.appendParam(q, ignoreCase, qp);
                } else if (paramInfo.comparisonAnno instanceof GreaterThanEqual) {
                    q.append((CharSequence)attributeExpr).append(">=");
                    RepositoryImpl.appendParam(q, ignoreCase, qp);
                } else if (paramInfo.comparisonAnno instanceof LessThan) {
                    q.append((CharSequence)attributeExpr).append('<');
                    RepositoryImpl.appendParam(q, ignoreCase, qp);
                } else if (paramInfo.comparisonAnno instanceof LessThanEqual) {
                    q.append((CharSequence)attributeExpr).append("<=");
                    RepositoryImpl.appendParam(q, ignoreCase, qp);
                } else if (paramInfo.comparisonAnno instanceof Contains) {
                    if (isCollection) {
                        q.append(" ?").append(qp).append(" MEMBER OF ").append((CharSequence)attributeExpr);
                    } else {
                        q.append((CharSequence)attributeExpr).append(" LIKE CONCAT('%', ");
                        RepositoryImpl.appendParam(q, ignoreCase, qp).append(", '%')");
                    }
                } else if (paramInfo.comparisonAnno instanceof Like) {
                    q.append((CharSequence)attributeExpr).append(" LIKE ");
                    RepositoryImpl.appendParam(q, ignoreCase, qp);
                } else if (paramInfo.comparisonAnno instanceof StartsWith) {
                    q.append((CharSequence)attributeExpr).append(" LIKE CONCAT(");
                    RepositoryImpl.appendParam(q, ignoreCase, qp).append(", '%')");
                } else if (paramInfo.comparisonAnno instanceof EndsWith) {
                    q.append((CharSequence)attributeExpr).append(" LIKE CONCAT('%', ");
                    RepositoryImpl.appendParam(q, ignoreCase, qp).append(')');
                } else {
                    if (!(paramInfo.comparisonAnno instanceof In)) throw new UnsupportedOperationException(paramInfo.comparisonAnno.annotationType().toString());
                    if (ignoreCase) {
                        throw new MappingException("The " + Set.of("IgnoreCase", "In") + " annotations cannot be combined on parameter " + (p + 1) + " of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository.");
                    }
                    q.append((CharSequence)attributeExpr).append(" IN ");
                    RepositoryImpl.appendParam(q, ignoreCase, qp);
                }
            }
            ++p;
            ++qp;
        }
    }

    private void generateKeysetQueries(QueryInfo queryInfo, StringBuilder q, StringBuilder fwd, StringBuilder prev) {
        StringBuilder a;
        String paramPrefix;
        int numKeys = queryInfo.sorts.size();
        String string = paramPrefix = queryInfo.paramNames == null ? "?" : ":keyset";
        StringBuilder stringBuilder = fwd == null ? null : (a = new StringBuilder(200).append(queryInfo.hasWhere ? " AND (" : " WHERE ("));
        StringBuilder b = prev == null ? null : new StringBuilder(200).append(queryInfo.hasWhere ? " AND (" : " WHERE (");
        String o = queryInfo.entityVar;
        for (int i = 0; i < numKeys; ++i) {
            if (a != null) {
                a.append(i == 0 ? "(" : " OR (");
            }
            if (b != null) {
                b.append(i == 0 ? "(" : " OR (");
            }
            for (int k = 0; k <= i; ++k) {
                Sort keyInfo = queryInfo.sorts.get(k);
                String name = keyInfo.property();
                boolean asc = keyInfo.isAscending();
                boolean lower = keyInfo.ignoreCase();
                if (a != null) {
                    if (lower) {
                        a.append(k == 0 ? "LOWER(" : " AND LOWER(").append(o).append('.').append(name).append(')');
                        a.append((char)(k < i ? 61 : (asc ? 62 : 60)));
                        a.append("LOWER(").append(paramPrefix).append(queryInfo.paramCount + 1 + k).append(')');
                    } else {
                        a.append(k == 0 ? "" : " AND ").append(o).append('.').append(name);
                        a.append((char)(k < i ? 61 : (asc ? 62 : 60)));
                        a.append(paramPrefix).append(queryInfo.paramCount + 1 + k);
                    }
                }
                if (b == null) continue;
                if (lower) {
                    b.append(k == 0 ? "LOWER(" : " AND LOWER(").append(o).append('.').append(name).append(')');
                    b.append((char)(k < i ? 61 : (asc ? 60 : 62)));
                    b.append("LOWER(").append(paramPrefix).append(queryInfo.paramCount + 1 + k).append(')');
                    continue;
                }
                b.append(k == 0 ? "" : " AND ").append(o).append('.').append(name);
                b.append((char)(k < i ? 61 : (asc ? 60 : 62)));
                b.append(paramPrefix).append(queryInfo.paramCount + 1 + k);
            }
            if (a != null) {
                a.append(')');
            }
            if (b == null) continue;
            b.append(')');
        }
        if (a != null) {
            queryInfo.jpqlAfterKeyset = new StringBuilder(q).append((CharSequence)a).append(')').append((CharSequence)fwd).toString();
        }
        if (b != null) {
            queryInfo.jpqlBeforeKeyset = new StringBuilder(q).append((CharSequence)b).append(')').append((CharSequence)prev).toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"forward & previous keyset queries", (Object[])new Object[]{queryInfo.jpqlAfterKeyset, queryInfo.jpqlBeforeKeyset});
        }
    }

    private void generateOrderBy(QueryInfo queryInfo, StringBuilder q) {
        Class<?> multiType = queryInfo.getMultipleResultType();
        boolean needsKeysetQueries = KeysetAwarePage.class.equals(multiType) || KeysetAwareSlice.class.equals(multiType) || Iterator.class.equals(multiType);
        StringBuilder fwd = needsKeysetQueries ? new StringBuilder(100) : q;
        StringBuilder prev = needsKeysetQueries ? new StringBuilder(100) : null;
        boolean first = true;
        for (Sort sort : queryInfo.sorts) {
            fwd.append(first ? " ORDER BY " : ", ");
            this.appendSort(fwd, queryInfo.entityVar, sort, true);
            if (needsKeysetQueries) {
                prev.append(first ? " ORDER BY " : ", ");
                this.appendSort(prev, queryInfo.entityVar, sort, false);
            }
            first = false;
        }
        if (needsKeysetQueries) {
            this.generateKeysetQueries(queryInfo, q, fwd, prev);
            q.append((CharSequence)fwd);
        }
    }

    private StringBuilder generateQueryFromMethod(QueryInfo queryInfo, Annotation methodTypeAnno, boolean countPages) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        EntityInfo entityInfo = queryInfo.entityInfo;
        String methodName = queryInfo.method.getName();
        String o = queryInfo.entityVar;
        StringBuilder q = null;
        boolean isParameterBased = methodTypeAnno != null;
        boolean hasUpdateParam = false;
        Annotation[][] annosForAllParams = queryInfo.method.getParameterAnnotations();
        ParamInfo[] allParamInfo = annosForAllParams.length == 0 ? null : new ParamInfo[annosForAllParams.length];
        for (int p = 0; p < annosForAllParams.length; ++p) {
            if (annosForAllParams[p].length <= 0) continue;
            ParamInfo paramInfo = null;
            for (Annotation anno : annosForAllParams[p]) {
                if (anno instanceof By) {
                    paramInfo = paramInfo == null ? new ParamInfo() : paramInfo;
                    paramInfo.byAttribute = ((By)anno).value();
                    continue;
                }
                if (anno instanceof Or) {
                    paramInfo = paramInfo == null ? new ParamInfo() : paramInfo;
                    paramInfo.or = true;
                    continue;
                }
                String packageName = anno.annotationType().getPackageName();
                if (COMPARISON_ANNO_PACKAGE.equals(packageName)) {
                    ParamInfo paramInfo2 = paramInfo = paramInfo == null ? new ParamInfo() : paramInfo;
                    if (paramInfo.comparisonAnno == null) {
                        paramInfo.comparisonAnno = anno;
                        continue;
                    }
                    throw new MappingException("The " + Set.of(paramInfo.comparisonAnno, anno) + " annotations cannot be combined on parameter " + (p + 1) + " of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository.");
                }
                if (FUNCTION_ANNO_PACKAGE.equals(packageName)) {
                    paramInfo = paramInfo == null ? new ParamInfo() : paramInfo;
                    paramInfo.addFunctionAnnotation(anno);
                    continue;
                }
                if (!UPDATE_ANNO_PACKAGE.equals(packageName)) continue;
                paramInfo = paramInfo == null ? new ParamInfo() : paramInfo;
                hasUpdateParam = true;
                if (paramInfo.updateAnno == null) {
                    paramInfo.updateAnno = anno;
                    continue;
                }
                throw new MappingException("The " + Set.of(paramInfo.updateAnno, anno) + " annotations cannot be combined on parameter " + (p + 1) + " of the " + queryInfo.method.getName() + " method of the " + this.repositoryInterface.getName() + " repository.");
            }
            allParamInfo[p] = paramInfo;
            isParameterBased |= paramInfo != null;
        }
        if (methodTypeAnno instanceof Update) {
            if (!hasUpdateParam) {
                throw new MappingException("Because the " + methodName + " method of the " + this.repositoryInterface.getName() + " repository is an update operation, it must have either a single parameter that is the entity type or an Iterable, Stream, or array of entity, Or it must have at least one parameter that is annotated with one of " + List.of(Assign.class, Add.class, Multiply.class, Divide.class) + ".");
            }
        } else if (methodTypeAnno != null && hasUpdateParam) {
            throw new MappingException("Parameters of the " + methodName + " method of the " + this.repositoryInterface.getName() + " repository must not be annotated with annotations from the " + UPDATE_ANNO_PACKAGE + " package because the repository method is not an update method.");
        }
        int by = isParameterBased ? -1 : methodName.indexOf("By");
        boolean bl = isParameterBased = by < 4;
        if (!isParameterBased) {
            if (methodName.startsWith("find")) {
                Select select = queryInfo.method.getAnnotation(Select.class);
                ArrayList<String> selections = select == null ? new ArrayList<String>() : null;
                int c = by + 2;
                this.parseFindBy(queryInfo, methodName, by, selections);
                q = this.generateSelectClause(queryInfo, select, selections == null ? null : selections.toArray(new String[selections.size()]));
                int orderBy = methodName.indexOf("OrderBy", by + 2);
                if (orderBy > c || orderBy == -1 && methodName.length() > c) {
                    int where = q.length();
                    this.generateWhereClause(queryInfo, methodName, c, orderBy > 0 ? orderBy : methodName.length(), q);
                    if (countPages) {
                        this.generateCount(queryInfo, q.substring(where));
                    }
                }
                if (orderBy >= c) {
                    this.parseOrderBy(queryInfo, orderBy, q);
                }
                queryInfo.type = QueryInfo.Type.FIND;
            } else if (methodName.startsWith("delete") || methodName.startsWith("remove")) {
                int orderBy;
                int c = by + 2;
                boolean isFindAndDelete = queryInfo.isFindAndDelete();
                if (isFindAndDelete) {
                    if (queryInfo.type != null) {
                        throw new UnsupportedOperationException("The " + queryInfo.method.getGenericReturnType() + " return type is not supported for the " + methodName + " repository method.");
                    }
                    queryInfo.type = QueryInfo.Type.FIND_AND_DELETE;
                    this.parseDeleteBy(queryInfo, by);
                    Select select = null;
                    q = this.generateSelectClause(queryInfo, select, new String[0]);
                    queryInfo.jpqlDelete = this.generateDeleteById(queryInfo);
                } else {
                    queryInfo.type = queryInfo.type == null ? QueryInfo.Type.DELETE : queryInfo.type;
                    q = new StringBuilder(150).append("DELETE FROM ").append(entityInfo.name).append(' ').append(o);
                }
                int n = orderBy = isFindAndDelete && by > 0 ? methodName.indexOf("OrderBy", by + 2) : -1;
                if (orderBy > c || orderBy == -1 && methodName.length() > c) {
                    this.generateWhereClause(queryInfo, methodName, c, orderBy > 0 ? orderBy : methodName.length(), q);
                }
                if (orderBy >= c) {
                    this.parseOrderBy(queryInfo, orderBy, q);
                }
                queryInfo.type = queryInfo.type == null ? QueryInfo.Type.DELETE : queryInfo.type;
            } else if (methodName.startsWith("update")) {
                q = this.generateUpdateClause(queryInfo, methodName, by + 2);
                queryInfo.type = QueryInfo.Type.UPDATE;
            } else if (methodName.startsWith("count")) {
                int c = by + 2;
                q = new StringBuilder(150).append("SELECT COUNT(").append(o).append(") FROM ").append(entityInfo.name).append(' ').append(o);
                if (methodName.length() > c) {
                    this.generateWhereClause(queryInfo, methodName, c, methodName.length(), q);
                }
                queryInfo.type = QueryInfo.Type.COUNT;
            } else if (methodName.startsWith("exists")) {
                int c = by + 2;
                String name = entityInfo.idClassAttributeAccessors == null ? "id" : entityInfo.idClassAttributeAccessors.firstKey();
                String attrName = entityInfo.getAttributeName(name, true);
                q = new StringBuilder(200).append("SELECT ").append(o).append('.').append(attrName).append(" FROM ").append(entityInfo.name).append(' ').append(o);
                if (methodName.length() > c) {
                    this.generateWhereClause(queryInfo, methodName, c, methodName.length(), q);
                }
                queryInfo.type = QueryInfo.Type.EXISTS;
            } else {
                isParameterBased = true;
            }
        }
        if (isParameterBased) {
            if (methodTypeAnno instanceof Delete || BasicRepository.class.equals(queryInfo.method.getDeclaringClass()) && methodName.equals("deleteAll")) {
                if (queryInfo.isFindAndDelete()) {
                    queryInfo.type = QueryInfo.Type.FIND_AND_DELETE;
                    q = this.generateSelectClause(queryInfo, null, new String[0]);
                    queryInfo.jpqlDelete = this.generateDeleteById(queryInfo);
                } else {
                    queryInfo.type = QueryInfo.Type.DELETE;
                    q = new StringBuilder(150).append("DELETE FROM ").append(entityInfo.name).append(' ').append(o);
                }
                if (queryInfo.method.getParameterCount() > 0) {
                    this.generateFromParameters(queryInfo, q, methodTypeAnno, countPages, hasUpdateParam, allParamInfo);
                }
            } else if (methodTypeAnno instanceof Count || BasicRepository.class.equals(queryInfo.method.getDeclaringClass()) && methodName.equals("count")) {
                queryInfo.type = QueryInfo.Type.COUNT;
                q = new StringBuilder(150).append("SELECT COUNT(").append(o).append(") FROM ").append(entityInfo.name).append(' ').append(o);
                if (queryInfo.method.getParameterCount() > 0) {
                    this.generateFromParameters(queryInfo, q, methodTypeAnno, countPages, hasUpdateParam, allParamInfo);
                }
            } else if (methodTypeAnno instanceof Exists) {
                queryInfo.type = QueryInfo.Type.EXISTS;
                String name = entityInfo.idClassAttributeAccessors == null ? "id" : entityInfo.idClassAttributeAccessors.firstKey();
                String attrName = entityInfo.getAttributeName(name, true);
                q = new StringBuilder(200).append("SELECT ").append(o).append('.').append(attrName).append(" FROM ").append(entityInfo.name).append(' ').append(o);
                if (queryInfo.method.getParameterCount() > 0) {
                    this.generateFromParameters(queryInfo, q, methodTypeAnno, countPages, hasUpdateParam, allParamInfo);
                }
            } else {
                q = this.generateFromParameters(queryInfo, null, methodTypeAnno, countPages, hasUpdateParam, allParamInfo);
            }
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(queryInfo.method.getName() + " is identified as a " + queryInfo.type + " method"), (Object[])new Object[0]);
        }
        return q;
    }

    private StringBuilder generateSelectClause(QueryInfo queryInfo, Select select, String ... selections) {
        String[] cols;
        String function;
        StringBuilder q = new StringBuilder(200);
        String o = queryInfo.entityVar;
        EntityInfo entityInfo = queryInfo.entityInfo;
        boolean distinct = select != null && select.distinct();
        String string = function = select == null ? null : RepositoryImpl.toFunctionName(select.function());
        if (select == null) {
            cols = selections;
        } else {
            selections = select.value();
            cols = new String[selections == null ? 0 : selections.length];
            for (int i = 0; i < cols.length; ++i) {
                String name = entityInfo.getAttributeName(selections[i], true);
                cols[i] = name == null ? selections[i] : name;
            }
        }
        Class<?> singleType = queryInfo.getSingleResultType();
        if (singleType.isPrimitive()) {
            singleType = QueryInfo.wrapperClassIfPrimitive(singleType);
        }
        q.append("SELECT ");
        if (cols == null || cols.length == 0) {
            if (singleType.isAssignableFrom(entityInfo.entityClass) || entityInfo.inheritance && entityInfo.entityClass.isAssignableFrom(singleType)) {
                q.append(distinct ? "DISTINCT " : "").append(o);
            } else {
                String singleAttributeName = null;
                for (Map.Entry<String, Class<?>> entry : entityInfo.attributeTypes.entrySet()) {
                    Class<?> attributeType;
                    Class<?> collectionElementType = entityInfo.collectionElementTypes.get(entry.getKey());
                    Class<?> clazz = attributeType = collectionElementType == null ? entry.getValue() : collectionElementType;
                    if (attributeType.isPrimitive()) {
                        attributeType = QueryInfo.wrapperClassIfPrimitive(attributeType);
                    }
                    if (!singleType.isAssignableFrom(attributeType)) continue;
                    singleAttributeName = entry.getKey();
                    q.append(distinct ? "DISTINCT " : "").append(o).append('.').append(singleAttributeName);
                    break;
                }
                if (singleAttributeName == null) {
                    q.append("NEW ").append(singleType.getName()).append('(');
                    boolean first = true;
                    if (entityInfo.idClassAttributeAccessors != null && singleType.equals(entityInfo.idType)) {
                        for (String idClassAttributeName : entityInfo.idClassAttributeAccessors.keySet()) {
                            String name = entityInfo.getAttributeName(idClassAttributeName, true);
                            this.generateSelectExpression(q, first, function, distinct, o, name);
                            first = false;
                        }
                    } else {
                        List<String> relAttrNames = entityInfo.relationAttributeNames.get(singleType);
                        if (relAttrNames != null) {
                            for (String name : relAttrNames) {
                                this.generateSelectExpression(q, first, function, distinct, o, name);
                                first = false;
                            }
                        } else if (entityInfo.recordClass == null) {
                            for (String name : entityInfo.attributeTypes.keySet()) {
                                this.generateSelectExpression(q, first, function, distinct, o, name);
                                first = false;
                            }
                        } else {
                            for (RecordComponent component : entityInfo.recordClass.getRecordComponents()) {
                                String name = component.getName();
                                this.generateSelectExpression(q, first, function, distinct, o, name);
                                first = false;
                            }
                        }
                    }
                    q.append(')');
                }
            }
        } else {
            boolean selectAsColumns;
            Class<?> entityType = entityInfo.getType();
            boolean bl = selectAsColumns = singleType.isAssignableFrom(entityType) || singleType.isInterface() || singleType.isPrimitive() || singleType.getName().startsWith("java") || entityInfo.inheritance && entityType.isAssignableFrom(singleType);
            if (!selectAsColumns && cols.length == 1) {
                String singleAttributeName = cols[0];
                Class attributeType = entityInfo.collectionElementTypes.get(singleAttributeName);
                if (attributeType == null) {
                    attributeType = (Class)entityInfo.attributeTypes.get(singleAttributeName);
                }
                boolean bl2 = selectAsColumns = attributeType != null && (Object.class.equals(attributeType) || singleType.isAssignableFrom(attributeType));
            }
            if (selectAsColumns) {
                for (int i = 0; i < cols.length; ++i) {
                    this.generateSelectExpression(q, i == 0, function, distinct, o, cols[i]);
                }
            } else {
                q.append("NEW ").append(singleType.getName()).append('(');
                for (int i = 0; i < cols.length; ++i) {
                    this.generateSelectExpression(q, i == 0, function, distinct, o, cols[i]);
                }
                q.append(')');
            }
        }
        q.append(" FROM ").append(entityInfo.name).append(' ').append(o);
        return q;
    }

    private void generateSelectExpression(StringBuilder q, boolean isFirst, String function, boolean distinct, String o, String attributeName) {
        if (!isFirst) {
            q.append(", ");
        }
        if (function != null) {
            q.append(function).append('(');
        }
        q.append(distinct ? "DISTINCT " : "");
        q.append(o).append('.').append(attributeName);
        if (function != null) {
            q.append(')');
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private StringBuilder generateUpdateClause(QueryInfo queryInfo, String methodName, int c) {
        int set = methodName.indexOf("Set", c);
        int add = methodName.indexOf("Add", c);
        int mul = methodName.indexOf("Multiply", c);
        int div = methodName.indexOf("Divide", c);
        int uFirst = Integer.MAX_VALUE;
        if (set > 0 && set < uFirst) {
            uFirst = set;
        }
        if (add > 0 && add < uFirst) {
            uFirst = add;
        }
        if (mul > 0 && mul < uFirst) {
            uFirst = mul;
        }
        if (div > 0 && div < uFirst) {
            uFirst = div;
        }
        if (uFirst == Integer.MAX_VALUE) {
            throw new IllegalArgumentException(methodName);
        }
        StringBuilder where = new StringBuilder(150);
        this.generateWhereClause(queryInfo, methodName, c, uFirst, where);
        String o = queryInfo.entityVar;
        StringBuilder q = new StringBuilder(250);
        q.append("UPDATE ").append(queryInfo.entityInfo.name).append(' ').append(o).append(" SET");
        int u = uFirst;
        while (true) {
            int next;
            block27: {
                String attribute;
                String name;
                char op;
                boolean first;
                if (u <= 0) {
                    return q.append((CharSequence)where);
                }
                boolean bl = first = u == uFirst;
                if (u == set) {
                    op = '=';
                    set = methodName.indexOf("Set", u += 3);
                } else if (u == add) {
                    op = '+';
                    add = methodName.indexOf("Add", u += 3);
                } else if (u == div) {
                    op = '/';
                    div = methodName.indexOf("Divide", u += 6);
                } else {
                    if (u != mul) {
                        throw new IllegalStateException(methodName);
                    }
                    op = '*';
                    mul = methodName.indexOf("Multiply", u += 8);
                }
                next = Integer.MAX_VALUE;
                if (set > u && set < next) {
                    next = set;
                }
                if (add > u && add < next) {
                    next = add;
                }
                if (mul > u && mul < next) {
                    next = mul;
                }
                if (div > u && div < next) {
                    next = div;
                }
                if ((name = queryInfo.entityInfo.getAttributeName(attribute = next == Integer.MAX_VALUE ? methodName.substring(u) : methodName.substring(u, next), true)) == null) {
                    if (op == '=') {
                        this.generateUpdatesForIdClass(queryInfo, first, q);
                        break block27;
                    } else {
                        String opName = op == '+' ? "Add" : (op == '*' ? "Multiply" : "Divide");
                        throw new MappingException("The " + opName + " repository update operation cannot be used on the Id of the entity when the Id is an IdClass.");
                    }
                }
                q.append(first ? " " : ", ").append(o).append('.').append(name).append("=");
                switch (op) {
                    case '+': {
                        if (CharSequence.class.isAssignableFrom((Class)queryInfo.entityInfo.attributeTypes.get(name))) {
                            q.append("CONCAT(").append(o).append('.').append(name).append(',').append('?').append(++queryInfo.paramCount).append(')');
                            break;
                        }
                    }
                    case '*': 
                    case '/': {
                        q.append(o).append('.').append(name).append(op);
                    }
                    case '=': {
                        q.append('?').append(++queryInfo.paramCount);
                        break;
                    }
                }
            }
            u = next == Integer.MAX_VALUE ? -1 : next;
        }
    }

    private StringBuilder generateUpdateEntity(QueryInfo queryInfo) {
        StringBuilder q;
        EntityInfo entityInfo = queryInfo.entityInfo;
        String o = queryInfo.entityVar;
        String idName = queryInfo.entityInfo.getAttributeName("id", true);
        if (idName == null && queryInfo.entityInfo.idClassAttributeAccessors != null) {
            throw new MappingException("Update operations cannot be used on entities with composite IDs.");
        }
        Class<?> singleType = queryInfo.getSingleResultType();
        if (UPDATE_COUNT_TYPES.contains(singleType)) {
            queryInfo.init(Update.class, QueryInfo.Type.UPDATE_WITH_ENTITY_PARAM);
            queryInfo.hasWhere = true;
            q = new StringBuilder(100).append("UPDATE ").append(entityInfo.name).append(' ').append(o).append(" SET ");
            boolean first = true;
            for (String name : entityInfo.getAttributeNamesForEntityUpdate()) {
                if (first) {
                    first = false;
                } else {
                    q.append(", ");
                }
                q.append(o).append('.').append(name).append("=?").append(++queryInfo.paramCount);
            }
            q.append(" WHERE ").append(o).append('.').append(idName).append("=?").append(++queryInfo.paramCount);
            if (entityInfo.versionAttributeName != null) {
                q.append(" AND ").append(o).append('.').append(entityInfo.versionAttributeName).append("=?").append(++queryInfo.paramCount);
            }
        } else {
            queryInfo.init(Update.class, QueryInfo.Type.UPDATE_WITH_ENTITY_PARAM_AND_RESULT);
            queryInfo.hasWhere = true;
            q = new StringBuilder(100).append("SELECT ").append(o).append(" FROM ").append(entityInfo.name).append(' ').append(o).append(" WHERE ").append(o).append('.').append(idName).append("=?").append(++queryInfo.paramCount);
            if (entityInfo.versionAttributeName != null) {
                q.append(" AND ").append(o).append('.').append(entityInfo.versionAttributeName).append("=?").append(++queryInfo.paramCount);
            }
        }
        return q;
    }

    private void generateUpdatesForIdClass(QueryInfo queryInfo, boolean firstOperation, StringBuilder q) {
        int count = 0;
        for (String idClassAttr : queryInfo.entityInfo.idClassAttributeAccessors.keySet()) {
            String name = queryInfo.entityInfo.getAttributeName(idClassAttr, true);
            q.append(firstOperation ? " " : ", ").append(queryInfo.entityVar).append('.').append(name).append("=?").append(++queryInfo.paramCount);
            if (++count != 1) {
                ++queryInfo.paramAddedCount;
            }
            firstOperation = false;
        }
    }

    private void generateWhereClause(QueryInfo queryInfo, String methodName, int start, int endBefore, StringBuilder q) {
        queryInfo.hasWhere = true;
        q.append(" WHERE (");
        int and = start;
        int or = start;
        int iNext = start;
        int i = start;
        while (queryInfo.hasWhere && i >= start && iNext < endBefore) {
            iNext = Math.min(and = and == -1 || and > i + 1 ? and : methodName.indexOf("And", i + 1), or = or == -1 || or > i + 1 ? or : methodName.indexOf("Or", i + 1));
            if (iNext < 0) {
                iNext = Math.max(and, or);
            }
            this.generateCondition(queryInfo, methodName, i, iNext < 0 || iNext >= endBefore ? endBefore : iNext, q);
            if (iNext > 0 && iNext < endBefore) {
                q.append(iNext == and ? " AND " : " OR ");
                iNext += iNext == and ? 3 : 2;
            }
            i = iNext;
        }
        if (queryInfo.hasWhere) {
            q.append(')');
        }
    }

    @Trivial
    private static final String getName(Parameter param, int index) {
        return param.isNamePresent() ? param.getName() : "(" + (index + 1) + ")";
    }

    @Trivial
    private List<Integer> getParameterPositions(String jpql) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int index = 0;
        while ((index = jpql.indexOf(58, index)) >= 0) {
            positions.add(++index);
        }
        return positions;
    }

    private <T> T getResource(Class<T> type) {
        Deque<EntityManager> resources = defaultMethodResources.get();
        if (EntityManager.class.equals(type)) {
            EntityManager em = this.primaryEntityInfoFuture.join().persister.createEntityManager();
            if (resources == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(type + " accessed outside the scope of repository default method"), (Object[])new Object[]{Arrays.toString(new Exception().getStackTrace())});
                }
            } else {
                resources.add(em);
            }
            EntityManager t = em;
            return (T)t;
        }
        throw new UnsupportedOperationException("The " + type.getName() + " type of resource is not available from the Jakarta Data provider.");
    }

    private Object insert(Object arg, QueryInfo queryInfo, EntityManager em) throws Exception {
        Object returnValue;
        int i;
        ArrayList<Object> results;
        boolean resultVoid;
        Class<?> singleType = queryInfo.getSingleResultType();
        boolean bl = resultVoid = Void.TYPE.equals(singleType) || Void.class.equals(singleType);
        if (queryInfo.entityParamType.isArray()) {
            int length = Array.getLength(arg);
            results = resultVoid ? null : new ArrayList<Object>(length);
            for (i = 0; i < length; ++i) {
                entity = RepositoryImpl.toEntity(Array.get(arg, i));
                em.persist(entity);
                if (results == null) continue;
                results.add(entity);
            }
            em.flush();
        } else {
            List list = arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
            if (arg instanceof Iterable) {
                results = resultVoid ? null : new ArrayList<Object>();
                for (Object e : (Iterable)arg) {
                    entity = RepositoryImpl.toEntity(e);
                    em.persist(entity);
                    if (results == null) continue;
                    results.add(entity);
                }
                em.flush();
            } else {
                results = resultVoid ? null : new ArrayList<Object>(1);
                Object entity = RepositoryImpl.toEntity(arg);
                em.persist(entity);
                em.flush();
                if (results != null) {
                    results.add(entity);
                }
            }
        }
        if (resultVoid) {
            returnValue = null;
        } else {
            if (queryInfo.entityInfo.recordClass != null) {
                for (i = 0; i < results.size(); ++i) {
                    results.set(i, queryInfo.entityInfo.toRecord(results.get(i)));
                }
            }
            if (queryInfo.returnArrayType != null) {
                Object[] newArray = (Object[])Array.newInstance(queryInfo.returnArrayType, results.size());
                returnValue = results.toArray(newArray);
            } else {
                Class<?> multiType = queryInfo.getMultipleResultType();
                if (multiType == null) {
                    returnValue = results.isEmpty() ? null : results.get(0);
                } else if (multiType.isInstance(results)) {
                    returnValue = results;
                } else if (Stream.class.equals(multiType)) {
                    returnValue = results.stream();
                } else if (Iterable.class.isAssignableFrom(multiType)) {
                    returnValue = RepositoryImpl.toIterable(multiType, null, results);
                } else if (Iterator.class.equals(multiType)) {
                    returnValue = results.iterator();
                } else {
                    throw new UnsupportedOperationException(multiType + " is an unsupported return type.");
                }
            }
        }
        Class<?> returnType = queryInfo.method.getReturnType();
        if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            returnValue = CompletableFuture.completedFuture(returnValue);
        } else if (!resultVoid && !returnType.isInstance(returnValue)) {
            throw new MappingException("The " + returnType.getName() + " return type of the " + queryInfo.method.getName() + " method of the " + queryInfo.method.getDeclaringClass().getName() + " class is not a valid return type for a repository @Insert method.");
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Trivial
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        queryInfoFuture = this.queries.get(method);
        isDefaultMethod = false;
        if (queryInfoFuture == null) {
            if (method.isDefault()) {
                isDefaultMethod = true;
            } else {
                methodName = method.getName();
                if (args == null) {
                    if ("hashCode".equals(methodName)) {
                        return System.identityHashCode(proxy);
                    }
                    if ("toString".equals(methodName) == false) throw new UnsupportedOperationException(method.toString());
                    return this.repositoryInterface.getName() + "(Proxy)@" + Integer.toHexString(System.identityHashCode(proxy));
                }
                if (args.length != 1) throw new UnsupportedOperationException(method.toString());
                if ("equals".equals(methodName) == false) throw new UnsupportedOperationException(method.toString());
                if (proxy == args[0]) {
                    v0 = true;
                    return v0;
                }
                v0 = false;
                return v0;
            }
        }
        if ((trace = TraceComponent.isAnyTracingEnabled()) && RepositoryImpl.tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)RepositoryImpl.tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), (Object[])args);
        }
        try {
            block137: {
                block136: {
                    block135: {
                        block134: {
                            block139: {
                                block138: {
                                    if (this.isDisposed.get()) {
                                        throw new IllegalStateException("Repository instance " + this.repositoryInterface.getName() + "(Proxy)@" + Integer.toHexString(System.identityHashCode(proxy)) + " is no longer in scope.");
                                    }
                                    if (!isDefaultMethod) break block138;
                                    resourceStack = RepositoryImpl.defaultMethodResources.get();
                                    added = resourceStack == null;
                                    if (added) {
                                        resourceStack = new LinkedList<EntityManager>();
                                        RepositoryImpl.defaultMethodResources.set(resourceStack);
                                    } else {
                                        resourceStack.add(null);
                                    }
                                    returnValue = InvocationHandler.invokeDefault(proxy, method, args);
                                    if (trace && RepositoryImpl.tc.isEntryEnabled()) {
                                        Tr.exit((Object)this, (TraceComponent)RepositoryImpl.tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), (Object)returnValue);
                                    }
                                    var10_16 = returnValue;
                                    return var10_16;
                                    ** finally { 
lbl41:
                                    // 1 sources

                                    ** GOTO lbl-1000
                                }
                                queryInfo = queryInfoFuture.join();
                                entityInfo = queryInfo.entityInfo;
                                if (trace && RepositoryImpl.tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)RepositoryImpl.tc, (String)queryInfo.toString(), (Object[])new Object[0]);
                                }
                                if (queryInfo.validateParams) {
                                    this.validator.validateParameters(proxy, method, args);
                                }
                                suspendedLTC = null;
                                em = null;
                                returnType = method.getReturnType();
                                failed = true;
                                switch (1.$SwitchMap$io$openliberty$data$internal$persistence$QueryInfo$Type[queryInfo.type.ordinal()]) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        requiresTransaction = false;
                                        break;
                                    }
                                    default: {
                                        requiresTransaction = 6 == this.provider.tranMgr.getStatus();
                                    }
                                }
                                if (requiresTransaction) {
                                    suspendedLTC = this.provider.localTranCurrent.suspend();
                                    this.provider.tranMgr.begin();
                                }
                                block10 : switch (1.$SwitchMap$io$openliberty$data$internal$persistence$QueryInfo$Type[queryInfo.type.ordinal()]) {
                                    case 5: {
                                        em = entityInfo.persister.createEntityManager();
                                        returnValue = this.save(args[0], queryInfo, em);
                                        break;
                                    }
                                    case 6: {
                                        em = entityInfo.persister.createEntityManager();
                                        returnValue = this.insert(args[0], queryInfo, em);
                                        break;
                                    }
                                    case 1: 
                                    case 7: {
                                        limit = null;
                                        pagination = null;
                                        sortList = null;
                                        for (i = queryInfo.paramCount - queryInfo.paramAddedCount; i < (args == null ? 0 : args.length); ++i) {
                                            param = args[i];
                                            if (param instanceof Limit) {
                                                if (limit != null) throw new DataException("Repository method " + method + " cannot have multiple Limit parameters.");
                                                limit = (Limit)param;
                                                continue;
                                            }
                                            if (param instanceof Pageable) {
                                                if (pagination != null) throw new DataException("Repository method " + method + " cannot have multiple Pageable parameters.");
                                                pagination = (Pageable)param;
                                                continue;
                                            }
                                            if (param instanceof Sort) {
                                                sortList = queryInfo.combineSorts(sortList, new Sort[]{(Sort)param});
                                                continue;
                                            }
                                            if (!(param instanceof Sort[])) continue;
                                            sortList = queryInfo.combineSorts(sortList, (Sort[])param);
                                        }
                                        if (pagination != null) {
                                            if (limit != null) {
                                                throw new DataException("Repository method " + method + " cannot have both Limit and Pageable as parameters.");
                                            }
                                            if (sortList == null) {
                                                sortList = queryInfo.combineSorts(sortList, pagination.sorts());
                                            } else if (sortList != null && !pagination.sorts().isEmpty()) {
                                                throw new DataException("Repository method " + method + " cannot specify Sort parameters if Pageable also has Sort parameters.");
                                            }
                                        }
                                        if (sortList == null && queryInfo.hasDynamicSortCriteria()) {
                                            sortList = queryInfo.sorts;
                                        }
                                        if (sortList != null && !sortList.isEmpty()) {
                                            forward = pagination == null || pagination.mode() != Pageable.Mode.CURSOR_PREVIOUS;
                                            q = new StringBuilder(queryInfo.jpql);
                                            order = null;
                                            for (Sort sort : sortList) {
                                                order = order == null ? new StringBuilder(100).append(" ORDER BY ") : order.append(", ");
                                                this.appendSort(order, queryInfo.entityVar, sort, forward);
                                            }
                                            if (pagination == null || pagination.mode() == Pageable.Mode.OFFSET) {
                                                queryInfo = queryInfo.withJPQL(q.append((CharSequence)order).toString(), sortList);
                                            } else {
                                                queryInfo = queryInfo.withJPQL(null, sortList);
                                                this.generateKeysetQueries(queryInfo, q, forward != false ? order : null, forward != false ? null : order);
                                            }
                                        }
                                        asyncCompatibleResultForPagination = pagination != null && (Void.TYPE.equals(returnType) != false || CompletableFuture.class.equals(returnType) != false || CompletionStage.class.equals(returnType) != false);
                                        multiType = queryInfo.getMultipleResultType();
                                        if (pagination == null || !Iterator.class.equals(multiType)) ** GOTO lbl120
                                        returnValue = new PaginatedIterator<T>(queryInfo, pagination, args);
                                        ** GOTO lbl251
lbl120:
                                        // 1 sources

                                        if (!KeysetAwareSlice.class.equals(multiType) && !KeysetAwarePage.class.equals(multiType)) ** GOTO lbl123
                                        returnValue = new KeysetAwarePageImpl<T>(queryInfo, limit == null ? pagination : RepositoryImpl.toPageable(limit), args);
                                        ** GOTO lbl251
lbl123:
                                        // 1 sources

                                        if (!Slice.class.equals(multiType) && !Page.class.equals(multiType) && (pagination == null || !Streamable.class.equals(multiType))) ** GOTO lbl126
                                        returnValue = new PageImpl<T>(queryInfo, limit == null ? pagination : RepositoryImpl.toPageable(limit), args);
                                        ** GOTO lbl251
lbl126:
                                        // 1 sources

                                        em = entityInfo.persister.createEntityManager();
                                        if (TraceComponent.isAnyTracingEnabled() && RepositoryImpl.tc.isDebugEnabled()) {
                                            Tr.debug((Object)this, (TraceComponent)RepositoryImpl.tc, (String)"createQuery", (Object[])new Object[]{queryInfo.jpql, entityInfo.entityClass.getName()});
                                        }
                                        qi = queryInfo;
                                        eMgr = em;
                                        query = eMgr.createQuery(qi.jpql, qi.entityInfo.entityClass);
                                        queryInfo.setParameters((Query)query, args);
                                        if (queryInfo.type == QueryInfo.Type.FIND_AND_DELETE) {
                                            query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
                                        }
                                        v1 = limit != null ? limit.maxResults() : (maxResults = pagination != null ? pagination.size() : queryInfo.maxResults);
                                        v2 = limit != null ? RepositoryImpl.computeOffset(limit) : (startAt = pagination != null ? RepositoryImpl.computeOffset(pagination) : 0);
                                        if (maxResults > 0) {
                                            if (trace && RepositoryImpl.tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)RepositoryImpl.tc, (String)("limit max results to " + maxResults), (Object[])new Object[0]);
                                            }
                                            query.setMaxResults(maxResults);
                                        }
                                        if (startAt > 0) {
                                            if (trace && RepositoryImpl.tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)RepositoryImpl.tc, (String)("start at (0-based) position " + startAt), (Object[])new Object[0]);
                                            }
                                            query.setFirstResult(startAt);
                                        }
                                        if (multiType == null || !BaseStream.class.isAssignableFrom(multiType)) ** GOTO lbl162
                                        stream = query.getResultStream();
                                        if (!Stream.class.equals(multiType)) ** GOTO lbl153
                                        returnValue = stream;
                                        ** GOTO lbl251
lbl153:
                                        // 1 sources

                                        if (!IntStream.class.equals(multiType)) ** GOTO lbl156
                                        returnValue = stream.mapToInt((ToIntFunction<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, toInt(java.lang.Object ), (Ljava/lang/Object;)I)());
                                        ** GOTO lbl251
lbl156:
                                        // 1 sources

                                        if (LongStream.class.equals(multiType)) {
                                            returnValue = stream.mapToLong((ToLongFunction<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)J, toLong(java.lang.Object ), (Ljava/lang/Object;)J)());
                                        } else {
                                            if (DoubleStream.class.equals(multiType) == false) throw new UnsupportedOperationException("Stream type " + multiType.getName());
                                            returnValue = stream.mapToDouble((ToDoubleFunction<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)D, toDouble(java.lang.Object ), (Ljava/lang/Object;)D)());
                                        }
                                        ** GOTO lbl251
lbl162:
                                        // 1 sources

                                        singleType = queryInfo.getSingleResultType();
                                        results = query.getResultList();
                                        if (queryInfo.type != QueryInfo.Type.FIND_AND_DELETE) ** GOTO lbl194
                                        var27_55 = results.iterator();
lbl166:
                                        // 3 sources

                                        while (true) {
                                            if (var27_55.hasNext()) {
                                                result = var27_55.next();
                                                if (result == null) {
                                                    throw new DataException("Unable to delete from the database when the query result includes a null value.");
                                                }
                                                if (entityInfo.entityClass.isInstance(result)) {
                                                    em.remove(result);
                                                    continue;
                                                }
                                                if (entityInfo.idClassAttributeAccessors != null) {
                                                    delete = em.createQuery(queryInfo.jpqlDelete);
                                                    numParams = 0;
                                                    var31_64 = entityInfo.idClassAttributeAccessors.values().iterator();
                                                    break block134;
                                                }
                                                value = result;
                                                if (entityInfo.entityClass.isInstance(result) || entityInfo.recordClass != null && entityInfo.recordClass.isInstance(result)) {
                                                    accessors = entityInfo.attributeAccessors.get(entityInfo.attributeNames.get("id"));
                                                    if (accessors == null) throw new MappingException("Unable to find the id attribute on the " + entityInfo.name + " entity.");
                                                    if (accessors.isEmpty()) {
                                                        throw new MappingException("Unable to find the id attribute on the " + entityInfo.name + " entity.");
                                                    }
                                                    var31_64 = accessors.iterator();
                                                    break block135;
                                                }
                                                if (!entityInfo.idType.isInstance(value) && (value = RepositoryImpl.to(entityInfo.idType, result, false)) == result) {
                                                    if (entityInfo.recordClass == null) {
                                                        v3 = entityInfo.entityClass;
                                                        throw new MappingException("Results for find-and-delete repository queries must be the entity class (" + v3.getName() + ") or the id class (" + entityInfo.idType + "), not the " + result.getClass().getName() + " class.");
                                                    }
                                                    v3 = entityInfo.recordClass;
                                                    throw new MappingException("Results for find-and-delete repository queries must be the entity class (" + v3.getName() + ") or the id class (" + entityInfo.idType + "), not the " + result.getClass().getName() + " class.");
                                                }
                                                break block136;
                                            }
lbl194:
                                            // 3 sources

                                            if (!results.isEmpty() || queryInfo.getOptionalResultType() == null) ** GOTO lbl197
                                            returnValue = null;
                                            ** GOTO lbl251
lbl197:
                                            // 1 sources

                                            if (multiType != null || !entityInfo.entityClass.equals(singleType)) ** GOTO lbl200
                                            returnValue = this.oneResult(results);
                                            ** GOTO lbl251
lbl200:
                                            // 1 sources

                                            if (multiType == null || !multiType.isInstance(results) || !results.isEmpty() && results.get(0) instanceof Object[]) ** GOTO lbl203
                                            returnValue = results;
                                            ** GOTO lbl251
lbl203:
                                            // 1 sources

                                            if (multiType == null || !Iterable.class.isAssignableFrom(multiType)) ** GOTO lbl206
                                            returnValue = RepositoryImpl.toIterable(multiType, singleType, results);
                                            ** GOTO lbl251
lbl206:
                                            // 1 sources

                                            if (!Iterator.class.equals(multiType)) ** GOTO lbl209
                                            returnValue = results.iterator();
                                            ** GOTO lbl251
lbl209:
                                            // 1 sources

                                            if (queryInfo.returnArrayType == null) ** GOTO lbl230
                                            size = results.size();
                                            v4 = firstResult = size == 0 ? null : (Object)results.get(0);
                                            if (firstResult == null || !firstResult.getClass().isArray()) ** GOTO lbl224
                                            if (size != 1) ** GOTO lbl222
                                            optionalType = queryInfo.getOptionalResultType();
                                            if (firstResult.getClass().equals(optionalType)) {
                                                returnValue = firstResult;
                                            } else {
                                                len = Array.getLength(firstResult);
                                                returnValue = Array.newInstance(queryInfo.returnArrayType, len);
                                                i = 0;
                                                break block137;
                                            }
lbl222:
                                            // 1 sources

                                            returnValue = results;
                                            ** GOTO lbl251
lbl224:
                                            // 1 sources

                                            returnValue = Array.newInstance(queryInfo.returnArrayType, size);
                                            i = 0;
                                            for (E result : results) {
                                                Array.set(returnValue, i++, result);
                                            }
                                            ** GOTO lbl251
lbl230:
                                            // 1 sources

                                            if (results.isEmpty()) {
                                                throw new EmptyResultException("Query with return type of " + returnType.getName() + " returned no results. If this is expected, specify a return type of array, List, Optional, Page, Slice, or Stream for the repository method.");
                                            }
                                            returnValue = this.oneResult(results);
                                            if (returnValue != null && !singleType.isAssignableFrom(returnValue.getClass())) {
                                                if (Double.TYPE.equals(singleType) || Double.class.equals(singleType)) {
                                                    returnValue = ((Number)returnValue).doubleValue();
                                                } else if (Float.TYPE.equals(singleType) || Float.class.equals(singleType)) {
                                                    returnValue = Float.valueOf(((Number)returnValue).floatValue());
                                                } else if (Long.TYPE.equals(singleType) || Long.class.equals(singleType)) {
                                                    returnValue = ((Number)returnValue).longValue();
                                                } else if (Integer.TYPE.equals(singleType) || Integer.class.equals(singleType)) {
                                                    returnValue = ((Number)returnValue).intValue();
                                                } else if (Short.TYPE.equals(singleType) || Short.class.equals(singleType)) {
                                                    returnValue = ((Number)returnValue).shortValue();
                                                } else if (Byte.TYPE.equals(singleType) || Byte.class.equals(singleType)) {
                                                    returnValue = ((Number)returnValue).byteValue();
                                                }
                                            }
lbl251:
                                            // 26 sources

                                            while (true) {
                                                if (Optional.class.equals(returnType)) {
                                                    returnValue = returnValue == null || returnValue instanceof Collection != false && ((Collection)returnValue).isEmpty() != false || returnValue instanceof Slice != false && ((Slice)returnValue).hasContent() == false ? Optional.empty() : Optional.of(returnValue);
                                                    break block10;
                                                }
                                                if (!CompletableFuture.class.equals(returnType) && !CompletionStage.class.equals(returnType)) break block10;
                                                returnValue = CompletableFuture.completedFuture(returnValue);
                                                break block10;
                                                break;
                                            }
                                            break;
                                        }
                                    }
                                    case 8: 
                                    case 9: {
                                        em = entityInfo.persister.createEntityManager();
                                        update = em.createQuery(queryInfo.jpql);
                                        queryInfo.setParameters(update, args);
                                        updateCount = update.executeUpdate();
                                        returnValue = RepositoryImpl.toReturnValue(updateCount, returnType, queryInfo);
                                        break;
                                    }
                                    case 10: {
                                        em = entityInfo.persister.createEntityManager();
                                        arg = args[0] instanceof Stream != false ? ((Stream)((Stream)args[0]).sequential()).collect(Collectors.toList()) : args[0];
                                        updateCount = 0;
                                        numExpected = 0;
                                        if (arg instanceof Iterable) {
                                            for (T e : (Iterable)arg) {
                                                ++numExpected;
                                                updateCount += this.remove(e, queryInfo, em);
                                            }
                                        } else if (queryInfo.entityParamType.isArray()) {
                                            numExpected = Array.getLength(arg);
                                            for (i = 0; i < numExpected; updateCount += this.remove(Array.get(arg, i), queryInfo, em), ++i) {
                                            }
                                        } else {
                                            numExpected = 1;
                                            updateCount = this.remove(arg, queryInfo, em);
                                        }
                                        if (updateCount < numExpected) {
                                            singleType = queryInfo.getSingleResultType();
                                            if (Void.TYPE.equals(singleType) != false) throw new OptimisticLockingFailureException(numExpected - updateCount + " of the " + numExpected + " entities were not found for deletion.");
                                            if (Void.class.equals(singleType)) {
                                                throw new OptimisticLockingFailureException(numExpected - updateCount + " of the " + numExpected + " entities were not found for deletion.");
                                            }
                                        }
                                        returnValue = RepositoryImpl.toReturnValue(updateCount, returnType, queryInfo);
                                        break;
                                    }
                                    case 11: {
                                        em = entityInfo.persister.createEntityManager();
                                        arg = args[0] instanceof Stream != false ? ((Stream)((Stream)args[0]).sequential()).collect(Collectors.toList()) : args[0];
                                        updateCount = 0;
                                        if (arg instanceof Iterable) {
                                            for (T e : (Iterable)arg) {
                                                updateCount += this.update(e, queryInfo, em);
                                            }
                                        } else if (queryInfo.entityParamType.isArray()) {
                                            length = Array.getLength(arg);
                                            for (i = 0; i < length; updateCount += this.update(Array.get(arg, i), queryInfo, em), ++i) {
                                            }
                                        } else {
                                            updateCount = this.update(arg, queryInfo, em);
                                        }
                                        returnValue = RepositoryImpl.toReturnValue(updateCount, returnType, queryInfo);
                                        break;
                                    }
                                    case 12: {
                                        em = entityInfo.persister.createEntityManager();
                                        returnValue = this.findAndUpdate(args[0], queryInfo, em);
                                        break;
                                    }
                                    case 2: {
                                        em = entityInfo.persister.createEntityManager();
                                        query = em.createQuery(queryInfo.jpql, Long.class);
                                        queryInfo.setParameters(query, args);
                                        result = (Long)query.getSingleResult();
                                        type = queryInfo.getSingleResultType();
                                        if (trace && RepositoryImpl.tc.isDebugEnabled()) {
                                            Tr.debug((Object)this, (TraceComponent)RepositoryImpl.tc, (String)("result " + result + " to be returned as " + type.getName()), (Object[])new Object[0]);
                                        }
                                        returnValue = result;
                                        if (!type.isInstance(result) && !type.isAssignableFrom(returnValue.getClass())) {
                                            if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                                                returnValue = result.intValue();
                                            } else if (Short.TYPE.equals(type) || Short.class.equals(type)) {
                                                returnValue = result.shortValue();
                                            } else if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
                                                returnValue = result.byteValue();
                                            }
                                        }
                                        if (Optional.class.equals(returnType)) {
                                            returnValue = Optional.of(returnValue);
                                            break;
                                        }
                                        if (!CompletableFuture.class.equals(returnType) && !CompletionStage.class.equals(returnType)) break;
                                        returnValue = CompletableFuture.completedFuture(returnValue);
                                        break;
                                    }
                                    case 3: {
                                        em = entityInfo.persister.createEntityManager();
                                        query = em.createQuery(queryInfo.jpql);
                                        query.setMaxResults(1);
                                        queryInfo.setParameters(query, args);
                                        returnValue = query.getResultList().isEmpty() == false;
                                        if (Optional.class.equals(returnType)) {
                                            returnValue = Optional.of(returnValue);
                                            break;
                                        }
                                        if (!CompletableFuture.class.equals(returnType) && !CompletionStage.class.equals(returnType)) break;
                                        returnValue = CompletableFuture.completedFuture(returnValue);
                                        break;
                                    }
                                    case 4: {
                                        returnValue = this.getResource(returnType);
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException(queryInfo.type.name());
                                    }
                                }
                                if (queryInfo.validateResult) {
                                    this.validator.validateReturnValue(proxy, method, returnValue);
                                }
                                break block139;
                                finally {
                                    if (em != null) {
                                        em.close();
                                    }
                                    if (requiresTransaction) {
                                        try {
                                            status = this.provider.tranMgr.getStatus();
                                            if (status == 1 || failed) {
                                                this.provider.tranMgr.rollback();
                                            }
                                            if (status == 6) ** GOTO lbl374
                                            this.provider.tranMgr.commit();
                                        }
                                        finally {
                                            if (suspendedLTC != null) {
                                                this.provider.localTranCurrent.resume(suspendedLTC);
                                            }
                                        }
                                    } else if (failed && 0 == this.provider.tranMgr.getStatus()) {
                                        this.provider.tranMgr.setRollbackOnly();
                                    }
lbl374:
                                    // 6 sources

                                }
                            }
                            failed = false;
                            if (trace == false) return returnValue;
                            if (RepositoryImpl.tc.isEntryEnabled() == false) return returnValue;
                            Tr.exit((Object)this, (TraceComponent)RepositoryImpl.tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), returnValue);
                            return returnValue;
lbl-1000:
                            // 4 sources

                            {
                                while ((em = resourceStack.pollLast()) != null) {
                                    if (!em.isOpen()) continue;
                                    try {
                                        if (trace && RepositoryImpl.tc.isDebugEnabled()) {
                                            Tr.debug((Object)this, (TraceComponent)RepositoryImpl.tc, (String)("close " + em), (Object[])new Object[0]);
                                        }
                                        em.close();
                                    }
                                    catch (Throwable x) {
                                        FFDCFilter.processException((Throwable)x, (String)this.getClass().getName(), (String)"1827", (Object)this);
                                    }
                                }
                                if (added) {
                                    RepositoryImpl.defaultMethodResources.remove();
                                }
                            }
                        }
                        while (var31_64.hasNext()) {
                            accessor = var31_64.next();
                            v5 = value = accessor instanceof Method != false ? ((Method)accessor).invoke(result, new Object[0]) : ((Field)accessor).get(result);
                            if (trace && RepositoryImpl.tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)RepositoryImpl.tc, (String)queryInfo.jpqlDelete, (Object[])new Object[]{"set ?" + (numParams + 1) + " " + (value == null ? null : value.getClass().getSimpleName())});
                            }
                            delete.setParameter(++numParams, value);
                        }
                        delete.executeUpdate();
                        ** GOTO lbl166
                    }
                    while (var31_64.hasNext()) {
                        accessor = var31_64.next();
                        value = accessor instanceof Method != false ? ((Method)accessor).invoke(value, new Object[0]) : ((Field)accessor).get(value);
                    }
                }
                delete = em.createQuery(queryInfo.jpqlDelete);
                if (trace && RepositoryImpl.tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)RepositoryImpl.tc, (String)queryInfo.jpqlDelete, (Object[])new Object[]{"set ?1 " + (value == null ? null : value.getClass().getSimpleName())});
                }
                delete.setParameter(1, value);
                delete.executeUpdate();
                ** continue;
            }
            while (true) {
                if (i >= len) ** continue;
                element = Array.get(firstResult, i);
                Array.set(returnValue, i, queryInfo.returnArrayType.isInstance(element) != false ? element : RepositoryImpl.to(queryInfo.returnArrayType, element, true));
                ++i;
            }
        }
        catch (Throwable x) {
            if (!isDefaultMethod && x instanceof Exception) {
                x = RepositoryImpl.failure((Exception)x);
            }
            if (trace == false) throw x;
            if (RepositoryImpl.tc.isEntryEnabled() == false) throw x;
            Tr.exit((Object)this, (TraceComponent)RepositoryImpl.tc, (String)("invoke " + this.repositoryInterface.getSimpleName() + "." + method.getName()), (Object)x);
            throw x;
        }
    }

    @Trivial
    private final Object oneResult(List<?> results) {
        int size = results.size();
        if (size == 1) {
            return results.get(0);
        }
        if (size == 0) {
            throw new EmptyResultException("Query returned no results. If this is expected, specify a return type of array, List, Optional, Page, Slice, or Stream for the repository method.");
        }
        throw new jakarta.data.exceptions.NonUniqueResultException("Found " + results.size() + " results. To limit to a single result, specify Limit.of(1) as a parameter or use the findFirstBy name pattern.");
    }

    private void parseDeleteBy(QueryInfo queryInfo, int by) {
        String methodName = queryInfo.method.getName();
        if (methodName.regionMatches(6, "First", 0, 5)) {
            int endBefore = by == -1 ? methodName.length() : by;
            this.parseFirst(queryInfo, 11, endBefore);
        }
    }

    private void parseFindBy(QueryInfo queryInfo, String methodName, int by, List<String> selections) {
        boolean distinct;
        int start = 4;
        int endBefore = by == -1 ? methodName.length() : by;
        boolean first = methodName.regionMatches(start, "First", 0, 5);
        boolean bl = distinct = !first && methodName.regionMatches(start, "Distinct", 0, 8);
        while (first || distinct) {
            if (first) {
                start += 5;
                start = this.parseFirst(queryInfo, start, endBefore);
                first = false;
                distinct = methodName.regionMatches(start, "Distinct", 0, 8);
                continue;
            }
            if (!distinct) continue;
            throw new DataException("The keyword Distinct is not supported on the " + queryInfo.method.getName() + " method.");
        }
        if (selections != null) {
            int and;
            ArrayList<String> notFound = new ArrayList<String>();
            do {
                if ((and = methodName.indexOf("And", start)) == -1 || and > endBefore) {
                    and = endBefore;
                }
                if (start >= and) continue;
                String name = methodName.substring(start, and);
                String attrName = queryInfo.entityInfo.getAttributeName(name, false);
                if (attrName == null) {
                    notFound.add(name);
                    continue;
                }
                selections.add(attrName);
            } while ((start = and + 3) < endBefore);
            if (!selections.isEmpty() && !notFound.isEmpty()) {
                throw new MappingException("Entity class " + queryInfo.entityInfo.getType().getName() + " does not have properties named " + notFound + ". The following are valid property names for the entity: " + queryInfo.entityInfo.attributeTypes.keySet());
            }
        }
    }

    private int parseFirst(QueryInfo queryInfo, int start, int endBefore) {
        int num;
        String methodName = queryInfo.method.getName();
        int n = num = start == endBefore ? 1 : 0;
        if (num == 0) {
            while (start < endBefore) {
                char ch = methodName.charAt(start);
                if (ch >= '0' && ch <= '9') {
                    if (num > (Integer.MAX_VALUE - (ch - 48)) / 10) {
                        throw new UnsupportedOperationException(methodName.substring(0, endBefore) + " exceeds Integer.MAX_VALUE (2147483647).");
                    }
                    num = num * 10 + (ch - 48);
                    ++start;
                    continue;
                }
                if (num != 0) break;
                num = 1;
                break;
            }
        }
        if (num == 0) {
            throw new DataException("The number of results to retrieve must not be 0 on the " + methodName + " method.");
        }
        queryInfo.maxResults = num;
        return start;
    }

    private void parseOrderBy(QueryInfo queryInfo, int orderBy, StringBuilder q) {
        String methodName = queryInfo.method.getName();
        queryInfo.sorts = queryInfo.sorts == null ? new ArrayList() : queryInfo.sorts;
        int length = methodName.length();
        int asc = 0;
        int desc = 0;
        int i = orderBy + 7;
        while (i >= 0 && i < length) {
            int iNext = Math.min(asc = asc == -1 || asc > i ? asc : methodName.indexOf("Asc", i), desc = desc == -1 || desc > i ? desc : methodName.indexOf("Desc", i));
            if (iNext < 0) {
                iNext = Math.max(asc, desc);
            }
            boolean descending = iNext > 0 && iNext == desc;
            int endBefore = iNext < 0 ? methodName.length() : iNext;
            boolean ignoreCase = RepositoryImpl.endsWith("IgnoreCase", methodName, i, endBefore);
            if (ignoreCase) {
                endBefore -= 10;
            }
            String attribute = methodName.substring(i, endBefore);
            queryInfo.addSort(ignoreCase, attribute, descending);
            if (iNext > 0) {
                iNext += iNext == desc ? 4 : 3;
            }
            i = iNext;
        }
        if (!queryInfo.hasDynamicSortCriteria()) {
            this.generateOrderBy(queryInfo, q);
        }
    }

    private int remove(Object e, QueryInfo queryInfo, EntityManager em) throws Exception {
        Class<?> entityClass;
        Class<?> clazz = entityClass = queryInfo.entityInfo.recordClass == null ? queryInfo.entityInfo.entityClass : queryInfo.entityInfo.recordClass;
        if (e == null) {
            throw new NullPointerException("The entity parameter cannot have a null value.");
        }
        if (!entityClass.isInstance(e)) {
            throw new DataException("The " + (e == null ? null : e.getClass().getName()) + " parameter does not match the " + entityClass.getName() + " entity type that is expected for this repository.");
        }
        EntityInfo entityInfo = queryInfo.entityInfo;
        String jpql = queryInfo.jpql;
        int versionParamIndex = (entityInfo.idClassAttributeAccessors == null ? 1 : entityInfo.idClassAttributeAccessors.size()) + 1;
        Object version = null;
        if (entityInfo.versionAttributeName != null && (version = entityInfo.getAttribute(e, entityInfo.versionAttributeName)) == null) {
            jpql = jpql.replace("=?" + versionParamIndex, " IS NULL");
        }
        Object id = null;
        if (entityInfo.idClassAttributeAccessors == null && (id = entityInfo.getAttribute(e, entityInfo.getAttributeName("id", true))) == null) {
            jpql = jpql.replace("=?" + (versionParamIndex - 1), " IS NULL");
            if (version != null) {
                jpql = jpql.replace("=?" + versionParamIndex, "=?" + (versionParamIndex - 1));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && jpql != queryInfo.jpql) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JPQL adjusted for NULL id or version", (Object[])new Object[]{jpql});
        }
        TypedQuery delete = em.createQuery(jpql, entityInfo.entityClass);
        if (entityInfo.idClassAttributeAccessors == null) {
            int p = 1;
            if (id != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + id.getClass().getSimpleName()), (Object[])new Object[0]);
                }
                delete.setParameter(p++, id);
            }
            if (version != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("set ?" + p + " " + version.getClass().getSimpleName()), (Object[])new Object[0]);
                }
                delete.setParameter(p, version);
            }
        } else {
            queryInfo.setParametersFromIdClassAndVersion((Query)delete, e, version);
        }
        int numDeleted = delete.executeUpdate();
        if (numDeleted == 0) {
            Class<?> returnType = queryInfo.method.getReturnType();
            if (Void.TYPE.equals(returnType) || Void.class.equals(returnType)) {
                if (entityInfo.versionAttributeName == null) {
                    throw new OptimisticLockingFailureException("Entity was not found.");
                }
                throw new OptimisticLockingFailureException("Version " + version + " of the entity was not found.");
            }
        } else if (numDeleted > 1) {
            throw new DataException("Found " + numDeleted + " matching entities.");
        }
        return numDeleted;
    }

    private static final Object to(Class<?> type, Object item, boolean failIfNotConverted) {
        Object result = item;
        if (item == null) {
            if (type.isPrimitive()) {
                throw new NullPointerException();
            }
        } else if (item instanceof Number && (type.isPrimitive() || Number.class.isAssignableFrom(type))) {
            Number n = (Number)item;
            if (Long.TYPE.equals(type) || Long.class.equals(type)) {
                result = n.longValue();
            } else if (Double.TYPE.equals(type) || Double.class.equals(type)) {
                result = n.doubleValue();
            } else if (Float.TYPE.equals(type) || Float.class.equals(type)) {
                result = Float.valueOf(n.floatValue());
            } else if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                result = n.intValue();
            } else if (Short.TYPE.equals(type) || Short.class.equals(type)) {
                result = n.shortValue();
            } else if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
                result = n.byteValue();
            } else if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
                result = n.longValue() != 0L;
            }
        } else if (type.isAssignableFrom(String.class)) {
            result = item.toString();
        }
        if (failIfNotConverted && result == item && item != null) {
            throw new DataException("Query returned a result of type " + item.getClass().getName() + " which is not compatible with the type that is expected by the repository method signature: " + type.getName());
        }
        return result;
    }

    @Trivial
    private static final double toDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        throw new IllegalArgumentException("Not representable as a double value: " + o.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private static final Object toEntity(Object o) {
        Class<?> oClass;
        Object entity = o;
        Class<?> clazz = oClass = o == null ? null : o.getClass();
        if (o != null && oClass.isRecord()) {
            try {
                Object recordObj = o;
                entity = AccessController.doPrivileged(() -> {
                    Class<?> entityClass = oClass.getClassLoader().loadClass(oClass.getName() + "Entity");
                    Constructor<?> ctor = entityClass.getConstructor(oClass);
                    return ctor.newInstance(recordObj);
                });
            }
            catch (PrivilegedActionException recordObj) {
                void x;
                FFDCFilter.processException((Throwable)recordObj, (String)"io.openliberty.data.internal.persistence.RepositoryImpl", (String)"2963", null, (Object[])new Object[]{o});
                throw new MappingException("Unable to convert record " + oClass + " to generated entity class.", x.getCause());
            }
        }
        if (entity != o && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("toEntity " + oClass.getName() + " --> " + entity.getClass().getName()), (Object[])new Object[0]);
        }
        return entity;
    }

    @Trivial
    private static final String toFunctionName(Select.Aggregate function) {
        switch (function) {
            case UNSPECIFIED: {
                return null;
            }
            case AVERAGE: {
                return "AVG";
            }
            case MAXIMUM: {
                return "MAX";
            }
            case MINIMUM: {
                return "MIN";
            }
        }
        return function.name();
    }

    @Trivial
    private static final int toInt(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Not representable as an int value: " + o.getClass().getName());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Trivial
    private static final Iterable<?> toIterable(Class<?> iterableType, Class<?> elementType, List<?> results) {
        Collection<Object> list;
        if (Streamable.class.equals(iterableType)) {
            return new StreamableImpl(results);
        }
        if (iterableType.isInterface()) {
            if (iterableType.isAssignableFrom(ArrayList.class)) {
                list = new ArrayList(results.size());
            } else if (iterableType.isAssignableFrom(ArrayDeque.class)) {
                list = new ArrayDeque(results.size());
            } else {
                if (!iterableType.isAssignableFrom(LinkedHashSet.class)) throw new UnsupportedOperationException(iterableType + " is an unsupported return type.");
                list = new LinkedHashSet(results.size());
            }
        } else {
            try {
                Constructor<ArrayList> c = iterableType.getConstructor(new Class[0]);
                list = c.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException c) {
                void x;
                FFDCFilter.processException((Throwable)c, (String)"io.openliberty.data.internal.persistence.RepositoryImpl", (String)"3024", null, (Object[])new Object[]{iterableType, elementType, results});
                throw new MappingException("The " + iterableType.getName() + " result type lacks a public zero parameter constructor.", (Throwable)x);
            }
            catch (IllegalAccessException | InstantiationException x) {
                FFDCFilter.processException((Throwable)x, (String)"io.openliberty.data.internal.persistence.RepositoryImpl", (String)"3026", null, (Object[])new Object[]{iterableType, elementType, results});
                throw new MappingException("Unable to access the zero parameter constructor of the " + iterableType.getName() + " result type.", (Throwable)x);
            }
            catch (InvocationTargetException x) {
                FFDCFilter.processException((Throwable)x, (String)"io.openliberty.data.internal.persistence.RepositoryImpl", (String)"3028", null, (Object[])new Object[]{iterableType, elementType, results});
                throw new MappingException("The constructor for the " + iterableType.getName() + " result type raised an error: " + x.getCause().getMessage(), x.getCause());
            }
        }
        if (results.size() == 1 && results.get(0) instanceof Object[]) {
            Object[] a = (Object[])results.get(0);
            for (int i = 0; i < a.length; ++i) {
                list.add(elementType.isInstance(a[i]) ? a[i] : RepositoryImpl.to(elementType, a[i], true));
            }
            return list;
        } else {
            list.addAll(results);
        }
        return list;
    }

    @Trivial
    private static final long toLong(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof String) {
            return Long.parseLong((String)o);
        }
        throw new IllegalArgumentException("Not representable as a long value: " + o.getClass().getName());
    }

    private static final Pageable toPageable(Limit limit) {
        if (limit.startAt() != 1L) {
            throw new DataException((Throwable)new IllegalArgumentException("Limit with starting point " + limit.startAt() + ", which is greater than 1, cannot be used to request pages or slices."));
        }
        return Pageable.ofSize((int)limit.maxResults());
    }

    private static final Object toReturnValue(int i, Class<?> returnType, QueryInfo queryInfo) {
        Object result;
        if (Integer.TYPE.equals(returnType) || Integer.class.equals(returnType) || Number.class.equals(returnType)) {
            result = i;
        } else if (Long.TYPE.equals(returnType) || Long.class.equals(returnType)) {
            result = (long)i;
        } else if (Boolean.TYPE.equals(returnType) || Boolean.class.equals(returnType)) {
            result = i != 0;
        } else if (Void.TYPE.equals(returnType) || Void.class.equals(returnType)) {
            result = null;
        } else if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            result = CompletableFuture.completedFuture(RepositoryImpl.toReturnValue(i, queryInfo.getSingleResultType(), null));
        } else {
            throw new UnsupportedOperationException("Return update count as " + returnType);
        }
        return result;
    }

    private Object save(Object arg, QueryInfo queryInfo, EntityManager em) throws Exception {
        Object returnValue;
        int i;
        ArrayList<Object> results;
        boolean resultVoid;
        Class<?> singleType = queryInfo.getSingleResultType();
        boolean bl = resultVoid = Void.TYPE.equals(singleType) || Void.class.equals(singleType);
        if (queryInfo.entityParamType.isArray()) {
            results = new ArrayList<Object>();
            int length = Array.getLength(arg);
            for (i = 0; i < length; ++i) {
                results.add(em.merge(RepositoryImpl.toEntity(Array.get(arg, i))));
            }
            em.flush();
        } else {
            List list = arg = arg instanceof Stream ? ((Stream)((Stream)((Object)arg)).sequential()).collect(Collectors.toList()) : arg;
            if (Iterable.class.isAssignableFrom(queryInfo.entityParamType)) {
                results = new ArrayList();
                for (Object e : (Iterable)arg) {
                    results.add(em.merge(RepositoryImpl.toEntity(e)));
                }
                em.flush();
            } else {
                results = resultVoid ? null : new ArrayList<Object>(1);
                Object entity = em.merge(RepositoryImpl.toEntity(arg));
                if (results != null) {
                    results.add(entity);
                }
                em.flush();
            }
        }
        if (resultVoid) {
            returnValue = null;
        } else {
            if (queryInfo.entityInfo.recordClass != null) {
                for (i = 0; i < results.size(); ++i) {
                    results.set(i, queryInfo.entityInfo.toRecord(results.get(i)));
                }
            }
            if (queryInfo.returnArrayType != null) {
                Object[] newArray = (Object[])Array.newInstance(queryInfo.returnArrayType, results.size());
                returnValue = results.toArray(newArray);
            } else {
                Class<?> multiType = queryInfo.getMultipleResultType();
                if (multiType == null) {
                    returnValue = results.isEmpty() ? null : results.get(0);
                } else if (multiType.isInstance(results)) {
                    returnValue = results;
                } else if (Stream.class.equals(multiType)) {
                    returnValue = results.stream();
                } else if (Iterable.class.isAssignableFrom(multiType)) {
                    returnValue = RepositoryImpl.toIterable(multiType, null, results);
                } else if (Iterator.class.equals(multiType)) {
                    returnValue = results.iterator();
                } else {
                    throw new UnsupportedOperationException(multiType + " is an unsupported return type.");
                }
            }
        }
        Class<?> returnType = queryInfo.method.getReturnType();
        if (CompletableFuture.class.equals(returnType) || CompletionStage.class.equals(returnType)) {
            returnValue = CompletableFuture.completedFuture(returnValue);
        } else if (!resultVoid && !returnType.isInstance(returnValue)) {
            throw new MappingException("The " + returnType.getName() + " return type of the " + queryInfo.method.getName() + " method of the " + queryInfo.method.getDeclaringClass().getName() + " class is not a valid return type for a repository @Save method.");
        }
        return returnValue;
    }

    private int update(Object e, QueryInfo queryInfo, EntityManager em) throws Exception {
        int numUpdated;
        Object id;
        Class<?> entityClass;
        Class<?> clazz = entityClass = queryInfo.entityInfo.recordClass == null ? queryInfo.entityInfo.entityClass : queryInfo.entityInfo.recordClass;
        if (e == null) {
            throw new NullPointerException("The entity parameter cannot have a null value.");
        }
        if (!entityClass.isInstance(e)) {
            throw new DataException("The " + (e == null ? null : e.getClass().getName()) + " parameter does not match the " + entityClass.getName() + " entity type that is expected for this repository.");
        }
        String jpql = queryInfo.jpql;
        EntityInfo entityInfo = queryInfo.entityInfo;
        LinkedHashSet<String> attrsToUpdate = entityInfo.getAttributeNamesForEntityUpdate();
        int versionParamIndex = attrsToUpdate.size() + 2;
        Object version = null;
        if (entityInfo.versionAttributeName != null && (version = entityInfo.getAttribute(e, entityInfo.versionAttributeName)) == null) {
            jpql = jpql.replace("=?" + versionParamIndex, " IS NULL");
        }
        if ((id = entityInfo.getAttribute(e, entityInfo.getAttributeName("id", true))) == null) {
            jpql = jpql.replace("=?" + (versionParamIndex - 1), " IS NULL");
            if (version != null) {
                jpql = jpql.replace("=?" + versionParamIndex, "=?" + (versionParamIndex - 1));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && jpql != queryInfo.jpql) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"JPQL adjusted for NULL id or version", (Object[])new Object[]{jpql});
        }
        TypedQuery update = em.createQuery(jpql, entityInfo.entityClass);
        int p = 0;
        for (String attrName : entityInfo.getAttributeNamesForEntityUpdate()) {
            QueryInfo.setParameter(++p, (Query)update, e, entityInfo.attributeAccessors.get(attrName));
        }
        if (entityInfo.idClassAttributeAccessors != null) {
            throw new UnsupportedOperationException();
        }
        if (id != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("set ?" + (p + 1) + " " + id.getClass().getSimpleName()), (Object[])new Object[0]);
            }
            update.setParameter(++p, id);
        }
        if (entityInfo.versionAttributeName != null && version != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("set ?" + (p + 1) + " " + version.getClass().getSimpleName()), (Object[])new Object[0]);
            }
            update.setParameter(++p, version);
        }
        if ((numUpdated = update.executeUpdate()) > 1) {
            throw new DataException("Found " + numUpdated + " matching entities.");
        }
        return numUpdated;
    }

    @Trivial
    private static void verifyCollectionsSupported(String attributeName, boolean ignoreCase, Annotation conditionAnno) {
        if (conditionAnno != null && !(conditionAnno instanceof Contains) || ignoreCase) {
            throw new MappingException((Throwable)new UnsupportedOperationException("The parameter annotation " + (ignoreCase ? "IgnoreCase" : conditionAnno.annotationType().getSimpleName()) + " which is applied to entity property " + attributeName + " is not supported for collection properties."));
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        FUNCTION_CALLS.put(AbsoluteValue.class.getSimpleName(), "ABS(");
        FUNCTION_CALLS.put(CharCount.class.getSimpleName(), "LENGTH(");
        FUNCTION_CALLS.put(ElementCount.class.getSimpleName(), "SIZE(");
        FUNCTION_CALLS.put(IgnoreCase.class.getSimpleName(), "LOWER(");
        FUNCTION_CALLS.put(Not.class.getSimpleName(), "NOT(");
        FUNCTION_CALLS.put(Rounded.Direction.DOWN.name(), "FLOOR(");
        FUNCTION_CALLS.put(Rounded.Direction.NEAREST.name(), "ROUND(");
        FUNCTION_CALLS.put(Rounded.Direction.UP.name(), "CEILING(");
        FUNCTION_CALLS.put(Trimmed.class.getSimpleName(), "TRIM(");
        FUNCTION_CALLS.put(Extract.Field.DAY.name(), "EXTRACT (DAY FROM ");
        FUNCTION_CALLS.put(Extract.Field.HOUR.name(), "EXTRACT (HOUR FROM ");
        FUNCTION_CALLS.put(Extract.Field.MINUTE.name(), "EXTRACT (MINUTE FROM ");
        FUNCTION_CALLS.put(Extract.Field.MONTH.name(), "EXTRACT (MONTH FROM ");
        FUNCTION_CALLS.put(Extract.Field.QUARTER.name(), "EXTRACT (QUARTER FROM ");
        FUNCTION_CALLS.put(Extract.Field.SECOND.name(), "EXTRACT (SECOND FROM ");
        FUNCTION_CALLS.put(Extract.Field.WEEK.name(), "EXTRACT (WEEK FROM ");
        FUNCTION_CALLS.put(Extract.Field.YEAR.name(), "EXTRACT (YEAR FROM ");
        SPECIAL_PARAM_TYPES = new HashSet<Class>(Arrays.asList(Limit.class, Pageable.class, Sort.class, Sort[].class));
        UPDATE_COUNT_TYPES = new HashSet<Class>(Arrays.asList(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Void.TYPE, Void.class, Number.class));
        defaultMethodResources = new ThreadLocal();
    }
}

