/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.resource.ResourceFactory;
import io.openliberty.data.internal.persistence.EntityDefiner;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.cdi.DataExtensionProvider;
import io.openliberty.data.internal.persistence.cdi.DelegatingResourceFactory;
import io.openliberty.data.internal.persistence.cdi.RepositoryProducer;
import jakarta.annotation.Generated;
import jakarta.data.exceptions.MappingException;
import jakarta.data.model.StaticMetamodel;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Insert;
import jakarta.data.repository.Query;
import jakarta.data.repository.Repository;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DataExtension
implements Extension,
PrivilegedAction<DataExtensionProvider> {
    private static final TraceComponent tc = Tr.register(DataExtension.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final DataExtensionProvider provider = AccessController.doPrivileged(this);
    private final Queue<Bean<?>> repositoryBeans = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<jakarta.enterprise.inject.spi.AnnotatedType<?>, String> repositoryTypes = new ConcurrentHashMap();
    private final Map<Class<?>, List<Class<?>>> staticMetamodels = new HashMap();
    static final long serialVersionUID = -41733261764199579L;

    @Trivial
    public <T> void annotatedRepository(@Observes @WithAnnotations(value={Repository.class}) ProcessAnnotatedType<T> event) {
        boolean provide;
        jakarta.enterprise.inject.spi.AnnotatedType type = event.getAnnotatedType();
        Repository repository = (Repository)type.getAnnotation(Repository.class);
        String provider = repository.provider();
        boolean bl = provide = "".equals(provider) || "OpenLiberty".equalsIgnoreCase(provider);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("annotatedRepository to " + (provide ? "provide" : "ignore")), (Object[])new Object[]{repository.toString(), type.getJavaClass().getName()});
        }
        if (provide) {
            String dataStore = repository.dataStore();
            dataStore = dataStore.length() == 0 ? "defaultDatabaseStore" : this.findOrCreateDatabaseStore(dataStore, type);
            this.repositoryTypes.put(type, dataStore);
        }
    }

    @Trivial
    public <T> void annotatedStaticMetamodel(@Observes @WithAnnotations(value={StaticMetamodel.class}) ProcessAnnotatedType<T> event) {
        jakarta.enterprise.inject.spi.AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(Generated.class)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("annotatedStaticMetamodel ignoring generated " + type.getJavaClass().getName()), (Object[])new Object[0]);
            }
        } else {
            StaticMetamodel staticMetamodel = (StaticMetamodel)type.getAnnotation(StaticMetamodel.class);
            Class entityClass = staticMetamodel.value();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("annotatedStaticMetamodel for " + entityClass.getName()), (Object[])new Object[]{type.getJavaClass().getName()});
            }
            LinkedList<Class> newList = new LinkedList<Class>();
            newList.add(type.getJavaClass());
            List existingList = this.staticMetamodels.putIfAbsent(entityClass, newList);
            if (existingList != null) {
                existingList.add(type.getJavaClass());
            }
        }
    }

    public void afterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanMgr) {
        HashMap<EntityGroupKey, EntityDefiner> entityGroups = new HashMap<EntityGroupKey, EntityDefiner>();
        Iterator<Map.Entry<jakarta.enterprise.inject.spi.AnnotatedType<?>, String>> it = this.repositoryTypes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<jakarta.enterprise.inject.spi.AnnotatedType<?>, String> entry = it.next();
            it.remove();
            jakarta.enterprise.inject.spi.AnnotatedType<?> repositoryType = entry.getKey();
            String databaseStoreId = entry.getValue();
            Class repositoryInterface = repositoryType.getJavaClass();
            ClassLoader loader = repositoryInterface.getClassLoader();
            HashMap queriesPerEntityClass = new HashMap();
            Class[] primaryEntityClassReturnValue = new Class[1];
            if (!this.discoverEntityClasses(repositoryType, queriesPerEntityClass, primaryEntityClassReturnValue)) continue;
            EntityGroupKey entityGroupKey = new EntityGroupKey(databaseStoreId, loader);
            EntityDefiner entityDefiner = (EntityDefiner)entityGroups.get(entityGroupKey);
            if (entityDefiner == null) {
                entityDefiner = new EntityDefiner(entityGroupKey.databaseId, loader);
                entityGroups.put(entityGroupKey, entityDefiner);
            }
            for (Class entityClass : queriesPerEntityClass.keySet()) {
                entityDefiner.add(entityClass);
            }
            BeanAttributes attrs = beanMgr.createBeanAttributes(repositoryType);
            Bean bean = beanMgr.createBean(attrs, repositoryInterface, new RepositoryProducer.Factory(repositoryInterface, beanMgr, this.provider, this, entityDefiner, primaryEntityClassReturnValue[0], queriesPerEntityClass));
            this.repositoryBeans.add(bean);
        }
        for (EntityDefiner entityDefiner : entityGroups.values()) {
            this.provider.executor.submit(entityDefiner);
        }
        for (EntityDefiner entityDefiner : entityGroups.values()) {
            entityDefiner.populateStaticMetamodelClasses(this.staticMetamodels);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanMgr) {
        Bean<?> bean;
        while ((bean = this.repositoryBeans.poll()) != null) {
            event.addBean(bean);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String findOrCreateDatabaseStore(String name, jakarta.enterprise.inject.spi.AnnotatedType<?> type) {
        String dbStoreId;
        ConcurrentHashMap<String, Configuration> dbStoreConfigurations;
        ComponentMetaData cData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        J2EEName jeeName = cData == null ? null : cData.getJ2EEName();
        String application = jeeName == null ? null : jeeName.getApplication();
        String module = jeeName == null ? null : jeeName.getModule();
        String qualifiedName = null;
        boolean javaAppOrModuleOrComp = false;
        if (name.startsWith("java:")) {
            boolean javaApp = name.regionMatches(5, "app", 0, 3);
            boolean javaModule = !javaApp && name.regionMatches(5, "module", 0, 6);
            boolean javaComp = !javaApp && !javaModule && name.regionMatches(5, "comp", 0, 4);
            javaAppOrModuleOrComp = javaApp || javaModule || javaComp;
            StringBuilder s = new StringBuilder(name.length() + 80);
            if (application != null && javaAppOrModuleOrComp) {
                s.append("application[").append(application).append(']').append('/');
                if (module != null && (javaModule || javaComp)) {
                    s.append("module[").append(module).append(']').append('/');
                }
            }
            qualifiedName = s.append("databaseStore[").append(name).append(']').toString();
        }
        Configuration dbStoreConfig = (dbStoreConfigurations = this.provider.dbStoreConfigAllApps.get(application)) == null ? null : dbStoreConfigurations.get(name);
        String string = dbStoreId = dbStoreConfig == null ? null : (String)dbStoreConfig.getProperties().get("id");
        if (dbStoreId == null) {
            try {
                Object filter;
                BundleContext bc = FrameworkUtil.getBundle(DatabaseStore.class).getBundleContext();
                ServiceReference dsRef = null;
                if (qualifiedName == null) {
                    filter = FilterUtils.createPropertyFilter((String)"id", (String)name);
                    Collection dbStoreRefs = bc.getServiceReferences(DatabaseStore.class, (String)filter);
                    if (!dbStoreRefs.isEmpty()) {
                        return name;
                    }
                    filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + FilterUtils.createPropertyFilter((String)"id", (String)name) + ")";
                    Collection dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                    if (!dsRefs.isEmpty()) {
                        dbStoreId = name;
                        dsRef = (ServiceReference)dsRefs.iterator().next();
                    } else {
                        filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + FilterUtils.createPropertyFilter((String)"jndiName", (String)name) + ")";
                        dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                        if (!dsRefs.isEmpty()) {
                            dbStoreId = name;
                            dsRef = (ServiceReference)dsRefs.iterator().next();
                        }
                    }
                }
                if (dbStoreId == null) {
                    ConcurrentHashMap<String, Configuration> empty;
                    filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + (javaAppOrModuleOrComp ? FilterUtils.createPropertyFilter((String)"application", (String)application) : "") + FilterUtils.createPropertyFilter((String)"jndiName", (String)name) + ")";
                    Collection dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                    if (!dsRefs.isEmpty()) {
                        dbStoreId = qualifiedName == null ? name : qualifiedName;
                        dsRef = (ServiceReference)dsRefs.iterator().next();
                    } else {
                        ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>> empty2;
                        DelegatingResourceFactory delegator = new DelegatingResourceFactory(name, cData);
                        Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
                        dbStoreId = qualifiedName == null ? name : qualifiedName;
                        String id = dbStoreId + "/ResourceFactory";
                        svcProps.put("id", id);
                        svcProps.put("config.displayId", id);
                        if (application != null) {
                            svcProps.put("application", application);
                        }
                        ServiceRegistration reg = bc.registerService(ResourceFactory.class, (Object)delegator, svcProps);
                        dsRef = reg.getReference();
                        ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>> registrations = this.provider.delegatorsAllApps.get(application);
                        if (registrations == null && (registrations = (ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>>)this.provider.delegatorsAllApps.putIfAbsent(application, empty2 = new ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>>())) == null) {
                            registrations = empty2;
                        }
                        registrations.add((ServiceRegistration<ResourceFactory>)reg);
                    }
                    if (dbStoreConfigurations == null && (dbStoreConfigurations = (ConcurrentHashMap<String, Configuration>)this.provider.dbStoreConfigAllApps.putIfAbsent(application, empty = new ConcurrentHashMap<String, Configuration>())) == null) {
                        dbStoreConfigurations = empty;
                    }
                    String dataSourceId = (String)dsRef.getProperty("id");
                    boolean nonJTA = Boolean.FALSE.equals(dsRef.getProperty("transactional"));
                    Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
                    svcProps.put("id", dbStoreId);
                    svcProps.put("config.displayId", qualifiedName == null ? "databaseStore[" + dbStoreId + "]" : qualifiedName);
                    svcProps.put("DataSourceFactory.target", "(id=" + dataSourceId + ")");
                    svcProps.put("AuthData.target", "(service.pid=${authDataRef})");
                    svcProps.put("AuthData.cardinality.minimum", 0);
                    if (nonJTA) {
                        svcProps.put("NonJTADataSourceFactory.target", "(id=" + dataSourceId + ")");
                    } else {
                        svcProps.put("NonJTADataSourceFactory.target", "(&(service.pid=${nonTransactionalDataSourceRef})(transactional=false))");
                    }
                    svcProps.put("NonJTADataSourceFactory.cardinality.minimum", nonJTA ? 1 : 0);
                    svcProps.put("createTables", !"FALSE".equalsIgnoreCase((String)dsRef.getProperty("properties.0.data.createTables")));
                    svcProps.put("dropTables", !"TRUE".equalsIgnoreCase((String)dsRef.getProperty("properties.0.data.dropTables")));
                    svcProps.put("tablePrefix", Objects.requireNonNullElse((String)dsRef.getProperty("properties.0.data.tablePrefix"), "DATA"));
                    svcProps.put("keyGenerationStrategy", Objects.requireNonNullElse((String)dsRef.getProperty("properties.0.data.keyGenerationStrategy"), "AUTO"));
                    dbStoreConfig = this.provider.configAdmin.createFactoryConfiguration("com.ibm.ws.persistence.databaseStore", bc.getBundle().getLocation());
                    dbStoreConfig.update(svcProps);
                    dbStoreConfigurations.put(name, dbStoreConfig);
                }
            }
            catch (IOException | InvalidSyntaxException bc) {
                void x;
                FFDCFilter.processException((Throwable)bc, (String)"io.openliberty.data.internal.persistence.cdi.DataExtension", (String)"376", (Object)this, (Object[])new Object[]{name, type});
                throw new RuntimeException((Throwable)x);
            }
            catch (Error | RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"io.openliberty.data.internal.persistence.cdi.DataExtension", (String)"378", (Object)this, (Object[])new Object[]{name, type});
                throw x;
            }
        }
        return dbStoreId;
    }

    private boolean discoverEntityClasses(jakarta.enterprise.inject.spi.AnnotatedType<?> repositoryType, Map<Class<?>, List<QueryInfo>> queriesPerEntity, Class<?>[] primaryEntityClassReturnValue) {
        Class repositoryInterface = repositoryType.getJavaClass();
        Class<?> primaryEntityClass = null;
        HashSet<Class> lifecycleMethodEntityClasses = new HashSet<Class>();
        for (AnnotatedType interfaceType : repositoryInterface.getAnnotatedInterfaces()) {
            Type firstParamType;
            if (!(interfaceType instanceof AnnotatedParameterizedType)) continue;
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)interfaceType;
            AnnotatedType[] typeParams = parameterizedType.getAnnotatedActualTypeArguments();
            Type type = firstParamType = typeParams.length > 0 ? typeParams[0].getType() : null;
            if (firstParamType == null || !(firstParamType instanceof Class)) continue;
            primaryEntityClass = (Class<?>)firstParamType;
            if (typeParams.length == 2 && parameterizedType.getType().getTypeName().startsWith(DataRepository.class.getPackageName())) break;
        }
        for (Method method : repositoryInterface.getMethods()) {
            String packageName;
            if (method.isDefault()) continue;
            Class<?> returnType = method.getReturnType();
            if (method.getParameterCount() == 0 && (EntityManager.class.equals(returnType) || DataSource.class.equals(returnType) || Connection.class.equals(returnType))) {
                QueryInfo queryInfo = new QueryInfo(method, QueryInfo.Type.RESOURCE_ACCESS);
                List<QueryInfo> queries = queriesPerEntity.get(Void.class);
                if (queries == null) {
                    queries = new ArrayList<QueryInfo>();
                    queriesPerEntity.put(Void.class, queries);
                }
                queries.add(queryInfo);
                continue;
            }
            Class<?> returnArrayComponentType = null;
            ArrayList returnTypeAtDepth = new ArrayList(5);
            Type type = method.getGenericReturnType();
            for (int depth = 0; depth < 5 && type != null; ++depth) {
                if (type instanceof ParameterizedType) {
                    returnTypeAtDepth.add((Class)((ParameterizedType)type).getRawType());
                    Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
                    type = typeParams.length == 1 ? typeParams[0] : null;
                    continue;
                }
                if (type instanceof Class) {
                    Class c = (Class)type;
                    returnTypeAtDepth.add(c);
                    if (IntStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Integer.TYPE);
                        ++depth;
                    } else if (LongStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Long.TYPE);
                        ++depth;
                    } else if (DoubleStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Double.TYPE);
                        ++depth;
                    } else if (returnArrayComponentType == null && (returnArrayComponentType = c.getComponentType()) != null) {
                        returnTypeAtDepth.add(returnArrayComponentType);
                        ++depth;
                    }
                    type = null;
                    continue;
                }
                if (type instanceof GenericArrayType) {
                    Class<?> arrayComponentType = primaryEntityClass;
                    returnTypeAtDepth.add((Class<?>)arrayComponentType.arrayType());
                    if (returnArrayComponentType == null) {
                        returnArrayComponentType = arrayComponentType;
                        returnTypeAtDepth.add(returnArrayComponentType);
                        ++depth;
                    }
                    type = null;
                    continue;
                }
                returnTypeAtDepth.add(primaryEntityClass);
                type = null;
            }
            Class entityClass = (Class)returnTypeAtDepth.get(returnTypeAtDepth.size() - 1);
            Class<?> entityParamType = null;
            if (!(method.getParameterCount() != 1 || method.isDefault() || method.getAnnotation(Query.class) != null || method.getAnnotation(Insert.class) == null && method.getAnnotation(Update.class) == null && method.getAnnotation(Save.class) == null && method.getAnnotation(Delete.class) == null)) {
                Class c = method.getParameterTypes()[0];
                if (Iterable.class.isAssignableFrom(c) || Stream.class.isAssignableFrom(c)) {
                    type = method.getGenericParameterTypes()[0];
                    if (type instanceof ParameterizedType) {
                        Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
                        if (typeParams.length == 1 && typeParams[0] instanceof Class) {
                            c = (Class)typeParams[0];
                        } else {
                            entityParamType = c;
                            c = null;
                        }
                    } else {
                        c = null;
                    }
                } else if (c.isArray()) {
                    c = c.getComponentType();
                }
                if (Object.class.equals(c)) {
                    entityParamType = method.getParameterTypes()[0];
                } else if (!(c == null || c.isPrimitive() || c.isInterface() || (packageName = c.getPackageName()).startsWith("java.") || packageName.startsWith("jakarta."))) {
                    Parameter param = method.getParameters()[0];
                    entityParamType = param.getType();
                    for (Annotation anno : param.getAnnotations()) {
                        if (!anno.annotationType().getPackageName().startsWith("jakarta.data")) continue;
                        entityParamType = null;
                    }
                    if (entityParamType != null) {
                        entityClass = c;
                        lifecycleMethodEntityClasses.add(c);
                    }
                }
            }
            QueryInfo queryInfo = new QueryInfo(method, entityParamType, returnArrayComponentType, returnTypeAtDepth);
            if (entityClass == null) {
                entityClass = Void.class;
            } else {
                packageName = entityClass.getPackageName();
                if (packageName.startsWith("java.") || packageName.startsWith("jakarta.") || entityClass.isPrimitive() || entityClass.isInterface()) {
                    entityClass = Void.class;
                }
            }
            List<QueryInfo> queries = queriesPerEntity.get(entityClass);
            if (queries == null) {
                queries = new ArrayList<QueryInfo>();
                queriesPerEntity.put(entityClass, queries);
            }
            queries.add(queryInfo);
        }
        List<QueryInfo> additionalQueriesForPrimaryEntity = queriesPerEntity.remove(Void.class);
        boolean supportsAllEntities = true;
        HashSet allEntityClasses = new HashSet();
        if (primaryEntityClass != null) {
            allEntityClasses.add(primaryEntityClass);
            supportsAllEntities &= this.supportsEntity(primaryEntityClass, repositoryType);
        }
        for (Class c : lifecycleMethodEntityClasses) {
            if (!allEntityClasses.add(c)) continue;
            supportsAllEntities &= this.supportsEntity(c, repositoryType);
        }
        Iterator<Map.Entry<Class<?>, List<QueryInfo>>> it = queriesPerEntity.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Class<?>, List<QueryInfo>> entry = it.next();
            Class<?> c = entry.getKey();
            if (allEntityClasses.contains(c)) continue;
            if (c.getAnnotation(Entity.class) == null) {
                supportsAllEntities &= this.supportsEntity(c, repositoryType);
                if (additionalQueriesForPrimaryEntity == null) {
                    additionalQueriesForPrimaryEntity = new ArrayList<QueryInfo>();
                }
                additionalQueriesForPrimaryEntity.addAll((Collection<QueryInfo>)entry.getValue());
                it.remove();
                continue;
            }
            allEntityClasses.add(c);
        }
        if (supportsAllEntities) {
            if (primaryEntityClass == null) {
                if (lifecycleMethodEntityClasses.size() == 1) {
                    primaryEntityClass = (Class)lifecycleMethodEntityClasses.iterator().next();
                } else if (lifecycleMethodEntityClasses.isEmpty()) {
                    if (queriesPerEntity.size() == 1) {
                        primaryEntityClass = queriesPerEntity.keySet().iterator().next();
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to determine primary entity class because there are multiple entity classes: ", (Object[])new Object[]{queriesPerEntity.keySet()});
                    }
                }
            } else if (!queriesPerEntity.containsKey(primaryEntityClass)) {
                queriesPerEntity.put(primaryEntityClass, new ArrayList());
            }
            if (additionalQueriesForPrimaryEntity != null && !additionalQueriesForPrimaryEntity.isEmpty()) {
                if (primaryEntityClass == null) {
                    throw new MappingException("@Repository " + repositoryInterface.getName() + " does not specify an entity class. To correct this, have the repository interface extend DataRepository or another built-in repository interface and supply the entity class as the first parameter.");
                }
                List<QueryInfo> queries = queriesPerEntity.get(primaryEntityClass);
                if (queries == null) {
                    queriesPerEntity.put(primaryEntityClass, additionalQueriesForPrimaryEntity);
                } else {
                    queries.addAll(additionalQueriesForPrimaryEntity);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(repositoryInterface.getName() + " has primary entity class " + primaryEntityClass), (Object[])new Object[]{"and methods that use the following entities:", queriesPerEntity});
        }
        primaryEntityClassReturnValue[0] = primaryEntityClass;
        return supportsAllEntities;
    }

    @Override
    @Trivial
    public DataExtensionProvider run() {
        BundleContext bundleContext = FrameworkUtil.getBundle(DataExtensionProvider.class).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(DataExtensionProvider.class);
        return (DataExtensionProvider)bundleContext.getService(ref);
    }

    private boolean supportsEntity(Class<?> entityClass, jakarta.enterprise.inject.spi.AnnotatedType<?> repositoryType) {
        Repository repository;
        boolean isSupported;
        Object[] entityClassAnnos = entityClass.getAnnotations();
        boolean hasEntityAnnos = false;
        for (Annotation annotation : entityClassAnnos) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (annoClass.equals(Entity.class)) {
                return true;
            }
            if (!annoClass.getSimpleName().endsWith("Entity")) continue;
            hasEntityAnnos = true;
        }
        boolean bl = isSupported = !hasEntityAnnos;
        if (hasEntityAnnos && !"".equals((repository = (Repository)repositoryType.getAnnotation(Repository.class)).provider())) {
            throw new MappingException("Open Liberty's built-in Jakarta Data provider cannot provide the " + repositoryType.getJavaClass().getName() + " repository because the repository's " + entityClass.getName() + " entity class includes an unrecognized entity annotation.  The following annotations are found on the entity class: " + Arrays.toString(entityClassAnnos) + ". Supported entity annotations are: " + Entity.class.getName() + ".");
        }
        return isSupported;
    }

    @Trivial
    private static class EntityGroupKey {
        private final String databaseId;
        private final int hash;
        private final ClassLoader loader;

        EntityGroupKey(String databaseId, ClassLoader loader) {
            this.loader = loader;
            this.databaseId = databaseId;
            this.hash = loader.hashCode() + databaseId.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof EntityGroupKey)) return false;
            EntityGroupKey k = (EntityGroupKey)o;
            if (!this.databaseId.equals(k.databaseId)) return false;
            if (!this.loader.equals(k.loader)) return false;
            return true;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

