/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.LocalTransaction.LocalTransactionCurrent;
import com.ibm.ws.container.service.metadata.ApplicationMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.wsspi.resource.ResourceFactory;
import io.openliberty.cdi.spi.CDIExtensionMetadata;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import jakarta.enterprise.inject.spi.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"io.openliberty.data.internal.persistence.cdi.DataExtensionProvider"}, configurationPolicy=ConfigurationPolicy.IGNORE, service={CDIExtensionMetadata.class, DataExtensionProvider.class, ApplicationMetaDataListener.class})
public class DataExtensionProvider
implements CDIExtensionMetadata,
ApplicationMetaDataListener {
    private static final TraceComponent tc = Tr.register(DataExtensionProvider.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private static final Set<Class<? extends Extension>> extensions = Collections.singleton(DataExtension.class);
    @Reference
    protected ConfigurationAdmin configAdmin;
    final Map<String, Map<String, Configuration>> dbStoreConfigAllApps = new ConcurrentHashMap<String, Map<String, Configuration>>();
    final Map<String, Queue<ServiceRegistration<ResourceFactory>>> delegatorsAllApps = new ConcurrentHashMap<String, Queue<ServiceRegistration<ResourceFactory>>>();
    @Reference(target="(component.name=com.ibm.ws.threading)")
    protected ExecutorService executor;
    @Reference
    public LocalTransactionCurrent localTranCurrent;
    @Reference
    public EmbeddableWebSphereTransactionManager tranMgr;
    private transient Object validationService;
    static final long serialVersionUID = 8571401142611298308L;

    @Trivial
    public void applicationMetaDataCreated(MetaDataEvent<ApplicationMetaData> event) throws MetaDataException {
    }

    public void applicationMetaDataDestroyed(MetaDataEvent<ApplicationMetaData> event) {
        Queue<ServiceRegistration<ResourceFactory>> registrations;
        String appName = ((ApplicationMetaData)event.getMetaData()).getName();
        Map<String, Configuration> configurations = this.dbStoreConfigAllApps.remove(appName);
        if (configurations != null) {
            for (Configuration config : configurations.values()) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("deleting " + config), (Object[])new Object[0]);
                    }
                    config.delete();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.data.internal.persistence.cdi.DataExtensionProvider", (String)"107", (Object)this, (Object[])new Object[]{event});
                }
            }
        }
        if ((registrations = this.delegatorsAllApps.remove(appName)) != null) {
            ServiceRegistration<ResourceFactory> reg;
            while ((reg = registrations.poll()) != null) {
                reg.unregister();
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        Iterator<Object> it = this.dbStoreConfigAllApps.values().iterator();
        while (it.hasNext()) {
            Map<String, Configuration> configurations = it.next();
            it.remove();
            for (Configuration config : configurations.values()) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("deleting " + config), (Object[])new Object[0]);
                    }
                    config.delete();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.data.internal.persistence.cdi.DataExtensionProvider", (String)"128", (Object)this, (Object[])new Object[]{cc});
                }
            }
        }
        it = this.delegatorsAllApps.values().iterator();
        while (it.hasNext()) {
            ServiceRegistration reg;
            Queue registrations = (Queue)it.next();
            it.remove();
            while ((reg = (ServiceRegistration)registrations.poll()) != null) {
                reg.unregister();
            }
        }
    }

    @Trivial
    public Set<Class<? extends Extension>> getExtensions() {
        return extensions;
    }

    @Reference(service=ModuleMetaDataListener.class, target="(service.pid=com.ibm.ws.beanvalidation.OSGiBeanValidationImpl)", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setValidation(ModuleMetaDataListener svc) {
        this.validationService = svc;
    }

    protected void unsetValidation(ModuleMetaDataListener svc) {
        if (this.validationService == svc) {
            this.validationService = null;
        }
    }

    public Object validationService() {
        return this.validationService;
    }
}

